/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-types.h"


#if GLIB_SIZEOF_LONG != GLIB_SIZEOF_SIZE_T
/* XXX: <gobject/gtype.h> */
# error "XXX"
#endif

GType
g_inspector_gtype_get_type (void)
{
  static GType gtype_type = 0;

  if (!gtype_type)
    {
      static const GTypeInfo type_info = {
	0,                          /* class_size */
	NULL,                       /* base_init */
	NULL,                       /* base_destroy */
	NULL,                       /* class_init */
	NULL,                       /* class_destroy */
	NULL,                       /* class_data */
	0,                          /* instance_size */
	0,                          /* n_preallocs */
	NULL,                       /* instance_init */
	NULL,                       /* value_table */
      };

      gtype_type = g_type_register_static (G_TYPE_ULONG,
					   "_gtype",
					   &type_info, 0);
    }

  return gtype_type;
}

GType
g_inspector_stock_id_get_type (void)
{
  static GType gtype_type = 0;

  if (!gtype_type)
    {
      static const GTypeInfo type_info = {
	0,                          /* class_size */
	NULL,                       /* base_init */
	NULL,                       /* base_destroy */
	NULL,                       /* class_init */
	NULL,                       /* class_destroy */
	NULL,                       /* class_data */
	0,                          /* instance_size */
	0,                          /* n_preallocs */
	NULL,                       /* instance_init */
	NULL,                       /* value_table */
      };

      gtype_type = g_type_register_static (G_TYPE_STRING,
					   "_stock_id",
					   &type_info, 0);
    }

  return gtype_type;
}


void
g_inspector_types_init (void)
{
#define INIT(gtype) \
  G_STMT_START { \
    GTypeQuery _query;			\
    g_type_query ((gtype), &_query);	\
    g_assert (_query.type == 0);	\
  } G_STMT_END


  INIT (G_INSPECTOR_TYPE_GTYPE);
  INIT (G_INSPECTOR_TYPE_STOCK_ID);


#undef INIT
}
