static const char * const apszGcsNameMapping[] = {
"North_American_Datum_1983", "GCS_North_American_1983",
"North_American_Datum_1927", "GCS_North_American_1927",
"NAD27_CONUS", "GCS_North_American_1927",
"Reseau_Geodesique_de_Nouvelle_Caledonie_1991-93", "GCS_RGNC_1991-93",
"Reseau_Geodesique_de_la_Polynesie_Francaise", "GCS_RGPF",
"Rauenberg_1983", "GCS_RD/83",
"Phillipine_Reference_System_1992", "GCS_PRS_1992",
"Potsdam_1983", "GCS_PD/83",
"Datum_Geodesi_Nasional_1995", "GCS_DGN_1995",
"Islands_Network_1993", "GCS_ISN_1993",
"Institut_Geographique_du_Congo_Belge_1955", "GCS_IGCB_1955",
"IGC_1962_Arc_of_the_6th_Parallel_South", "GCS_IGC_1962_6th_Parallel_South",
"Jamaica_2001", "GCS_JAD_2001",
"European_Libyan_1979", "GCS_European_Libyan_Datum_1979",
"Madrid_1870", "GCS_Madrid_1870_Madrid",
"Azores_Occidental_Islands_1939", "GCS_Azores_Occidental_1939",
"Azores_Central_Islands_1948", "GCS_Azores_Central_1948",
"Azores_Oriental_Islands_1940", "GCS_Azores_Oriental_1940",
"Lithuania_1994", "GCS_LKS_1994",
"Libyan_Geodetic_Datum_2006", "GCS_LGD2006",
//"Lisbon", "GCS_Lisbon_Lisbon",
"Stockholm_1938", "GCS_RT38",
"Latvia_1992", "GCS_LKS_1992",
"Azores_Oriental_Islands_1995", "GCS_Azores_Oriental_1995",
"Azores_Central_Islands_1948", "GCS_Azores_Central_1948",
"Azores_Central_Islands_1995", "GCS_Azores_Central_1995",
"ATF", "GCS_ATF_Paris",
//"ITRF_2000", "GCS_MONREF_1997",
"Faroe_Datum_1954", "GCS_FD_1954",
"Vietnam_2000", "GCS_VN_2000",
//"Belge_1950", "GCS_Belge_1950_Brussels",
"Qatar_1948", "GCS_Qatar_1948",
"Qatar", "GCS_Qatar_1974",
"Kuwait_Utility", "GCS_KUDAMS",
"ED_1950_16", "GCS_European_1950",
"SAD_1969_Mean", "GCS_South_American_1969",
"Sphere_of_Radius_6370997m", "GCS_Sphere_ARC_INFO",
"Australian_Geodetic_1966", "GCS_Australian_1966",
"Australian_Geodetic_1984", "GCS_Australian_1984",
"AGD84", "GCS_Australian_1984",
"AGD66", "GCS_Australian_1966",
"Rome_1940", "GCS_Monte_Mario",
"Tokyo_Japan", "GCS_Tokyo",
"Graciosa_Base_SW_1948_1", "GCS_Graciosa_Base_SW_1948",
"Datum_Lisboa_Bessel_1", "GCS_Datum_Lisboa_Bessel",
"Datum_Lisboa_Hayford_1", "GCS_Datum_Lisboa_Hayford",
"Observatorio_Metereo_1939_Grupo_Ocidental", "GCS_Observ_Meteorologico_1939",
"Porto_Santo_1936_1", "GCS_Porto_Santo_1936",
"Sao_Braz_1", "GCS_Sao_Braz",
"GDA94", "GCS_GDA_1994",
"HARN", "GCS_North_American_1983_HARN",
"NAD83_HARN", "GCS_North_American_1983_HARN",
"Voirol_1875", "GCS_Voirol_1875",
"Voirol_1960", "GCS_Voirol_Unifie_1960",
"Ain_el_Abd_1970_Bahrain", "GCS_Ain_el_Abd_1970",
"ED_1950_ED77", "GCS_European_1950_ED77",
"Naparima_1955_2", "GCS_Naparima_1955",
"Aratu_Brazil_Campos_Espirito_Santo_and_Santos_basins", "GCS_Aratu",
"Camacupa_Angola_1", "GCS_Camacupa",
"Cape_1", "GCS_Cape",
"Carthage_Tunisia", "GCS_Carthage",
"Deir_ez_Zor_2", "GCS_Deir_ez_Zor",
"Old_Egyptian_1907", "GCS_Egypt_1907",
"PSAD56", "GCS_Provisional_S_American_1956",
"Indian 1975", "GCS_Indian_1975",
"Indian_1960_1", "GCS_Indian_1960",
"Kalianpur_1937_1", "GCS_Kalianpur_1937",
"Kertau_1948", "GCS_Kertau",
"Kertau_1968", "GCS_Kertau",
"Luzon", "GCS_Luzon_1911",
"Malongo_1987_1", "GCS_Malongo_1987",
"Minna_Cameroon", "GCS_Minna",
"Mporaloko_1", "GCS_Mporaloko",
"Nahrwan_Oman", "GCS_Nahrwan_1967",
"Naparima_BWI", "GCS_Naparima_1972",
"Geodetic_Datum_1949", "GCS_New_Zealand_1949",
"Qatar_National", "GCS_Qatar_1974",
"SAD_1969_Mean", "GCS_South_American_1969",
"Tananarive_Observatory_1925", "GCS_Tananarive_1925",
"Tananarive", "GCS_Tananarive_1925",
"Ireland_1965", "GCS_TM65",
"DE_DHDN_whole_country_2001_to_ETRS89", "GCS_Deutsches_Hauptdreiecksnetz",
"Belge_1972_1", "GCS_Belge_1972",
"WGS_72", "GCS_WGS_1972",
"JGD2000", "GCS_JGD_2000",
"NZGD49", "GCS_New_Zealand_1949",
"CH1903_1", "GCS_CH1903",
"DE_42/83_to_ETRS89", "GCS_Pulkovo_1942",
"DE_42_83_to_ETRS89", "GCS_Pulkovo_1942",
"Amersfoort_1", "GCS_Amersfoort",
"CH1903+_L+T1997", "GCS_CH1903+",
"Ord_Survey_G_Britain_1936", "GCS_OSGB_1936",
"European_Datum_1950", "GCS_European_1950",
"Geocentric_Datum_of_Australia_1994", "GCS_GDA_1994",
"NAD83_High_Accuracy_Regional_Network", "GCS_North_American_1983_HARN",
"Bogota_1975", "GCS_Bogota",
"North_American_Datum_1927_CGQ77", "GCS_NAD_1927_CGQ77",
"North_American_Datum_1927_1976", "GCS_NAD_1927_Definition_1976",
"European_Datum_1950_1977", "GCS_European_1950_ED77",
"WGS_1972_Transit_Broadcast_Ephemeris", "GCS_WGS_1972_BE",
"Greek_Geodetic_Reference_System_1987", "GCS_GGRS_1987",
"Militar_Geographische_Institute", "GCS_MGI",
"ED50", "GCS_European_1950",
"ETRS89", "GCS_ETRS_1989",
NULL, NULL};

static const char * const apszGcsNameMappingBasedOnProjCS[] = {
"EUREF_FIN_TM35FIN", "GCS_ETRS_1989", "GCS_EUREF_FIN",
"Nord_Maroc_Degree", "GCS_Merchich", "GCS_Merchich_Degree",
"Sahara_Degree", "GCS_Merchich", "GCS_Merchich_Degree",
"Sud_Maroc_Degree", "GCS_Merchich", "GCS_Merchich_Degree",
"Merchich_Degree_UTM_Zone_28N", "GCS_Merchich", "GCS_Merchich_Degree",
"Lambert_Conformal_Conic", "GCS_Merchich", "GCS_Merchich_Degree",
"UTM", "GCS_Merchich", "GCS_Merchich_Degree",
"UTM_Zone_28_Northern_Hemisphere", "GCS_Merchich", "GCS_Merchich_Degree",
"Portuguese_National_Grid", "GCS_Lisbon", "GCS_Lisbon_Lisbon",
"Belge_Lambert_1950", "GCS_Belge_1950", "GCS_Belge_1950_Brussels",
"MONREF_1997_UTM_Zone_46N", "GCS_ITRF_2000", "GCS_MONREF_1997",
"MONREF_1997_UTM_Zone_47N", "GCS_ITRF_2000", "GCS_MONREF_1997",
NULL, NULL, NULL};



static const char * const apszGcsNameMappingBasedOnUnit[] = {
"Voirol_Unifie_1960", "Degree", "GCS_Voirol_Unifie_1960_Degree",
"Voirol_1960", "Degree", "GCS_Voirol_Unifie_1960_Degree",
"Voirol 1960", "Degree", "GCS_Voirol_Unifie_1960_Degree",
"Voirol_1875", "Degree", "GCS_Voirol_1875_Degree",
"Voirol 1875", "Degree", "GCS_Voirol_1875_Degree",
"NTF", "Grad", "GCS_NTF_Paris",
NULL, NULL, NULL};

static const char * const apszGcsNameMappingBasedPrime[] = {
"Bern_1898", "Bern", "GCS_Bern_1898_Bern",
"Madrid_1870", "Madrid", "GCS_Madrid_1870_Madrid",
"MGI", "Ferro", "GCS_MGI_Ferro",
"MGI", "Stockholm", "GCS_RT38_Stockholm",
"Monte_Mario", "Rome", "GCS_Monte_Mario_Rome",
"NGO_1948", "Oslo", "GCS_NGO_1948_Oslo",
"S_JTSK", "Ferro", "GCS_S_JTSK_Ferro",
"Stockholm_1938", "Stockholm", "GCS_RT38_Stockholm",
NULL, NULL, NULL};

static const char * const apszInvFlatteningMapping[] = {
"293.464999999", "293.465",
"293.465000003", "293.465",
"293.465073361", "293.465",
"293.466020000", "293.46602",
"293.466021293", "293.46602",
"293.4663077168286", "293.466307656",
"293.4664236085404", "293.466307656",
"294.2606763690", "294.260676369",
"294.9786981999", "294.9786982",
"294.978698213", "294.9786982",
"295.9999999999", "296.0",
"297.0000000000", "297.0",
"297.0000000284", "297.0",
"297.0000535480", "297.0",
"298.2499972761", "298.25",
"298.2500000654", "298.25",
"298.2500112226", "298.25",
"298.256999999", "298.257",
"298.2600000000", "298.26",
"298.2571643544962", "298.257223563",
"298.25716435449", "298.257222101",
"298.257222096042", "298.257222101",
"298.25722210100", "298.257222101",
"298.25722356299", "298.257223563",
"298.25722356300", "298.257223563",
"298.25999858999", "298.26",
"298.2684109950054", "298.268410995005",
"298.2999", "298.3",
"298.3000", "298.3",
"299.1527033239203", "299.1528128",
"299.15281280000", "299.1528128",
"299.15281283", "299.1528128",
"299.15281310607", "299.1528128",
"299.15281327254", "299.1528128",
"299.32496460000", "299.3249646",
"299.32496405862", "299.3249646",
"299.32497531503", "299.3249646",
"300.80158474106", "300.8017",
"300.80169943849", "300.8017",
"300.80169999999", "300.8017",
"300.80170000000", "300.8017",
"300.80170009712", "300.8017",
NULL, NULL};

static const char * const apszParamValueMapping[] = {
"Cassini", "false_easting", "283799.9999", "283800.0",
"Cassini", "false_easting", "132033.9199", "132033.92",
"Cassini", "false_northing", "214499.9999", "214500.0",
"Cassini", "false_northing", "62565.9599", "62565.95",
"Transverse_Mercator", "false_easting", "499999.1331", "500000.0",
"Transverse_Mercator", "false_easting", "299999.4798609", "300000.0",
"Transverse_Mercator", "false_northing", "399999.30648", "400000.0",
"Transverse_Mercator", "false_northing", "499999.1331", "500000.0",
"Transverse_Mercator", "central_meridian","51.21666666666668", "51.21666666666667",
"Transverse_Mercator", "Scale_Factor", "0.999601272", "0.9996012717",
"Lambert_Conformal_Conic", "central_meridian", "-90.33333333333334", "-90.33333333333333",
"Lambert_Conformal_Conic", "central_meridian", "-76.83333333333334", "-76.83333333333333",
"Krovak", "longitude_of_center", "24.83333333333334", "24.83333333333333",
"Hotine_Oblique_Mercator_Azimuth_Center", "longitude_of_center", "7.439583333333334", "7.439583333333333",
"Hotine_Oblique_Mercator_Azimuth_Center", "latitude_of_center",	"46.95240555555557", "46.95240555555556",
NULL, NULL, NULL, NULL};

static const char * const apszParamNameMapping[] = {
"Lambert_Azimuthal_Equal_Area", "longitude_of_center", "Central_Meridian",
"Lambert_Azimuthal_Equal_Area", "Latitude_Of_Center", "Latitude_Of_Origin",
"Miller_Cylindrical", "longitude_of_center", "Central_Meridian",
"Gnomonic", "central_meridian", "Longitude_Of_Center",
"Gnomonic", "latitude_of_origin", "Latitude_Of_Center",
"Orthographic", "central_meridian", "Longitude_Of_Center",
"Orthographic", "latitude_of_origin", "Latitude_Of_Center",
"New_Zealand_Map_Grid", "central_meridian", "Longitude_Of_Origin",
"Hotine_Oblique_Mercator_Two_Point_Natural_Origin", "latitude_of_point_1", "Latitude_Of_1st_Point",
"Hotine_Oblique_Mercator_Two_Point_Natural_Origin", "longitude_of_point_1", "Longitude_Of_1st_Point",
"Hotine_Oblique_Mercator_Two_Point_Natural_Origin", "latitude_of_point_2", "Latitude_Of_2nd_Point",
"Hotine_Oblique_Mercator_Two_Point_Natural_Origin", "longitude_of_point_2", "Longitude_Of_2nd_Point",
NULL, NULL, NULL};

static const char * const apszDeleteParametersBasedOnProjection[] = {
"Stereographic_South_Pole", "scale_factor",
"Stereographic_North_Pole", "scale_factor",
"Mercator", "scale_factor",
"Miller_Cylindrical", "latitude_of_center",
"Equidistant_Cylindrical", "pseudo_standard_parallel_1",
"Equidistant_Cylindrical", "latitude_of_origin",
"Plate_Carree", "latitude_of_origin",
"Plate_Carree", "pseudo_standard_parallel_1",
"Plate_Carree", "standard_parallel_1",
"Hotine_Oblique_Mercator_Azimuth_Center", "rectified_grid_angle",
"Hotine_Oblique_Mercator_Azimuth_Natural_Origin", "rectified_grid_angle",
NULL, NULL};

static const char * const apszAddParametersBasedOnProjection[] = {
"Cassini", "scale_factor", "1.0",
"Mercator", "standard_parallel_1", "0.0",
NULL, NULL, NULL};

static const int statePlaneZoneMapping[] = {
/* old zone code, prj code, new zone code */
 3126, -1,    101,
 3151, -1,    102,
 3176, -1,    202,
 3201, -1,    203,
 3226, -1,    301,
 3251, -1,    302,
 3326, -1,    403,
 3351, -1,    404,
 3376, 26945, 405,
 3426, -1,    407,
 3451, -1,    501,
 3476, -1,    502,
 3526, -1,    600,
 3551, -1,    700,
 3576, -1,    903,
 3626, -1,    902,
 3651, -1,    1001,
 3676, -1,    1002,
 3726, -1,    1102,
 3751, -1,    1103,
 3776, -1,    1201,
 3801, -1,    1202,
 3826, -1,    1301,
 3851, -1,    1302,
 3876, -1,    1401,
 3926, -1,    1501,
 3951, -1,    1502,
 3976, -1,    1601,
 4026, -1,    1701,
 6426, -1,    1703,
 4076, -1,    1801,
 4101, -1,    1802,
 4126, -1,    1900,
 4151, -1,    2001,
 4176, -1,    2002,
 4226, -1,    2102,
 4251, -1,    2103,
 6351, -1,    2111,
 6376, -1,    2112,
 6401, -1,    2113,
 4276, -1,    2201,
 4326, -1,    2203,
 4351, -1,    2301,
 4376, -1,    2302,
 4400, 32045, 3400,
 4401, -1,    2401,
 4426, -1,    2402,
 4451, -1,    2403,
 4476, 32100, 2500,
 4476, -1,    2501,
 4701, 32111,	2900,
 4801, 2260,  3101,
 4801, 32115, 3101,
 4526, -1,    2503,
 4551, -1,    2601,
 4576, -1,    2602,
 4626, -1,    2702,
 4651, -1,    2703,
 4676, -1,    2800,
 4726, -1,    3001,
 4751, -1,    3002,
 4776, -1,    3003,
 4826, -1,    3102,
 4851, -1,    3103,
 4876, -1,    3104,
 4926, -1,    3301,
 4951, -1,    3302,
 4976, -1,    3401,
 5026, -1,    3501,
 5051, -1,    3502,
 5076, -1,    3601,
 5126, -1,    3701,
 5151, -1,    3702,
 5176, -1,    3800,
 5226, -1,    3902,
 5251, -1,    4001,
 5276, -1,    4002,
 5301, -1,    4100,
 5326, -1,    4201,
 5351, -1,    4202,
 5376, -1,    4203,
 5401, -1,    4204,
 5426, -1,    4205,
 5451, -1,    4301,
 5476, -1,    4302,
 5501, -1,    4303,
 5526, -1,    4400,
 5551, -1,    4501,
 5576, -1,    4502,
 5601, -1,    4601,
 5626, -1,    4602,
 5651, -1,    4701,
 5676, -1,    4702,
 5701, -1,    4801,
 5726, -1,    4802,
 5751, -1,    4803,
 5776, -1,    4901,
 5801, -1,    4902,
 5826, -1,    4903,
 5851, -1,    4904,
 6101, -1,    5001,
 6126, -1,    5002,
 6151, -1,    5003,
 6176, -1,    5004,
 6201, -1,    5005,
 6226, -1,    5006,
 6251, -1,    5007,
 6276, -1,    5008,
 6301, -1,    5009,
 6326, -1,    5010,
 5876, -1,    5101,
 5901, -1,    5102,
 5926, -1,    5103,
 5951, -1,    5104,
 5976, -1,    5105,
 6001, -1,    5201,
 6026, -1,    5200,
 6076, -1,    5200,
 6051, -1,    5202,
 0,    0,     0
 };

/* This is not a complete mapping. Need to add more. */
static const int statePlanePcsCodeToZoneCode[] = {
/* pcs code, state plane prj str index*/
2222, 2016,
2223, 2026,
2224, 2036,
2225, 4012,
2226, 4022,
2227, 4032,
2228, 4042,
2229, 4052,
2230, 4062,
2231, 5012,
2232, 5022,
2233, 5032,
2234, 6002,
2235, 7002,
2236, 9012,
2237, 9022,
2238, 9032,
2239, 10012,
2240, 10022,
2241, 11012,
2242, 11022,
2243, 11032,
2251, 21116,
2252, 21126,
2253, 21136,
2256, 25006,
2265, 33016,
2266, 33026,
2965, 13012,
2966, 13022,
2246, 16012,
2247, 16022,
2248, 19002,
2249, 20012,
2250, 20022,
2254, 23012,
2255, 23022,
2257, 30012,
2258, 30022,
2259, 30032,
2260, 31012,
2261, 31022,
2262, 31032,
2263, 31042,
2264, 32002,
2267, 35012,
2268, 35022,
2269, 36016,
2270, 36026,
2271, 37012,
2272, 37022,
2273, 39006,
2274, 41002,
2275, 42012,
2276, 42022,
2277, 42032,
2278, 42042,
2279, 42052,
2280, 43016,
2281, 43026,
2282, 43036,
2283, 45012,
2284, 45022,
2285, 46012,
2286, 46022,
2287, 48012,
2288, 48022,
2289, 48032,
2867, 2015,
2868, 2025,
2869, 2035,
2896, 21115,
2897, 21125,
2898, 21135,
2901, 25005,
2909, 33015,
2910, 33025,
2913, 36015,
2914, 36025,
2921, 43015,
2922, 43025,
2923, 43035,
2870, 4013,
2871, 4023,
2872, 4033,
2873, 4043,
2874, 4053,
2875, 4063,
2876, 5013,
2877, 5023,
2878, 5033,
2879, 6003,
2880, 7003,
2881, 9013,
2882, 9023,
2883, 9033,
2884, 10013,
2885, 10023,
2886, 11013,
2887, 11023,
2888, 11033,
2967, 13013,
2968, 13023,
2891, 16013,
2892, 16023,
2893, 19003,
2894, 20013,
2895, 20023,
2899, 23013,
2900, 23023,
2902, 30013,
2903, 30023,
2904, 30033,
2905, 31013,
2906, 31023,
2907, 31033,
2908, 31043,
2911, 35013,
2912, 35023,
2915, 41003,
2916, 42013,
2917, 42023,
2918, 42033,
2919, 42043,
2920, 42053,
2924, 45013,
2925, 45023,
2926, 46013,
2927, 46023,
2928, 48013,
2929, 48023,
2930, 48033,
// following are state systems (not complete)
2964, 102965,
2991, 102991,
2992, 102992,
2993, 102993,
2994, 102994,
// following are NAD 1983 SPCS Zone
26929, 1011,
26930, 1021,
26931, 50011,
26932, 50021,
26933, 50031,
26934, 50041,
26935, 50051,
26936, 50061,
26937, 50071,
26938, 50081,
26939, 50091,
26940, 50101,
26948, 2011,
26949, 2021,
26950, 2031,
26951, 3011,
26952, 3021,
26941, 4011,
26942, 4021,
26943, 4031,
26944, 4041,
26945, 4051,
26946, 4061,
26953, 5011,
26954, 5021,
26955, 5031,
26956, 6001,
26957, 7001,
26958, 9011,
26959, 9021,
26960, 9031,
26966, 10011,
26967, 10021,
26961, 51011,
26962, 51021,
26963, 51031,
26964, 51041,
26965, 51051,
26968, 11011,
26969, 11021,
26970, 11031,
26971, 12011,
26972, 12021,
26973, 13011,
26974, 13021,
26975, 14011,
26976, 14021,
26977, 15011,
26978, 15021,
26979, 16011,
26980, 16021,
26981, 17011,
26982, 17021,
26983, 18011,
26984, 18021,
26985, 19001,
26986, 20011,
26987, 20021,
26988, 21111,
26989, 21121,
26990, 21131,
26991, 22011,
26992, 22021,
26993, 22031,
26994, 23011,
26995, 23021,
26996, 24011,
26997, 24021,
26998, 24031,
32100, 25001,
32104, 26001,
32107, 27011,
32108, 27021,
32109, 27031,
32110, 28001,
32111, 29001,
32112, 30011,
32113, 30021,
32114, 30031,
32115, 31011,
32116, 31021,
32117, 31031,
32118, 31041,
32119, 32001,
32120, 33011,
32121, 33021,
32122, 34011,
32123, 34021,
32124, 35011,
32125, 35021,
32126, 36011,
32127, 36021,
32128, 37011,
32129, 37021,
32130, 38001,
32133, 39001,
32134, 40011,
32135, 40021,
32136, 41001,
32137, 42011,
32138, 42021,
32139, 42031,
32140, 42041,
32141, 42051,
32142, 43011,
32143, 43021,
32144, 43031,
32145, 44001,
32146, 45011,
32147, 45021,
32148, 46011,
32149, 46021,
32150, 47011,
32151, 47021,
32152, 48011,
32153, 48021,
32154, 48031,
32155, 49011,
32156, 49021,
32157, 49031,
32158, 49041,
32161, 52000,
65161, 54001,
0,     0
};

/* ==================================================================== */
/*      WISCRS Table                                                    */
/* ==================================================================== */
static const double apszWISCRS_LCC_meter[] = {
// Central_Meridian, Latitude_Of_Origin, SR code
   -91.1527777777, 46.6696483772, 103303.0,
   -92.4577777777, 45.8987148658, 103306.0,
   -91.2944444444, 44.9778568986, 103308.0,
   -89.3944444444, 43.4625466458, 103310.0,
   -90.9388888888, 43.2000556050, 103311.0,
   -89.4222222222, 43.0695160375, 103312.0,
   -91.2888888888, 45.8722811263, 103317.0,
   -89.8388888888, 42.6375622769, 103322.0,
   -89.2416666666, 43.8070001177, 103323.0,
   -89.8388888888, 42.6375622769, 103332.0,
   -89.0333333333, 45.1542371052, 103333.0,
   -89.7700000000, 44.9009044236, 103336.0,
   -89.2416666666, 43.8070001177, 103338.0,
   -90.6416666666, 44.0000739286, 103341.0,
   -89.5444444444, 45.7042237702, 103343.0,
   -92.2277777777, 44.6361488719, 103346.0,
   -92.2277777777, 44.6361488719, 103347.0,
   -89.5000000000, 44.4168239752, 103349.0,
   -90.4305555555, 43.3223129275, 103352.0,
   -91.1166666666, 45.9000991313, 103356.0,
   -90.4833333333, 45.1778220858, 103360.0,
   -90.7833333333, 43.5750329397, 103362.0,
   -89.4888888888, 46.0778440905, 103363.0,
   -88.5416666667, 42.6694620969, 103364.0,
   -91.7833333333, 45.9612198333, 103365.0,
   -89.2416666666, 44.1139440458, 103369.0,
   -90.0000000000, 44.3625954694, 103371.0,
   0.0, 0,0, 0,0
};

static const double apszWISCRS_TM_meter[] = {
// Central_Meridian, Latitude_Of_Origin, SR code
   -90.0000000000, 43.3666666666, 103300.0,
   -90.6222222222, 45.7061111111, 103301.0,
   -91.8500000000, 45.1333333333, 103302.0,
   -88.0000000000, 43.0000000000, 103304.0,
   -91.7972222222, 43.4813888888, 103305.0,
   -88.5000000000, 42.7194444444, 103307.0,
   -90.7083333333, 43.6000000000, 103309.0,
   -88.7750000000, 41.4722222222, 103313.0,
   -87.2722222222, 44.4000000000, 103314.0,
   -91.9166666666, 45.8833333333, 103315.0,
   -91.8944444444, 44.4083333333, 103316.0,
   -88.1416666666, 45.4388888888, 103318.0,
   -88.5000000000, 42.7194444444, 103319.0,
   -88.6333333333, 44.0055555556, 103320.0,
   -90.8000000000, 41.4111111111, 103321.0,
   -90.1611111111, 42.5388888888, 103324.0,
   -90.2555555555, 45.4333333333, 103325.0,
   -90.8442965194, 44.2533351277, 103326.0,
   -88.7750000000, 41.4722222222, 103327.0,
   -90.0000000000, 43.3666666666, 103328.0,
   -87.8944444444, 42.2166666666, 103329.0,
   -87.5500000000, 43.2666666666, 103330.0,
   -91.3166666666, 43.4511111111, 103331.0,
   -89.7333333333, 44.8444444444, 103334.0,
   -87.5500000000, 43.2666666666, 103335.0,
   -87.7111111111, 44.6916666666, 103337.0,
   -88.4166666666, 44.7166666666, 103339.0,
   -87.8944444444, 42.2166666666, 103340.0,
   -87.9083333333, 44.3972222222, 103342.0,
   -88.5000000000, 42.7194444444, 103344.0,
   -87.8944444444, 42.2166666666, 103345.0,
   -92.6333333333, 44.6611111111, 103348.0,
   -90.4888888889, 44.5555555556, 103350.0,
   -87.8944444444, 42.2166666666, 103351.0,
   -89.0722222222, 41.9444444444, 103353.0,
   -91.0666666666, 43.9194444444, 103354.0,
   -89.9000000000, 42.8194444444, 103355.0,
   -88.6055555556, 44.0361111111, 103357.0,
   -87.5500000000, 43.2666666666, 103358.0,
   -92.6333333333, 44.0361111111, 103359.0,
   -91.3666666666, 43.1611111111, 103361.0,
   -88.0638888888, 42.9180555555, 103366.0,
   -88.2250000000, 42.5694444444, 103367.0,
   -88.8166666666, 43.4202777777, 103368.0,
   -88.5000000000, 42.7194444444, 103370.0,
   0.0, 0,0, 0,0
};
