#---------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#---------------------------------------------------------------------------------------------

## Runs pylint on the command modules ##
from __future__ import print_function
import os
import sys

from _common import get_all_command_modules, exec_command, print_summary

all_command_modules = get_all_command_modules()
print("Running pylint on command modules.")

failed_module_names = []
for name, fullpath in all_command_modules:
    path_to_module = os.path.join(fullpath, 'azure')
    success = exec_command("python -m pylint -d I0013 -r n "+path_to_module)
    if not success:
        failed_module_names.append(name)

print_summary(failed_module_names)

if failed_module_names:
    sys.exit(1)
