/* applet.c generated by valac 0.10.0, the Vala compiler
 * generated from applet.vala, do not modify */

/*
 * Trash applet written in Vala.
 *
 * Copyright (C) 2008, 2009 Mark Lee <avant-wn@lazymalevolence.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Author : Mark Lee <avant-wn@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <libawn/libawn.h>
#include <libdesktop-agnostic/vfs.h>
#include <libdesktop-agnostic/config.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n.h>
#include <locale.h>


#define TYPE_GARBAGE_APPLET (garbage_applet_get_type ())
#define GARBAGE_APPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GARBAGE_APPLET, GarbageApplet))
#define GARBAGE_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GARBAGE_APPLET, GarbageAppletClass))
#define IS_GARBAGE_APPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GARBAGE_APPLET))
#define IS_GARBAGE_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GARBAGE_APPLET))
#define GARBAGE_APPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GARBAGE_APPLET, GarbageAppletClass))

typedef struct _GarbageApplet GarbageApplet;
typedef struct _GarbageAppletClass GarbageAppletClass;
typedef struct _GarbageAppletPrivate GarbageAppletPrivate;

#define TYPE_GARBAGE_PREFS (garbage_prefs_get_type ())
#define GARBAGE_PREFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GARBAGE_PREFS, GarbagePrefs))
#define GARBAGE_PREFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GARBAGE_PREFS, GarbagePrefsClass))
#define IS_GARBAGE_PREFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GARBAGE_PREFS))
#define IS_GARBAGE_PREFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GARBAGE_PREFS))
#define GARBAGE_PREFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GARBAGE_PREFS, GarbagePrefsClass))

typedef struct _GarbagePrefs GarbagePrefs;
typedef struct _GarbagePrefsClass GarbagePrefsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_slist_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_object_unref (var), NULL)))

struct _GarbageApplet {
	AwnAppletSimple parent_instance;
	GarbageAppletPrivate * priv;
	DesktopAgnosticVFSTrash* trash;
};

struct _GarbageAppletClass {
	AwnAppletSimpleClass parent_class;
};

struct _GarbageAppletPrivate {
	DesktopAgnosticConfigClient* config;
	GtkMenu* menu;
	GtkMenuItem* empty_menu_item;
	GarbagePrefs* prefs;
	AwnOverlayText* text_overlay;
	AwnOverlayThrobber* throbber_overlay;
	AwnOverlayProgress* progress_overlay;
	gboolean highlighted;
	gboolean _show_count;
	gboolean _confirm_empty;
};


static gpointer garbage_applet_parent_class = NULL;

#define not_used APPLETSDIR
GType garbage_applet_get_type (void) G_GNUC_CONST;
GType garbage_prefs_get_type (void) G_GNUC_CONST;
#define GARBAGE_APPLET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GARBAGE_APPLET, GarbageAppletPrivate))
enum  {
	GARBAGE_APPLET_DUMMY_PROPERTY,
	GARBAGE_APPLET_SHOW_COUNT,
	GARBAGE_APPLET_CONFIRM_EMPTY
};
GarbageApplet* garbage_applet_new (const char* canonical_name, const char* uid, gint panel_id);
GarbageApplet* garbage_applet_construct (GType object_type, const char* canonical_name, const char* uid, gint panel_id);
static void garbage_applet_on_prop_changed (GarbageApplet* self, GParamSpec* pspec);
static void _garbage_applet_on_prop_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void garbage_applet_render_applet_icon (GarbageApplet* self);
static gboolean garbage_applet_on_map_event (GarbageApplet* self, GdkEvent* evt);
static gboolean garbage_applet_on_drag_motion (GarbageApplet* self, GdkDragContext* context, gint x, gint y, guint time);
static gboolean _garbage_applet_on_drag_motion_gtk_widget_drag_motion (GtkWidget* _sender, GdkDragContext* context, gint x, gint y, guint time_, gpointer self);
static void garbage_applet_on_drag_leave (GarbageApplet* self, GdkDragContext* context, guint time);
static void _garbage_applet_on_drag_leave_gtk_widget_drag_leave (GtkWidget* _sender, GdkDragContext* context, guint time_, gpointer self);
static void garbage_applet_on_drag_data_received (GarbageApplet* self, GdkDragContext* context, gint x, gint y, GtkSelectionData* data, guint info, guint time);
static void _garbage_applet_on_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint info, guint time_, gpointer self);
static void garbage_applet_show_error_message (GarbageApplet* self, const char* msg);
gboolean garbage_applet_get_show_count (GarbageApplet* self);
static void garbage_applet_on_clicked (GarbageApplet* self);
static void garbage_applet_on_context_menu_popup (GarbageApplet* self, GdkEventButton* evt);
static void garbage_applet_on_menu_empty_activate (GarbageApplet* self);
static void _garbage_applet_on_menu_empty_activate_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void garbage_applet_on_menu_prefs_activate (GarbageApplet* self);
static void _garbage_applet_on_menu_prefs_activate_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
gboolean garbage_applet_get_confirm_empty (GarbageApplet* self);
GarbagePrefs* garbage_prefs_new (GarbageApplet* applet);
GarbagePrefs* garbage_prefs_construct (GType object_type, GarbageApplet* applet);
static void garbage_applet_trash_changed (GarbageApplet* self);
static void _g_slist_free_g_object_unref (GSList* self);
void garbage_applet_set_show_count (GarbageApplet* self, gboolean value);
void garbage_applet_set_confirm_empty (GarbageApplet* self, gboolean value);
static void _garbage_applet_trash_changed_desktop_agnostic_vfs_trash_file_count_changed (DesktopAgnosticVFSTrash* _sender, gpointer self);
static gboolean _garbage_applet_on_map_event_gtk_widget_map_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
static void _garbage_applet_on_clicked_awn_applet_simple_clicked (AwnAppletSimple* _sender, gpointer self);
static void _garbage_applet_on_context_menu_popup_awn_applet_simple_context_menu_popup (AwnAppletSimple* _sender, GdkEventButton* event, gpointer self);
static GObject * garbage_applet_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void garbage_applet_finalize (GObject* obj);
static void garbage_applet_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void garbage_applet_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
AwnApplet* awn_applet_factory_initp (const char* canonical_name, const char* uid, gint panel_id);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const char* GARBAGE_APPLET_authors[1] = {"Mark Lee <avant-wn@lazymalevolence.com>"};
static const GtkTargetEntry GARBAGE_APPLET_targets[2] = {{"text/uri-list", (guint) 0, (guint) 0}, {"text/plain", (guint) 0, (guint) 0}};


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _garbage_applet_on_prop_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	garbage_applet_on_prop_changed (self, pspec);
}


GarbageApplet* garbage_applet_construct (GType object_type, const char* canonical_name, const char* uid, gint panel_id) {
	GarbageApplet * self;
	AwnIcon* _tmp0_;
	DesktopAgnosticConfigClient* _tmp1_;
	DesktopAgnosticConfigClient* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (canonical_name != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	self = (GarbageApplet*) g_object_new (object_type, "canonical-name", canonical_name, "uid", uid, "panel-id", panel_id, NULL);
	g_object_set ((GObject*) (_tmp0_ = awn_applet_simple_get_icon ((AwnAppletSimple*) self), AWN_IS_THEMED_ICON (_tmp0_) ? ((AwnThemedIcon*) _tmp0_) : NULL), "drag-and-drop", FALSE, NULL);
	_tmp1_ = awn_config_get_default_for_applet ((AwnApplet*) self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->priv->config = (_tmp2_ = _g_object_ref0 (_tmp1_), _g_object_unref0 (self->priv->config), _tmp2_);
	{
		desktop_agnostic_config_client_bind (self->priv->config, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT, "show_count", (GObject*) self, "show-count", FALSE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_ERROR) {
				goto __catch0_desktop_agnostic_config_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		desktop_agnostic_config_client_bind (self->priv->config, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT, "confirm_empty", (GObject*) self, "confirm-empty", FALSE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_ERROR) {
				goto __catch0_desktop_agnostic_config_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		g_signal_connect_object ((GObject*) self, "notify::show-count", (GCallback) _garbage_applet_on_prop_changed_g_object_notify, self, 0);
		garbage_applet_render_applet_icon (self);
	}
	goto __finally0;
	__catch0_desktop_agnostic_config_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("applet.vala:88: Config Error: %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


GarbageApplet* garbage_applet_new (const char* canonical_name, const char* uid, gint panel_id) {
	return garbage_applet_construct (TYPE_GARBAGE_APPLET, canonical_name, uid, panel_id);
}


static void garbage_applet_on_prop_changed (GarbageApplet* self, GParamSpec* pspec) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (pspec != NULL);
	garbage_applet_render_applet_icon (self);
}


static gboolean _garbage_applet_on_drag_motion_gtk_widget_drag_motion (GtkWidget* _sender, GdkDragContext* context, gint x, gint y, guint time_, gpointer self) {
	gboolean result;
	result = garbage_applet_on_drag_motion (self, context, x, y, time_);
	return result;
}


static void _garbage_applet_on_drag_leave_gtk_widget_drag_leave (GtkWidget* _sender, GdkDragContext* context, guint time_, gpointer self) {
	garbage_applet_on_drag_leave (self, context, time_);
}


static void _garbage_applet_on_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint info, guint time_, gpointer self) {
	garbage_applet_on_drag_data_received (self, context, x, y, selection_data, info, time_);
}


static gboolean garbage_applet_on_map_event (GarbageApplet* self, GdkEvent* evt) {
	gboolean result = FALSE;
	GtkWidget* icon;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	icon = (GtkWidget*) awn_applet_simple_get_icon ((AwnAppletSimple*) self);
	gtk_drag_dest_set (icon, GTK_DEST_DEFAULT_DROP | GTK_DEST_DEFAULT_MOTION, GARBAGE_APPLET_targets, G_N_ELEMENTS (GARBAGE_APPLET_targets), GDK_ACTION_MOVE);
	g_signal_connect_object (icon, "drag-motion", (GCallback) _garbage_applet_on_drag_motion_gtk_widget_drag_motion, self, 0);
	g_signal_connect_object (icon, "drag-leave", (GCallback) _garbage_applet_on_drag_leave_gtk_widget_drag_leave, self, 0);
	g_signal_connect_object (icon, "drag-data-received", (GCallback) _garbage_applet_on_drag_data_received_gtk_widget_drag_data_received, self, 0);
	result = TRUE;
	return result;
}


static void garbage_applet_show_error_message (GarbageApplet* self, const char* msg) {
	GtkMessageDialog* dialog;
	GtkMessageDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	dialog = NULL;
	dialog = (_tmp0_ = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", msg)), _g_object_unref0 (dialog), _tmp0_);
	gtk_dialog_run ((GtkDialog*) dialog);
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (dialog);
}


static void garbage_applet_render_applet_icon (GarbageApplet* self) {
	guint file_count = 0U;
	char* plural;
	gboolean _tmp2_ = FALSE;
	char* _tmp8_;
	char* _tmp9_;
	g_return_if_fail (self != NULL);
	plural = NULL;
	file_count = desktop_agnostic_vfs_trash_get_file_count (self->trash);
	if (file_count > 0) {
		gboolean _tmp0_ = FALSE;
		gtk_window_set_icon_name ((GtkWindow*) self, "user-trash-full");
		if (self->priv->empty_menu_item != NULL) {
			_tmp0_ = !gtk_widget_get_sensitive ((GtkWidget*) self->priv->empty_menu_item);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			gtk_widget_set_sensitive ((GtkWidget*) self->priv->empty_menu_item, TRUE);
		}
	} else {
		gboolean _tmp1_ = FALSE;
		gtk_window_set_icon_name ((GtkWindow*) self, "user-trash");
		if (self->priv->empty_menu_item != NULL) {
			_tmp1_ = gtk_widget_get_sensitive ((GtkWidget*) self->priv->empty_menu_item);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gtk_widget_set_sensitive ((GtkWidget*) self->priv->empty_menu_item, FALSE);
		}
	}
	awn_applet_simple_set_icon_name ((AwnAppletSimple*) self, gtk_window_get_icon_name ((GtkWindow*) self));
	if (self->priv->_show_count) {
		_tmp2_ = file_count > 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp5_;
		char* _tmp6_;
		if (self->priv->text_overlay == NULL) {
			AwnOverlayable* overlayable;
			AwnIcon* _tmp3_;
			AwnOverlayText* _tmp4_;
			overlayable = NULL;
			overlayable = (_tmp3_ = awn_applet_simple_get_icon ((AwnAppletSimple*) self), AWN_IS_OVERLAYABLE (_tmp3_) ? ((AwnOverlayable*) _tmp3_) : NULL);
			self->priv->text_overlay = (_tmp4_ = g_object_ref_sink (awn_overlay_text_new ()), _g_object_unref0 (self->priv->text_overlay), _tmp4_);
			g_object_set (self->priv->text_overlay, "font-sizing", (double) 17, NULL);
			g_object_set ((AwnOverlay*) self->priv->text_overlay, "gravity", GDK_GRAVITY_SOUTH, NULL);
			awn_overlayable_add_overlay (overlayable, (AwnOverlay*) self->priv->text_overlay);
		}
		if (!(g_object_get ((AwnOverlay*) self->priv->text_overlay, "active", &_tmp5_, NULL), _tmp5_)) {
			g_object_set ((AwnOverlay*) self->priv->text_overlay, "active", TRUE, NULL);
		}
		g_object_set (self->priv->text_overlay, "text", _tmp6_ = g_strdup_printf ("%u", file_count), NULL);
		_g_free0 (_tmp6_);
	} else {
		if (self->priv->text_overlay != NULL) {
			gboolean _tmp7_;
			if ((g_object_get ((AwnOverlay*) self->priv->text_overlay, "active", &_tmp7_, NULL), _tmp7_)) {
				g_object_set ((AwnOverlay*) self->priv->text_overlay, "active", FALSE, NULL);
			}
		}
	}
	plural = (_tmp8_ = g_strdup (ngettext ("%u item", "%u items", (gulong) file_count)), _g_free0 (plural), _tmp8_);
	awn_applet_simple_set_tooltip_text ((AwnAppletSimple*) self, _tmp9_ = g_strdup_printf (plural, file_count));
	_g_free0 (_tmp9_);
	_g_free0 (plural);
}


static void garbage_applet_on_clicked (GarbageApplet* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gint argv_length1;
		gint _argv_size_;
		char** _tmp1_;
		char** _tmp0_ = NULL;
		char** argv;
		argv = (_tmp1_ = (_tmp0_ = g_new0 (char*, 2 + 1), _tmp0_[0] = g_strdup ("xdg-open"), _tmp0_[1] = g_strdup ("trash:"), _tmp0_), argv_length1 = 2, _argv_size_ = argv_length1, _tmp1_);
		gdk_spawn_on_screen (gtk_window_get_screen ((GtkWindow*) self), NULL, argv, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			goto __catch1_g_error;
		}
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			char* msg;
			char* _tmp2_;
			msg = NULL;
			msg = (_tmp2_ = g_strdup_printf (_ ("Could not open the trash folder with your file manager: %s"), err->message), _g_free0 (msg), _tmp2_);
			_g_free0 (msg);
			_g_error_free0 (err);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _garbage_applet_on_menu_empty_activate_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	garbage_applet_on_menu_empty_activate (self);
}


static void _garbage_applet_on_menu_prefs_activate_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	garbage_applet_on_menu_prefs_activate (self);
}


static void garbage_applet_on_context_menu_popup (GarbageApplet* self, GdkEventButton* evt) {
	GtkMenu* ctx_menu;
	g_return_if_fail (self != NULL);
	ctx_menu = NULL;
	if (self->priv->menu == NULL) {
		GtkImageMenuItem* prefs_item;
		GtkWidget* about_item;
		GtkSeparatorMenuItem* sep_item;
		GtkWidget* _tmp0_;
		GtkMenu* _tmp1_;
		GtkMenuItem* _tmp2_;
		GtkSeparatorMenuItem* _tmp3_;
		GtkImageMenuItem* _tmp4_;
		GtkWidget* _tmp5_;
		GtkWidget* _tmp6_;
		prefs_item = NULL;
		about_item = NULL;
		sep_item = NULL;
		self->priv->menu = (_tmp1_ = _g_object_ref0 ((_tmp0_ = awn_applet_create_default_menu ((AwnApplet*) self), GTK_IS_MENU (_tmp0_) ? ((GtkMenu*) _tmp0_) : NULL)), _g_object_unref0 (self->priv->menu), _tmp1_);
		self->priv->empty_menu_item = (_tmp2_ = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Empty Trash"))), _g_object_unref0 (self->priv->empty_menu_item), _tmp2_);
		g_signal_connect_object (self->priv->empty_menu_item, "activate", (GCallback) _garbage_applet_on_menu_empty_activate_gtk_menu_item_activate, self, 0);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->empty_menu_item, desktop_agnostic_vfs_trash_get_file_count (self->trash) > 0);
		gtk_widget_show ((GtkWidget*) self->priv->empty_menu_item);
		gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) self->priv->empty_menu_item);
		sep_item = (_tmp3_ = g_object_ref_sink ((GtkSeparatorMenuItem*) gtk_separator_menu_item_new ()), _g_object_unref0 (sep_item), _tmp3_);
		gtk_widget_show ((GtkWidget*) sep_item);
		gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) ((GtkMenuItem*) sep_item));
		prefs_item = (_tmp4_ = g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_PREFERENCES, NULL)), _g_object_unref0 (prefs_item), _tmp4_);
		g_signal_connect_object ((GtkMenuItem*) prefs_item, "activate", (GCallback) _garbage_applet_on_menu_prefs_activate_gtk_menu_item_activate, self, 0);
		gtk_widget_show ((GtkWidget*) prefs_item);
		gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) ((GtkMenuItem*) prefs_item));
		about_item = (_tmp5_ = _g_object_ref0 (awn_applet_create_about_item ((AwnApplet*) self, "Copyright © 2009 Mark Lee", AWN_APPLET_LICENSE_GPLV2, VERSION, _ ("A lightweight, cross-desktop trash applet"), NULL, NULL, "user-trash", NULL, GARBAGE_APPLET_authors, NULL, NULL)), _g_object_unref0 (about_item), _tmp5_);
		gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) (_tmp6_ = about_item, GTK_IS_MENU_ITEM (_tmp6_) ? ((GtkMenuItem*) _tmp6_) : NULL));
		_g_object_unref0 (sep_item);
		_g_object_unref0 (about_item);
		_g_object_unref0 (prefs_item);
	}
	ctx_menu = GTK_MENU (self->priv->menu);
	gtk_menu_set_screen (ctx_menu, NULL);
	awn_icon_popup_gtk_menu (awn_applet_simple_get_icon ((AwnAppletSimple*) self), (GtkWidget*) ctx_menu, (*evt).button, (*evt).time);
}


static void garbage_applet_on_menu_empty_activate (GarbageApplet* self) {
	gboolean do_empty = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->_confirm_empty) {
		char* msg;
		GtkMessageDialog* dialog;
		gint response;
		msg = g_strdup_printf (_ ("Are you sure you want to empty your trash? It currently contains %u it" \
"em(s)."), desktop_agnostic_vfs_trash_get_file_count (self->trash));
		dialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (GTK_WINDOW (self), 0, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, "%s", msg));
		response = gtk_dialog_run ((GtkDialog*) dialog);
		gtk_object_destroy ((GtkObject*) dialog);
		do_empty = response == GTK_RESPONSE_YES;
		_g_object_unref0 (dialog);
		_g_free0 (msg);
	} else {
		do_empty = TRUE;
	}
	if (do_empty) {
		if (self->priv->throbber_overlay == NULL) {
			GtkWidget* widget;
			AwnOverlayable* overlayable;
			GtkWidget* _tmp0_;
			AwnOverlayThrobber* _tmp1_;
			widget = NULL;
			overlayable = NULL;
			widget = (GtkWidget*) awn_applet_simple_get_icon ((AwnAppletSimple*) self);
			overlayable = (_tmp0_ = widget, AWN_IS_OVERLAYABLE (_tmp0_) ? ((AwnOverlayable*) _tmp0_) : NULL);
			self->priv->throbber_overlay = (_tmp1_ = g_object_ref_sink ((AwnOverlayThrobber*) awn_overlay_throbber_new ()), _g_object_unref0 (self->priv->throbber_overlay), _tmp1_);
			awn_overlayable_add_overlay (overlayable, (AwnOverlay*) self->priv->throbber_overlay);
		}
		g_object_set ((AwnOverlay*) self->priv->throbber_overlay, "active", TRUE, NULL);
		desktop_agnostic_vfs_trash_empty (self->trash);
		g_object_set ((AwnOverlay*) self->priv->throbber_overlay, "active", FALSE, NULL);
	}
}


static void garbage_applet_on_menu_prefs_activate (GarbageApplet* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->prefs == NULL) {
		GarbagePrefs* _tmp0_;
		self->priv->prefs = (_tmp0_ = g_object_ref_sink (garbage_prefs_new (self)), _g_object_unref0 (self->priv->prefs), _tmp0_);
	}
	gtk_widget_show_all ((GtkWidget*) self->priv->prefs);
}


static void garbage_applet_trash_changed (GarbageApplet* self) {
	g_return_if_fail (self != NULL);
	garbage_applet_render_applet_icon (self);
}


static gboolean garbage_applet_on_drag_motion (GarbageApplet* self, GdkDragContext* context, gint x, gint y, guint time) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	if (!self->priv->highlighted) {
		awn_effects_start (awn_overlayable_get_effects ((AwnOverlayable*) awn_applet_simple_get_icon ((AwnAppletSimple*) self)), AWN_EFFECT_LAUNCHING);
		self->priv->highlighted = TRUE;
	}
	result = TRUE;
	return result;
}


static void garbage_applet_on_drag_leave (GarbageApplet* self, GdkDragContext* context, guint time) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	if (self->priv->highlighted) {
		awn_effects_stop (awn_overlayable_get_effects ((AwnOverlayable*) awn_applet_simple_get_icon ((AwnAppletSimple*) self)), AWN_EFFECT_LAUNCHING);
		self->priv->highlighted = FALSE;
	}
}


static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


static void garbage_applet_on_drag_data_received (GarbageApplet* self, GdkDragContext* context, gint x, gint y, GtkSelectionData* data, guint info, guint time) {
	GSList* file_uris;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (data != NULL);
	file_uris = NULL;
	if (data == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = gtk_selection_data_get_length (data) == 0;
	}
	if (_tmp0_) {
		gtk_drag_finish (context, FALSE, FALSE, (guint32) time);
		__g_slist_free_g_object_unref0 (file_uris);
		return;
	}
	if (self->priv->progress_overlay == NULL) {
		AwnOverlayable* overlayable;
		AwnIcon* _tmp1_;
		AwnOverlayProgress* _tmp2_;
		overlayable = NULL;
		overlayable = (_tmp1_ = awn_applet_simple_get_icon ((AwnAppletSimple*) self), AWN_IS_OVERLAYABLE (_tmp1_) ? ((AwnOverlayable*) _tmp1_) : NULL);
		self->priv->progress_overlay = (_tmp2_ = (AwnOverlayProgress*) g_object_ref_sink (awn_overlay_progress_circle_new ()), _g_object_unref0 (self->priv->progress_overlay), _tmp2_);
		awn_overlayable_add_overlay (overlayable, (AwnOverlay*) self->priv->progress_overlay);
	}
	g_object_set (self->priv->progress_overlay, "percent-complete", 0.0, NULL);
	g_object_set ((AwnOverlay*) self->priv->progress_overlay, "active", TRUE, NULL);
	{
		double total = 0.0;
		guint pos;
		GSList* _tmp3_;
		GSList* _tmp4_;
		pos = (guint) 0;
		_tmp3_ = desktop_agnostic_vfs_files_from_uri_list ((const char*) data->data, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		file_uris = (_tmp4_ = _tmp3_, __g_slist_free_g_object_unref0 (file_uris), _tmp4_);
		total = (double) g_slist_length (file_uris);
		{
			GSList* file_collection;
			GSList* file_it;
			file_collection = file_uris;
			for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
				DesktopAgnosticVFSFile* file;
				file = (DesktopAgnosticVFSFile*) file_it->data;
				{
					if (desktop_agnostic_vfs_file_exists (file)) {
						desktop_agnostic_vfs_trash_send_to_trash (self->trash, file, &_inner_error_);
						if (_inner_error_ != NULL) {
							goto __catch2_g_error;
						}
					}
					g_object_set (self->priv->progress_overlay, "percent-complete", (pos = pos + 1) / total, NULL);
				}
			}
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			char* msg;
			msg = g_strdup_printf (_ ("Could not send the dragged file(s) to the trash: %s"), err->message);
			garbage_applet_show_error_message (self, msg);
			_g_free0 (msg);
			_g_error_free0 (err);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		__g_slist_free_g_object_unref0 (file_uris);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_object_set ((AwnOverlay*) self->priv->progress_overlay, "active", FALSE, NULL);
	gtk_drag_finish (context, TRUE, TRUE, (guint32) time);
	__g_slist_free_g_object_unref0 (file_uris);
}


gboolean garbage_applet_get_show_count (GarbageApplet* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_count;
	return result;
}


void garbage_applet_set_show_count (GarbageApplet* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_show_count = value;
	g_object_notify ((GObject *) self, "show-count");
}


gboolean garbage_applet_get_confirm_empty (GarbageApplet* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_confirm_empty;
	return result;
}


void garbage_applet_set_confirm_empty (GarbageApplet* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_confirm_empty = value;
	g_object_notify ((GObject *) self, "confirm-empty");
}


static void _garbage_applet_trash_changed_desktop_agnostic_vfs_trash_file_count_changed (DesktopAgnosticVFSTrash* _sender, gpointer self) {
	garbage_applet_trash_changed (self);
}


static gboolean _garbage_applet_on_map_event_gtk_widget_map_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	gboolean result;
	result = garbage_applet_on_map_event (self, event);
	return result;
}


static void _garbage_applet_on_clicked_awn_applet_simple_clicked (AwnAppletSimple* _sender, gpointer self) {
	garbage_applet_on_clicked (self);
}


static void _garbage_applet_on_context_menu_popup_awn_applet_simple_context_menu_popup (AwnAppletSimple* _sender, GdkEventButton* event, gpointer self) {
	garbage_applet_on_context_menu_popup (self, event);
}


static GObject * garbage_applet_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GarbageApplet * self;
	GError * _inner_error_;
	parent_class = G_OBJECT_CLASS (garbage_applet_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GARBAGE_APPLET (obj);
	_inner_error_ = NULL;
	{
		DesktopAgnosticVFSTrash* _tmp0_;
		DesktopAgnosticVFSTrash* _tmp1_;
		AwnOverlayText* _tmp2_;
		AwnOverlayThrobber* _tmp3_;
		AwnOverlayProgress* _tmp4_;
		_tmp0_ = desktop_agnostic_vfs_trash_get_default (&_inner_error_);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		self->trash = (_tmp1_ = _g_object_ref0 (_tmp0_), _g_object_unref0 (self->trash), _tmp1_);
		g_signal_connect_object (self->trash, "file-count-changed", (GCallback) _garbage_applet_trash_changed_desktop_agnostic_vfs_trash_file_count_changed, self, 0);
		g_object_set ((AwnApplet*) self, "display-name", _ ("Garbage"), NULL);
		g_signal_connect_object ((GtkWidget*) self, "map-event", (GCallback) _garbage_applet_on_map_event_gtk_widget_map_event, self, 0);
		g_signal_connect_object ((AwnAppletSimple*) self, "clicked", (GCallback) _garbage_applet_on_clicked_awn_applet_simple_clicked, self, 0);
		g_signal_connect_object ((AwnAppletSimple*) self, "context-menu-popup", (GCallback) _garbage_applet_on_context_menu_popup_awn_applet_simple_context_menu_popup, self, 0);
		self->priv->text_overlay = (_tmp2_ = NULL, _g_object_unref0 (self->priv->text_overlay), _tmp2_);
		self->priv->throbber_overlay = (_tmp3_ = NULL, _g_object_unref0 (self->priv->throbber_overlay), _tmp3_);
		self->priv->progress_overlay = (_tmp4_ = NULL, _g_object_unref0 (self->priv->progress_overlay), _tmp4_);
		self->priv->highlighted = FALSE;
	}
	return obj;
}


static void garbage_applet_class_init (GarbageAppletClass * klass) {
	garbage_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GarbageAppletPrivate));
	G_OBJECT_CLASS (klass)->get_property = garbage_applet_get_property;
	G_OBJECT_CLASS (klass)->set_property = garbage_applet_set_property;
	G_OBJECT_CLASS (klass)->constructor = garbage_applet_constructor;
	G_OBJECT_CLASS (klass)->finalize = garbage_applet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GARBAGE_APPLET_SHOW_COUNT, g_param_spec_boolean ("show-count", "show-count", "show-count", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GARBAGE_APPLET_CONFIRM_EMPTY, g_param_spec_boolean ("confirm-empty", "confirm-empty", "confirm-empty", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void garbage_applet_instance_init (GarbageApplet * self) {
	self->priv = GARBAGE_APPLET_GET_PRIVATE (self);
}


static void garbage_applet_finalize (GObject* obj) {
	GarbageApplet * self;
	self = GARBAGE_APPLET (obj);
	_g_object_unref0 (self->trash);
	_g_object_unref0 (self->priv->config);
	_g_object_unref0 (self->priv->menu);
	_g_object_unref0 (self->priv->empty_menu_item);
	_g_object_unref0 (self->priv->prefs);
	_g_object_unref0 (self->priv->text_overlay);
	_g_object_unref0 (self->priv->throbber_overlay);
	_g_object_unref0 (self->priv->progress_overlay);
	G_OBJECT_CLASS (garbage_applet_parent_class)->finalize (obj);
}


GType garbage_applet_get_type (void) {
	static volatile gsize garbage_applet_type_id__volatile = 0;
	if (g_once_init_enter (&garbage_applet_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GarbageAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) garbage_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GarbageApplet), 0, (GInstanceInitFunc) garbage_applet_instance_init, NULL };
		GType garbage_applet_type_id;
		garbage_applet_type_id = g_type_register_static (AWN_TYPE_APPLET_SIMPLE, "GarbageApplet", &g_define_type_info, 0);
		g_once_init_leave (&garbage_applet_type_id__volatile, garbage_applet_type_id);
	}
	return garbage_applet_type_id__volatile;
}


static void garbage_applet_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GarbageApplet * self;
	self = GARBAGE_APPLET (object);
	switch (property_id) {
		case GARBAGE_APPLET_SHOW_COUNT:
		g_value_set_boolean (value, garbage_applet_get_show_count (self));
		break;
		case GARBAGE_APPLET_CONFIRM_EMPTY:
		g_value_set_boolean (value, garbage_applet_get_confirm_empty (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void garbage_applet_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GarbageApplet * self;
	self = GARBAGE_APPLET (object);
	switch (property_id) {
		case GARBAGE_APPLET_SHOW_COUNT:
		garbage_applet_set_show_count (self, g_value_get_boolean (value));
		break;
		case GARBAGE_APPLET_CONFIRM_EMPTY:
		garbage_applet_set_confirm_empty (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


AwnApplet* awn_applet_factory_initp (const char* canonical_name, const char* uid, gint panel_id) {
	AwnApplet* result = NULL;
	g_return_val_if_fail (canonical_name != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	textdomain (GETTEXT_PACKAGE);
	result = (AwnApplet*) g_object_ref_sink (garbage_applet_new (canonical_name, uid, panel_id));
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




