/*
**
** The C code is generated by ATS/Anairiats
** The compilation time is: 2013-9-3:  2h:41m
**
*/

/* include some .h files */
#ifndef _ATS_HEADER_NONE
#include "ats_config.h"
#include "ats_basics.h"
#include "ats_types.h"
#include "ats_exception.h"
#include "ats_memory.h"
#endif /* _ATS_HEADER_NONE */

/* include some .cats files */
#ifndef _ATS_PRELUDE_NONE
#include "prelude/CATS/basics.cats"
#include "prelude/CATS/bool.cats"
#include "prelude/CATS/char.cats"
#include "prelude/CATS/byte.cats"
#include "prelude/CATS/float.cats"
#include "prelude/CATS/integer.cats"
#include "prelude/CATS/integer_ptr.cats"
#include "prelude/CATS/integer_fixed.cats"
#include "prelude/CATS/sizetype.cats"
#include "prelude/CATS/pointer.cats"
#include "prelude/CATS/reference.cats"
#include "prelude/CATS/string.cats"
#include "prelude/CATS/lazy.cats"
#include "prelude/CATS/lazy_vt.cats"
#include "prelude/CATS/printf.cats"
#include "prelude/CATS/list.cats"
#include "prelude/CATS/option.cats"
#include "prelude/CATS/array.cats"
#include "prelude/CATS/matrix.cats"
#endif /* _ATS_PRELUDE_NONE */
/* prologues from statically loaded files */

/* external codes at top */
#line 39 "gcats1_chunk.dats"


#include "config.h" // automatically generated by [configure]

// [posix_memalign] is in [stdlib.h]
extern int posix_memalign(void **memptr, size_t alignment, size_t size);

// [memalign] is in [stdlib.h] or [malloc.h]
extern void *memalign(size_t boundary, size_t size);

static inline
int gcats_memalign (
  void **memptr
, size_t alignment
, size_t size
) {
  int err ;
#if HAVE_POSIX_MEMALIGN // for [posix_memalign]
  // fprintf (stderr, "posix_memalign: bef\n") ;
  err = posix_memalign (memptr, alignment, size) ;
  // fprintf (stderr, "posix_memalign: aft\n") ;
#elif HAVE_MEMALIGN // if [memalign] is avaiable
  void *ptr ;
  ptr = memalign(alignment, size) ; *memptr = ptr ;
  err = (ptr ? 0 : -1) ;
#else // neither [posix_memalign] nor [memalign] is available
  void *ptr ;
  ptr = malloc (size + alignment - 1) ; *memptr = ptr ;
  err = (ptr ? 0 : -1) ;
#endif
/*
  fprintf (stderr, "gcats_memalign: size = %i\n", size);
  fprintf (stderr, "gcats_memalign: *memptr = %p(%i)\n", *memptr, *memptr);
*/
  return err ;
} /* end of [gcats_memalign] */


/* type definitions */
/* external typedefs */
/* external dynamic constructor declarations */
/* external dynamic constant declarations */
ATSextern_fun(ats_void_type, atspre_prerr_newline) () ;
ATSextern_fun(ats_int_type, atspre_add_int_int) (ats_int_type, ats_int_type) ;
ATSextern_fun(ats_int_type, atspre_sub_int_int) (ats_int_type, ats_int_type) ;
ATSextern_fun(ats_bool_type, atspre_gt_int_int) (ats_int_type, ats_int_type) ;
ATSextern_fun(ats_int_type, atspre_asl_int_int1) (ats_int_type, ats_int_type) ;
ATSextern_fun(ats_int_type, atspre_asr_int_int1) (ats_int_type, ats_int_type) ;
ATSextern_fun(ats_int_type, atspre_iadd) (ats_int_type, ats_int_type) ;
ATSextern_fun(ats_bool_type, atspre_ilt) (ats_int_type, ats_int_type) ;
ATSextern_fun(ats_void_type, atspre_prerr_string) (ats_ptr_type) ;
ATSextern_fun(ats_ptr_type, freeitmlst2ptr) (ats_ptr_type) ;
ATSextern_fun(ats_void_type, gc_main_lock_release) () ;
ATSextern_fun(ats_bool_type, chunklst_is_cons) (ats_ptr_type) ;
ATSextern_fun(ats_int_type, chunklst_itemwsz_get) (ats_ptr_type) ;
ATSextern_fun(ats_ptr_type, chunklst_data_get) (ats_ptr_type) ;
ATSextern_fun(ats_ptr_type, chunklst_data_nonalign_get) (ats_ptr_type) ;
ATSextern_fun(ats_ptr_type, chunklst_sweep_next_get) (ats_ptr_type) ;
ATSextern_fun(ats_ptr_type, chunklst_create) (ats_int_type, ats_int_type) ;
ATSextern_fun(ats_void_type, the_chunk_count_dec_by) (ats_int_type) ;
ATSextern_fun(ats_uintptr1_type, PTR_TOPSEG_GET) (ats_ptr_type) ;
ATSextern_fun(ats_int_type, PTR_BOTSEG_GET) (ats_ptr_type) ;
ATSextern_fun(ats_bool_type, botsegtbllst_is_nil) (ats_ptr_type) ;
ATSextern_fun(ats_bool_type, botsegtbllst_is_cons) (ats_ptr_type) ;
ATSextern_fun(ats_ptr_type, botsegtbl_make_32) () ;
ATSextern_fun(ats_ptr_type, botsegtbllst_get) (ats_ptr_type, ats_int_type) ;
ATSextern_fun(ats_void_type, botsegtbllst_set) (ats_ptr_type, ats_int_type, ats_ptr_type) ;
ATSextern_fun(ats_void_type, botsegtbllst_clear) (ats_ptr_type, ats_int_type) ;
ATSextern_fun(ats_ptr_type, ATS_2d0_2e2_2e10_2ccomp_2runtime_2GCATS1_2gcats1_2esats__the_topsegtbl_get) (ats_uintptr1_type) ;
ATSextern_fun(ats_ptr_type, ATS_2d0_2e2_2e10_2ccomp_2runtime_2GCATS1_2gcats1_2esats__the_topsegtbl_get_some) (ats_uintptr1_type) ;
ATSextern_fun(ats_ptr_type, the_topsegtbl_get_32) (ats_uintptr1_type) ;
ATSextern_fun(ats_void_type, the_topsegtbl_set_32) (ats_uintptr1_type, ats_ptr_type) ;
ATSextern_fun(ats_void_type, chunklst_insert_into_table) (ats_ptr_type) ;
ATSextern_fun(ats_void_type, chunklst_remove_from_table) (ats_ptr_type) ;
ATSextern_fun(ats_void_type, freeitmlst_chunk_data_free) (ats_ptr_type) ;
ATSextern_fun(ats_void_type, freeitmlst_chunk_data_recycle) (ats_ptr_type) ;
ATSextern_fun(ats_void_type, chunk_header_free) (ats_ptr_type) ;
ATSextern_fun(ats_void_type, gc_markbits_clear_chunk) (ats_ptr_type) ;
ATSextern_fun(ats_void_type, gc_markbits_clear_botsegtbl) (ats_ptr_type) ;

/* external dynamic terminating constant declarations */
#ifdef _ATS_PROOFCHECK
#endif /* _ATS_PROOFCHECK */

/* assuming abstract types */
/* sum constructor declarations */
/* exn constructor declarations */
/* global dynamic (non-functional) constant declarations */
/* internal function declarations */
static
ats_int_type gcats1_chunk_aux_1 (ats_ptr_type arg0, ats_int_type arg1) ;
static
ats_void_type gcats1_chunk_loop_9 (ats_ptr_type arg0, ats_int_type arg1) ;

/* partial value template declarations */
/* static temporary variable declarations */
/* external value variable declarations */

/* function implementations */

/*
// /home/hwxi/research/Anairiats/ccomp/runtime/GCATS1/gcats1_chunk.dats: 2777(line=93, offs=5) -- 2974(line=102, offs=4)
*/
ATSstaticdec()
ats_int_type
gcats1_chunk_aux_1 (ats_ptr_type arg0, ats_int_type arg1) {
/* local vardec */
ATSlocal (ats_int_type, tmp1) ;
ATSlocal (ats_bool_type, tmp2) ;
ATSlocal (ats_ptr_type, tmp3) ;
ATSlocal (ats_int_type, tmp4) ;

__ats_lab_gcats1_chunk_aux_1:
#line 97 "gcats1_chunk.dats"
tmp2 = chunklst_is_cons (arg0) ;
#line 99 "gcats1_chunk.dats"
if (tmp2) {
#line 100 "gcats1_chunk.dats"
tmp3 = chunklst_sweep_next_get (arg0) ;
#line 100 "gcats1_chunk.dats"
tmp4 = atspre_iadd (arg1, 1) ;
#line 100 "gcats1_chunk.dats"
arg0 = tmp3 ;
#line 100 "gcats1_chunk.dats"
arg1 = tmp4 ;
#line 100 "gcats1_chunk.dats"
goto __ats_lab_gcats1_chunk_aux_1 ; // tail call
} else {
#line 100 "gcats1_chunk.dats"
tmp1 = arg1 ;
} /* end of [if] */
return (tmp1) ;
} /* end of [gcats1_chunk_aux_1] */

/*
// /home/hwxi/research/Anairiats/ccomp/runtime/GCATS1/gcats1_chunk.dats: 2757(line=91, offs=23) -- 3016(line=106, offs=4)
*/
ATSglobaldec()
ats_int_type
ATS_2d0_2e2_2e10_2ccomp_2runtime_2GCATS1_2gcats1_2esats__chunklst_sweep_length (ats_ptr_type arg0) {
/* local vardec */
ATSlocal (ats_int_type, tmp0) ;

__ats_lab_ATS_2d0_2e2_2e10_2ccomp_2runtime_2GCATS1_2gcats1_2esats__chunklst_sweep_length:
#line 105 "gcats1_chunk.dats"
tmp0 = gcats1_chunk_aux_1 (arg0, 0) ;
return (tmp0) ;
} /* end of [ATS_2d0_2e2_2e10_2ccomp_2runtime_2GCATS1_2gcats1_2esats__chunklst_sweep_length] */

/*
// /home/hwxi/research/Anairiats/ccomp/runtime/GCATS1/gcats1_chunk.dats: 3391(line=120, offs=29) -- 3435(line=120, offs=73)
*/
ATSglobaldec()
ats_ptr_type
ATS_2d0_2e2_2e10_2ccomp_2runtime_2GCATS1_2gcats1_2esats__the_topsegtbl_get (ats_uintptr1_type arg0) {
/* local vardec */
ATSlocal (ats_ptr_type, tmp5) ;

__ats_lab_ATS_2d0_2e2_2e10_2ccomp_2runtime_2GCATS1_2gcats1_2esats__the_topsegtbl_get:
#line 120 "gcats1_chunk.dats"
tmp5 = the_topsegtbl_get_32 (arg0) ;
return (tmp5) ;
} /* end of [ATS_2d0_2e2_2e10_2ccomp_2runtime_2GCATS1_2gcats1_2esats__the_topsegtbl_get] */

/*
// /home/hwxi/research/Anairiats/ccomp/runtime/GCATS1/gcats1_chunk.dats: 3470(line=122, offs=34) -- 3769(line=133, offs=4)
*/
ATSglobaldec()
ats_ptr_type
ATS_2d0_2e2_2e10_2ccomp_2runtime_2GCATS1_2gcats1_2esats__the_topsegtbl_get_some (ats_uintptr1_type arg0) {
/* local vardec */
ATSlocal (ats_ptr_type, tmp6) ;
ATSlocal (ats_ptr_type, tmp7) ;
ATSlocal (ats_bool_type, tmp8) ;
ATSlocal (ats_ptr_type, tmp9) ;
// ATSlocal_void (tmp10) ;

__ats_lab_ATS_2d0_2e2_2e10_2ccomp_2runtime_2GCATS1_2gcats1_2esats__the_topsegtbl_get_some:
#line 123 "gcats1_chunk.dats"
tmp7 = the_topsegtbl_get_32 (arg0) ;
#line 125 "gcats1_chunk.dats"
tmp8 = botsegtbllst_is_nil (tmp7) ;
#line 125 "gcats1_chunk.dats"
if (tmp8) {
#line 126 "gcats1_chunk.dats"
tmp9 = botsegtbl_make_32 () ;
#line 127 "gcats1_chunk.dats"
/* tmp10 = */ the_topsegtbl_set_32 (arg0, tmp9) ;
#line 129 "gcats1_chunk.dats"
tmp6 = tmp9 ;
} else {
#line 131 "gcats1_chunk.dats"
tmp6 = tmp7 ;
} /* end of [if] */
return (tmp6) ;
} /* end of [ATS_2d0_2e2_2e10_2ccomp_2runtime_2GCATS1_2gcats1_2esats__the_topsegtbl_get_some] */

/*
// /home/hwxi/research/Anairiats/ccomp/runtime/GCATS1/gcats1_chunk.dats: 5340(line=185, offs=38) -- 5624(line=193, offs=4)
*/
ATSglobaldec()
ats_void_type
chunklst_insert_into_table (ats_ptr_type arg0) {
/* local vardec */
// ATSlocal_void (tmp11) ;
ATSlocal (ats_ptr_type, tmp12) ;
ATSlocal (ats_ptr_type, tmp13) ;
ATSlocal (ats_uintptr1_type, tmp14) ;
ATSlocal (ats_uintptr1_type, tmp15) ;
ATSlocal (ats_ptr_type, tmp16) ;
ATSlocal (ats_int_type, tmp17) ;

__ats_lab_chunklst_insert_into_table:
#line 186 "gcats1_chunk.dats"
tmp12 = chunklst_data_get (arg0) ;
#line 187 "gcats1_chunk.dats"
tmp13 = freeitmlst2ptr (tmp12) ;
#line 188 "gcats1_chunk.dats"
tmp14 = PTR_TOPSEG_GET (tmp13) ;
#line 188 "gcats1_chunk.dats"
tmp15 = ats_selsin_mac(tmp14, atslab_1) ;
#line 189 "gcats1_chunk.dats"
tmp16 = ATS_2d0_2e2_2e10_2ccomp_2runtime_2GCATS1_2gcats1_2esats__the_topsegtbl_get_some (tmp15) ;
#line 190 "gcats1_chunk.dats"
tmp17 = PTR_BOTSEG_GET (tmp13) ;
#line 192 "gcats1_chunk.dats"
/* tmp11 = */ botsegtbllst_set (tmp16, tmp17, arg0) ;
return /* (tmp11) */ ;
} /* end of [chunklst_insert_into_table] */

/*
// /home/hwxi/research/Anairiats/ccomp/runtime/GCATS1/gcats1_chunk.dats: 5702(line=195, offs=38) -- 6226(line=211, offs=4)
*/
ATSglobaldec()
ats_void_type
chunklst_remove_from_table (ats_ptr_type arg0) {
/* local vardec */
// ATSlocal_void (tmp18) ;
ATSlocal (ats_ptr_type, tmp19) ;
ATSlocal (ats_ptr_type, tmp20) ;
ATSlocal (ats_uintptr1_type, tmp21) ;
ATSlocal (ats_uintptr1_type, tmp22) ;
ATSlocal (ats_ptr_type, tmp23) ;
ATSlocal (ats_bool_type, tmp24) ;
ATSlocal (ats_int_type, tmp25) ;
// ATSlocal_void (tmp26) ;
// ATSlocal_void (tmp27) ;
// ATSlocal_void (tmp28) ;

__ats_lab_chunklst_remove_from_table:
#line 196 "gcats1_chunk.dats"
tmp19 = chunklst_data_get (arg0) ;
#line 197 "gcats1_chunk.dats"
tmp20 = freeitmlst2ptr (tmp19) ;
#line 198 "gcats1_chunk.dats"
tmp21 = PTR_TOPSEG_GET (tmp20) ;
#line 198 "gcats1_chunk.dats"
tmp22 = ats_selsin_mac(tmp21, atslab_1) ;
#line 199 "gcats1_chunk.dats"
tmp23 = ATS_2d0_2e2_2e10_2ccomp_2runtime_2GCATS1_2gcats1_2esats__the_topsegtbl_get (tmp22) ;
#line 201 "gcats1_chunk.dats"
tmp24 = botsegtbllst_is_cons (tmp23) ;
#line 201 "gcats1_chunk.dats"
if (tmp24) {
#line 202 "gcats1_chunk.dats"
tmp25 = PTR_BOTSEG_GET (tmp20) ;
#line 204 "gcats1_chunk.dats"
/* tmp18 = */ botsegtbllst_clear (tmp23, tmp25) ;
} else {
#line 206 "gcats1_chunk.dats"
/* tmp26 = */ atspre_prerr_string (ATSstrcst("GC: Fatal Error: [chunklst_remove_from_table]")) ;
#line 207 "gcats1_chunk.dats"
/* tmp27 = */ atspre_prerr_string (ATSstrcst(": the chunk to be removed is not in the table!")) ;
#line 208 "gcats1_chunk.dats"
/* tmp28 = */ atspre_prerr_newline () ;
#line 209 "gcats1_chunk.dats"
/* tmp18 = */ ats_exit (1) ;
} /* end of [if] */
return /* (tmp18) */ ;
} /* end of [chunklst_remove_from_table] */

/*
// /home/hwxi/research/Anairiats/ccomp/runtime/GCATS1/gcats1_chunk.dats: 6324(line=216, offs=3) -- 6506(line=221, offs=4)
*/
ATSglobaldec()
ats_ptr_type
chunklst_create_release (ats_int_type arg0, ats_int_type arg1) {
/* local vardec */
ATSlocal (ats_ptr_type, tmp29) ;
ATSlocal (ats_ptr_type, tmp30) ;
// ATSlocal_void (tmp31) ;

__ats_lab_chunklst_create_release:
#line 217 "gcats1_chunk.dats"
tmp30 = chunklst_create (arg0, arg1) ;
#line 218 "gcats1_chunk.dats"
/* tmp31 = */ gc_main_lock_release () ;
#line 220 "gcats1_chunk.dats"
tmp29 = tmp30 ;
return (tmp29) ;
} /* end of [chunklst_create_release] */

/*
// /home/hwxi/research/Anairiats/ccomp/runtime/GCATS1/gcats1_chunk.dats: 6836(line=233, offs=28) -- 7805(line=262, offs=4)
*/
ATSglobaldec()
ats_void_type
chunklst_destroy (ats_ptr_type arg0) {
/* local vardec */
// ATSlocal_void (tmp32) ;
// ATSlocal_void (tmp33) ;
ATSlocal (ats_ptr_type, tmp34) ;
ATSlocal (ats_int_type, tmp35) ;
// ATSlocal_void (tmp36) ;
ATSlocal (ats_int_type, tmp37) ;
ATSlocal (ats_int_type, tmp38) ;
ATSlocal (ats_int_type, tmp39) ;
ATSlocal (ats_int_type, tmp40) ;
// ATSlocal_void (tmp41) ;
ATSlocal (ats_bool_type, tmp42) ;
ATSlocal (ats_int_type, tmp43) ;

__ats_lab_chunklst_destroy:
#line 240 "gcats1_chunk.dats"
/* tmp33 = */ chunklst_remove_from_table (arg0) ;
#line 241 "gcats1_chunk.dats"
tmp34 = chunklst_data_nonalign_get (arg0) ;
#line 242 "gcats1_chunk.dats"
tmp35 = chunklst_itemwsz_get (arg0) ;
#line 243 "gcats1_chunk.dats"
/* tmp36 = */ chunk_header_free (arg0) ;
#line 246 "gcats1_chunk.dats"
tmp40 = atspre_asl_int_int1 (1, 11) ;
#line 246 "gcats1_chunk.dats"
tmp39 = atspre_sub_int_int (tmp40, 1) ;
#line 246 "gcats1_chunk.dats"
tmp38 = atspre_add_int_int (tmp35, tmp39) ;
#line 246 "gcats1_chunk.dats"
tmp37 = atspre_asr_int_int1 (tmp38, 11) ;
#line 247 "gcats1_chunk.dats"
/* tmp41 = */ the_chunk_count_dec_by (tmp37) ;
#line 249 "gcats1_chunk.dats"
do {
/* branch: __ats_lab_0 */
#line 250 "gcats1_chunk.dats"
__ats_lab_0_0:
#line 250 "gcats1_chunk.dats"
__ats_lab_0_1:
#line 250 "gcats1_chunk.dats"
tmp43 = atspre_asl_int_int1 (1, 11) ;
#line 250 "gcats1_chunk.dats"
tmp42 = atspre_gt_int_int (tmp35, tmp43) ;
#line 250 "gcats1_chunk.dats"
if (!tmp42) { goto __ats_lab_1_1 ; }
#line 257 "gcats1_chunk.dats"
/* tmp32 = */ freeitmlst_chunk_data_free (tmp34) ;
break ;

/* branch: __ats_lab_1 */
#line 259 "gcats1_chunk.dats"
__ats_lab_1_0:
#line 259 "gcats1_chunk.dats"
__ats_lab_1_1:
#line 260 "gcats1_chunk.dats"
/* tmp32 = */ freeitmlst_chunk_data_recycle (tmp34) ;
break ;
} while (0) ;
return /* (tmp32) */ ;
} /* end of [chunklst_destroy] */

/*
// /home/hwxi/research/Anairiats/ccomp/runtime/GCATS1/gcats1_chunk.dats: 8137(line=274, offs=7) -- 8426(line=282, offs=8)
*/
ATSstaticdec()
ats_void_type
gcats1_chunk_loop_9 (ats_ptr_type arg0, ats_int_type arg1) {
/* local vardec */
// ATSlocal_void (tmp45) ;
ATSlocal (ats_bool_type, tmp46) ;
ATSlocal (ats_ptr_type, tmp47) ;
// ATSlocal_void (tmp48) ;
ATSlocal (ats_bool_type, tmp49) ;
ATSlocal (ats_int_type, tmp50) ;

__ats_lab_gcats1_chunk_loop_9:
#line 276 "gcats1_chunk.dats"
tmp46 = atspre_ilt (arg1, 1024) ;
#line 276 "gcats1_chunk.dats"
if (tmp46) {
#line 277 "gcats1_chunk.dats"
tmp47 = botsegtbllst_get (arg0, arg1) ;
#line 278 "gcats1_chunk.dats"
tmp49 = chunklst_is_cons (tmp47) ;
#line 278 "gcats1_chunk.dats"
if (tmp49) {
#line 278 "gcats1_chunk.dats"
/* tmp48 = */ gc_markbits_clear_chunk (tmp47) ;
} else {
/* empty */
} /* end of [if] */
#line 281 "gcats1_chunk.dats"
tmp50 = atspre_iadd (arg1, 1) ;
#line 281 "gcats1_chunk.dats"
arg0 = arg0 ;
#line 281 "gcats1_chunk.dats"
arg1 = tmp50 ;
#line 281 "gcats1_chunk.dats"
goto __ats_lab_gcats1_chunk_loop_9 ; // tail call
} else {
/* empty */
} /* end of [if] */
return /* (tmp45) */ ;
} /* end of [gcats1_chunk_loop_9] */

/*
// /home/hwxi/research/Anairiats/ccomp/runtime/GCATS1/gcats1_chunk.dats: 8088(line=272, offs=39) -- 8465(line=285, offs=4)
*/
ATSglobaldec()
ats_void_type
gc_markbits_clear_botsegtbl (ats_ptr_type arg0) {
/* local vardec */
// ATSlocal_void (tmp44) ;

__ats_lab_gc_markbits_clear_botsegtbl:
#line 284 "gcats1_chunk.dats"
/* tmp44 = */ gcats1_chunk_loop_9 (arg0, 0) ;
return /* (tmp44) */ ;
} /* end of [gc_markbits_clear_botsegtbl] */

/* static load function */

extern ats_void_type ATS_2d0_2e2_2e10_2ccomp_2runtime_2GCATS1_2gcats1_2esats__staload (void) ;

ats_void_type
ATS_2d0_2e2_2e10_2ccomp_2runtime_2GCATS1_2gcats1_chunk_2edats__staload () {
static int ATS_2d0_2e2_2e10_2ccomp_2runtime_2GCATS1_2gcats1_chunk_2edats__staload_flag = 0 ;
if (ATS_2d0_2e2_2e10_2ccomp_2runtime_2GCATS1_2gcats1_chunk_2edats__staload_flag) return ;
ATS_2d0_2e2_2e10_2ccomp_2runtime_2GCATS1_2gcats1_chunk_2edats__staload_flag = 1 ;

ATS_2d0_2e2_2e10_2ccomp_2runtime_2GCATS1_2gcats1_2esats__staload () ;

return ;
} /* staload function */

/* dynamic load function */

// dynload flag declaration
extern ats_int_type ATS_2d0_2e2_2e10_2ccomp_2runtime_2GCATS1_2gcats1_chunk_2edats__dynload_flag ;

ats_void_type
ATS_2d0_2e2_2e10_2ccomp_2runtime_2GCATS1_2gcats1_chunk_2edats__dynload () {
ATS_2d0_2e2_2e10_2ccomp_2runtime_2GCATS1_2gcats1_chunk_2edats__dynload_flag = 1 ;
ATS_2d0_2e2_2e10_2ccomp_2runtime_2GCATS1_2gcats1_chunk_2edats__staload () ;

#ifdef _ATS_PROOFCHECK
#endif /* _ATS_PROOFCHECK */

/* marking static variables for GC */

/* marking external values for GC */

/* code for dynamic loading */
return ;
} /* end of [dynload function] */

/* external codes at mid */
/* external codes at bot */
#line 289 "gcats1_chunk.dats"


#if (__WORDSIZE == 32)

ats_ptr_type botsegtbl_make_32 () {
  botsegtbllst tbls ;
/*
  fprintf (
    stderr, "botsegtbl_make_32: sizeof(botsegtbl) = %i\n", sizeof(botsegtbl)
  ) ; // end of [fprintf]
*/
  tbls = (botsegtbllst)malloc(sizeof(botsegtbl)) ;
  if (!tbls) {
    fprintf (stderr, "Exit: [botsegtbl_make_32: malloc] failed\n") ;
    exit (1) ;
  } // end of [if]

  memset(tbls, 0, sizeof(botsegtbl)) ;
/*
  fprintf (stderr, "botsegtbl_make_32: return: tbls = %p\n", tbls) ;
*/
  return tbls ;
} /* end of [botsegtbl_make_32] */

#endif // end of [__WORDSIZE == 32]

/* ****** ****** */

#if (__WORDSIZE == 64)

ats_ptr_type botsegtbl_make_64
  (ats_uintptr1_type ofs, ats_ptr_type tbls0) {
  botsegtbllst tbls ;
/*
  fprintf (
    stderr, "botsegtbl_make_64: sizeof(botsegtbl) = %i\n", sizeof(botsegtbl)
  ) ; // end of [fprintf]
*/
  tbls = (botsegtbllst)malloc(sizeof(botsegtbl)) ;
  if (!tbls) {
    fprintf (stderr, "Exit: [botsegtbl_make_64: malloc] failed\n") ;
    exit (1) ;
  } // end of [if]

  memset(tbls, 0, sizeof(botsegtbl)) ;

  tbls->key = ofs ; tbls->hash_next = (botsegtbllst)tbls0 ;
/*
  fprintf (stderr, "botsegtbl_make_64: tbls = %p\n", tbls) ;
*/
  return tbls ;
} /* end of [botsegtbl_make_64] */

#endif // end of [__WORDSIZE == 64]

#line 348 "gcats1_chunk.dats"


ats_ptr_type gc_ptr_is_valid
  (ats_ptr_type ptr, ats_ref_type ofs_r) {
  uintptr_t ofs_topseg ;
  int ofs_botseg, ofs_chkseg, itemwsz ;
  botsegtbllst tbls = (botsegtbllst)0 ;
  chunklst chks = (chunklst)0 ;
/*
  fprintf (stderr, "gc_ptr_is_valid: 1: ptr = %p\n", ptr) ;
*/
  if (!ptr) return (chunklst)0 ;

/*
  fprintf (stderr, "gc_ptr_is_valid: 2: ptr = %p\n", ptr) ;
*/
  if ((uintptr_t)ptr & NBYTE_PER_WORD_MASK) return (chunklst)0 ;

  ofs_topseg = PTR_TOPSEG_GET (ptr) ;

/*
  fprintf (stderr, "gc_ptr_is_valid: 3: ofs_topseg = %li\n", ofs_topseg) ;
*/

#if (__WORDSIZE == 32)
  tbls = the_topsegtbl_get_32 (ofs_topseg) ;
#endif

#if (__WORDSIZE == 64)
  tbls = the_topsegtbl_get_64 (ofs_topseg) ;
#endif

  if (!tbls) return (chunklst)0 ;

  ofs_botseg = PTR_BOTSEG_GET (ptr) ;
  chks = botsegtbllst_get (tbls, ofs_botseg) ;
/*
  fprintf (stderr, "gc_ptr_is_valid: 4: ofs_botseg = %li\n", ofs_botseg) ;
*/
  if (!chks) return (chunklst)0 ;

  ofs_chkseg = PTR_CHKSEG_GET (ptr) ;
  itemwsz = chks->itemwsz ;
/*
  fprintf (stderr, "gc_ptr_is_valid: 5: ofs_chkseg = %li\n", ofs_chkseg) ;
  fprintf (stderr, "gc_ptr_is_valid: 6: itemwsz = %i\n", itemwsz) ;
*/

/*
** for a large chunk (itemwsz_log = -1), ofs_chkseg == 0
*/
  if (ofs_chkseg % itemwsz) return (chunklst)0 ;

  *((int*)ofs_r) = (ofs_chkseg / itemwsz) ;

  return chks ;
} /* end of [gc_ptr_is_valid] */

#line 410 "gcats1_chunk.dats"


/*

// itemwsz_log = log (itemwsz) if itemwsz_log >= 0
fun chunklst_create (itemwsz_log: int, itemwsz: int): chunklst1

*/

ats_ptr_type chunklst_create
  (ats_int_type itemwsz_log, ats_int_type itemwsz) {
  int i, err ;
  int chunk_bsz, data_ofs ;
  int itemtot, nmarkbit ;
  freeitmlst data ;
  chunklst chks ;
/*
  fprintf (stderr, "chunklst_create: itemwsz_log = %i\n", itemwsz_log) ;
  fprintf (stderr, "chunklst_create: itemwsz = %i\n", itemwsz) ;
*/
  if (itemwsz_log >= 0) {
    itemtot = (CHUNK_WORDSIZE >> itemwsz_log) ;
    nmarkbit = (itemtot + NBIT_PER_BYTE_MASK) >> NBIT_PER_BYTE_LOG ;
  } else {
    itemtot = 1 ; nmarkbit = 1 ;
  }

  chks = (chunklst)malloc(sizeof(chunk) + nmarkbit) ;
  if (!chks) {
    fprintf (
      stderr, "GC Fatal Error: [chunklst_create]: [malloc] failed.\n"
    ) ; // end of [fprintf]
    exit (1) ;
  } // end of [if]

  data = (freeitmlst)0 ;
  if (itemwsz <= MAX_CHUNK_BLOCK_WORDSIZE) {
    if (the_freeitmlst_chunk_data) {
      data = the_freeitmlst_chunk_data;
      the_freeitmlst_chunk_data = *(freeitmlst*)data ;
    } // end of [if]
  } // end of [if]
/*
  fprintf (stderr, "chunklst_create: data = %p(%i)\n", data, data) ;
*/
  if (!data) {
    if (itemwsz > CHUNK_WORDSIZE)
      chunk_bsz = itemwsz << NBYTE_PER_WORD_LOG ;
    else chunk_bsz = CHUNK_BYTESIZE ;
/*
    fprintf (stderr, "gcats_memalign: size = %i\n", chunk_bsz) ;
*/
    err = gcats_memalign
      (&data, CHUNK_BYTESIZE/*alignment*/, chunk_bsz/*size*/) ;
/*
    fprintf (stderr, "gcats_memalign: err = %i\n", err) ;
*/
    if (err) {
      fprintf (stderr, "GC: Fatal Error: [gcats_memalign] failed\n") ;
      exit (1) ;
    } // end of [if]
  } // end of [if]
/*
  fprintf (stderr, "chunklst_create: data = %p(%i)\n", data, data) ;
*/
  chks->itemwsz = itemwsz ;
  chks->itemwsz_log = itemwsz_log ;
  chks->itemtot = itemtot ;
  chks->markcnt = 0 ; // for fast threading!
#ifdef _ATS_MULTITHREAD
  chks->freecnt = 0 ; // not in use yet
#endif
  chks->sweep_next = (chunklst)0 ;
  data_ofs = (uintptr_t)data & (CHUNK_BYTESIZE - 1) ;
  if (data_ofs) {
/*
    fprintf (stderr, "chunklst_create: data_ofs = %i\n", data_ofs) ;
*/
    chks->data = (byte*)data - data_ofs + CHUNK_BYTESIZE ;
  } else {
    chks->data = data ;
  }
  chks->data_nonalign = data ; // [data] is *not* zeroed
  memset (chks->markbits, 0, nmarkbit) ;

  the_chunk_count_inc_by ((itemwsz + CHUNK_WORDSIZE_MASK) >> CHUNK_WORDSIZE_LOG) ;

  chunklst_insert_into_table (chks) ;
/*
  fprintf (stderr, "chunklst_create: chks = %p(%i)\n", chks, chks) ;
*/
  return chks ;

} /* end of [chunklst_create] */

#line 509 "gcats1_chunk.dats"


#if (__WORDSIZE == 32)

ats_void_type gc_markbits_clear_the_topsegtbl () {
  int i ; botsegtbllst tbls ;
  for (i = 0; i < TOPSEG_TABLESIZE; i += 1) {
    tbls = the_topsegtbl[i] ;
    if (tbls) gc_markbits_clear_botsegtbl (tbls) ;
  } // end of [for]
  return ;
} /* end of [gc_markbits_clear_the_topsegtbl] */

#endif // end of [__WORDSIZE == 32]

#if (__WORDSIZE == 64)

ats_void_type gc_markbits_clear_the_topsegtbl () {
  int i ; botsegtbllst tbls ;
  for (i = 0; i < TOPSEG_HASHTABLESIZE; i += 1) {
    tbls = the_topsegtbl[i] ;
    while (tbls) { // terminating: obvious
      gc_markbits_clear_botsegtbl (tbls) ; tbls = tbls->hash_next ;
    } // end of [while]
  } // end of [for]
  return ;
} /* end of [gc_markbits_clear_the_topsegtbl] */

#endif // end of [__WORDSIZE == 64]



/* ****** ****** */

/* end of [gcats1_chunk_dats.c] */
