// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __verbose_mgr_h__
#define __verbose_mgr_h__

#include <sstream>
#include <iostream>
using namespace std;

namespace Puma {


class VerboseMgr : public std::ostringstream {
  int _level;
  int _verbose;
  ostream &_out;

public:
  VerboseMgr (ostream &out) : _level (0), _verbose (10), _out (out) {}
  VerboseMgr (ostream &out,int verbose) : _level (0), _verbose (verbose), _out (out) {}
  void verbose (int verbose) { _verbose = verbose; }
  int verbose () { return _verbose; }
  void operator ++ (int) { _level++; }
  void operator -- (int) { _level--; }
  void endl ();
};

inline ostream &endvm (ostream &outs) {
  ((VerboseMgr&)outs).endl ();
  return outs;
}


} // namespace Puma

#endif /* __verbose_mgr_h__ */
