// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ACWeaver_h__
#define __ACWeaver_h__

// C++ includes
#include <sstream>
using std::stringstream;
#include <set>
using std::set;
#include <list>
using std::list;

// PUMA includes
#include "Puma/CProject.h"
#include "Puma/CUnit.h"

// AspectC++ includes
#include "ACConfig.h"
#include "LineDirectiveMgr.h"
using namespace Puma;

class Transformer;

namespace Puma {
  class VerboseMgr;
  class Unit;
} // namespace Puma

class ACWeaver {
  CProject &_project;
  ACConfig &_conf;
  LineDirectiveMgr _line_mgr;
  
  Unit *translate (VerboseMgr &vm, const char *file, Transformer &transformer);
  void aspect_includes (ostream &includes);
  void aspect_include (ostream &includes, const char *name);
  void insert_aspect_includes (VerboseMgr &vm, Unit* u, bool header,
      const string &aspect_includes, const string &aspect_fwd_decls);
  void insert_aspect_includes (VerboseMgr &vm, set<Unit*> &cc_units,
    set<Unit*> &h_units, const string &aspect_includes, const string &aspect_fwd_decls);
  void update_line_directives (set<Unit*> &cc_units, set<Unit*> &h_units);
  void update_line_directives (Unit *unit, const char *filename);
  ErrorStream &err () const { return _project.err (); }
  void match_expr_in_repo (VerboseMgr &vm);

public:
  
  // Initialize the weaver
  ACWeaver (CProject& project, ACConfig &conf);

  // Do the AspectC++ -> C++ tranformation on the project
  void weave ();
};

#endif // __ACWeaver_h__
