/*
 * image.c
 * This file is part of anyPaper
 *
 * Copyright (C) 2008 - Sergio Rodrigues de Oliveira Filho 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * "You should have received a copy of the GNU General Public License 
 * along with this program.  If not, see http://www.gnu.org/licenses/.
 */

#include <gtk/gtk.h>

#include "config.h"
#include "function.h"
#include "image.h"
#include "variables.h"

GdkInterpType quality=GDK_INTERP_BILINEAR;

int ox=0, oy=0, x=0, y=0, dx=0, dy=0;
double sx=1, sy=1;

void read_color ()
{
	gchar *background_buffer;
	GdkColor color;
	gtk_color_button_get_color (GTK_COLOR_BUTTON (cbutton), &color);
	background_buffer = gdk_color_to_string (&color);
	string_background = g_strdup_printf("%c%c%c%c%c%c00", background_buffer[1], background_buffer[2], background_buffer[5], background_buffer[6], background_buffer[9], background_buffer[10]);
}

void make_image(int md, gchar *image_name, GtkWidget *image)
{
	GdkPixbuf *tempbuf, *tempbuf2;
	int wn, hn;

	ox=0; oy=0; x=0; y=0; dx=0; dy=0; sx=1; sy=1;
	g_object_unref(pixbuf0);
	g_signal_handlers_block_by_func (G_OBJECT (spin1), G_CALLBACK (refresh_spin), (gpointer) "button 2");
	g_signal_handlers_block_by_func (G_OBJECT (spin2), G_CALLBACK (refresh_spin), (gpointer) "button 2");
	g_signal_handlers_block_by_func (G_OBJECT (spin3), G_CALLBACK (refresh), (gpointer) "button 2");
	g_signal_handlers_block_by_func (G_OBJECT (spin4), G_CALLBACK (refresh), (gpointer) "button 2");
	g_signal_handlers_block_by_func (G_OBJECT (cbutton), G_CALLBACK (refresh_spin), (gpointer) "button 2");
	g_signal_handlers_block_by_func (G_OBJECT (file_entry), G_CALLBACK (refresh), (gpointer) "button 2");
	g_signal_handlers_block_by_func (G_OBJECT (combo), G_CALLBACK (refresh), (gpointer) "button 2");
	g_signal_handlers_block_by_func (G_OBJECT (spin5), G_CALLBACK (refresh), (gpointer) "spin5");
	g_signal_handlers_block_by_func (G_OBJECT (spin6), G_CALLBACK (refresh), (gpointer) "spin6");

	tempbuf = gdk_pixbuf_new_from_file(image_name, NULL);
	if (md==5)
	{
		double scx, scy;

		tempbuf2 = tempbuf;
		scx = gtk_spin_button_get_value (GTK_SPIN_BUTTON (spin5));
		scy = gtk_spin_button_get_value (GTK_SPIN_BUTTON (spin6));
		w = gdk_pixbuf_get_width(tempbuf2);
		h = gdk_pixbuf_get_height(tempbuf2);
		tempbuf = gdk_pixbuf_scale_simple(tempbuf2, scx*w, scy*h, quality);
		g_object_unref(tempbuf2);
		md = 1;
	}
	pixbuf0 = gdk_pixbuf_add_alpha(tempbuf, FALSE, 0, 0, 0);
	g_object_unref(tempbuf);

	tempbuf = gdk_pixbuf_new(GDK_COLORSPACE_RGB, FALSE, 8, (screenw), (screenh));
	gdk_pixbuf_fill(tempbuf, spi(string_background,16));
	pixbuf = gdk_pixbuf_add_alpha(tempbuf, FALSE, 0, 0, 0);
	g_object_unref(tempbuf);
	w = gdk_pixbuf_get_width(pixbuf0);
	h = gdk_pixbuf_get_height(pixbuf0);

	if (md==0) 
	{
		x=y=0;
		dx=screenw;
		dy=screenh;
		ox=oy=0;
		sx=(double) screenw/w;
		sy=(double) screenh/h;
		gdk_pixbuf_composite(pixbuf0, pixbuf,x, y, dx, dy, ox, oy, sx, sy, quality, 0xff);
	}
	if (md==1)
	{
		if ((screenh-h)>=0)
		{
			y=((screenh-h))/2;
			oy=((screenh-h))/2;
			dy=h;
			gtk_spin_button_set_range (GTK_SPIN_BUTTON (spin2), 0, 2*oy);
		}
		if ((screenh-h)<0)
		{
			y=0;
			oy=((screenh-h))/2;
			dy=(screenh);
			gtk_spin_button_set_range (GTK_SPIN_BUTTON (spin2), 2*oy, 0);
		}
		if ((screenw-w)>=0)
		{
			x=((screenw-w))/2;
			ox=((screenw-w))/2;
			dx=w;
			gtk_spin_button_set_range (GTK_SPIN_BUTTON (spin1), 0, 2*ox);
		}
		if ((screenw-w)<0)
		{
			x=0;
			ox=((screenw-w))/2;
			dx=(screenw);
			gtk_spin_button_set_range (GTK_SPIN_BUTTON (spin1), 2*ox, 0);
		}
		gdk_pixbuf_composite(pixbuf0, pixbuf,x, y, dx, dy, ox, oy, sx, sy, quality, 0xff);
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin1), ox);
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin2), oy);
	}
	if (md==2)
	{
		while (x<(screenw))
		{
			while (y<(screenh))
			{
				if ((screenh-(h+y))>=0) dy=h;
				if ((screenh-(h+y))<0) dy=((screenh)-y);
				if ((screenw-(w+x))>=0) dx=w;
				if ((screenw-(w+x))<0) dx=((screenw)-x);

				gdk_pixbuf_composite(pixbuf0, pixbuf,x, y, dx, dy, x, y, sx, sy, quality, 0xff);
				y=y+(h);
			}
			x=x+(w);
			y=0;
		}
	}
	if (md==3)
	{
		hn=(h*screenw*100/w)/100;
		wn=(w*screenh*100/h)/100;
		if (hn<=((screenh)))
		{
			x=0;
			y=(screenh-hn)/2;
			dx=screenw;
			dy=hn;
			ox=0;
			oy=(screenh-hn)/2;
			sx=(double) screenw/w;
			sy=(double) screenw/w;
		}
		else
		{
			x=(screenw-wn)/2;
			y=0;
			dx=wn;
			dy=screenh;
			ox=(screenw-wn)/2;
			oy=0;
			sx=(double) screenh/h;
			sy=(double) screenh/h;
		}
		gdk_pixbuf_composite(pixbuf0, pixbuf,x, y, dx, dy, ox, oy, sx, sy, quality, 0xff);
		gtk_spin_button_set_range (GTK_SPIN_BUTTON (spin1), 0, 2*ox);
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin1), ox);
		gtk_spin_button_set_range (GTK_SPIN_BUTTON (spin2), 0, 2*oy);
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin2), oy);
	}
	if (md==4)
	{
		hn=(h*screenw*100/w)/100;
		wn=(w*screenh*100/h)/100;
		x=y=0;
		dx=screenw;
		dy=screenh;
		if (hn<=((screenh)))
		{
			ox=(screenw-wn)/2;
			oy=0;
			sx=(double) screenh/h;
			sy=(double) screenh/h;
		}
		else
		{
			ox=0;
			oy=(screenh-hn)/2;
			sx=(double) screenw/w;
			sy=(double) screenw/w;
		}
		gdk_pixbuf_composite(pixbuf0, pixbuf,x, y, dx, dy, ox, oy, sx, sy, quality, 0xff);
		gtk_spin_button_set_range (GTK_SPIN_BUTTON (spin1), 2*ox, 0);
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin1), ox);
		gtk_spin_button_set_range (GTK_SPIN_BUTTON (spin2), 2*oy, 0);
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin2), oy);
	}
	tempbuf = gdk_pixbuf_scale_simple(pixbuf, (gdouble)(120*screenw/screenh), (gdouble)(120), quality);
	gtk_image_set_from_pixbuf (GTK_IMAGE(image), tempbuf);
	g_object_unref(tempbuf);

	g_signal_handlers_unblock_by_func (G_OBJECT (spin1), G_CALLBACK (refresh_spin), (gpointer) "button 2");
	g_signal_handlers_unblock_by_func (G_OBJECT (spin2), G_CALLBACK (refresh_spin), (gpointer) "button 2");
	g_signal_handlers_unblock_by_func (G_OBJECT (spin3), G_CALLBACK (refresh), (gpointer) "button 2");
	g_signal_handlers_unblock_by_func (G_OBJECT (spin4), G_CALLBACK (refresh), (gpointer) "button 2");
	g_signal_handlers_unblock_by_func (G_OBJECT (cbutton), G_CALLBACK (refresh_spin), (gpointer) "button 2");
	g_signal_handlers_unblock_by_func (G_OBJECT (file_entry), G_CALLBACK (refresh), (gpointer) "button 2");
	g_signal_handlers_unblock_by_func (G_OBJECT (combo), G_CALLBACK (refresh), (gpointer) "button 2");
	g_signal_handlers_unblock_by_func (G_OBJECT (spin5), G_CALLBACK (refresh), (gpointer) "spin5");
	g_signal_handlers_unblock_by_func (G_OBJECT (spin6), G_CALLBACK (refresh), (gpointer) "spin6");
}

void move_image(gchar *image_name, GtkWidget *image)
{
	GdkPixbuf *tempbuf;
	gdouble min, max;
	g_signal_handlers_block_by_func (G_OBJECT (spin1), G_CALLBACK (refresh_spin), (gpointer) "button 2");
	g_signal_handlers_block_by_func (G_OBJECT (spin2), G_CALLBACK (refresh_spin), (gpointer) "button 2");
	g_signal_handlers_block_by_func (G_OBJECT (spin3), G_CALLBACK (refresh), (gpointer) "button 2");
	g_signal_handlers_block_by_func (G_OBJECT (spin4), G_CALLBACK (refresh), (gpointer) "button 2");
	g_signal_handlers_block_by_func (G_OBJECT (cbutton), G_CALLBACK (refresh_spin), (gpointer) "button 2");
	g_signal_handlers_block_by_func (G_OBJECT (file_entry), G_CALLBACK (refresh), (gpointer) "button 2");
	g_signal_handlers_block_by_func (G_OBJECT (combo), G_CALLBACK (refresh), (gpointer) "button 2");

	tempbuf = gdk_pixbuf_new(GDK_COLORSPACE_RGB, FALSE, 8, (screenw), (screenh));
	gdk_pixbuf_fill(tempbuf, spi(string_background,16));
	pixbuf = gdk_pixbuf_add_alpha(tempbuf, FALSE, 0, 0, 0);
	g_object_unref(tempbuf);
	gtk_spin_button_get_range (GTK_SPIN_BUTTON (spin1), &min, &max);
	if (min==0) x=ox=gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin1));
	else 
	{
		x=0;
		ox=gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin1));
	}
	gtk_spin_button_get_range (GTK_SPIN_BUTTON (spin2), &min, &max);
	if (min==0) y=oy=gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin2));
	else
	{
		y=0;
		oy=gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin2));
	}
	gdk_pixbuf_composite(pixbuf0, pixbuf,x, y, dx, dy, ox, oy, sx, sy, quality, 0xff);

	tempbuf = gdk_pixbuf_scale_simple(pixbuf, (gdouble)(120*screenw/screenh), (gdouble)(120), quality);
	gtk_image_set_from_pixbuf (GTK_IMAGE(image), tempbuf);
	g_object_unref(tempbuf);

	g_signal_handlers_unblock_by_func (G_OBJECT (spin1), G_CALLBACK (refresh_spin), (gpointer) "button 2");
	g_signal_handlers_unblock_by_func (G_OBJECT (spin2), G_CALLBACK (refresh_spin), (gpointer) "button 2");
	g_signal_handlers_unblock_by_func (G_OBJECT (spin3), G_CALLBACK (refresh), (gpointer) "button 2");
	g_signal_handlers_unblock_by_func (G_OBJECT (spin4), G_CALLBACK (refresh), (gpointer) "button 2");
	g_signal_handlers_unblock_by_func (G_OBJECT (cbutton), G_CALLBACK (refresh_spin), (gpointer) "button 2");
	g_signal_handlers_unblock_by_func (G_OBJECT (file_entry), G_CALLBACK (refresh), (gpointer) "button 2");
	g_signal_handlers_unblock_by_func (G_OBJECT (combo), G_CALLBACK (refresh), (gpointer) "button 2");
}

void set_background_image( GtkWidget *widget, gpointer data )
{
	char *buffer, op;
	GtkWidget *dialog, *dialog_error;
	GtkWidget *window;

	window = GTK_WIDGET (data);

	char *filename, *down_filename;

	filename = gtk_entry_get_text (GTK_ENTRY (def_entry));
	down_filename = g_ascii_strdown (filename, -1);

	if (!g_file_test (gtk_entry_get_text (GTK_ENTRY (file_entry)), G_FILE_TEST_EXISTS))
	{
		dialog = gtk_message_dialog_new (GTK_WINDOW (window), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "No such file exists");
		gtk_window_set_title (GTK_WINDOW (dialog), "Error");
		g_signal_connect_swapped (dialog, "response", G_CALLBACK (gtk_widget_destroy), dialog);
		gtk_widget_show(dialog);
	}
	else
	{
		if ((g_str_has_suffix (down_filename, ".jpg")) || (g_str_has_suffix (down_filename, ".jpeg"))) 
		{
			gdk_pixbuf_save (pixbuf, filename, "jpeg", NULL, "quality", "100", NULL);
			buffer=g_strdup_printf("%s \"%s\"", gtk_entry_get_text (GTK_ENTRY (com_entry)), filename);
			if (system (buffer))
			{
				dialog = gtk_message_dialog_new (GTK_WINDOW (window), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "Invalid command");
				gtk_window_set_title (GTK_WINDOW (dialog), "Error");
			 	g_signal_connect_swapped (dialog, "response", G_CALLBACK (gtk_widget_destroy), dialog);
				gtk_widget_show(dialog);
			}
		}
		else if(g_str_has_suffix (down_filename, ".png"))
		{
			gdk_pixbuf_save (pixbuf, filename, "png", NULL, NULL);
			buffer=g_strdup_printf("%s \"%s\"", gtk_entry_get_text (GTK_ENTRY (com_entry)), filename);
			if (system (buffer))
			{
				dialog = gtk_message_dialog_new (GTK_WINDOW (window), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "Invalid command");
				gtk_window_set_title (GTK_WINDOW (dialog), "Error");
			 	g_signal_connect_swapped (dialog, "response", G_CALLBACK (gtk_widget_destroy), dialog);
				gtk_widget_show(dialog);
			}
		}
		else
		{
			dialog_error = gtk_message_dialog_new (GTK_WINDOW (window), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "Invalid format");
			gtk_window_set_title (GTK_WINDOW (dialog_error), "Error");
		 	g_signal_connect_swapped (dialog_error, "response", G_CALLBACK (gtk_widget_destroy), dialog_error);
			gtk_widget_show(dialog_error);
		}
		g_free (down_filename);
		write_parameters ();
	}
}

void refresh( GtkWidget *widget, gpointer data )
{
	int md;
	g_object_unref(pixbuf);
	screenw = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(spin3));
	screenh = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(spin4));
	interpolation_set(gtk_combo_box_get_active (GTK_COMBO_BOX (combo_interpolation)));
	make_image(gtk_combo_box_get_active (GTK_COMBO_BOX (combo)), gtk_entry_get_text (GTK_ENTRY (file_entry)), preview);
	show_spin(gtk_combo_box_get_active (GTK_COMBO_BOX (combo)));
}

void refresh_color( GtkWidget *widget, gpointer data )
{
	read_color();
	if (gtk_combo_box_get_active (GTK_COMBO_BOX (combo)) != 2)
	{
		g_object_unref(pixbuf);
		interpolation_set(gtk_combo_box_get_active (GTK_COMBO_BOX (combo_interpolation)));
		move_image(gtk_entry_get_text (GTK_ENTRY (file_entry)), preview);
	}
}

