/*
 * about.c
 * This file is part of anyPaper
 *
 * Copyright (C) 2008 - Sergio Rodrigues de Oliveira Filho 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * "You should have received a copy of the GNU General Public License 
 * along with this program.  If not, see http://www.gnu.org/licenses/.
 */

#include <gtk/gtk.h>

#include "config.h"
#include "variables.h"

void about_window( GtkWidget *widget, gpointer data )
{
	GtkWidget *window;

	window = GTK_WIDGET (data);

	static const gchar * const authors[] = {
		"Sergio Rodrigues de Oliveira Filho <cdvdt@users.sourceforge.net>",
		NULL
	};

	static const gchar * const documenters[] = {
		"Ninguém",
		NULL
	};

	static const gchar copyright[] = \
		"Copyright \xc2\xa9 2007-2009 Sergio Rodrigues de Oliveira Filho";

	static const gchar comments[] = \
		"anyPaper adjusts the image that will be used as wallpaper and set it";

	static const gchar license[] = LICENSE;

	GdkPixbuf *logo;

	logo = gdk_pixbuf_new_from_file (ANYPAPER_DATA "anypaper.png",
					 NULL);

	gtk_show_about_dialog (GTK_WINDOW (window),
				"authors", authors,
				"comments", comments,
				"copyright", copyright,
				"logo", logo,
				"version", VERSION,
				"license", license,
				"website", "anypaper.sourceforge.net",
				"name", "nPaper",
				"wrap-license",TRUE,
				NULL);

	if (logo)
		g_object_unref (logo);
}

