// ---------------------------------------------------------------------------
// - Saveas.hpp                                                             -
// - afnix:sps module - saveas class definition                             -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2019 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_SAVEAS_HPP
#define  AFNIX_SAVEAS_HPP

#ifndef  AFNIX_TAGGABLE_HPP
#include "Taggable.hpp"
#endif

namespace afnix {

  /// The Saveas class is a base class for a persistent object. The class
  /// defines the methods that are used to write a particular object. When
  /// saving, the object name is retreived with the getname method.
  /// The saveas method does the same as save but takes a name argument.
  /// @author amaury darsch

  class Saveas : public Taggable {
  public:
    /// save the object
    virtual void save (void) const;

    /// save the object by name
    virtual void saveas (const String& name) const;    

  public:
    /// @return true if the given quark is defined
    bool isquark (const long quark, const bool hflg) const;

    /// apply this object with a set of arguments and a quark
    /// @param robj  the current runnable
    /// @param nset  the current nameset    
    /// @param quark the quark to apply these arguments
    /// @param argv  the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
                   Vector* argv);
  };
}

#endif
