// -*- C++ -*-
// $Id: Writer_Receiver_exec.cpp 92776 2010-12-03 06:18:09Z msmit $

/**
 * Code generated by the The ACE ORB (TAO) IDL Compiler v1.8.3
 * TAO and the TAO IDL Compiler have been developed by:
 *       Center for Distributed Object Computing
 *       Washington University
 *       St. Louis, MO
 *       USA
 *       http://www.cs.wustl.edu/~schmidt/doc-center.html
 * and
 *       Distributed Object Computing Laboratory
 *       University of California at Irvine
 *       Irvine, CA
 *       USA
 * and
 *       Institute for Software Integrated Systems
 *       Vanderbilt University
 *       Nashville, TN
 *       USA
 *       http://www.isis.vanderbilt.edu/
 *
 * Information about TAO is available at:
 *     http://www.cs.wustl.edu/~schmidt/TAO.html
 **/

#include "Writer_Receiver_exec.h"
#include "tao/ORB_Core.h"
#include "ace/Reactor.h"

#include "Connector/Writer_Connector_conn.h"
#include <dds4ccm/impl/CCM_DataReader.h>

namespace CIAO_Writer_Receiver_Impl
{

  /**
   * Facet Executor Implementation Class: info_out_data_listener_exec_i
   */

  info_out_data_listener_exec_i::info_out_data_listener_exec_i (
        ::Writer::CCM_Receiver_Context_ptr ctx)
    : ciao_context_ (
        ::Writer::CCM_Receiver_Context::_duplicate (ctx))
  {
  }

  info_out_data_listener_exec_i::~info_out_data_listener_exec_i (void)
  {
  }

  // Operations from ::WriterTestConnector::Listener

  void
  info_out_data_listener_exec_i::on_one_data (const ::WriterTest & datum,
  const ::CCM_DDS::ReadInfo & /* info */)
  {
    ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("WriterTest_Listener: ")
            ACE_TEXT ("received writer info for <%C> at %u\n"),
            datum.key.in (),
            datum.iteration));
  }

  void
  info_out_data_listener_exec_i::on_many_data (const ::WriterTestSeq & data,
  const ::CCM_DDS::ReadInfoSeq & /* infos */)
  {
    for (CORBA::ULong i = 0; i < data.length (); ++i)
      {
        ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("WriterTest_Listener: ")
                ACE_TEXT ("received writer info for <%C> at %u\n"),
                data[i].key.in (),
                data[i].iteration));
      }
  }

  /**
   * Facet Executor Implementation Class: info_out_status_exec_i
   */

  info_out_status_exec_i::info_out_status_exec_i (
        ::Writer::CCM_Receiver_Context_ptr ctx)
    : ciao_context_ (
        ::Writer::CCM_Receiver_Context::_duplicate (ctx))
  {
  }

  info_out_status_exec_i::~info_out_status_exec_i (void)
  {
  }

  // Operations from ::CCM_DDS::PortStatusListener

  void
  info_out_status_exec_i::on_requested_deadline_missed (::DDS::DataReader_ptr /* the_reader */,
  const ::DDS::RequestedDeadlineMissedStatus & /* status */)
  {
    /* Your code here. */
  }

  void
  info_out_status_exec_i::on_sample_lost (::DDS::DataReader_ptr /* the_reader */,
  const ::DDS::SampleLostStatus & /* status */)
  {
    /* Your code here. */
  }

  /**
   * Component Executor Implementation Class: Receiver_exec_i
   */

  Receiver_exec_i::Receiver_exec_i (void){
  }

  Receiver_exec_i::~Receiver_exec_i (void)
  {
  }

  // Supported operations and attributes.

  // Component attributes and port operations.

  ::WriterTestConnector::CCM_Listener_ptr
  Receiver_exec_i::get_info_out_data_listener (void)
  {
    if ( ::CORBA::is_nil (this->ciao_info_out_data_listener_.in ()))
      {
        info_out_data_listener_exec_i *tmp = 0;
        ACE_NEW_RETURN (
          tmp,
          info_out_data_listener_exec_i (
            this->ciao_context_.in ()),
            ::WriterTestConnector::CCM_Listener::_nil ());

          this->ciao_info_out_data_listener_ = tmp;
      }

    return
      ::WriterTestConnector::CCM_Listener::_duplicate (
        this->ciao_info_out_data_listener_.in ());
  }

  ::CCM_DDS::CCM_PortStatusListener_ptr
  Receiver_exec_i::get_info_out_status (void)
  {
    if ( ::CORBA::is_nil (this->ciao_info_out_status_.in ()))
      {
        info_out_status_exec_i *tmp = 0;
        ACE_NEW_RETURN (
          tmp,
          info_out_status_exec_i (
            this->ciao_context_.in ()),
            ::CCM_DDS::CCM_PortStatusListener::_nil ());

          this->ciao_info_out_status_ = tmp;
      }

    return
      ::CCM_DDS::CCM_PortStatusListener::_duplicate (
        this->ciao_info_out_status_.in ());
  }

  // Operations from Components::SessionComponent.

  void
  Receiver_exec_i::set_session_context (
    ::Components::SessionContext_ptr ctx)
  {
    this->ciao_context_ =
      ::Writer::CCM_Receiver_Context::_narrow (ctx);

    if ( ::CORBA::is_nil (this->ciao_context_.in ()))
      {
        throw ::CORBA::INTERNAL ();
      }
  }

  void
  Receiver_exec_i::configuration_complete (void)
  {
    /* Your code here. */
  }

  void
  Receiver_exec_i::ccm_activate (void)
  {
    WriterTestDataReader * reader = 0;

    ::DDS::DataReader_var dds_dr =
      this->ciao_context_->get_connection_info_out_dds_entity ();

    if (::CORBA::is_nil (dds_dr.in ()))
      {
        ACE_ERROR ((LM_ERROR, "ERROR : Receiver_exec_i::ccm_activate - "
                    "Datareader connection is NIL.\n"));
        throw ::CORBA::INTERNAL ();
      }

    ::CIAO::DDS4CCM::CCM_DataReader * ccm_dr =
      dynamic_cast < ::CIAO::DDS4CCM::CCM_DataReader *  > (dds_dr.in ());

    if (ccm_dr)
      {
        typedef ::CIAO::NDDS::DDS_DataReader_Base DataReader_type;

        ::DDS::DataReader_var tmp = ccm_dr->get_dds_entity ();
        if (! ::CORBA::is_nil (tmp.in ()))
          {
            DataReader_type * typed_ccm_dr =
              dynamic_cast <DataReader_type*> (tmp.in ());
            if (typed_ccm_dr)
              {
                DDSDataReader* dds_reader = typed_ccm_dr->get_rti_entity ();
                if (dds_reader)
                  {
                    reader = ::CIAO_WriterTestConnector_DDS_Event_Impl
                             ::WriterTest_DDS_Traits
                             ::datareader_type::narrow (dds_reader);
                    if (!reader)
                      {
                        ACE_ERROR ((LM_ERROR, "ERROR : Receiver_exec_i::ccm_activate - "
                                    "Error narrowing to a typed "
                                    "DDS DataReader.\n"));
                        throw ::CORBA::INTERNAL ();
                      }
                  }
                else
                  {
                    ACE_ERROR ((LM_ERROR, "ERROR : Receiver_exec_i::ccm_activate - "
                                "Error getting DDS Datareader.\n"));
                    throw ::CORBA::INTERNAL ();
                  }
              }
            else
              {
                ACE_ERROR ((LM_ERROR, "ERROR : Receiver_exec_i::ccm_activate - "
                            "Error casting DataReader to typed DataReader\n"));
                throw ::CORBA::INTERNAL ();
              }
          }
        else
          {
            ACE_ERROR ((LM_ERROR, "ERROR : Receiver_exec_i::ccm_activate - "
                        "::DDS::DataReader of CCM DataReader seems nil\n"));
            throw ::CORBA::INTERNAL ();
          }
      }
    else
      {
        ACE_ERROR ((LM_ERROR, "ERROR : Receiver_exec_i::ccm_activate - "
                    "Error casting DDS::DataReader to CCM_DataReader\n"));
        throw ::CORBA::INTERNAL ();
      }

    ::CIAO_WriterTestConnector_DDS_Event_Impl::WriterTest_DDS_Traits::dds_seq_type
      data;
    ::CIAO_WriterTestConnector_DDS_Event_Impl::WriterTest_DDS_Traits::sampleinfo_seq_type
      sample_info_seq;

    ::DDS::ReturnCode_t const result = reader->take (
                data,
                sample_info_seq,
                1,
                0);

    ACE_DEBUG ((LM_DEBUG, "Take returned %C with %d samples\n",
                ::CIAO::DDS4CCM::translate_retcode (result), data.length ()));

    ::DDS::ReturnCode_t const result_loan = reader->return_loan (data, sample_info_seq);

    ACE_DEBUG ((LM_DEBUG, "Return loan returned %C\n",
                ::CIAO::DDS4CCM::translate_retcode (result_loan)));

    ::CCM_DDS::DataListenerControl_var lc =
      this->ciao_context_->get_connection_info_out_data_control ();

    if (::CORBA::is_nil (lc.in ()))
      {
        ACE_ERROR ((LM_INFO, ACE_TEXT ("Error:  Listener control receptacle is null!\n")));
        throw ::CORBA::INTERNAL ();
      }
    lc->mode (::CCM_DDS::ONE_BY_ONE);
  }

  void
  Receiver_exec_i::ccm_passivate (void)
  {
    /* Your code here. */
  }

  void
  Receiver_exec_i::ccm_remove (void)
  {
    /* Your code here. */
  }

  extern "C" RECEIVER_EXEC_Export ::Components::EnterpriseComponent_ptr
  create_Writer_Receiver_Impl (void)
  {
    ::Components::EnterpriseComponent_ptr retval =
      ::Components::EnterpriseComponent::_nil ();

    ACE_NEW_NORETURN (
      retval,
      Receiver_exec_i);

    return retval;
  }
}
