// -*- C++ -*-
// $Id: ExceptionT_Sender_exec.cpp 92902 2010-12-17 15:09:42Z mcorino $

/**
 * Code generated by the The ACE ORB (TAO) IDL Compiler v1.8.3
 * TAO and the TAO IDL Compiler have been developed by:
 *       Center for Distributed Object Computing
 *       Washington University
 *       St. Louis, MO
 *       USA
 *       http://www.cs.wustl.edu/~schmidt/doc-center.html
 * and
 *       Distributed Object Computing Laboratory
 *       University of California at Irvine
 *       Irvine, CA
 *       USA
 * and
 *       Institute for Software Integrated Systems
 *       Vanderbilt University
 *       Nashville, TN
 *       USA
 *       http://www.isis.vanderbilt.edu/
 *
 * Information about TAO is available at:
 *     http://www.cs.wustl.edu/~schmidt/TAO.html
 **/

#include "ExceptionT_Sender_exec.h"
#include "ace/OS_NS_unistd.h"

namespace CIAO_ExceptionT_Sender_Impl
{
  CORBA::Short nr_of_received = 0;
  CORBA::Short nr_of_syn_received = 0;

  void HandleException (
        long id,
        const char* error_string,
        const char* test,
        const char* func)
  {
    if (id != 42)
      {
        ACE_ERROR ((LM_ERROR, "ERROR Sender: unexpected ID received in except "
                              "handler <%u> <%C> (%C)\n",
                               id, error_string,func));
        return;
      }
    if (ACE_OS::strcmp (test, "thrown by receiver") != 0)
      {
        ACE_ERROR ((LM_ERROR, "ERROR Sender (%s): unexpected string received in"
                              " except handler <%s>\n",
                              func, test));
        return;
      }
    ACE_DEBUG ((LM_DEBUG, "Sender: Caught correct exception <%u,"
                            "%C> for %C\n",
                            id, error_string, func));
    ++nr_of_received;
  }

  void HandleException (
        ::CCM_AMI::ExceptionHolder_ptr excep_holder,
        const char* func)
  {
    try
      {
        excep_holder->raise_exception ();
      }
    catch (const ExceptionT::InternalError& ex)
      {
        CIAO_ExceptionT_Sender_Impl::HandleException (ex.id,
                                                      ex.error_string.in (),
                                                      ex.test.in(), func);
      }
    catch (const CORBA::Exception& ex)
      {
        ex._tao_print_exception ("ERROR: Caught unexpected exception:");
      }
  }

  //============================================================
  // Worker thread for asynchronous invocations for MyFoo
  //============================================================
  asynch_foo_generator::asynch_foo_generator (
        ::ExceptionT::CCM_Sender_Context_ptr context)
     : context_(::ExceptionT::CCM_Sender_Context::_duplicate (context))
  {
  }

  int asynch_foo_generator::svc ()
  {
    ACE_OS::sleep (3);
    ::ExceptionT::AMI4CCM_MyFoo_var my_foo_ami_  =
        context_->get_connection_sendc_run_my_foo();

    if (CORBA::is_nil (my_foo_ami_))
      {
        ACE_ERROR ((LM_ERROR, "ERROR Sender (ASYNCH) :\tfoo_ami is NIL !\n"));
       return 1;
      }
    else
      {
       ::ExceptionT::AMI4CCM_MyFooReplyHandler_var cb =
          new AMI4CCM_MyFooReplyHandler_run_my_foo_i ();

        //Invoke Asynchronous calls to test exception handling
        //for this test, hello , get_ro_attrib and get_rw_attrib functions of
        //receiver always sent back a exception
        my_foo_ami_->sendc_hello (cb.in());
        my_foo_ami_->sendc_get_rw_attrib(cb.in());
        my_foo_ami_->sendc_get_ro_attrib(cb.in());
        my_foo_ami_->sendc_foo (cb.in(), "");
        my_foo_ami_->sendc_set_rw_attrib(cb.in(), 0);
      }
    return 0;
  }

  //============================================================
  // Worker thread for synchronous invocations for MyFoo
  //============================================================
  synch_foo_generator::synch_foo_generator (
      ::ExceptionT::CCM_Sender_Context_ptr context)
    : context_(::ExceptionT::CCM_Sender_Context::_duplicate (context))
  {
  }

  int synch_foo_generator::svc ()
  {
    ACE_OS::sleep (3);
    ::ExceptionT::MyFoo_var my_foo_ami_ =
          context_->get_connection_run_my_foo ();

    //run synch calls
    CORBA::String_var out_str;
    try
      {
        my_foo_ami_->foo ("Do something synchronous",
                           out_str.out ());
      }
    catch (const ExceptionT::InternalError&)
      {
        ACE_ERROR ((LM_ERROR, "ERROR: synch_foo_generator::foo: "
                              "Unexpected exception.\n"));
      }
    try
      {
        my_foo_ami_->foo ("", out_str);
      }
    catch (const ExceptionT::InternalError& ex)
      {
        //expected exception
        HandleException (ex.id, ex.error_string.in (), ex.test.in(),
                         "foo (syn)");
        ++nr_of_syn_received;

      }
    try
      {
        CORBA::Long answer;
        my_foo_ami_->hello (answer);
      }
    catch (const ExceptionT::InternalError& ex)
      {
        //expected exception
        HandleException (ex.id, ex.error_string.in (), ex.test.in(),
                         "hello (syn)");
        ++nr_of_syn_received;
      }
    try
      {
        my_foo_ami_->rw_attrib ();
      }
    catch (const ExceptionT::InternalError& ex)
      {
        //expected exception
        HandleException (ex.id, ex.error_string.in (), ex.test.in(),
                         "get_rw_attrib (syn)");
        ++nr_of_syn_received;
      }
    try
      {
        my_foo_ami_->rw_attrib (0);
      }
    catch (const ExceptionT::InternalError& ex)
      {
        //expected exception
        HandleException (ex.id, ex.error_string.in (), ex.test.in(),
                         "set_rw_attrib (syn)");
        ++nr_of_syn_received;
      }
    try
      {
        my_foo_ami_->ro_attrib ();
      }
    catch (const ExceptionT::InternalError& ex)
      {
        HandleException (ex.id, ex.error_string.in (), ex.test.in(),
                         "ro_attrib (syn)");
        ++nr_of_syn_received;
      }

    return 0;
    }

  /**
   * Component Executor Implementation Class: Sender_exec_i
   */

  Sender_exec_i::Sender_exec_i (void){
  }

  Sender_exec_i::~Sender_exec_i (void)
  {
  }

  // Supported operations and attributes.

  // Component attributes and port operations.

  // Operations from Components::SessionComponent.

  void
  Sender_exec_i::set_session_context (
    ::Components::SessionContext_ptr ctx)
  {
    this->ciao_context_ =
      ::ExceptionT::CCM_Sender_Context::_narrow (ctx);

    if ( ::CORBA::is_nil (this->ciao_context_.in ()))
      {
        throw ::CORBA::INTERNAL ();
      }
  }

  void
  Sender_exec_i::configuration_complete (void)
  {
    /* Your code here. */
  }

  void
  Sender_exec_i::ccm_activate (void)
  {
    this->asynch_foo_gen =
         new asynch_foo_generator (this->ciao_context_.in ());
     asynch_foo_gen->activate (THR_NEW_LWP | THR_JOINABLE, 1);

     this->synch_foo_gen =
       new synch_foo_generator (this->ciao_context_.in ());
     synch_foo_gen->activate (THR_NEW_LWP | THR_JOINABLE, 1);
  }

  void
  Sender_exec_i::ccm_passivate (void)
  {
    /* Your code here. */
  }

  void
  Sender_exec_i::ccm_remove (void)
  {
    CORBA::Short nr_of_asyn = nr_of_received - nr_of_syn_received;
    if (nr_of_asyn != 5)
      {
        ACE_ERROR ((LM_ERROR, "ERROR: not received the expected number of"
                              " exceptions for asynchronous calls"
                              "Expected: 5, Received: %u.\n",
                              nr_of_asyn));
      }
    if (nr_of_syn_received != 5)
      {
        ACE_ERROR ((LM_ERROR, "ERROR: not received the expected number of"
                              " exceptions for synchronous calls"
                              "Expected: 5, Received: %u.\n",
                              nr_of_syn_received));
      }
    if ((nr_of_asyn == 5) && (nr_of_syn_received == 5))
      {
        ACE_DEBUG ((LM_DEBUG, "OK: Received the expected number of"
                              " exceptions for  asynchronous and "
                              "synchronous calls\n"));
      }
    delete this->asynch_foo_gen;
    this->asynch_foo_gen = 0;
    delete this->synch_foo_gen;
    this->synch_foo_gen = 0;
  }
  AMI4CCM_MyFooReplyHandler_run_my_foo_i::AMI4CCM_MyFooReplyHandler_run_my_foo_i (void)
  {
  }

  AMI4CCM_MyFooReplyHandler_run_my_foo_i::~AMI4CCM_MyFooReplyHandler_run_my_foo_i (void)
  {
  }

  void
  AMI4CCM_MyFooReplyHandler_run_my_foo_i::foo (
    ::CORBA::Long /* ami_return_val */,
    const char * /* answer */)
  {
    // never should come here in this test.
    ACE_ERROR ((LM_ERROR, "ERROR: MyFoo_callback_exec_i::foo: "
                           "Unexpected return.\n"));
  }

  void
  AMI4CCM_MyFooReplyHandler_run_my_foo_i::foo_excep (
    ::CCM_AMI::ExceptionHolder_ptr excep_holder)
  {
    HandleException (excep_holder, "FOO (asyn)");
  }

  void
  AMI4CCM_MyFooReplyHandler_run_my_foo_i::hello (
    ::CORBA::Long /* answer */)
  {
    // never should come here in this test.
     ACE_ERROR ((LM_ERROR, "ERROR: MyFoo_callback_exec_i::hello: "
                            "Unexpected return.\n"));
  }

  void
  AMI4CCM_MyFooReplyHandler_run_my_foo_i::hello_excep (
    ::CCM_AMI::ExceptionHolder_ptr excep_holder)
  {
    HandleException (excep_holder, "HELLO (asyn)");
  }

  void
  AMI4CCM_MyFooReplyHandler_run_my_foo_i::get_rw_attrib (
    ::CORBA::Short /* rw_attrib */)
  {
    // never should come here in this test.
       ACE_ERROR ((LM_ERROR, "ERROR: MyFoo_callback_exec_i::get_rw_attrib : "
                              "Unexpected return.\n"));
  }

  void
  AMI4CCM_MyFooReplyHandler_run_my_foo_i::get_rw_attrib_excep (
    ::CCM_AMI::ExceptionHolder_ptr excep_holder)
  {
    HandleException (excep_holder, "get_rw_attrib (asyn)");
  }

  void
  AMI4CCM_MyFooReplyHandler_run_my_foo_i::set_rw_attrib (void)
  {
    // never should come here in this test.
     ACE_ERROR ((LM_ERROR, "ERROR: MyFoo_callback_exec_i::set_rw_attrib: "
                            "Unexpected return.\n"));
  }

  void
  AMI4CCM_MyFooReplyHandler_run_my_foo_i::set_rw_attrib_excep (
    ::CCM_AMI::ExceptionHolder_ptr excep_holder)
  {
    HandleException (excep_holder, "SET_RW_ATTRIB (asyn)");
 }

  void
  AMI4CCM_MyFooReplyHandler_run_my_foo_i::get_ro_attrib (
    ::CORBA::Short /* ro_attrib */)
  {
    // never should come here in this test.
      ACE_ERROR ((LM_ERROR, "ERROR: MyFoo_callback_exec_i::get_ro_attrib: "
                             "Unexpected return.\n"));
  }

  void
  AMI4CCM_MyFooReplyHandler_run_my_foo_i::get_ro_attrib_excep (
    ::CCM_AMI::ExceptionHolder_ptr excep_holder)
  {
    HandleException (excep_holder, "RO_ATTRIB (asyn)");
  }

  extern "C" EXCEPTION_T_SENDER_EXEC_Export ::Components::EnterpriseComponent_ptr
  create_ExceptionT_Sender_Impl (void)
  {
    ::Components::EnterpriseComponent_ptr retval =
      ::Components::EnterpriseComponent::_nil ();

    ACE_NEW_NORETURN (
      retval,
      Sender_exec_i);

    return retval;
  }
}
