!{\src2tex{textfont=tt}}
!!****f* ABINIT/density
!! NAME
!! density
!!
!! FUNCTION
!!  Compute the real-space density rho2, as well as
!!  the average density to initialize omegaplasma
!!
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG, MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  irottb(nr,nop) = symmetry operations on the FFT grid.
!!   irottb(r,R)=index of (R**-1)r  in the FFT array where R is one of the nop
!!   symmetry operation in reciprocal space
!!  nbnds=number of bands
!!  nkibzm=maximum number of k point in IBZ
!!  nkibz=number of k point in IBZ
!!  nkbz=number of k point in BZ
!!  ngfft1,ngfft1a,ngfft2,ngfft3=FFT grid dimensions
!!  ninv=2 if time-reversal symmetry is used, 1 if not
!!  nop=number of symmetry operations
!!  nr=number of point in FFT grid
!!  nsppol=1 for unpolarized, 2 for spin-polarized
!!  occ(nkibzm,nbnds,nsppol)=occupation numbers, for each k point in IBZ, each band and spin
!!  ucvol=unit cell volume
!!  wtk(nkibz)=weights for k points (input variable)
!!
!! OUTPUT
!!  omegaplasma=Drude plasma frequency
!!  rho2(nr,nsppol) = the density on the FFT grid.
!!   (total in first half and spin-up in second half if nsppol=2)
!!
!! NOTES
!!  1) The subroutine must be modified to take into account non-symmorphic
!!  operations
!!  2) Wavefunctions are supposed to be on disk, chro.F90 performs the same task
!!     but with wavefunctions in memory 
!!
!! PARENTS
!!      screening
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine density(nbnds,nkibzm,nkibz,nkbz,nsppol,nop,ninv,nr,ngfft1,ngfft1a,&
& ngfft2,ngfft3,irottb,ucvol,wtk,occ,rho2,omegaplasma,mpi_enreg,min_band_proc,max_band_proc,parallelism_is_on_bands,nonlocal,wfr)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_lib01hidempi
#else
 use defs_xfuncmpi
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: max_band_proc,min_band_proc,nbnds,ngfft1,ngfft1a,ngfft2
 integer,intent(in) :: ngfft3,ninv,nkbz,nkibz,nkibzm,nop,nr,nsppol
 real(dp),intent(in) :: ucvol
 real(dp),intent(out) :: omegaplasma
 logical,intent(in) :: parallelism_is_on_bands
 type(MPI_type),intent(inout) :: mpi_enreg
!arrays
 integer,intent(in) :: irottb(nr,nop)
 real(dp),intent(in) :: occ(nkibzm,min_band_proc:max_band_proc,nsppol)
 real(dp),intent(in) :: wtk(nkibz)
 real(dp),intent(out) :: rho2(nr,nsppol)
 complex,intent(in),optional :: wfr(nr,min_band_proc:max_band_proc,nkibz,nsppol)
 logical,intent(in)::nonlocal
!Local variables-------------------------------
!scalars
 integer,parameter :: unitwfr=26
 integer :: ib,ierr,ik,iop,ir,is,istat,master,me,spaceComm
 real(dp) :: fact,rhoav,rs,tnepuc
 character(len=500) :: message
 logical::i_can_read,master_must_cast_data
!arrays
 real(dp),allocatable :: rho(:)
 complex,allocatable :: wfnk(:,:)

! *************************************************************************

 write(message,'(a)')' density: calculating charge density'
 call wrtout(6,message,'COLL')

     call xcomm_init(mpi_enreg,spaceComm)
!Init me
     call xme_init(mpi_enreg,me)
!Init master
     call xmaster_init(mpi_enreg,master)

if( mpi_enreg%nproc==1 .or. (.not.nonlocal) .or. me==0 )then
  i_can_read=.true.
 else
  i_can_read=.false.
 end if

  if(mpi_enreg%nproc>1.and.nonlocal)then
   master_must_cast_data=.true.
  else
   master_must_cast_data=.false.
  end if

 allocate(rho(nr),stat=istat)
 if(istat/=0) stop 'out of memory'
  if(.not.(present(wfr)))then
   allocate(wfnk(nr,nbnds),stat=istat)
   if(istat/=0) stop 'out of memory'
  end if

 !zero charge density
 rho2(:,:)=zero

!MG060914 added external loop on spin
!FIXME rho2 is the output density, rho is the temporary array. a little bit misdleading
 do is=1,nsppol
  rho(:)=zero
  !loop over k-points in IBZ 
!FIXME we are reading all the bands, it is a waste
!we can calculate the maximum band index for this point and then read only 
!the portion of the record we need
  do ik=1,nkibz
   if(.not.(present(wfr)))then
     if(i_can_read)then
    read(unitwfr,rec=ik+nkibz*(is-1)) ((wfnk(ir,ib),ir=1,nr),ib=1,nbnds)
     end if
     if(master_must_cast_data)then
   call xcast_mpi(wfnk,master,spaceComm,ierr)
  end if
   end if
   do ib=1,nbnds
    if(mpi_enreg%nproc>1.and.parallelism_is_on_bands)then
     if(minval(abs(mpi_enreg%proc_distrb(ib,:,:)-mpi_enreg%me))/=0) cycle
    end if
    if(abs(occ(ik,ib,is))<tol8) cycle
!     write(*,*)me,ib
    do ir=1,nr
     if(.not.(present(wfr)))then
      rho(ir)=rho(ir)+occ(ik,ib,is)*conjg(wfnk(ir,ib))*wfnk(ir,ib)*wtk(ik)
     else
      rho(ir)=rho(ir)+occ(ik,ib,is)*conjg(wfr(ir,ib,ik,is))*wfr(ir,ib,ik,is)*wtk(ik)
     end if
    end do !ir
   end do !ib
  end do !ik
  !loop over symmetry operations, symmetrising rho
  !factor 2 is for inversion
  fact=real(ninv)/(nkbz*ucvol)
  do ir=1,nr
   do iop=1,nop
    rho2(ir,is)=rho2(ir,is)+fact*rho(irottb(ir,iop))
   end do !iop
  end do !ir
 end do !is

 !store the total charge in the first half only if nsspol==2 
 if (nsppol==2) then 
  rho(:)=rho2(:,1)
  rho2(:,1)=rho2(:,1)+rho2(:,2)
  rho2(:,2)=rho(:)
 end if 

 if(parallelism_is_on_bands) call xsum_mpi(rho2,spaceComm,ierr)

 deallocate(rho)
 if(allocated(wfnk))deallocate(wfnk)

!write total charge:
!open(unit=66,file='rho')
!write(66,'(f7.4)') (rho2(ir),ir=1,nr)
!close(66)

 !calculate total number of electrons as a check
 tnepuc=0.0
 do ir=1,nr
  tnepuc=tnepuc+rho2(ir,1)
 end do
 tnepuc=tnepuc*ucvol/(ngfft1*ngfft2*ngfft3)

 write(message,'(a,f7.4)')' total number of electrons per unit cell = ',tnepuc
 call wrtout(6,message,'COLL') ;  call wrtout(ab_out,message,'COLL')

 rhoav=tnepuc/ucvol
 write(message,'(a,f7.4)')' average of density, n = ',rhoav
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')

 rs=(3.0/(4.0*(4.0*atan(1.0))*rhoav))**(1.0/3.0)
 write(message,'(a,f7.4)')' r_s = ',rs
 call wrtout(6,message,'COLL') ;  call wrtout(ab_out,message,'COLL')

 omegaplasma=sqrt(4.0*(4.0*atan(1.0))*rhoav)
 write(message,'(a,f7.4,2a)')' omega_plasma = ',omegaplasma*Ha_eV,' [eV]',ch10
 call wrtout(6,message,'COLL') ;  call wrtout(ab_out,message,'COLL')
end subroutine density
!!***
