/****************************************************************************
 *                                                                          *
 * Copyright 1999-2005 ATI Technologies Inc., Markham, Ontario, CANADA.     *
 * All Rights Reserved.                                                     *
 *                                                                          *
 * Your use and or redistribution of this software in source and \ or       *
 * binary form, with or without modification, is subject to: (i) your       *
 * ongoing acceptance of and compliance with the terms and conditions of    *
 * the ATI Technologies Inc. software End User License Agreement; and (ii)  *
 * your inclusion of this notice in any version of this software that you   *
 * use or redistribute.  A copy of the ATI Technologies Inc. software End   *
 * User License Agreement is included with this software and is also        *
 * available by contacting ATI Technologies Inc. at http://www.ati.com      *
 *                                                                          *
 ****************************************************************************/

/** \brief Declarations for KCL IOMMU supporting interfaces */

#ifndef KCL_IOMMU_H
#define KCL_IOMMU_H

#include "kcl_config.h"
#include "kcl_type.h"
#include "kcl_pci.h"

typedef union _iommu_req_perm_
{
    struct __packed__
    {
        uint32_t read    :  1;
        uint32_t write   :  1;
        uint32_t exec    :  1;
        uint32_t priv    :  1; 
        uint32_t res     :  28;  
    }flags;   
    uint32_t all;
} KCL_IOMMU_req_perm_t;

#define KCL_PRI_DEV_ERRATUM_ENABLE_RESET   0 
//This indicates that the PRI capability needs to be resetted while PRI being enabled. The Spec requires PRI to be disabled by default. 

#define KCL_PRI_DEV_ERRATUM_LIMIT_REQ_ONE  1
//This limits the number of outstanding PRI requests to one. 

typedef struct _iommu_info_
{
    int32_t max_pasids;            //maximum PASIDs supported by the device and the IOMMU in control of the device 
    int32_t gvas_size;             //maximum guest virtual address space supported by the iommu driver
    int32_t pas_size;              //maximum physical address generated by the iommu driver
    int32_t erratum_mask;          //bit mask of device specificed work around for iommu ,The bit is defined as KCL_PRI_DEV_ERRATUM_XXX  
    union 
    {
        struct  
        {
            uint32_t ats_sup:     1; // ATS features supported 
            uint32_t pri_sup:     1; // PRI features supported 
            uint32_t pasid_sup:   1; // PASID contexts supported
            uint32_t exec_sup:    1; // Device may request code execution privileges 
            uint32_t priv_sup:    1; // Device may request super-user privileges 
            uint32_t: 27;
        } f;
        uint32_t raw;
    }flags;
}  KCL_IOMMU_info_t;

//need to check iommu driver defines
typedef enum {
    KCL_IOMMU_PRI_SUCCESS,
    KCL_IOMMU_PRI_INVALID_RESPONSE,    
    KCL_IOMMU_PRI_RESPONSE_FAILURE,
    KCL_IOMMU_PRI_DROP,
}KCL_IOMMU_INVALID_PRI_RESPONSE;
    
    

int ATI_API_CALL KCL_IOMMU_InitDevice( KCL_PCI_DevHandle pcidev, KCL_IOMMU_info_t* pInfo);
void ATI_API_CALL KCL_IOMMU_FreeDevice( KCL_PCI_DevHandle pcidev);
int ATI_API_CALL KCL_IOMMU_BindPasid( KCL_PCI_DevHandle pcidev, int pid, int  pasid);
void ATI_API_CALL KCL_IOMMU_UnbindPasid( KCL_PCI_DevHandle pcidev, int  pasid);


#endif
