package tijmp.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tijmp.ui.Translator;

/** A filter that uses a regexp to match classes
 */
public class RegexpFilter implements Filter {
    private Pattern p;

    public RegexpFilter (String pattern) {
	p = Pattern.compile (pattern, Pattern.CASE_INSENSITIVE);
    }
    
    public boolean accept (Class<?> c) {
	String hrn = Translator.translate (c, null);
	Matcher m = p.matcher (hrn);
	return m.find ();
    }
}
