/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.input;

import base.drawable.Drawable;
import base.drawable.TimeBoundingBox;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import logformat.slog2.input.InputLog;
import logformat.slog2.input.TreeNode;
import logformat.slog2.input.TreeTrunk;

public class Navigator {
    private static boolean printAll = false;
    private static boolean changedPrintAll = false;
    private static boolean isVerbose = false;
    private static InputStreamReader sys_insrdr = new InputStreamReader(System.in);
    private static BufferedReader sys_bufrdr = new BufferedReader(sys_insrdr);
    private static String in_filename;
    private static short depth_max;
    private static short depth;
    private static String format_msg;
    private static String input_msg;
    private static double zoom_ftr;
    private static String stub_msg;
    private static String help_msg;

    public static final void main(String[] stringArray) {
        String string;
        Navigator.parseCmdLineArgs(stringArray);
        InputLog inputLog = new InputLog(in_filename);
        if (inputLog == null) {
            System.err.println("Null input logfile!");
            System.exit(1);
        }
        if (!inputLog.isSLOG2()) {
            System.err.println(in_filename + " is NOT SLOG-2 file!.");
            System.exit(1);
        }
        if ((string = inputLog.getCompatibleHeader()) != null) {
            System.err.print(string);
            InputLog.stdoutConfirmation();
        }
        inputLog.initialize();
        TreeTrunk treeTrunk = new TreeTrunk(inputLog, Drawable.INCRE_STARTTIME_ORDER);
        treeTrunk.setDebuggingEnabled(isVerbose);
        treeTrunk.initFromTreeTop();
        TreeNode treeNode = treeTrunk.getTreeRoot();
        if (treeNode == null) {
            System.out.println("SLOG-2 file, " + in_filename + " " + "contains no drawables");
            inputLog.close();
            System.exit(0);
        }
        TimeBoundingBox timeBoundingBox = new TimeBoundingBox(treeNode);
        depth_max = treeNode.getTreeNodeID().depth;
        System.out.println("TimeWindow = " + timeBoundingBox + " @ dmax = " + depth_max);
        TimeBoundingBox timeBoundingBox2 = new TimeBoundingBox(timeBoundingBox);
        depth = depth_max;
        TimeBoundingBox timeBoundingBox3 = Navigator.getTimeWindowFromStdin(timeBoundingBox2);
        System.out.println("TimeWindow = " + timeBoundingBox3 + " @ d = " + depth);
        treeTrunk.growInTreeWindow(treeNode, depth, timeBoundingBox3);
        if (printAll) {
            System.out.println(treeTrunk.toString(timeBoundingBox3));
        } else {
            System.out.println(treeTrunk.toStubString());
        }
        timeBoundingBox2 = timeBoundingBox3;
        while ((timeBoundingBox3 = Navigator.getTimeWindowFromStdin(timeBoundingBox2)) != null) {
            System.out.println("TimeWindow = " + timeBoundingBox3 + " @ d = " + depth);
            if (!changedPrintAll && treeTrunk.updateTimeWindow(timeBoundingBox2, timeBoundingBox3) <= 0) continue;
            if (printAll) {
                System.out.println(treeTrunk.toString(timeBoundingBox3));
            } else {
                System.out.println(treeTrunk.toStubString());
            }
            timeBoundingBox2 = timeBoundingBox3;
            changedPrintAll = false;
        }
        inputLog.close();
    }

    private static TimeBoundingBox getTimeWindow(TimeBoundingBox timeBoundingBox, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        TimeBoundingBox timeBoundingBox2 = new TimeBoundingBox(timeBoundingBox);
        int n = 0;
        try {
            while (n < stringArray.length) {
                double d;
                double d2;
                if (stringArray[n].indexOf(61) != -1) {
                    String string;
                    if (stringArray[n].startsWith("d=")) {
                        string = stringArray[n].trim().substring(2);
                        depth = Short.parseShort(string);
                        stringBuffer.append("\n lowest_depth = " + string);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].startsWith("ts=")) {
                        string = stringArray[n].trim().substring(3);
                        timeBoundingBox2.setEarliestTime(Double.parseDouble(string));
                        stringBuffer.append("\n time_frame_start = " + string);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].startsWith("tf=")) {
                        string = stringArray[n].trim().substring(3);
                        timeBoundingBox2.setLatestTime(Double.parseDouble(string));
                        stringBuffer.append("\n time_frame_final = " + string);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].startsWith("+=")) {
                        string = stringArray[n].trim().substring(2);
                        d2 = Double.parseDouble(string);
                        d = timeBoundingBox.getDuration() / 2.0 / zoom_ftr;
                        timeBoundingBox2.setEarliestTime(d2 - d);
                        timeBoundingBox2.setLatestTime(d2 + d);
                        stringBuffer.append("\n zoom_in_center = " + string);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].startsWith("-=")) {
                        string = stringArray[n].trim().substring(2);
                        d2 = Double.parseDouble(string);
                        d = timeBoundingBox.getDuration() / 2.0 * zoom_ftr;
                        timeBoundingBox2.setEarliestTime(d2 - d);
                        timeBoundingBox2.setLatestTime(d2 + d);
                        stringBuffer.append("\n zoom_out_center = " + string);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].startsWith(">=")) {
                        string = stringArray[n].trim().substring(2);
                        d2 = Double.parseDouble(string);
                        d = timeBoundingBox.getDuration();
                        timeBoundingBox2.setEarliestTime(d2 * d + timeBoundingBox.getEarliestTime());
                        timeBoundingBox2.setLatestTime(d + timeBoundingBox2.getEarliestTime());
                        stringBuffer.append("\n scroll_forward = " + string + " frames");
                        ++n;
                        continue;
                    }
                    if (stringArray[n].startsWith("<=")) {
                        string = stringArray[n].trim().substring(2);
                        d2 = Double.parseDouble(string);
                        d = timeBoundingBox.getDuration();
                        timeBoundingBox2.setEarliestTime(-d2 * d + timeBoundingBox.getEarliestTime());
                        timeBoundingBox2.setLatestTime(d + timeBoundingBox2.getEarliestTime());
                        stringBuffer.append("\n scroll_forward = " + string + " frames");
                        ++n;
                        continue;
                    }
                    System.err.println("Unrecognized option, " + stringArray[n] + ", at " + Navigator.indexOrderStr(n + 1) + " input argument");
                    System.err.flush();
                    return null;
                }
                if (stringArray[n].startsWith("+")) {
                    d2 = (timeBoundingBox.getEarliestTime() + timeBoundingBox.getLatestTime()) / 2.0;
                    d = timeBoundingBox.getDuration() / 2.0 / zoom_ftr;
                    timeBoundingBox2.setEarliestTime(d2 - d);
                    timeBoundingBox2.setLatestTime(d2 + d);
                    stringBuffer.append("\n zoom_in_center = " + d2);
                    ++n;
                    continue;
                }
                if (stringArray[n].startsWith("-")) {
                    d2 = (timeBoundingBox.getEarliestTime() + timeBoundingBox.getLatestTime()) / 2.0;
                    d = timeBoundingBox.getDuration() / 2.0 * zoom_ftr;
                    timeBoundingBox2.setEarliestTime(d2 - d);
                    timeBoundingBox2.setLatestTime(d2 + d);
                    stringBuffer.append("\n zoom_out_center = " + d2);
                    ++n;
                    continue;
                }
                if (stringArray[n].startsWith(">")) {
                    d2 = 1.0;
                    d = timeBoundingBox.getDuration();
                    timeBoundingBox2.setEarliestTime(d2 * d + timeBoundingBox.getEarliestTime());
                    timeBoundingBox2.setLatestTime(d + timeBoundingBox2.getEarliestTime());
                    stringBuffer.append("\n scroll_forward = " + d2 + " frames");
                    ++n;
                    continue;
                }
                if (stringArray[n].startsWith("<")) {
                    d2 = 1.0;
                    d = timeBoundingBox.getDuration();
                    timeBoundingBox2.setEarliestTime(-d2 * d + timeBoundingBox.getEarliestTime());
                    timeBoundingBox2.setLatestTime(d + timeBoundingBox2.getEarliestTime());
                    stringBuffer.append("\n scroll_forward = " + d2 + " frames");
                    ++n;
                    continue;
                }
                if (stringArray[n].startsWith("s")) {
                    printAll = false;
                    changedPrintAll = true;
                    stringBuffer.append("\n print_details = " + printAll);
                    ++n;
                    continue;
                }
                if (stringArray[n].startsWith("a")) {
                    printAll = true;
                    changedPrintAll = true;
                    stringBuffer.append("\n print_details = " + printAll);
                    ++n;
                    continue;
                }
                System.err.println("Unrecognized option, " + stringArray[n] + ", at " + Navigator.indexOrderStr(n + 1) + " input argument");
                System.err.flush();
                return null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (stringBuffer.length() > 0) {
                System.err.println(stringBuffer.toString());
            }
            String string = Navigator.indexOrderStr(n);
            System.err.println("Error occurs after option " + stringArray[n - 1] + ", " + Navigator.indexOrderStr(n) + " input argument.  It needs a number.");
            numberFormatException.printStackTrace();
            return null;
        }
        if (depth >= 0 && depth <= depth_max) {
            return timeBoundingBox2;
        }
        System.err.println("Invalid TimeWindow!");
        return null;
    }

    private static TimeBoundingBox getTimeWindowFromStdin(TimeBoundingBox timeBoundingBox) {
        String[] stringArray;
        TimeBoundingBox timeBoundingBox2;
        do {
            String string;
            System.out.print("Enter TimeWindow: " + format_msg + " ?\n");
            try {
                string = sys_bufrdr.readLine();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
        } while ((timeBoundingBox2 = Navigator.getTimeWindow(timeBoundingBox, stringArray)) == null);
        return timeBoundingBox2;
    }

    private static void parseCmdLineArgs(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("-")) {
                if (stringArray[n].equals("-h") || stringArray[n].equals("-help") || stringArray[n].equals("--help")) {
                    System.out.println(help_msg);
                    System.out.flush();
                    System.exit(0);
                    continue;
                }
                if (stringArray[n].equals("-s") || stringArray[n].equals("-stub")) {
                    printAll = false;
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-a") || stringArray[n].equals("-all")) {
                    printAll = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-v") || stringArray[n].equals("-verbose")) {
                    isVerbose = true;
                    ++n;
                    continue;
                }
                System.err.println("Unrecognized option, " + stringArray[n] + ", at " + Navigator.indexOrderStr(n + 1) + " command line argument");
                System.out.flush();
                System.exit(1);
                continue;
            }
            in_filename = stringArray[n];
            ++n;
        }
        if (in_filename == null) {
            System.err.println("The Program needs a SLOG-2 filename as a command line argument.");
            System.err.println(help_msg);
            System.exit(1);
        }
    }

    private static String indexOrderStr(int n) {
        switch (n) {
            case 1: {
                return Integer.toString(n) + "st";
            }
            case 2: {
                return Integer.toString(n) + "nd";
            }
            case 3: {
                return Integer.toString(n) + "rd";
            }
        }
        return Integer.toString(n) + "th";
    }

    static {
        format_msg = "[s|a] [d=I] [[ts=D] [tf=D]] [-[=D]] [+[=D]] [<[=F]] [>[=F]]";
        input_msg = "Interactive Input Options: \n\t Specification of the Time Frame : \n\t \t " + format_msg + "\n" + "\t [s|a], print details              " + " s for stub, a for all drawables.\n" + "\t [d=I], depth=Integer              " + " Needed only when program starts.\n" + "\t [ts=D], timeframe_start=Double    " + " Specify Start of TimeFrame.\n" + "\t [tf=D], timeframe_final=Double    " + " Specify Final of TimeFrame.\n" + "\t [-[=D]], zoom-out[=Double]        " + " Specify Center of Zoom-Out Frame.\n" + "\t [+[=D]], zoom-in[=Double]         " + " Specify Center of Zoom-In Frame.\n" + "\t [<[=F]], scroll-backward[=Frames] " + " Specify Frames to Scroll Backward.\n" + "\t [>[=F]], scroll-forward[=Frames]  " + " Specify Frames to Scroll Forward.\n";
        zoom_ftr = 2.0;
        stub_msg = "Format of the TreeNodeStub: \n  { TreeNodeID, TreeNodeEndtimes, BlockSize + FilePointer, NumOfDrawables .. }\n\t TreeNodeID : ID( d, i )            d is the depth of the TreeNode.\n\t                                    d = 0, for LeafNode; \n\t                                    d = d_max, for RootNode.\n\t                                    i is TreeNode's index(same depth).\n\t TreeNodeEndtimes                   TreeNode's Start and End times.\n";
        help_msg = "Usage: java slog2.input.Navigator [options] slog2_filename.\nOptions: \n\t [-h|-help|--help]                  Display this message.\n\t [-s|-stub]                         Print TreeNode's stub (Default).\n\t [-a|-all]                          Print TreeNode's drawable content.\n\t [-v|-verbose]                      Print detailed diagnostic message.\n\n" + input_msg + "\n" + stub_msg;
    }
}

