/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;

public class CategoryRatios {
    public static final int BYTESIZE = 8;
    public static final Comparator INCL_RATIO_ORDER = new InclRatioOrder();
    public static final Comparator EXCL_RATIO_ORDER = new ExclRatioOrder();
    public static final int PRINT_ALL_RATIOS = 0;
    public static final int PRINT_INCL_RATIO = 1;
    public static final int PRINT_EXCL_RATIO = 2;
    private static final String TITLE_ALL_RATIOS = "*** All Duration Ratios:";
    private static final String TITLE_INCL_RATIO = "*** Inclusive Duration Ratio:";
    private static final String TITLE_EXCL_RATIO = "*** Exclusive Duration Ratio:";
    private float incl_ratio;
    private float excl_ratio;

    public CategoryRatios() {
        this.incl_ratio = 0.0f;
        this.excl_ratio = 0.0f;
    }

    public CategoryRatios(float f, float f2) {
        this.incl_ratio = f;
        this.excl_ratio = f2;
    }

    public CategoryRatios(CategoryRatios categoryRatios) {
        this.incl_ratio = categoryRatios.incl_ratio;
        this.excl_ratio = categoryRatios.excl_ratio;
    }

    public float getRatio(boolean bl) {
        if (bl) {
            return this.incl_ratio;
        }
        return this.excl_ratio;
    }

    public void rescaleAllRatios(float f) {
        this.incl_ratio *= f;
        this.excl_ratio *= f;
    }

    public void addAllRatios(CategoryRatios categoryRatios, float f) {
        this.incl_ratio += categoryRatios.incl_ratio * f;
        this.excl_ratio += categoryRatios.excl_ratio * f;
    }

    public void addExclusiveRatio(float f) {
        this.excl_ratio += f;
    }

    public void addInclusiveRatio(float f) {
        this.incl_ratio += f;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeFloat(this.incl_ratio);
        dataOutput.writeFloat(this.excl_ratio);
    }

    public CategoryRatios(DataInput dataInput) throws IOException {
        this.readObject(dataInput);
    }

    public void readObject(DataInput dataInput) throws IOException {
        this.incl_ratio = dataInput.readFloat();
        this.excl_ratio = dataInput.readFloat();
    }

    public static String getPrintTitle(int n) {
        if (n == 1) {
            return TITLE_INCL_RATIO;
        }
        if (n == 2) {
            return TITLE_EXCL_RATIO;
        }
        return TITLE_ALL_RATIOS;
    }

    public String toInfoBoxString(int n) {
        if (n == 1) {
            return "ratio=" + this.incl_ratio;
        }
        if (n == 2) {
            return "ratio=" + this.excl_ratio;
        }
        return "incl_ratio=" + this.incl_ratio + ", excl_ratio=" + this.excl_ratio;
    }

    public String toString() {
        return "ratios=" + this.incl_ratio + "," + this.excl_ratio;
    }

    private static class ExclRatioOrder
    implements Comparator {
        private ExclRatioOrder() {
        }

        public int compare(Object object, Object object2) {
            CategoryRatios categoryRatios = (CategoryRatios)object;
            CategoryRatios categoryRatios2 = (CategoryRatios)object2;
            float f = categoryRatios.excl_ratio - categoryRatios2.excl_ratio;
            return f < 0.0f ? -1 : (f == 0.0f ? 0 : 1);
        }
    }

    private static class InclRatioOrder
    implements Comparator {
        private InclRatioOrder() {
        }

        public int compare(Object object, Object object2) {
            CategoryRatios categoryRatios = (CategoryRatios)object;
            CategoryRatios categoryRatios2 = (CategoryRatios)object2;
            float f = categoryRatios.incl_ratio - categoryRatios2.incl_ratio;
            return f < 0.0f ? -1 : (f == 0.0f ? 0 : 1);
        }
    }
}

