/*
 * Decompiled with CFR 0.152.
 */
package old_logformat.slog2.input;

import old_base.drawable.Drawable;
import old_base.drawable.TimeBoundingBox;
import old_logformat.slog2.input.InputLog;
import old_logformat.slog2.input.TreeNode;
import old_logformat.slog2.input.TreeTrunk;

public class PrintRecursively {
    private static boolean printNode = true;
    private static String in_filename;
    private static double time_init_ftr;
    private static double time_final_ftr;
    private static short lowest_depth;
    private static String help_msg;

    public static final void main(String[] stringArray) {
        String string;
        PrintRecursively.parseCmdLineArgs(stringArray);
        InputLog inputLog = new InputLog(in_filename);
        if (inputLog == null) {
            System.err.println("Null input logfile!");
            System.exit(1);
        }
        if (!inputLog.isSLOG2()) {
            System.err.println(in_filename + " is NOT SLOG-2 file!.");
            System.exit(1);
        }
        if ((string = inputLog.getCompatibleHeader()) != null) {
            System.err.print(string);
            InputLog.stdoutConfirmation();
        }
        inputLog.initialize();
        System.out.println(inputLog);
        TreeTrunk treeTrunk = new TreeTrunk(inputLog, Drawable.INCRE_STARTTIME_ORDER);
        treeTrunk.initFromTreeTop();
        TreeNode treeNode = treeTrunk.getTreeRoot();
        if (treeNode == null) {
            System.out.println("SLOG-2 file, " + in_filename + " " + "contains no drawables");
            inputLog.close();
            System.exit(0);
        }
        TimeBoundingBox timeBoundingBox = new TimeBoundingBox(treeNode);
        PrintRecursively.resetTimeBounds(timeBoundingBox);
        System.err.println("Time Window is " + timeBoundingBox);
        treeTrunk.growInTreeWindow(treeNode, lowest_depth, timeBoundingBox);
        if (printNode) {
            System.out.println(treeTrunk.toString());
        } else {
            System.out.println(treeTrunk.toString(timeBoundingBox));
        }
        inputLog.close();
    }

    private static void resetTimeBounds(TimeBoundingBox timeBoundingBox) {
        double d = timeBoundingBox.getEarliestTime();
        double d2 = timeBoundingBox.getLatestTime();
        double d3 = d2 - d;
        timeBoundingBox.setEarliestTime(d + time_init_ftr * d3);
        timeBoundingBox.setLatestTime(d + time_final_ftr * d3);
    }

    private static void parseCmdLineArgs(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        try {
            while (n < stringArray.length) {
                if (stringArray[n].startsWith("-")) {
                    String string;
                    if (stringArray[n].equals("-h") || stringArray[n].equals("-help") || stringArray[n].equals("--help")) {
                        System.out.println(help_msg);
                        System.out.flush();
                        System.exit(0);
                        continue;
                    }
                    if (stringArray[n].equals("-n") || stringArray[n].equals("-node")) {
                        printNode = true;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-t") || stringArray[n].equals("-time")) {
                        printNode = false;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-ts")) {
                        string = stringArray[++n];
                        time_init_ftr = Double.parseDouble(string);
                        stringBuffer.append("\n time_start_factor = " + string);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-tf")) {
                        string = stringArray[++n];
                        time_final_ftr = Double.parseDouble(string);
                        stringBuffer.append("\n time_final_factor = " + string);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-d")) {
                        string = stringArray[++n];
                        lowest_depth = Short.parseShort(string);
                        stringBuffer.append("\n lowest_depth = " + string);
                        ++n;
                        continue;
                    }
                    System.err.println("Unrecognized option, " + stringArray[n] + ", at " + PrintRecursively.indexOrderStr(n + 1) + " command line argument");
                    System.out.flush();
                    System.exit(1);
                    continue;
                }
                in_filename = stringArray[n];
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (stringBuffer.length() > 0) {
                System.err.println(stringBuffer.toString());
            }
            String string = PrintRecursively.indexOrderStr(n);
            System.err.println("Error occurs after option " + stringArray[n - 1] + ", " + PrintRecursively.indexOrderStr(n) + " command line argument.  It needs a number.");
            numberFormatException.printStackTrace();
        }
        if (in_filename == null) {
            System.err.println("The Program needs a SLOG-2 filename as a command line argument.");
            System.err.println(help_msg);
            System.exit(1);
        }
        if (time_init_ftr > time_final_ftr || time_init_ftr < 0.0 || time_final_ftr > 1.0) {
            System.err.println("Invalid time_init_factor and time_final_factor!");
            System.err.println("time_init_factor = " + time_init_ftr);
            System.err.println("time_final_factor = " + time_final_ftr);
            System.exit(1);
        }
    }

    private static String indexOrderStr(int n) {
        switch (n) {
            case 1: {
                return Integer.toString(n) + "st";
            }
            case 2: {
                return Integer.toString(n) + "nd";
            }
            case 3: {
                return Integer.toString(n) + "rd";
            }
        }
        return Integer.toString(n) + "th";
    }

    static {
        time_init_ftr = 0.0;
        time_final_ftr = 1.0;
        lowest_depth = 0;
        help_msg = "Usage: java slog2.input.Print [options] slog2_filename.\nOptions: \n\t [-h|-help|--help]             \t Display this message.\n\t [-n|-node] (default)          \t Print drawables in TreeNodes.\n\t [-t|-time]                    \t Print drawables within endtimes.\n\t [-ts time_start_factor]       \t Default value is 0.0 (min).\n\t [-tf time_final_factor]       \t Default value is 1.0 (max).\n\t [-d lowest_depth]             \t Default value is 0 (leaf level).\n";
    }
}

