# Copyright 2016 Canonical Ltd.  This software is licensed under the
# GNU Affero General Public License version 3 (see the file LICENSE).

""":class:`PackageRepository` tests."""

__all__ = []

from maasserver.models import PackageRepository
from maasserver.testing.factory import factory
from maasserver.testing.testcase import MAASServerTestCase


class TestPackageRepositoryManager(MAASServerTestCase):

    def test_get_default_archive(self):
        PackageRepository.objects.all().delete()
        arch = 'amd64'
        main_url = 'http://us.archive.ubuntu.com/ubuntu'
        archive = factory.make_PackageRepository(
            url=main_url, default=True, arches=['i386', 'amd64'])
        self.assertEquals(
            archive,
            PackageRepository.objects.get_default_archive(arch))

    def test_get_additional_repositories(self):
        arch = 'amd64'
        main_url = 'http://additional.repository/ubuntu'
        archive = factory.make_PackageRepository(
            url=main_url, default=False, arches=['i386', 'amd64'])
        self.assertEquals(
            archive,
            PackageRepository.objects.get_additional_repositories(
                arch).first())

    def test_get_multiple_with_a_ppa(self):
        ppa_arch = 'armhf'
        ppa_url = 'ppa:%s/%s' % (
            factory.make_hostname(), factory.make_hostname())
        ppa_archive = factory.make_PackageRepository(
            url=ppa_url, default=False, arches=[
                ppa_arch, factory.make_name()])
        arch = 'i386'
        url = factory.make_url(scheme='http')
        archive = factory.make_PackageRepository(
            url=url, default=False, arches=[arch, factory.make_name()])
        self.assertEquals(
            ppa_archive,
            PackageRepository.objects.get_additional_repositories(
                ppa_arch).first())
        self.assertEquals(
            archive,
            PackageRepository.objects.get_additional_repositories(
                arch).first())

    def test_get_known_architectures(self):
        self.assertEqual(
            PackageRepository.objects.get_known_architectures(),
            PackageRepository.MAIN_ARCHES + PackageRepository.PORTS_ARCHES)

    def test_get_pockets_to_disable(self):
        self.assertEqual(
            PackageRepository.objects.get_pockets_to_disable(),
            PackageRepository.POCKETS_TO_DISABLE)
