/* unity-lens-private.c generated by valac 0.14.2, the Vala compiler
 * generated from unity-lens-private.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "unity.h"
#include <dee.h>
#include <gee.h>
#include <unity-trace.h>


#define UNITY_TYPE_LENS_SERVICE (unity_lens_service_get_type ())
#define UNITY_LENS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_LENS_SERVICE, UnityLensService))
#define UNITY_IS_LENS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_LENS_SERVICE))
#define UNITY_LENS_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_TYPE_LENS_SERVICE, UnityLensServiceIface))

typedef struct _UnityLensService UnityLensService;
typedef struct _UnityLensServiceIface UnityLensServiceIface;

#define UNITY_TYPE_LENS_SERVICE_PROXY (unity_lens_service_proxy_get_type ())

#define UNITY_TYPE_ACTIVATION_REPLY_RAW (unity_activation_reply_raw_get_type ())
typedef struct _UnityActivationReplyRaw UnityActivationReplyRaw;

#define UNITY_TYPE_PREVIEW_REPLY_RAW (unity_preview_reply_raw_get_type ())
typedef struct _UnityPreviewReplyRaw UnityPreviewReplyRaw;

#define UNITY_TYPE_LENS_IMPL (unity_lens_impl_get_type ())
#define UNITY_LENS_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_LENS_IMPL, UnityLensImpl))
#define UNITY_LENS_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_LENS_IMPL, UnityLensImplClass))
#define UNITY_IS_LENS_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_LENS_IMPL))
#define UNITY_IS_LENS_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_LENS_IMPL))
#define UNITY_LENS_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_LENS_IMPL, UnityLensImplClass))

typedef struct _UnityLensImpl UnityLensImpl;
typedef struct _UnityLensImplClass UnityLensImplClass;
typedef struct _UnityLensImplPrivate UnityLensImplPrivate;

#define UNITY_TYPE_SCOPE_FACTORY (unity_scope_factory_get_type ())
#define UNITY_SCOPE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_FACTORY, UnityScopeFactory))
#define UNITY_SCOPE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_SCOPE_FACTORY, UnityScopeFactoryClass))
#define UNITY_IS_SCOPE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_FACTORY))
#define UNITY_IS_SCOPE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_SCOPE_FACTORY))
#define UNITY_SCOPE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_SCOPE_FACTORY, UnityScopeFactoryClass))

typedef struct _UnityScopeFactory UnityScopeFactory;
typedef struct _UnityScopeFactoryClass UnityScopeFactoryClass;

#define UNITY_TYPE_FILTERS_SYNCHRONIZER (unity_filters_synchronizer_get_type ())
#define UNITY_FILTERS_SYNCHRONIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_FILTERS_SYNCHRONIZER, UnityFiltersSynchronizer))
#define UNITY_FILTERS_SYNCHRONIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_FILTERS_SYNCHRONIZER, UnityFiltersSynchronizerClass))
#define UNITY_IS_FILTERS_SYNCHRONIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_FILTERS_SYNCHRONIZER))
#define UNITY_IS_FILTERS_SYNCHRONIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_FILTERS_SYNCHRONIZER))
#define UNITY_FILTERS_SYNCHRONIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_FILTERS_SYNCHRONIZER, UnityFiltersSynchronizerClass))

typedef struct _UnityFiltersSynchronizer UnityFiltersSynchronizer;
typedef struct _UnityFiltersSynchronizerClass UnityFiltersSynchronizerClass;

#define UNITY_TYPE_RESULTS_SYNCHRONIZER (unity_results_synchronizer_get_type ())
#define UNITY_RESULTS_SYNCHRONIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_RESULTS_SYNCHRONIZER, UnityResultsSynchronizer))
#define UNITY_RESULTS_SYNCHRONIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_RESULTS_SYNCHRONIZER, UnityResultsSynchronizerClass))
#define UNITY_IS_RESULTS_SYNCHRONIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_RESULTS_SYNCHRONIZER))
#define UNITY_IS_RESULTS_SYNCHRONIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_RESULTS_SYNCHRONIZER))
#define UNITY_RESULTS_SYNCHRONIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_RESULTS_SYNCHRONIZER, UnityResultsSynchronizerClass))

typedef struct _UnityResultsSynchronizer UnityResultsSynchronizer;
typedef struct _UnityResultsSynchronizerClass UnityResultsSynchronizerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define UNITY_TYPE_SCOPE_PROXY (unity_scope_proxy_get_type ())
#define UNITY_SCOPE_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_PROXY, UnityScopeProxy))
#define UNITY_IS_SCOPE_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_PROXY))
#define UNITY_SCOPE_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_TYPE_SCOPE_PROXY, UnityScopeProxyIface))

typedef struct _UnityScopeProxy UnityScopeProxy;
typedef struct _UnityScopeProxyIface UnityScopeProxyIface;

#define UNITY_TYPE_VIEW_TYPE (unity_view_type_get_type ())
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define UNITY_TYPE_LENS_INFO (unity_lens_info_get_type ())
typedef struct _UnityLensInfo UnityLensInfo;
typedef struct _Block1Data Block1Data;

#define UNITY_TYPE_SCOPE_PROXY_REMOTE (unity_scope_proxy_remote_get_type ())
#define UNITY_SCOPE_PROXY_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_PROXY_REMOTE, UnityScopeProxyRemote))
#define UNITY_SCOPE_PROXY_REMOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_SCOPE_PROXY_REMOTE, UnityScopeProxyRemoteClass))
#define UNITY_IS_SCOPE_PROXY_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_PROXY_REMOTE))
#define UNITY_IS_SCOPE_PROXY_REMOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_SCOPE_PROXY_REMOTE))
#define UNITY_SCOPE_PROXY_REMOTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_SCOPE_PROXY_REMOTE, UnityScopeProxyRemoteClass))

typedef struct _UnityScopeProxyRemote UnityScopeProxyRemote;
typedef struct _UnityScopeProxyRemoteClass UnityScopeProxyRemoteClass;

#define UNITY_TYPE_FILTER_COLUMN (unity_filter_column_get_type ())
typedef struct _UnityLensImplInfoRequestData UnityLensImplInfoRequestData;
typedef struct _UnityLensImplActivateData UnityLensImplActivateData;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _UnityScopeFactoryPrivate UnityScopeFactoryPrivate;
typedef struct _UnityLensImplSearchData UnityLensImplSearchData;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
typedef struct _UnityLensImplGlobalSearchData UnityLensImplGlobalSearchData;
typedef struct _UnityLensImplPreviewData UnityLensImplPreviewData;
typedef struct _UnityLensImplUpdateFilterData UnityLensImplUpdateFilterData;
typedef struct _UnityLensImplUpdateActiveSourcesData UnityLensImplUpdateActiveSourcesData;
typedef struct _UnityLensImplSetViewTypeData UnityLensImplSetViewTypeData;

struct _UnityActivationReplyRaw {
	gchar* uri;
	guint handled;
	GHashTable* hints;
};

struct _UnityPreviewReplyRaw {
	gchar* uri;
	gchar* renderer_name;
	GHashTable* properties;
};

struct _UnityLensServiceIface {
	GTypeInterface parent_iface;
	void (*info_request) (UnityLensService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*info_request_finish) (UnityLensService* self, GAsyncResult* _res_, GError** error);
	void (*activate) (UnityLensService* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*activate_finish) (UnityLensService* self, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error);
	void (*search) (UnityLensService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*search_finish) (UnityLensService* self, GAsyncResult* _res_, GError** error);
	void (*global_search) (UnityLensService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*global_search_finish) (UnityLensService* self, GAsyncResult* _res_, GError** error);
	void (*preview) (UnityLensService* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*preview_finish) (UnityLensService* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error);
	void (*update_filter) (UnityLensService* self, const gchar* filter_name, GHashTable* properties, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*update_filter_finish) (UnityLensService* self, GAsyncResult* _res_, GError** error);
	void (*set_view_type) (UnityLensService* self, guint view_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_view_type_finish) (UnityLensService* self, GAsyncResult* _res_, GError** error);
};

struct _UnityLensImpl {
	GObject parent_instance;
	UnityLensImplPrivate * priv;
};

struct _UnityLensImplClass {
	GObjectClass parent_class;
};

struct _UnityLensImplPrivate {
	UnityLens* _owner;
	guint _dbus_id;
	guint _info_changed_id;
	guint _sources_update_id;
	DeeSharedModel* _results_model;
	DeeSharedModel* _global_results_model;
	DeeSharedModel* _categories_model;
	DeeSharedModel* _filters_model;
	UnityOptionsFilter* _sources;
	UnityScopeFactory* _scope_factory;
	UnityFiltersSynchronizer* _filters_sync;
	UnityResultsSynchronizer* _results_sync;
	UnityResultsSynchronizer* _global_results_sync;
};

typedef enum  {
	UNITY_VIEW_TYPE_HIDDEN,
	UNITY_VIEW_TYPE_HOME_VIEW,
	UNITY_VIEW_TYPE_LENS_VIEW
} UnityViewType;

struct _UnityScopeProxyIface {
	GTypeInterface parent_iface;
	void (*activate) (UnityScopeProxy* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*activate_finish) (UnityScopeProxy* self, GAsyncResult* _res_, UnityActivationReplyRaw* result);
	void (*search) (UnityScopeProxy* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*search_finish) (UnityScopeProxy* self, GAsyncResult* _res_);
	void (*global_search) (UnityScopeProxy* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*global_search_finish) (UnityScopeProxy* self, GAsyncResult* _res_);
	void (*preview) (UnityScopeProxy* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*preview_finish) (UnityScopeProxy* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result);
	void (*set_active_sources) (UnityScopeProxy* self, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_active_sources_finish) (UnityScopeProxy* self, GAsyncResult* _res_);
	UnityOptionsFilter* (*get_sources) (UnityScopeProxy* self);
	void (*set_sources) (UnityScopeProxy* self, UnityOptionsFilter* value);
	gboolean (*get_search_in_global) (UnityScopeProxy* self);
	void (*set_search_in_global) (UnityScopeProxy* self, gboolean value);
	UnityViewType (*get_view_type) (UnityScopeProxy* self);
	void (*set_view_type) (UnityScopeProxy* self, UnityViewType value);
	DeeSerializableModel* (*get_results_model) (UnityScopeProxy* self);
	void (*set_results_model) (UnityScopeProxy* self, DeeSerializableModel* value);
	DeeSerializableModel* (*get_global_results_model) (UnityScopeProxy* self);
	void (*set_global_results_model) (UnityScopeProxy* self, DeeSerializableModel* value);
	DeeSerializableModel* (*get_filters_model) (UnityScopeProxy* self);
	void (*set_filters_model) (UnityScopeProxy* self, DeeSerializableModel* value);
};

struct _UnityLensInfo {
	gchar* dbus_path;
	gboolean search_in_global;
	gboolean visible;
	gchar* search_hint;
	gchar* private_connection_name;
	gchar* results_model_name;
	gchar* global_results_model_name;
	gchar* categories_model_name;
	gchar* filters_model_name;
	GHashTable* hints;
};

struct _Block1Data {
	int _ref_count_;
	UnityLensImpl * self;
	UnityScopeProxy* scope;
};

typedef enum  {
	UNITY_FILTER_COLUMN_ID = 0,
	UNITY_FILTER_COLUMN_NAME,
	UNITY_FILTER_COLUMN_ICON_HINT,
	UNITY_FILTER_COLUMN_RENDERER_NAME,
	UNITY_FILTER_COLUMN_RENDERER_STATE,
	UNITY_FILTER_COLUMN_VISIBLE,
	UNITY_FILTER_COLUMN_COLLAPSED,
	UNITY_FILTER_COLUMN_FILTERING
} UnityFilterColumn;

struct _UnityLensImplInfoRequestData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityLensImpl* self;
};

struct _UnityLensImplActivateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityLensImpl* self;
	gchar* uri;
	guint action_type;
	UnityActivationReplyRaw result;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** tokens;
	gint tokens_length1;
	gint _tokens_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	UnityScopeProxy* _tmp5_;
	UnityScopeProxy* scope;
	UnityActivationReplyRaw raw;
	GHashTable* _tmp6_;
	UnityScopeProxy* _tmp7_;
	UnityScopeProxy* _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	const gchar* _tmp10_;
	guint _tmp11_;
	UnityActivationReplyRaw _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
};

struct _Block2Data {
	int _ref_count_;
	UnityLensImpl * self;
	GHashTable* _result_;
	gint num_scopes;
	gpointer _async_data_;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	guint64 seqnum;
};

struct _Block4Data {
	int _ref_count_;
	Block3Data * _data3_;
	gulong update_sig_id;
};

struct _UnityScopeFactory {
	GObject parent_instance;
	UnityScopeFactoryPrivate * priv;
	GeeArrayList* scopes;
};

struct _UnityScopeFactoryClass {
	GObjectClass parent_class;
};

struct _UnityLensImplSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityLensImpl* self;
	gchar* search_string;
	GHashTable* hints;
	GHashTable* result;
	Block2Data* _data2_;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GAsyncReadyCallback cb;
	void* cb_target;
	GDestroyNotify cb_target_destroy_notify;
	UnityScopeFactory* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _scope_list;
	GeeArrayList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _scope_size;
	gint _scope_index;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GeeArrayList* _tmp12_;
	gint _tmp13_;
	gpointer _tmp14_;
	UnityScopeProxy* scope;
	gint _tmp15_;
	UnityScopeProxy* _tmp16_;
	const gchar* _tmp17_;
	GHashTable* _tmp18_;
	GAsyncReadyCallback _tmp19_;
	void* _tmp19__target;
	gint _tmp20_;
	GHashTable* _tmp21_;
	gchar* _tmp22_;
	DeeSharedModel* _tmp23_;
	guint64 _tmp24_;
	GVariant* _tmp25_;
	GVariant* _tmp26_;
	GHashTable* _tmp27_;
	GHashTable* _tmp28_;
};

struct _Block5Data {
	int _ref_count_;
	UnityLensImpl * self;
	gint num_scopes;
	gpointer _async_data_;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	guint64 seqnum;
};

struct _Block7Data {
	int _ref_count_;
	Block6Data * _data6_;
	gulong update_sig_id;
};

struct _UnityLensImplGlobalSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityLensImpl* self;
	gchar* search_string;
	GHashTable* hints;
	GHashTable* result;
	Block5Data* _data5_;
	GAsyncReadyCallback cb;
	void* cb_target;
	GDestroyNotify cb_target_destroy_notify;
	UnityScopeFactory* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _scope_list;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _scope_size;
	gint _scope_index;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GeeArrayList* _tmp9_;
	gint _tmp10_;
	gpointer _tmp11_;
	UnityScopeProxy* scope;
	UnityScopeProxy* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	gint _tmp15_;
	UnityScopeProxy* _tmp16_;
	const gchar* _tmp17_;
	GHashTable* _tmp18_;
	GAsyncReadyCallback _tmp19_;
	void* _tmp19__target;
	gint _tmp20_;
	GHashFunc _tmp21_;
	GEqualFunc _tmp22_;
	GHashTable* _tmp23_;
	GHashTable* _result_;
	gchar* _tmp24_;
	DeeSharedModel* _tmp25_;
	guint64 _tmp26_;
	GVariant* _tmp27_;
	GVariant* _tmp28_;
};

struct _UnityLensImplPreviewData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityLensImpl* self;
	gchar* uri;
	UnityPreviewReplyRaw result;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** tokens;
	gint tokens_length1;
	gint _tokens_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	UnityScopeProxy* _tmp5_;
	UnityScopeProxy* scope;
	UnityPreviewReplyRaw raw;
	gchar* _tmp6_;
	GHashTable* _tmp7_;
	UnityScopeProxy* _tmp8_;
	UnityScopeProxy* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	UnityPreviewReplyRaw _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
};

struct _UnityLensImplUpdateFilterData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityLensImpl* self;
	gchar* filter_name;
	GHashTable* properties;
	const gchar* _tmp0_;
};

struct _UnityLensImplUpdateActiveSourcesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityLensImpl* self;
	GeeSet* updated_scope_uids;
	GeeSet* _tmp0_;
	GeeIterator* _tmp1_;
	GeeIterator* _scope_uid_it;
	GeeIterator* _tmp2_;
	gboolean _tmp3_;
	GeeIterator* _tmp4_;
	gpointer _tmp5_;
	gchar* scope_uid;
	const gchar* _tmp6_;
	UnityScopeProxy* _tmp7_;
	UnityScopeProxy* scope;
	UnityScopeProxy* _tmp8_;
	gchar** _tmp9_;
	gchar** active_sources;
	gint active_sources_length1;
	gint _active_sources_size_;
	UnityOptionsFilter* _tmp10_;
	GList* _tmp11_;
	GList* filter_option_collection;
	GList* filter_option_it;
	UnityFilterOption* _tmp12_;
	UnityFilterOption* filter_option;
	gboolean _tmp13_;
	UnityFilterOption* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gboolean _tmp18_;
	UnityFilterOption* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	UnityFilterOption* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gchar* _tmp30_;
	UnityScopeProxy* _tmp31_;
	gchar** _tmp32_;
	gint _tmp32__length1;
};

struct _UnityLensImplSetViewTypeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityLensImpl* self;
	guint view_type;
	UnityScopeFactory* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _scope_list;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _scope_size;
	gint _scope_index;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GeeArrayList* _tmp9_;
	gint _tmp10_;
	gpointer _tmp11_;
	UnityScopeProxy* scope;
	UnityScopeProxy* _tmp12_;
	guint _tmp13_;
	UnityLens* _tmp14_;
	guint _tmp15_;
};


static gpointer unity_lens_impl_parent_class = NULL;
static const gchar* unity_lens_impl_LENS_DIRECTORY;
static const gchar* unity_lens_impl_LENS_DIRECTORY = NULL;
static UnityLensServiceIface* unity_lens_impl_unity_lens_service_parent_iface = NULL;

GType unity_lens_service_proxy_get_type (void) G_GNUC_CONST;
guint unity_lens_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType unity_activation_reply_raw_get_type (void) G_GNUC_CONST;
UnityActivationReplyRaw* unity_activation_reply_raw_dup (const UnityActivationReplyRaw* self);
void unity_activation_reply_raw_free (UnityActivationReplyRaw* self);
void unity_activation_reply_raw_copy (const UnityActivationReplyRaw* self, UnityActivationReplyRaw* dest);
void unity_activation_reply_raw_destroy (UnityActivationReplyRaw* self);
GType unity_preview_reply_raw_get_type (void) G_GNUC_CONST;
UnityPreviewReplyRaw* unity_preview_reply_raw_dup (const UnityPreviewReplyRaw* self);
void unity_preview_reply_raw_free (UnityPreviewReplyRaw* self);
void unity_preview_reply_raw_copy (const UnityPreviewReplyRaw* self, UnityPreviewReplyRaw* dest);
void unity_preview_reply_raw_destroy (UnityPreviewReplyRaw* self);
GType unity_lens_service_get_type (void) G_GNUC_CONST;
GType unity_lens_impl_get_type (void) G_GNUC_CONST;
GType unity_scope_factory_get_type (void) G_GNUC_CONST;
GType unity_filters_synchronizer_get_type (void) G_GNUC_CONST;
GType unity_results_synchronizer_get_type (void) G_GNUC_CONST;
#define UNITY_LENS_IMPL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_LENS_IMPL, UnityLensImplPrivate))
enum  {
	UNITY_LENS_IMPL_DUMMY_PROPERTY,
	UNITY_LENS_IMPL_RESULTS_SYNC,
	UNITY_LENS_IMPL_GLOBAL_RESULTS_SYNC
};
UnityLensImpl* unity_lens_impl_new (UnityLens* owner);
UnityLensImpl* unity_lens_impl_construct (GType object_type, UnityLens* owner);
static void unity_lens_impl_queue_info_changed (UnityLensImpl* self);
static void _unity_lens_impl_queue_info_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_lens_impl_sources_display_name_changed (UnityLensImpl* self, GObject* obj, GParamSpec* pspec);
static void _unity_lens_impl_sources_display_name_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
#define UNITY_LENS_SOURCES_FILTER_ID "unity-sources"
static void unity_lens_impl_create_models (UnityLensImpl* self, const gchar* dbus_name);
static gchar* unity_lens_impl_create_dbus_name (UnityLensImpl* self);
static void unity_lens_impl_create_synchronizers (UnityLensImpl* self);
UnityScopeFactory* unity_scope_factory_new (const gchar* lens_id_, const gchar* lenses_directory_);
UnityScopeFactory* unity_scope_factory_construct (GType object_type, const gchar* lens_id_, const gchar* lenses_directory_);
GType unity_view_type_get_type (void) G_GNUC_CONST;
GType unity_scope_proxy_get_type (void) G_GNUC_CONST;
static void unity_lens_impl_on_scope_added (UnityLensImpl* self, UnityScopeFactory* factory, UnityScopeProxy* scope);
static void _unity_lens_impl_on_scope_added_unity_scope_factory_scope_added (UnityScopeFactory* _sender, UnityScopeProxy* scope, gpointer self);
static DeeSharedModel* unity_lens_impl_create_master_model (UnityLensImpl* self, const gchar* swarm_name);
UnityResultsSynchronizer* unity_results_synchronizer_new (DeeModel* receiver);
UnityResultsSynchronizer* unity_results_synchronizer_construct (GType object_type, DeeModel* receiver);
UnityFiltersSynchronizer* unity_filters_synchronizer_new (DeeModel* provider);
UnityFiltersSynchronizer* unity_filters_synchronizer_construct (GType object_type, DeeModel* provider);
static void __lambda10_ (UnityLensImpl* self, DeeModel* model, DeeModelIter* iter);
static void unity_lens_impl_sources_filter_changed (UnityLensImpl* self, DeeModel* model, DeeModelIter* iter);
static void ___lambda10__dee_model_row_changed (DeeModel* _sender, DeeModelIter* iter, gpointer self);
void unity_lens_impl_export (UnityLensImpl* self, GError** error);
void unity_lens_impl_load_categories (UnityLensImpl* self, GList* categories);
const gchar* unity_category_get_renderer (UnityCategory* self);
GVariant* unity_tools_hash_table_to_asv (GHashTable* hash);
GHashTable* unity_category_get_hints (UnityCategory* self);
void unity_lens_impl_load_filters (UnityLensImpl* self, GList* filters);
static void unity_lens_impl_on_filter_changed (UnityLensImpl* self, UnityFilter* filter);
static void _unity_lens_impl_on_filter_changed_unity_filter_changed (UnityFilter* _sender, gpointer self);
const gchar* unity_filter_get_renderer_name (UnityFilterRenderer renderer);
GHashTable* unity_filter_get_hints (UnityFilter* self);
static gboolean unity_lens_impl_emit_info_changed (UnityLensImpl* self);
static gboolean _unity_lens_impl_emit_info_changed_gsource_func (gpointer self);
GType unity_lens_info_get_type (void) G_GNUC_CONST;
UnityLensInfo* unity_lens_info_dup (const UnityLensInfo* self);
void unity_lens_info_free (UnityLensInfo* self);
void unity_lens_info_copy (const UnityLensInfo* self, UnityLensInfo* dest);
void unity_lens_info_destroy (UnityLensInfo* self);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
DeeSerializableModel* unity_scope_proxy_get_results_model (UnityScopeProxy* self);
static void unity_lens_impl_on_scope_results_model_changed (UnityLensImpl* self, GObject* obj, GParamSpec* pspec);
DeeSerializableModel* unity_scope_proxy_get_global_results_model (UnityScopeProxy* self);
static void unity_lens_impl_on_scope_global_results_model_changed (UnityLensImpl* self, GObject* obj, GParamSpec* pspec);
DeeSerializableModel* unity_scope_proxy_get_filters_model (UnityScopeProxy* self);
static void unity_lens_impl_on_scope_filters_model_changed (UnityLensImpl* self, GObject* obj, GParamSpec* pspec);
static void _unity_lens_impl_on_scope_results_model_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _unity_lens_impl_on_scope_global_results_model_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _unity_lens_impl_on_scope_filters_model_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_lens_impl_on_scope_sources_updated (UnityLensImpl* self, GObject* obj, GParamSpec* pspec);
static void _unity_lens_impl_on_scope_sources_updated_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void unity_results_synchronizer_add_provider (UnityResultsSynchronizer* self, DeeModel* provider, const gchar* uid);
static gchar* unity_lens_impl_uid_for_scope (UnityLensImpl* self, UnityScopeProxy* scope);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
GType unity_scope_proxy_remote_get_type (void) G_GNUC_CONST;
static void ___lambda11_ (Block1Data* _data1_);
void unity_filters_synchronizer_add_receiver (UnityFiltersSynchronizer* self, DeeModel* receiver);
static void ____lambda11__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
UnityOptionsFilter* unity_scope_proxy_get_sources (UnityScopeProxy* self);
void unity_filter_option_set_active (UnityFilterOption* self, gboolean value);
static void unity_lens_impl_queue_sources_update (UnityLensImpl* self);
GType unity_filter_column_get_type (void) G_GNUC_CONST;
void unity_filter_set_display_name (UnityFilter* self, const gchar* value);
static gboolean ___lambda9_ (UnityLensImpl* self);
static gboolean ____lambda9__gsource_func (gpointer self);
void unity_filter_set_filtering (UnityFilter* self, gboolean value);
void unity_filter_update (UnityFilter* self, GVariant* properties);
void unity_lens_impl_update_active_sources (UnityLensImpl* self, GeeSet* updated_scope_uids, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_lens_impl_update_active_sources_finish (UnityLensImpl* self, GAsyncResult* _res_);
void unity_lens_impl_add_local_scope (UnityLensImpl* self, UnityScope* scope);
void unity_scope_factory_add_local_scope (UnityScopeFactory* self, UnityScope* scope);
UnityOptionsFilter* unity_lens_impl_get_sources (UnityLensImpl* self);
DeeModel* unity_lens_impl_get_model (UnityLensImpl* self, gint index);
static void unity_lens_impl_real_info_request_data_free (gpointer _data);
static void unity_lens_impl_real_info_request (UnityLensService* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_lens_impl_real_info_request_co (UnityLensImplInfoRequestData* _data_);
static void unity_lens_impl_real_activate_data_free (gpointer _data);
static void unity_lens_impl_real_activate (UnityLensService* base, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_lens_impl_real_activate_co (UnityLensImplActivateData* _data_);
static UnityScopeProxy* unity_lens_impl_get_scope_for_uid (UnityLensImpl* self, const gchar* uid);
void unity_scope_proxy_activate (UnityScopeProxy* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_proxy_activate_finish (UnityScopeProxy* self, GAsyncResult* _res_, UnityActivationReplyRaw* result);
static void unity_lens_impl_activate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_lens_impl_real_search_data_free (gpointer _data);
static void unity_lens_impl_real_search (UnityLensService* base, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_lens_impl_real_search_co (UnityLensImplSearchData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void __lambda12_ (Block2Data* _data2_, GObject* obj, GAsyncResult* res);
void unity_scope_proxy_search (UnityScopeProxy* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable* unity_scope_proxy_search_finish (UnityScopeProxy* self, GAsyncResult* _res_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static void _____lambda13_ (Block4Data* _data4_, DeeSharedModel* m, guint64 begin_seqnum, guint64 end_seqnum);
void unity_lens_service_search (UnityLensService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable* unity_lens_service_search_finish (UnityLensService* self, GAsyncResult* _res_, GError** error);
static void ______lambda13__dee_shared_model_end_transaction (DeeSharedModel* _sender, guint64 begin_seqnum, guint64 end_seqnum, gpointer self);
static void ___lambda12__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void unity_lens_impl_real_global_search_data_free (gpointer _data);
static void unity_lens_impl_real_global_search (UnityLensService* base, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_lens_impl_real_global_search_co (UnityLensImplGlobalSearchData* _data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static void __lambda14_ (Block5Data* _data5_, GObject* obj, GAsyncResult* _result_);
void unity_scope_proxy_global_search (UnityScopeProxy* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable* unity_scope_proxy_global_search_finish (UnityScopeProxy* self, GAsyncResult* _res_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
static void ____lambda15_ (Block7Data* _data7_, DeeSharedModel* m, guint64 begin_seqnum, guint64 end_seqnum);
void unity_lens_service_global_search (UnityLensService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable* unity_lens_service_global_search_finish (UnityLensService* self, GAsyncResult* _res_, GError** error);
static void _____lambda15__dee_shared_model_end_transaction (DeeSharedModel* _sender, guint64 begin_seqnum, guint64 end_seqnum, gpointer self);
static void ___lambda14__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
gboolean unity_scope_proxy_get_search_in_global (UnityScopeProxy* self);
static void unity_lens_impl_real_preview_data_free (gpointer _data);
static void unity_lens_impl_real_preview (UnityLensService* base, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_lens_impl_real_preview_co (UnityLensImplPreviewData* _data_);
void unity_scope_proxy_preview (UnityScopeProxy* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_proxy_preview_finish (UnityScopeProxy* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result);
static void unity_lens_impl_preview_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_lens_impl_real_update_filter_data_free (gpointer _data);
static void unity_lens_impl_real_update_filter (UnityLensService* base, const gchar* filter_name, GHashTable* properties, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_lens_impl_real_update_filter_co (UnityLensImplUpdateFilterData* _data_);
static void unity_lens_impl_update_active_sources_data_free (gpointer _data);
static gboolean unity_lens_impl_update_active_sources_co (UnityLensImplUpdateActiveSourcesData* _data_);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
void unity_scope_proxy_set_active_sources (UnityScopeProxy* self, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_proxy_set_active_sources_finish (UnityScopeProxy* self, GAsyncResult* _res_);
static void unity_lens_impl_real_set_view_type_data_free (gpointer _data);
static void unity_lens_impl_real_set_view_type (UnityLensService* base, guint view_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_lens_impl_real_set_view_type_co (UnityLensImplSetViewTypeData* _data_);
void unity_scope_proxy_set_view_type (UnityScopeProxy* self, UnityViewType value);
void unity_lens_set_active_internal (UnityLens* self, gboolean is_active);
UnityResultsSynchronizer* unity_lens_impl_get_results_sync (UnityLensImpl* self);
UnityResultsSynchronizer* unity_lens_impl_get_global_results_sync (UnityLensImpl* self);
static void unity_lens_impl_finalize (GObject* obj);
static void _vala_unity_lens_impl_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _unity_lens_impl_queue_info_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_lens_impl_queue_info_changed (self);
}


static void _unity_lens_impl_sources_display_name_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_lens_impl_sources_display_name_changed (self, _sender, pspec);
}


static void _unity_lens_impl_on_scope_added_unity_scope_factory_scope_added (UnityScopeFactory* _sender, UnityScopeProxy* scope, gpointer self) {
	unity_lens_impl_on_scope_added (self, _sender, scope);
}


UnityLensImpl* unity_lens_impl_construct (GType object_type, UnityLens* owner) {
	UnityLensImpl * self = NULL;
	UnityLens* _tmp0_;
	UnityLens* _tmp1_;
	UnityLens* _tmp2_;
	UnityLens* _tmp3_;
	UnityLens* _tmp4_;
	UnityLens* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	UnityCheckOptionFilter* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	UnityLens* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	UnityScopeFactory* _tmp15_;
	UnityScopeFactory* _tmp16_;
	g_return_val_if_fail (owner != NULL, NULL);
	self = (UnityLensImpl*) g_object_new (object_type, NULL);
	_tmp0_ = owner;
	self->priv->_owner = _tmp0_;
	_tmp1_ = self->priv->_owner;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::search-in-global", (GCallback) _unity_lens_impl_queue_info_changed_g_object_notify, self, 0);
	_tmp2_ = self->priv->_owner;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::visible", (GCallback) _unity_lens_impl_queue_info_changed_g_object_notify, self, 0);
	_tmp3_ = self->priv->_owner;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::search-hint", (GCallback) _unity_lens_impl_queue_info_changed_g_object_notify, self, 0);
	_tmp4_ = self->priv->_owner;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::sources-display-name", (GCallback) _unity_lens_impl_sources_display_name_changed_g_object_notify, self, 0);
	_tmp5_ = self->priv->_owner;
	_tmp6_ = unity_lens_get_sources_display_name (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = unity_check_option_filter_new (UNITY_LENS_SOURCES_FILTER_ID, _tmp7_, NULL, TRUE);
	_g_object_unref0 (self->priv->_sources);
	self->priv->_sources = (UnityOptionsFilter*) _tmp8_;
	_tmp9_ = unity_lens_impl_create_dbus_name (self);
	_tmp10_ = _tmp9_;
	unity_lens_impl_create_models (self, _tmp10_);
	_g_free0 (_tmp10_);
	unity_lens_impl_create_synchronizers (self);
	_tmp11_ = self->priv->_owner;
	_tmp12_ = unity_lens_get_id (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = unity_lens_impl_LENS_DIRECTORY;
	_tmp15_ = unity_scope_factory_new (_tmp13_, _tmp14_);
	_g_object_unref0 (self->priv->_scope_factory);
	self->priv->_scope_factory = _tmp15_;
	_tmp16_ = self->priv->_scope_factory;
	g_signal_connect_object (_tmp16_, "scope-added", (GCallback) _unity_lens_impl_on_scope_added_unity_scope_factory_scope_added, self, 0);
	return self;
}


UnityLensImpl* unity_lens_impl_new (UnityLens* owner) {
	return unity_lens_impl_construct (UNITY_TYPE_LENS_IMPL, owner);
}


static gchar* unity_lens_impl_create_dbus_name (UnityLensImpl* self) {
	gchar* result = NULL;
	GTimeVal tv = {0};
	GTimeVal _tmp0_;
	glong _tmp1_;
	gint64 milli;
	gint64 _tmp2_;
	GTimeVal _tmp3_;
	glong _tmp4_;
	UnityLens* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gint64 _tmp8_;
	gchar* _tmp9_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_get_current_time (&tv);
	_tmp0_ = tv;
	_tmp1_ = _tmp0_.tv_sec;
	milli = (gint64) _tmp1_;
	_tmp2_ = milli;
	_tmp3_ = tv;
	_tmp4_ = _tmp3_.tv_usec;
	milli = (_tmp2_ * 1000) + (_tmp4_ / 1000);
	_tmp5_ = self->priv->_owner;
	_tmp6_ = unity_lens_get_id (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = milli;
	_tmp9_ = g_strdup_printf ("com.canonical.Unity.Lens.%s.T%" G_GINT64_FORMAT "", _tmp7_, _tmp8_);
	result = _tmp9_;
	return result;
}


static DeeSharedModel* unity_lens_impl_create_master_model (UnityLensImpl* self, const gchar* swarm_name) {
	DeeSharedModel* result = NULL;
	const gchar* _tmp0_;
	GObject* _tmp1_ = NULL;
	GObject* _tmp2_;
	DeePeer* peer;
	DeeSharedModelAccessMode access_mode;
	DeeSequenceModel* _tmp3_;
	DeeSequenceModel* _tmp4_;
	GObject* _tmp5_ = NULL;
	GObject* _tmp6_;
	DeeSharedModel* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (swarm_name != NULL, NULL);
	_tmp0_ = swarm_name;
	_tmp1_ = g_object_new (dee_peer_get_type (), "swarm-name", _tmp0_, "swarm-owner", TRUE, NULL, NULL);
	_tmp2_ = G_IS_INITIALLY_UNOWNED (_tmp1_) ? g_object_ref_sink (_tmp1_) : _tmp1_;
	peer = DEE_IS_PEER (_tmp2_) ? ((DeePeer*) _tmp2_) : NULL;
	access_mode = DEE_SHARED_MODEL_ACCESS_MODE_LEADER_WRITABLE;
	_tmp3_ = (DeeSequenceModel*) dee_sequence_model_new ();
	_tmp4_ = _tmp3_;
	_tmp5_ = g_object_new (dee_shared_model_get_type (), "peer", peer, "back-end", _tmp4_, "access-mode", access_mode, NULL, NULL);
	_tmp6_ = G_IS_INITIALLY_UNOWNED (_tmp5_) ? g_object_ref_sink (_tmp5_) : _tmp5_;
	_tmp7_ = DEE_IS_SHARED_MODEL (_tmp6_) ? ((DeeSharedModel*) _tmp6_) : NULL;
	_g_object_unref0 (_tmp4_);
	result = _tmp7_;
	_g_object_unref0 (peer);
	return result;
}


static void unity_lens_impl_create_models (UnityLensImpl* self, const gchar* dbus_name) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	DeeSharedModel* _tmp3_ = NULL;
	DeeSharedModel* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	DeeSharedModel* _tmp8_ = NULL;
	DeeSharedModel* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	DeeSharedModel* _tmp13_ = NULL;
	DeeSharedModel* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	DeeSharedModel* _tmp18_;
	DeeSharedModel* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dbus_name != NULL);
	_tmp0_ = dbus_name;
	_tmp1_ = g_strconcat (_tmp0_, ".Results", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = unity_lens_impl_create_master_model (self, _tmp2_);
	_g_object_unref0 (self->priv->_results_model);
	self->priv->_results_model = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp4_ = self->priv->_results_model;
	dee_model_set_schema ((DeeModel*) _tmp4_, "s", "s", "u", "s", "s", "s", "s", NULL);
	_tmp5_ = dbus_name;
	_tmp6_ = g_strconcat (_tmp5_, ".GlobalResults", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = unity_lens_impl_create_master_model (self, _tmp7_);
	_g_object_unref0 (self->priv->_global_results_model);
	self->priv->_global_results_model = _tmp8_;
	_g_free0 (_tmp7_);
	_tmp9_ = self->priv->_global_results_model;
	dee_model_set_schema ((DeeModel*) _tmp9_, "s", "s", "u", "s", "s", "s", "s", NULL);
	_tmp10_ = dbus_name;
	_tmp11_ = g_strconcat (_tmp10_, ".Categories", NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = unity_lens_impl_create_master_model (self, _tmp12_);
	_g_object_unref0 (self->priv->_categories_model);
	self->priv->_categories_model = _tmp13_;
	_g_free0 (_tmp12_);
	_tmp14_ = self->priv->_categories_model;
	dee_model_set_schema ((DeeModel*) _tmp14_, "s", "s", "s", "a{sv}", NULL);
	_tmp15_ = dbus_name;
	_tmp16_ = g_strconcat (_tmp15_, ".Filters", NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = (DeeSharedModel*) dee_shared_model_new (_tmp17_);
	_g_object_unref0 (self->priv->_filters_model);
	self->priv->_filters_model = _tmp18_;
	_g_free0 (_tmp17_);
	_tmp19_ = self->priv->_filters_model;
	dee_model_set_schema ((DeeModel*) _tmp19_, "s", "s", "s", "s", "a{sv}", "b", "b", "b", NULL);
}


static void __lambda10_ (UnityLensImpl* self, DeeModel* model, DeeModelIter* iter) {
	DeeModel* _tmp0_;
	DeeModelIter* _tmp1_;
	const gchar* _tmp2_ = NULL;
	DeeModel* _tmp3_;
	DeeModelIter* _tmp4_;
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = model;
	_tmp1_ = iter;
	_tmp2_ = dee_model_get_string (_tmp0_, _tmp1_, (guint) 0);
	if (g_strcmp0 (_tmp2_, UNITY_LENS_SOURCES_FILTER_ID) != 0) {
		return;
	}
	_tmp3_ = model;
	_tmp4_ = iter;
	unity_lens_impl_sources_filter_changed (self, _tmp3_, _tmp4_);
}


static void ___lambda10__dee_model_row_changed (DeeModel* _sender, DeeModelIter* iter, gpointer self) {
	__lambda10_ (self, _sender, iter);
}


static void unity_lens_impl_create_synchronizers (UnityLensImpl* self) {
	DeeSharedModel* _tmp0_;
	UnityResultsSynchronizer* _tmp1_;
	DeeSharedModel* _tmp2_;
	UnityResultsSynchronizer* _tmp3_;
	DeeSharedModel* _tmp4_;
	UnityFiltersSynchronizer* _tmp5_;
	DeeSharedModel* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_results_model;
	_tmp1_ = unity_results_synchronizer_new ((DeeModel*) _tmp0_);
	_g_object_unref0 (self->priv->_results_sync);
	self->priv->_results_sync = _tmp1_;
	_tmp2_ = self->priv->_global_results_model;
	_tmp3_ = unity_results_synchronizer_new ((DeeModel*) _tmp2_);
	_g_object_unref0 (self->priv->_global_results_sync);
	self->priv->_global_results_sync = _tmp3_;
	_tmp4_ = self->priv->_filters_model;
	_tmp5_ = unity_filters_synchronizer_new ((DeeModel*) _tmp4_);
	_g_object_unref0 (self->priv->_filters_sync);
	self->priv->_filters_sync = _tmp5_;
	_tmp6_ = self->priv->_filters_model;
	g_signal_connect_object ((DeeModel*) _tmp6_, "row-changed", (GCallback) ___lambda10__dee_model_row_changed, self, 0);
}


void unity_lens_impl_export (UnityLensImpl* self, GError** error) {
	GDBusConnection* _tmp0_ = NULL;
	GDBusConnection* conn;
	GDBusConnection* _tmp1_;
	UnityLens* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	guint _tmp5_ = 0U;
	guint _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
	conn = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp1_ = conn;
	_tmp2_ = self->priv->_owner;
	_tmp3_ = unity_lens_get_dbus_path (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = unity_lens_service_register_object (UNITY_IS_LENS_SERVICE (self) ? ((UnityLensService*) self) : NULL, _tmp1_, _tmp4_, &_inner_error_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (conn);
			return;
		} else {
			_g_object_unref0 (conn);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	self->priv->_dbus_id = _tmp6_;
	unity_lens_impl_queue_info_changed (self);
	_g_object_unref0 (conn);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void unity_lens_impl_load_categories (UnityLensImpl* self, GList* categories) {
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = categories;
	{
		GList* category_collection = NULL;
		GList* category_it = NULL;
		category_collection = _tmp0_;
		for (category_it = category_collection; category_it != NULL; category_it = category_it->next) {
			UnityCategory* _tmp1_;
			UnityCategory* category = NULL;
			_tmp1_ = _g_object_ref0 ((UnityCategory*) category_it->data);
			category = _tmp1_;
			{
				gchar* _tmp2_ = NULL;
				UnityCategory* _tmp3_;
				GIcon* _tmp4_;
				GIcon* _tmp5_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* icon_hint_s;
				DeeSharedModel* _tmp13_;
				UnityCategory* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				UnityCategory* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				UnityCategory* _tmp21_;
				GHashTable* _tmp22_;
				GHashTable* _tmp23_;
				GVariant* _tmp24_ = NULL;
				GVariant* _tmp25_;
				_tmp3_ = category;
				_tmp4_ = unity_category_get_icon_hint (_tmp3_);
				_tmp5_ = _tmp4_;
				if (_tmp5_ != NULL) {
					UnityCategory* _tmp6_;
					GIcon* _tmp7_;
					GIcon* _tmp8_;
					gchar* _tmp9_ = NULL;
					_tmp6_ = category;
					_tmp7_ = unity_category_get_icon_hint (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = g_icon_to_string (_tmp8_);
					_g_free0 (_tmp2_);
					_tmp2_ = _tmp9_;
				} else {
					gchar* _tmp10_;
					_tmp10_ = g_strdup ("");
					_g_free0 (_tmp2_);
					_tmp2_ = _tmp10_;
				}
				_tmp11_ = _tmp2_;
				_tmp12_ = g_strdup (_tmp11_);
				icon_hint_s = _tmp12_;
				_tmp13_ = self->priv->_categories_model;
				_tmp14_ = category;
				_tmp15_ = unity_category_get_name (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = icon_hint_s;
				_tmp18_ = category;
				_tmp19_ = unity_category_get_renderer (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = category;
				_tmp22_ = unity_category_get_hints (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = unity_tools_hash_table_to_asv (_tmp23_);
				_tmp25_ = _tmp24_;
				dee_model_append ((DeeModel*) _tmp13_, _tmp16_, _tmp17_, _tmp20_, _tmp25_, NULL);
				_g_variant_unref0 (_tmp25_);
				_g_free0 (icon_hint_s);
				_g_free0 (_tmp2_);
				_g_object_unref0 (category);
			}
		}
	}
}


static void _unity_lens_impl_on_filter_changed_unity_filter_changed (UnityFilter* _sender, gpointer self) {
	unity_lens_impl_on_filter_changed (self, _sender);
}


void unity_lens_impl_load_filters (UnityLensImpl* self, GList* filters) {
	DeeSharedModel* _tmp0_;
	GList* _tmp1_;
	GList* _tmp3_;
	GList* _tmp4_ = NULL;
	GList* filters_and_sources;
	UnityOptionsFilter* _tmp5_;
	GList* _tmp6_;
	guint _tmp7_ = 0U;
	GList* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_filters_model;
	dee_model_clear ((DeeModel*) _tmp0_);
	_tmp1_ = filters;
	{
		GList* filter_collection = NULL;
		GList* filter_it = NULL;
		filter_collection = _tmp1_;
		for (filter_it = filter_collection; filter_it != NULL; filter_it = filter_it->next) {
			UnityFilter* filter = NULL;
			filter = (UnityFilter*) filter_it->data;
			{
				UnityFilter* _tmp2_;
				_tmp2_ = filter;
				g_signal_connect_object (_tmp2_, "changed", (GCallback) _unity_lens_impl_on_filter_changed_unity_filter_changed, self, 0);
			}
		}
	}
	_tmp3_ = filters;
	_tmp4_ = g_list_copy (_tmp3_);
	filters_and_sources = _tmp4_;
	_tmp5_ = self->priv->_sources;
	_tmp6_ = _tmp5_->options;
	_tmp7_ = g_list_length (_tmp6_);
	if (_tmp7_ > ((guint) 0)) {
		UnityOptionsFilter* _tmp8_;
		_tmp8_ = self->priv->_sources;
		filters_and_sources = g_list_append (filters_and_sources, (UnityFilter*) _tmp8_);
	}
	_tmp9_ = filters_and_sources;
	{
		GList* filter_collection = NULL;
		GList* filter_it = NULL;
		filter_collection = _tmp9_;
		for (filter_it = filter_collection; filter_it != NULL; filter_it = filter_it->next) {
			UnityFilter* filter = NULL;
			filter = (UnityFilter*) filter_it->data;
			{
				gchar* _tmp10_ = NULL;
				UnityFilter* _tmp11_;
				GIcon* _tmp12_;
				GIcon* _tmp13_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* icon_hint_s;
				DeeSharedModel* _tmp21_;
				UnityFilter* _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				UnityFilter* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				UnityFilter* _tmp29_;
				UnityFilterRenderer _tmp30_;
				UnityFilterRenderer _tmp31_;
				const gchar* _tmp32_ = NULL;
				UnityFilter* _tmp33_;
				GHashTable* _tmp34_ = NULL;
				GHashTable* _tmp35_;
				GVariant* _tmp36_ = NULL;
				GVariant* _tmp37_;
				UnityFilter* _tmp38_;
				gboolean _tmp39_;
				gboolean _tmp40_;
				UnityFilter* _tmp41_;
				gboolean _tmp42_;
				gboolean _tmp43_;
				UnityFilter* _tmp44_;
				gboolean _tmp45_;
				gboolean _tmp46_;
				_tmp11_ = filter;
				_tmp12_ = unity_filter_get_icon_hint (_tmp11_);
				_tmp13_ = _tmp12_;
				if (_tmp13_ != NULL) {
					UnityFilter* _tmp14_;
					GIcon* _tmp15_;
					GIcon* _tmp16_;
					gchar* _tmp17_ = NULL;
					_tmp14_ = filter;
					_tmp15_ = unity_filter_get_icon_hint (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = g_icon_to_string (_tmp16_);
					_g_free0 (_tmp10_);
					_tmp10_ = _tmp17_;
				} else {
					gchar* _tmp18_;
					_tmp18_ = g_strdup ("");
					_g_free0 (_tmp10_);
					_tmp10_ = _tmp18_;
				}
				_tmp19_ = _tmp10_;
				_tmp20_ = g_strdup (_tmp19_);
				icon_hint_s = _tmp20_;
				_tmp21_ = self->priv->_filters_model;
				_tmp22_ = filter;
				_tmp23_ = unity_filter_get_id (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = filter;
				_tmp26_ = unity_filter_get_display_name (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = icon_hint_s;
				_tmp29_ = filter;
				_tmp30_ = unity_filter_get_renderer (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = unity_filter_get_renderer_name (_tmp31_);
				_tmp33_ = filter;
				_tmp34_ = unity_filter_get_hints (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = unity_tools_hash_table_to_asv (_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = filter;
				_tmp39_ = unity_filter_get_visible (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = filter;
				_tmp42_ = unity_filter_get_collapsed (_tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = filter;
				_tmp45_ = unity_filter_get_filtering (_tmp44_);
				_tmp46_ = _tmp45_;
				dee_model_append ((DeeModel*) _tmp21_, _tmp24_, _tmp27_, _tmp28_, _tmp32_, _tmp37_, _tmp40_, _tmp43_, _tmp46_, NULL);
				_g_variant_unref0 (_tmp37_);
				_g_hash_table_unref0 (_tmp35_);
				_g_free0 (icon_hint_s);
				_g_free0 (_tmp10_);
			}
		}
	}
	_g_list_free0 (filters_and_sources);
}


static gboolean _unity_lens_impl_emit_info_changed_gsource_func (gpointer self) {
	gboolean result;
	result = unity_lens_impl_emit_info_changed (self);
	return result;
}


static void unity_lens_impl_queue_info_changed (UnityLensImpl* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_info_changed_id;
	if (_tmp0_ == ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _unity_lens_impl_emit_info_changed_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->_info_changed_id = _tmp1_;
	}
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


static gboolean unity_lens_impl_emit_info_changed (UnityLensImpl* self) {
	gboolean result = FALSE;
	UnityLensInfo info = {0};
	UnityLens* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	UnityLens* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	UnityLens* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	UnityLens* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gchar* _tmp14_;
	DeeSharedModel* _tmp15_;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	DeeSharedModel* _tmp18_;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	DeeSharedModel* _tmp21_;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	DeeSharedModel* _tmp24_;
	const gchar* _tmp25_ = NULL;
	gchar* _tmp26_;
	GHashTable* _tmp27_;
	UnityLensInfo _tmp28_;
	g_return_val_if_fail (self != NULL, FALSE);
	memset (&info, 0, sizeof (UnityLensInfo));
	_tmp0_ = self->priv->_owner;
	_tmp1_ = unity_lens_get_dbus_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (info.dbus_path);
	info.dbus_path = _tmp3_;
	_tmp4_ = self->priv->_owner;
	_tmp5_ = unity_lens_get_search_in_global (_tmp4_);
	_tmp6_ = _tmp5_;
	info.search_in_global = _tmp6_;
	_tmp7_ = self->priv->_owner;
	_tmp8_ = unity_lens_get_search_hint (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (info.search_hint);
	info.search_hint = _tmp10_;
	_tmp11_ = self->priv->_owner;
	_tmp12_ = unity_lens_get_visible (_tmp11_);
	_tmp13_ = _tmp12_;
	info.visible = _tmp13_;
	_tmp14_ = g_strdup ("<not implemented>");
	_g_free0 (info.private_connection_name);
	info.private_connection_name = _tmp14_;
	_tmp15_ = self->priv->_results_model;
	_tmp16_ = dee_shared_model_get_swarm_name (_tmp15_);
	_tmp17_ = g_strdup (_tmp16_);
	_g_free0 (info.results_model_name);
	info.results_model_name = _tmp17_;
	_tmp18_ = self->priv->_global_results_model;
	_tmp19_ = dee_shared_model_get_swarm_name (_tmp18_);
	_tmp20_ = g_strdup (_tmp19_);
	_g_free0 (info.global_results_model_name);
	info.global_results_model_name = _tmp20_;
	_tmp21_ = self->priv->_categories_model;
	_tmp22_ = dee_shared_model_get_swarm_name (_tmp21_);
	_tmp23_ = g_strdup (_tmp22_);
	_g_free0 (info.categories_model_name);
	info.categories_model_name = _tmp23_;
	_tmp24_ = self->priv->_filters_model;
	_tmp25_ = dee_shared_model_get_swarm_name (_tmp24_);
	_tmp26_ = g_strdup (_tmp25_);
	_g_free0 (info.filters_model_name);
	info.filters_model_name = _tmp26_;
	_tmp27_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
	_g_hash_table_unref0 (info.hints);
	info.hints = _tmp27_;
	_tmp28_ = info;
	g_signal_emit_by_name ((UnityLensService*) self, "changed", &_tmp28_);
	self->priv->_info_changed_id = (guint) 0;
	result = FALSE;
	unity_lens_info_destroy (&info);
	return result;
}


static void _unity_lens_impl_on_scope_results_model_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_lens_impl_on_scope_results_model_changed (self, _sender, pspec);
}


static void _unity_lens_impl_on_scope_global_results_model_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_lens_impl_on_scope_global_results_model_changed (self, _sender, pspec);
}


static void _unity_lens_impl_on_scope_filters_model_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_lens_impl_on_scope_filters_model_changed (self, _sender, pspec);
}


static void _unity_lens_impl_on_scope_sources_updated_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_lens_impl_on_scope_sources_updated (self, _sender, pspec);
}


static void unity_lens_impl_on_scope_added (UnityLensImpl* self, UnityScopeFactory* factory, UnityScopeProxy* scope) {
	UnityScopeProxy* _tmp0_;
	DeeSerializableModel* _tmp1_;
	DeeSerializableModel* _tmp2_;
	UnityScopeProxy* _tmp4_;
	DeeSerializableModel* _tmp5_;
	DeeSerializableModel* _tmp6_;
	UnityScopeProxy* _tmp8_;
	DeeSerializableModel* _tmp9_;
	DeeSerializableModel* _tmp10_;
	UnityScopeProxy* _tmp12_;
	UnityScopeProxy* _tmp13_;
	UnityScopeProxy* _tmp14_;
	UnityScopeProxy* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (factory != NULL);
	g_return_if_fail (scope != NULL);
	_tmp0_ = scope;
	_tmp1_ = unity_scope_proxy_get_results_model (_tmp0_);
	_tmp2_ = _tmp1_;
	if (DEE_IS_MODEL (_tmp2_)) {
		UnityScopeProxy* _tmp3_;
		_tmp3_ = scope;
		unity_lens_impl_on_scope_results_model_changed (self, (GObject*) _tmp3_, NULL);
	}
	_tmp4_ = scope;
	_tmp5_ = unity_scope_proxy_get_global_results_model (_tmp4_);
	_tmp6_ = _tmp5_;
	if (DEE_IS_MODEL (_tmp6_)) {
		UnityScopeProxy* _tmp7_;
		_tmp7_ = scope;
		unity_lens_impl_on_scope_global_results_model_changed (self, (GObject*) _tmp7_, NULL);
	}
	_tmp8_ = scope;
	_tmp9_ = unity_scope_proxy_get_filters_model (_tmp8_);
	_tmp10_ = _tmp9_;
	if (DEE_IS_MODEL (_tmp10_)) {
		UnityScopeProxy* _tmp11_;
		_tmp11_ = scope;
		unity_lens_impl_on_scope_filters_model_changed (self, (GObject*) _tmp11_, NULL);
	}
	_tmp12_ = scope;
	g_signal_connect_object ((GObject*) _tmp12_, "notify::results-model", (GCallback) _unity_lens_impl_on_scope_results_model_changed_g_object_notify, self, 0);
	_tmp13_ = scope;
	g_signal_connect_object ((GObject*) _tmp13_, "notify::global-results-model", (GCallback) _unity_lens_impl_on_scope_global_results_model_changed_g_object_notify, self, 0);
	_tmp14_ = scope;
	g_signal_connect_object ((GObject*) _tmp14_, "notify::filters-model", (GCallback) _unity_lens_impl_on_scope_filters_model_changed_g_object_notify, self, 0);
	_tmp15_ = scope;
	g_signal_connect_object ((GObject*) _tmp15_, "notify::sources", (GCallback) _unity_lens_impl_on_scope_sources_updated_g_object_notify, self, 0);
}


static void unity_lens_impl_on_scope_results_model_changed (UnityLensImpl* self, GObject* obj, GParamSpec* pspec) {
	GObject* _tmp0_;
	UnityScopeProxy* _tmp1_;
	UnityScopeProxy* scope;
	UnityResultsSynchronizer* _tmp2_;
	DeeSerializableModel* _tmp3_;
	DeeSerializableModel* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	_tmp0_ = obj;
	_tmp1_ = _g_object_ref0 (UNITY_IS_SCOPE_PROXY (_tmp0_) ? ((UnityScopeProxy*) _tmp0_) : NULL);
	scope = _tmp1_;
	_tmp2_ = self->priv->_results_sync;
	_tmp3_ = unity_scope_proxy_get_results_model (scope);
	_tmp4_ = _tmp3_;
	_tmp5_ = unity_lens_impl_uid_for_scope (self, scope);
	_tmp6_ = _tmp5_;
	unity_results_synchronizer_add_provider (_tmp2_, (DeeModel*) _tmp4_, _tmp6_);
	_g_free0 (_tmp6_);
	_g_object_unref0 (scope);
}


static void unity_lens_impl_on_scope_global_results_model_changed (UnityLensImpl* self, GObject* obj, GParamSpec* pspec) {
	GObject* _tmp0_;
	UnityScopeProxy* _tmp1_;
	UnityScopeProxy* scope;
	UnityResultsSynchronizer* _tmp2_;
	DeeSerializableModel* _tmp3_;
	DeeSerializableModel* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	_tmp0_ = obj;
	_tmp1_ = _g_object_ref0 (UNITY_IS_SCOPE_PROXY (_tmp0_) ? ((UnityScopeProxy*) _tmp0_) : NULL);
	scope = _tmp1_;
	_tmp2_ = self->priv->_global_results_sync;
	_tmp3_ = unity_scope_proxy_get_global_results_model (scope);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%p", scope);
	_tmp6_ = _tmp5_;
	unity_results_synchronizer_add_provider (_tmp2_, (DeeModel*) _tmp4_, _tmp6_);
	_g_free0 (_tmp6_);
	_g_object_unref0 (scope);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->scope);
		g_slice_free (Block1Data, _data1_);
	}
}


static void ___lambda11_ (Block1Data* _data1_) {
	UnityLensImpl * self;
	UnityFiltersSynchronizer* _tmp0_;
	UnityScopeProxy* _tmp1_;
	DeeSerializableModel* _tmp2_;
	DeeSerializableModel* _tmp3_;
	self = _data1_->self;
	_tmp0_ = self->priv->_filters_sync;
	_tmp1_ = _data1_->scope;
	_tmp2_ = unity_scope_proxy_get_filters_model (_tmp1_);
	_tmp3_ = _tmp2_;
	unity_filters_synchronizer_add_receiver (_tmp0_, (DeeModel*) _tmp3_);
}


static void ____lambda11__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	___lambda11_ (self);
}


static void unity_lens_impl_on_scope_filters_model_changed (UnityLensImpl* self, GObject* obj, GParamSpec* pspec) {
	Block1Data* _data1_;
	GObject* _tmp0_;
	UnityScopeProxy* _tmp1_;
	gboolean _tmp2_ = FALSE;
	UnityScopeProxy* _tmp3_;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = obj;
	_tmp1_ = _g_object_ref0 (UNITY_IS_SCOPE_PROXY (_tmp0_) ? ((UnityScopeProxy*) _tmp0_) : NULL);
	_data1_->scope = _tmp1_;
	_tmp3_ = _data1_->scope;
	if (UNITY_IS_SCOPE_PROXY_REMOTE (_tmp3_)) {
		UnityScopeProxy* _tmp4_;
		DeeSerializableModel* _tmp5_;
		DeeSerializableModel* _tmp6_;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_;
		_tmp4_ = _data1_->scope;
		_tmp5_ = unity_scope_proxy_get_filters_model (_tmp4_);
		_tmp6_ = _tmp5_;
		g_object_get (DEE_IS_SHARED_MODEL (_tmp6_) ? ((DeeSharedModel*) _tmp6_) : NULL, "synchronized", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == FALSE;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp9_ = _tmp2_;
	if (_tmp9_) {
		UnityScopeProxy* _tmp10_;
		DeeSerializableModel* _tmp11_;
		DeeSerializableModel* _tmp12_;
		_tmp10_ = _data1_->scope;
		_tmp11_ = unity_scope_proxy_get_filters_model (_tmp10_);
		_tmp12_ = _tmp11_;
		g_signal_connect_data ((GObject*) _tmp12_, "notify::synchronized", (GCallback) ____lambda11__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	} else {
		UnityFiltersSynchronizer* _tmp13_;
		UnityScopeProxy* _tmp14_;
		DeeSerializableModel* _tmp15_;
		DeeSerializableModel* _tmp16_;
		_tmp13_ = self->priv->_filters_sync;
		_tmp14_ = _data1_->scope;
		_tmp15_ = unity_scope_proxy_get_filters_model (_tmp14_);
		_tmp16_ = _tmp15_;
		unity_filters_synchronizer_add_receiver (_tmp13_, (DeeModel*) _tmp16_);
	}
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static void unity_lens_impl_on_scope_sources_updated (UnityLensImpl* self, GObject* obj, GParamSpec* pspec) {
	GObject* _tmp0_;
	UnityScopeProxy* _tmp1_;
	UnityScopeProxy* scope;
	GeeHashSet* _tmp2_;
	GeeHashSet* touched_filters;
	UnityScopeProxy* _tmp3_;
	UnityOptionsFilter* _tmp4_;
	UnityOptionsFilter* _tmp5_;
	GList* _tmp6_;
	UnityScopeProxy* _tmp41_;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_;
	gchar* prefix;
	GeeHashSet* _tmp46_;
	GeeHashSet* removed_ids;
	UnityOptionsFilter* _tmp47_;
	GList* _tmp48_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = obj;
	_tmp1_ = _g_object_ref0 (UNITY_IS_SCOPE_PROXY (_tmp0_) ? ((UnityScopeProxy*) _tmp0_) : NULL);
	scope = _tmp1_;
	_tmp2_ = gee_hash_set_new (UNITY_TYPE_FILTER_OPTION, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	touched_filters = _tmp2_;
	_tmp3_ = scope;
	_tmp4_ = unity_scope_proxy_get_sources (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->options;
	{
		GList* filter_collection = NULL;
		GList* filter_it = NULL;
		filter_collection = _tmp6_;
		for (filter_it = filter_collection; filter_it != NULL; filter_it = filter_it->next) {
			UnityFilterOption* _tmp7_;
			UnityFilterOption* filter = NULL;
			_tmp7_ = _g_object_ref0 ((UnityFilterOption*) filter_it->data);
			filter = _tmp7_;
			{
				UnityScopeProxy* _tmp8_;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				UnityFilterOption* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				gchar* mangled_id;
				UnityOptionsFilter* _tmp16_;
				const gchar* _tmp17_;
				UnityFilterOption* _tmp18_ = NULL;
				UnityFilterOption* option;
				UnityFilterOption* _tmp19_;
				_tmp8_ = scope;
				_tmp9_ = unity_lens_impl_uid_for_scope (self, _tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = filter;
				_tmp12_ = unity_filter_option_get_id (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_strdup_printf ("%s:%s", _tmp10_, _tmp13_);
				_tmp15_ = _tmp14_;
				_g_free0 (_tmp10_);
				mangled_id = _tmp15_;
				_tmp16_ = self->priv->_sources;
				_tmp17_ = mangled_id;
				_tmp18_ = unity_options_filter_get_option (_tmp16_, _tmp17_);
				option = _tmp18_;
				_tmp19_ = option;
				if (_tmp19_ == NULL) {
					UnityOptionsFilter* _tmp20_;
					const gchar* _tmp21_;
					UnityFilterOption* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					UnityFilterOption* _tmp25_;
					GIcon* _tmp26_;
					GIcon* _tmp27_;
					UnityFilterOption* _tmp28_ = NULL;
					UnityFilterOption* new_option;
					UnityFilterOption* _tmp29_;
					UnityFilterOption* _tmp30_;
					gboolean _tmp31_;
					gboolean _tmp32_;
					GeeHashSet* _tmp33_;
					UnityFilterOption* _tmp34_;
					_tmp20_ = self->priv->_sources;
					_tmp21_ = mangled_id;
					_tmp22_ = filter;
					_tmp23_ = unity_filter_option_get_display_name (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = filter;
					_tmp26_ = unity_filter_option_get_icon_hint (_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = unity_options_filter_add_option (_tmp20_, _tmp21_, _tmp24_, _tmp27_);
					new_option = _tmp28_;
					_tmp29_ = new_option;
					_tmp30_ = filter;
					_tmp31_ = unity_filter_option_get_active (_tmp30_);
					_tmp32_ = _tmp31_;
					unity_filter_option_set_active (_tmp29_, _tmp32_);
					_tmp33_ = touched_filters;
					_tmp34_ = new_option;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp33_, _tmp34_);
					_g_object_unref0 (new_option);
				} else {
					UnityFilterOption* _tmp35_;
					UnityFilterOption* _tmp36_;
					gboolean _tmp37_;
					gboolean _tmp38_;
					GeeHashSet* _tmp39_;
					UnityFilterOption* _tmp40_;
					_tmp35_ = option;
					_tmp36_ = filter;
					_tmp37_ = unity_filter_option_get_active (_tmp36_);
					_tmp38_ = _tmp37_;
					unity_filter_option_set_active (_tmp35_, _tmp38_);
					_tmp39_ = touched_filters;
					_tmp40_ = option;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp39_, _tmp40_);
				}
				_g_object_unref0 (option);
				_g_free0 (mangled_id);
				_g_object_unref0 (filter);
			}
		}
	}
	_tmp41_ = scope;
	_tmp42_ = unity_lens_impl_uid_for_scope (self, _tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = g_strdup_printf ("%s:", _tmp43_);
	_tmp45_ = _tmp44_;
	_g_free0 (_tmp43_);
	prefix = _tmp45_;
	_tmp46_ = gee_hash_set_new (G_TYPE_STRING, NULL, NULL, NULL, NULL);
	removed_ids = _tmp46_;
	_tmp47_ = self->priv->_sources;
	_tmp48_ = _tmp47_->options;
	{
		GList* filter_option_collection = NULL;
		GList* filter_option_it = NULL;
		filter_option_collection = _tmp48_;
		for (filter_option_it = filter_option_collection; filter_option_it != NULL; filter_option_it = filter_option_it->next) {
			UnityFilterOption* _tmp49_;
			UnityFilterOption* filter_option = NULL;
			_tmp49_ = _g_object_ref0 ((UnityFilterOption*) filter_option_it->data);
			filter_option = _tmp49_;
			{
				gboolean _tmp50_ = FALSE;
				UnityFilterOption* _tmp51_;
				const gchar* _tmp52_;
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				gboolean _tmp55_ = FALSE;
				gboolean _tmp59_;
				_tmp51_ = filter_option;
				_tmp52_ = unity_filter_option_get_id (_tmp51_);
				_tmp53_ = _tmp52_;
				_tmp54_ = prefix;
				_tmp55_ = g_str_has_prefix (_tmp53_, _tmp54_);
				if (_tmp55_) {
					GeeHashSet* _tmp56_;
					UnityFilterOption* _tmp57_;
					gboolean _tmp58_ = FALSE;
					_tmp56_ = touched_filters;
					_tmp57_ = filter_option;
					_tmp58_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp56_, _tmp57_);
					_tmp50_ = !_tmp58_;
				} else {
					_tmp50_ = FALSE;
				}
				_tmp59_ = _tmp50_;
				if (_tmp59_) {
					GeeHashSet* _tmp60_;
					UnityFilterOption* _tmp61_;
					const gchar* _tmp62_;
					const gchar* _tmp63_;
					_tmp60_ = removed_ids;
					_tmp61_ = filter_option;
					_tmp62_ = unity_filter_option_get_id (_tmp61_);
					_tmp63_ = _tmp62_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp60_, _tmp63_);
				}
				_g_object_unref0 (filter_option);
			}
		}
	}
	{
		GeeHashSet* _tmp64_;
		GeeIterator* _tmp65_ = NULL;
		GeeIterator* _id_it;
		_tmp64_ = removed_ids;
		_tmp65_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp64_);
		_id_it = _tmp65_;
		while (TRUE) {
			GeeIterator* _tmp66_;
			gboolean _tmp67_ = FALSE;
			GeeIterator* _tmp68_;
			gpointer _tmp69_ = NULL;
			const gchar* id;
			UnityOptionsFilter* _tmp70_;
			const gchar* _tmp71_;
			_tmp66_ = _id_it;
			_tmp67_ = gee_iterator_next (_tmp66_);
			if (!_tmp67_) {
				break;
			}
			_tmp68_ = _id_it;
			_tmp69_ = gee_iterator_get (_tmp68_);
			id = (const gchar*) _tmp69_;
			_tmp70_ = self->priv->_sources;
			_tmp71_ = id;
			unity_options_filter_remove_option (_tmp70_, _tmp71_);
		}
		_g_object_unref0 (_id_it);
	}
	unity_lens_impl_queue_sources_update (self);
	_g_object_unref0 (removed_ids);
	_g_free0 (prefix);
	_g_object_unref0 (touched_filters);
	_g_object_unref0 (scope);
}


static void unity_lens_impl_on_filter_changed (UnityLensImpl* self, UnityFilter* filter) {
	DeeSharedModel* _tmp0_;
	DeeModelIter* _tmp1_ = NULL;
	DeeModelIter* iter;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filter != NULL);
	_tmp0_ = self->priv->_filters_model;
	_tmp1_ = dee_model_get_first_iter ((DeeModel*) _tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		DeeModelIter* _tmp2_;
		DeeSharedModel* _tmp3_;
		DeeModelIter* _tmp4_ = NULL;
		DeeSharedModel* _tmp5_;
		DeeModelIter* _tmp6_;
		const gchar* _tmp7_ = NULL;
		UnityFilter* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp2_ = iter;
		_tmp3_ = self->priv->_filters_model;
		_tmp4_ = dee_model_get_last_iter ((DeeModel*) _tmp3_);
		if (!(_tmp2_ != _tmp4_)) {
			break;
		}
		_tmp5_ = self->priv->_filters_model;
		_tmp6_ = iter;
		_tmp7_ = dee_model_get_string ((DeeModel*) _tmp5_, _tmp6_, (guint) UNITY_FILTER_COLUMN_ID);
		_tmp8_ = filter;
		_tmp9_ = unity_filter_get_id (_tmp8_);
		_tmp10_ = _tmp9_;
		if (g_strcmp0 (_tmp7_, _tmp10_) == 0) {
			gchar* _tmp11_ = NULL;
			UnityFilter* _tmp12_;
			GIcon* _tmp13_;
			GIcon* _tmp14_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* icon_hint_s;
			DeeSharedModel* _tmp22_;
			DeeModelIter* _tmp23_;
			UnityFilter* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			UnityFilter* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			UnityFilter* _tmp31_;
			UnityFilterRenderer _tmp32_;
			UnityFilterRenderer _tmp33_;
			const gchar* _tmp34_ = NULL;
			UnityFilter* _tmp35_;
			GHashTable* _tmp36_ = NULL;
			GHashTable* _tmp37_;
			GVariant* _tmp38_ = NULL;
			GVariant* _tmp39_;
			UnityFilter* _tmp40_;
			gboolean _tmp41_;
			gboolean _tmp42_;
			UnityFilter* _tmp43_;
			gboolean _tmp44_;
			gboolean _tmp45_;
			UnityFilter* _tmp46_;
			gboolean _tmp47_;
			gboolean _tmp48_;
			_tmp12_ = filter;
			_tmp13_ = unity_filter_get_icon_hint (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ != NULL) {
				UnityFilter* _tmp15_;
				GIcon* _tmp16_;
				GIcon* _tmp17_;
				gchar* _tmp18_ = NULL;
				_tmp15_ = filter;
				_tmp16_ = unity_filter_get_icon_hint (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_icon_to_string (_tmp17_);
				_g_free0 (_tmp11_);
				_tmp11_ = _tmp18_;
			} else {
				gchar* _tmp19_;
				_tmp19_ = g_strdup ("");
				_g_free0 (_tmp11_);
				_tmp11_ = _tmp19_;
			}
			_tmp20_ = _tmp11_;
			_tmp21_ = g_strdup (_tmp20_);
			icon_hint_s = _tmp21_;
			_tmp22_ = self->priv->_filters_model;
			_tmp23_ = iter;
			_tmp24_ = filter;
			_tmp25_ = unity_filter_get_id (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = filter;
			_tmp28_ = unity_filter_get_display_name (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = icon_hint_s;
			_tmp31_ = filter;
			_tmp32_ = unity_filter_get_renderer (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = unity_filter_get_renderer_name (_tmp33_);
			_tmp35_ = filter;
			_tmp36_ = unity_filter_get_hints (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = unity_tools_hash_table_to_asv (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = filter;
			_tmp41_ = unity_filter_get_visible (_tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = filter;
			_tmp44_ = unity_filter_get_collapsed (_tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = filter;
			_tmp47_ = unity_filter_get_filtering (_tmp46_);
			_tmp48_ = _tmp47_;
			dee_model_set ((DeeModel*) _tmp22_, _tmp23_, _tmp26_, _tmp29_, _tmp30_, _tmp34_, _tmp39_, _tmp42_, _tmp45_, _tmp48_, NULL);
			_g_variant_unref0 (_tmp39_);
			_g_hash_table_unref0 (_tmp37_);
			_g_free0 (icon_hint_s);
			_g_free0 (_tmp11_);
			break;
		}
	}
}


static void unity_lens_impl_sources_display_name_changed (UnityLensImpl* self, GObject* obj, GParamSpec* pspec) {
	UnityOptionsFilter* _tmp0_;
	UnityLens* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->_sources;
	_tmp1_ = self->priv->_owner;
	_tmp2_ = unity_lens_get_sources_display_name (_tmp1_);
	_tmp3_ = _tmp2_;
	unity_filter_set_display_name ((UnityFilter*) _tmp0_, _tmp3_);
	unity_lens_impl_queue_sources_update (self);
}


static gboolean ___lambda9_ (UnityLensImpl* self) {
	gboolean result = FALSE;
	DeeSharedModel* _tmp0_;
	DeeModelIter* _tmp1_ = NULL;
	DeeSharedModel* _tmp2_;
	DeeModelIter* _tmp3_ = NULL;
	gboolean empty_model;
	gboolean _tmp4_;
	UnityOptionsFilter* _tmp15_;
	GList* _tmp16_;
	guint _tmp17_ = 0U;
	_tmp0_ = self->priv->_filters_model;
	_tmp1_ = dee_model_get_first_iter ((DeeModel*) _tmp0_);
	_tmp2_ = self->priv->_filters_model;
	_tmp3_ = dee_model_get_last_iter ((DeeModel*) _tmp2_);
	empty_model = _tmp1_ == _tmp3_;
	_tmp4_ = empty_model;
	if (!_tmp4_) {
		DeeSharedModel* _tmp5_;
		DeeModelIter* _tmp6_ = NULL;
		DeeModelIter* iter;
		DeeSharedModel* _tmp7_;
		DeeModelIter* _tmp8_;
		DeeModelIter* _tmp9_ = NULL;
		DeeSharedModel* _tmp10_;
		DeeModelIter* _tmp11_;
		const gchar* _tmp12_ = NULL;
		_tmp5_ = self->priv->_filters_model;
		_tmp6_ = dee_model_get_last_iter ((DeeModel*) _tmp5_);
		iter = _tmp6_;
		_tmp7_ = self->priv->_filters_model;
		_tmp8_ = iter;
		_tmp9_ = dee_model_prev ((DeeModel*) _tmp7_, _tmp8_);
		iter = _tmp9_;
		_tmp10_ = self->priv->_filters_model;
		_tmp11_ = iter;
		_tmp12_ = dee_model_get_string ((DeeModel*) _tmp10_, _tmp11_, (guint) UNITY_FILTER_COLUMN_ID);
		if (g_strcmp0 (_tmp12_, UNITY_LENS_SOURCES_FILTER_ID) == 0) {
			DeeSharedModel* _tmp13_;
			DeeModelIter* _tmp14_;
			_tmp13_ = self->priv->_filters_model;
			_tmp14_ = iter;
			dee_model_remove ((DeeModel*) _tmp13_, _tmp14_);
		}
	}
	_tmp15_ = self->priv->_sources;
	_tmp16_ = _tmp15_->options;
	_tmp17_ = g_list_length (_tmp16_);
	if (_tmp17_ > ((guint) 0)) {
		UnityOptionsFilter* _tmp18_;
		UnityOptionsFilter* _tmp19_;
		UnityOptionsFilter* filter;
		gchar* _tmp20_ = NULL;
		UnityOptionsFilter* _tmp21_;
		GIcon* _tmp22_;
		GIcon* _tmp23_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* icon_hint_s;
		DeeSharedModel* _tmp31_;
		UnityOptionsFilter* _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		UnityOptionsFilter* _tmp35_;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		UnityOptionsFilter* _tmp39_;
		UnityFilterRenderer _tmp40_;
		UnityFilterRenderer _tmp41_;
		const gchar* _tmp42_ = NULL;
		UnityOptionsFilter* _tmp43_;
		GHashTable* _tmp44_ = NULL;
		GHashTable* _tmp45_;
		GVariant* _tmp46_ = NULL;
		GVariant* _tmp47_;
		UnityOptionsFilter* _tmp48_;
		gboolean _tmp49_;
		gboolean _tmp50_;
		UnityOptionsFilter* _tmp51_;
		gboolean _tmp52_;
		gboolean _tmp53_;
		UnityOptionsFilter* _tmp54_;
		gboolean _tmp55_;
		gboolean _tmp56_;
		_tmp18_ = self->priv->_sources;
		_tmp19_ = _g_object_ref0 (_tmp18_);
		filter = _tmp19_;
		_tmp21_ = filter;
		_tmp22_ = unity_filter_get_icon_hint ((UnityFilter*) _tmp21_);
		_tmp23_ = _tmp22_;
		if (_tmp23_ != NULL) {
			UnityOptionsFilter* _tmp24_;
			GIcon* _tmp25_;
			GIcon* _tmp26_;
			gchar* _tmp27_ = NULL;
			_tmp24_ = filter;
			_tmp25_ = unity_filter_get_icon_hint ((UnityFilter*) _tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_icon_to_string (_tmp26_);
			_g_free0 (_tmp20_);
			_tmp20_ = _tmp27_;
		} else {
			gchar* _tmp28_;
			_tmp28_ = g_strdup ("");
			_g_free0 (_tmp20_);
			_tmp20_ = _tmp28_;
		}
		_tmp29_ = _tmp20_;
		_tmp30_ = g_strdup (_tmp29_);
		icon_hint_s = _tmp30_;
		_tmp31_ = self->priv->_filters_model;
		_tmp32_ = filter;
		_tmp33_ = unity_filter_get_id ((UnityFilter*) _tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = filter;
		_tmp36_ = unity_filter_get_display_name ((UnityFilter*) _tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = icon_hint_s;
		_tmp39_ = filter;
		_tmp40_ = unity_filter_get_renderer ((UnityFilter*) _tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = unity_filter_get_renderer_name (_tmp41_);
		_tmp43_ = filter;
		_tmp44_ = unity_filter_get_hints ((UnityFilter*) _tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = unity_tools_hash_table_to_asv (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = filter;
		_tmp49_ = unity_filter_get_visible ((UnityFilter*) _tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = filter;
		_tmp52_ = unity_filter_get_collapsed ((UnityFilter*) _tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = filter;
		_tmp55_ = unity_filter_get_filtering ((UnityFilter*) _tmp54_);
		_tmp56_ = _tmp55_;
		dee_model_append ((DeeModel*) _tmp31_, _tmp34_, _tmp37_, _tmp38_, _tmp42_, _tmp47_, _tmp50_, _tmp53_, _tmp56_, NULL);
		_g_variant_unref0 (_tmp47_);
		_g_hash_table_unref0 (_tmp45_);
		_g_free0 (icon_hint_s);
		_g_free0 (_tmp20_);
		_g_object_unref0 (filter);
	}
	self->priv->_sources_update_id = (guint) 0;
	result = FALSE;
	return result;
}


static gboolean ____lambda9__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda9_ (self);
	return result;
}


static void unity_lens_impl_queue_sources_update (UnityLensImpl* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_sources_update_id;
	if (_tmp0_ == ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda9__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->_sources_update_id = _tmp1_;
	}
}


static void unity_lens_impl_sources_filter_changed (UnityLensImpl* self, DeeModel* model, DeeModelIter* iter) {
	UnityOptionsFilter* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	UnityOptionsFilter* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	UnityOptionsFilter* _tmp6_;
	GIcon* _tmp7_;
	GIcon* _tmp8_;
	UnityOptionsFilter* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	UnityCheckOptionFilter* _tmp12_;
	UnityCheckOptionFilter* temp;
	UnityCheckOptionFilter* _tmp13_;
	DeeModel* _tmp14_;
	DeeModelIter* _tmp15_;
	gboolean _tmp16_ = FALSE;
	DeeModel* _tmp17_;
	DeeModelIter* _tmp18_;
	GVariant* _tmp19_ = NULL;
	GVariant* properties;
	UnityCheckOptionFilter* _tmp20_;
	GVariant* _tmp21_;
	GeeHashSet* _tmp22_;
	GeeHashSet* updated_scopes;
	gboolean force_update;
	UnityCheckOptionFilter* _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	UnityOptionsFilter* _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	UnityCheckOptionFilter* _tmp29_;
	GList* _tmp30_;
	UnityCheckOptionFilter* _tmp55_;
	UnityOptionsFilter* _tmp56_;
	GeeHashSet* _tmp57_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = self->priv->_sources;
	_tmp1_ = unity_filter_get_id ((UnityFilter*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_sources;
	_tmp4_ = unity_filter_get_display_name ((UnityFilter*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_sources;
	_tmp7_ = unity_filter_get_icon_hint ((UnityFilter*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->_sources;
	_tmp10_ = unity_filter_get_collapsed ((UnityFilter*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = unity_check_option_filter_new (_tmp2_, _tmp5_, _tmp8_, _tmp11_);
	temp = _tmp12_;
	_tmp13_ = temp;
	_tmp14_ = model;
	_tmp15_ = iter;
	_tmp16_ = dee_model_get_bool (_tmp14_, _tmp15_, (guint) UNITY_FILTER_COLUMN_FILTERING);
	unity_filter_set_filtering ((UnityFilter*) _tmp13_, _tmp16_);
	_tmp17_ = model;
	_tmp18_ = iter;
	_tmp19_ = dee_model_get_value (_tmp17_, _tmp18_, (guint) UNITY_FILTER_COLUMN_RENDERER_STATE);
	properties = _tmp19_;
	_tmp20_ = temp;
	_tmp21_ = properties;
	unity_filter_update ((UnityFilter*) _tmp20_, _tmp21_);
	_tmp22_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	updated_scopes = _tmp22_;
	force_update = FALSE;
	_tmp23_ = temp;
	_tmp24_ = unity_filter_get_filtering ((UnityFilter*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = self->priv->_sources;
	_tmp27_ = unity_filter_get_filtering ((UnityFilter*) _tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp25_ != _tmp28_) {
		force_update = TRUE;
	}
	_tmp29_ = temp;
	_tmp30_ = ((UnityOptionsFilter*) _tmp29_)->options;
	{
		GList* filter_option_collection = NULL;
		GList* filter_option_it = NULL;
		filter_option_collection = _tmp30_;
		for (filter_option_it = filter_option_collection; filter_option_it != NULL; filter_option_it = filter_option_it->next) {
			UnityFilterOption* _tmp31_;
			UnityFilterOption* filter_option = NULL;
			_tmp31_ = _g_object_ref0 ((UnityFilterOption*) filter_option_it->data);
			filter_option = _tmp31_;
			{
				UnityOptionsFilter* _tmp32_;
				UnityFilterOption* _tmp33_;
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				UnityFilterOption* _tmp36_ = NULL;
				UnityFilterOption* current_value;
				UnityFilterOption* _tmp37_;
				gboolean _tmp38_ = FALSE;
				gboolean _tmp39_;
				gboolean _tmp46_;
				_tmp32_ = self->priv->_sources;
				_tmp33_ = filter_option;
				_tmp34_ = unity_filter_option_get_id (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = unity_options_filter_get_option (_tmp32_, _tmp35_);
				current_value = _tmp36_;
				_tmp37_ = current_value;
				if (_tmp37_ == NULL) {
					_g_object_unref0 (current_value);
					_g_object_unref0 (filter_option);
					continue;
				}
				_tmp39_ = force_update;
				if (_tmp39_) {
					_tmp38_ = TRUE;
				} else {
					UnityFilterOption* _tmp40_;
					gboolean _tmp41_;
					gboolean _tmp42_;
					UnityFilterOption* _tmp43_;
					gboolean _tmp44_;
					gboolean _tmp45_;
					_tmp40_ = current_value;
					_tmp41_ = unity_filter_option_get_active (_tmp40_);
					_tmp42_ = _tmp41_;
					_tmp43_ = filter_option;
					_tmp44_ = unity_filter_option_get_active (_tmp43_);
					_tmp45_ = _tmp44_;
					_tmp38_ = _tmp42_ != _tmp45_;
				}
				_tmp46_ = _tmp38_;
				if (_tmp46_) {
					UnityFilterOption* _tmp47_;
					const gchar* _tmp48_;
					const gchar* _tmp49_;
					gchar** _tmp50_;
					gchar** _tmp51_ = NULL;
					gchar** tokens;
					gint tokens_length1;
					gint _tokens_size_;
					GeeHashSet* _tmp52_;
					gchar** _tmp53_;
					gint _tmp53__length1;
					const gchar* _tmp54_;
					_tmp47_ = filter_option;
					_tmp48_ = unity_filter_option_get_id (_tmp47_);
					_tmp49_ = _tmp48_;
					_tmp51_ = _tmp50_ = g_strsplit (_tmp49_, ":", 2);
					tokens = _tmp51_;
					tokens_length1 = _vala_array_length (_tmp50_);
					_tokens_size_ = tokens_length1;
					_tmp52_ = updated_scopes;
					_tmp53_ = tokens;
					_tmp53__length1 = tokens_length1;
					_tmp54_ = _tmp53_[0];
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp52_, _tmp54_);
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_object_unref0 (current_value);
				_g_object_unref0 (filter_option);
			}
		}
	}
	_tmp55_ = temp;
	_tmp56_ = _g_object_ref0 ((UnityOptionsFilter*) _tmp55_);
	_g_object_unref0 (self->priv->_sources);
	self->priv->_sources = _tmp56_;
	_tmp57_ = updated_scopes;
	unity_lens_impl_update_active_sources (self, (GeeSet*) _tmp57_, NULL, NULL);
	_g_object_unref0 (updated_scopes);
	_g_variant_unref0 (properties);
	_g_object_unref0 (temp);
}


void unity_lens_impl_add_local_scope (UnityLensImpl* self, UnityScope* scope) {
	UnityScopeFactory* _tmp0_;
	UnityScope* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scope != NULL);
	_tmp0_ = self->priv->_scope_factory;
	_tmp1_ = scope;
	unity_scope_factory_add_local_scope (_tmp0_, _tmp1_);
}


UnityOptionsFilter* unity_lens_impl_get_sources (UnityLensImpl* self) {
	UnityOptionsFilter* result = NULL;
	UnityOptionsFilter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sources;
	result = _tmp0_;
	return result;
}


DeeModel* unity_lens_impl_get_model (UnityLensImpl* self, gint index) {
	DeeModel* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = index;
	_tmp1_ = index;
	g_return_val_if_fail ((_tmp0_ >= 0) && (_tmp1_ <= 3), NULL);
	_tmp2_ = index;
	switch (_tmp2_) {
		case 0:
		{
			DeeSharedModel* _tmp3_;
			_tmp3_ = self->priv->_results_model;
			result = (DeeModel*) _tmp3_;
			return result;
		}
		case 1:
		{
			DeeSharedModel* _tmp4_;
			_tmp4_ = self->priv->_global_results_model;
			result = (DeeModel*) _tmp4_;
			return result;
		}
		case 2:
		{
			DeeSharedModel* _tmp5_;
			_tmp5_ = self->priv->_filters_model;
			result = (DeeModel*) _tmp5_;
			return result;
		}
		case 3:
		{
			DeeSharedModel* _tmp6_;
			_tmp6_ = self->priv->_categories_model;
			result = (DeeModel*) _tmp6_;
			return result;
		}
		default:
		break;
	}
	result = NULL;
	return result;
}


static void unity_lens_impl_real_info_request_data_free (gpointer _data) {
	UnityLensImplInfoRequestData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityLensImplInfoRequestData, _data_);
}


static void unity_lens_impl_real_info_request (UnityLensService* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityLensImpl * self;
	UnityLensImplInfoRequestData* _data_;
	UnityLensImpl* _tmp0_;
	self = (UnityLensImpl*) base;
	_data_ = g_slice_new0 (UnityLensImplInfoRequestData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_lens_impl_real_info_request);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_lens_impl_real_info_request_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	unity_lens_impl_real_info_request_co (_data_);
}


static void unity_lens_impl_real_info_request_finish (UnityLensService* base, GAsyncResult* _res_, GError** error) {
	UnityLensImplInfoRequestData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean unity_lens_impl_real_info_request_co (UnityLensImplInfoRequestData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	unity_lens_impl_queue_info_changed (_data_->self);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_lens_impl_real_activate_data_free (gpointer _data) {
	UnityLensImplActivateData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	unity_activation_reply_raw_destroy (&_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityLensImplActivateData, _data_);
}


static void unity_lens_impl_real_activate (UnityLensService* base, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityLensImpl * self;
	UnityLensImplActivateData* _data_;
	UnityLensImpl* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	guint _tmp3_;
	self = (UnityLensImpl*) base;
	_data_ = g_slice_new0 (UnityLensImplActivateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_lens_impl_real_activate);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_lens_impl_real_activate_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = uri;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->uri = _tmp2_;
	_tmp3_ = action_type;
	_data_->action_type = _tmp3_;
	unity_lens_impl_real_activate_co (_data_);
}


static void unity_lens_impl_real_activate_finish (UnityLensService* base, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error) {
	UnityLensImplActivateData* _data_;
	UnityActivationReplyRaw _tmp0_ = {0};
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	unity_activation_reply_raw_copy (&_data_->result, &_tmp0_);
	*result = _tmp0_;
}


static void unity_lens_impl_activate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityLensImplActivateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_lens_impl_real_activate_co (_data_);
}


static gboolean unity_lens_impl_real_activate_co (UnityLensImplActivateData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->uri;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_ = g_strsplit (_data_->_tmp0_, ":", 2);
	_data_->tokens = _data_->_tmp2_;
	_data_->tokens_length1 = _vala_array_length (_data_->_tmp1_);
	_data_->_tokens_size_ = _data_->tokens_length1;
	_data_->_tmp3_ = _data_->tokens;
	_data_->_tmp3__length1 = _data_->tokens_length1;
	_data_->_tmp4_ = _data_->_tmp3_[0];
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = unity_lens_impl_get_scope_for_uid (_data_->self, _data_->_tmp4_);
	_data_->scope = _data_->_tmp5_;
	memset (&_data_->raw, 0, sizeof (UnityActivationReplyRaw));
	_data_->raw.handled = (guint) UNITY_HANDLED_TYPE_NOT_HANDLED;
	_data_->_tmp6_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
	_g_hash_table_unref0 (_data_->raw.hints);
	_data_->raw.hints = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->scope;
	if (UNITY_IS_SCOPE_PROXY (_data_->_tmp7_)) {
		_data_->_tmp8_ = _data_->scope;
		_data_->_tmp9_ = _data_->tokens;
		_data_->_tmp9__length1 = _data_->tokens_length1;
		_data_->_tmp10_ = _data_->_tmp9_[1];
		_data_->_tmp11_ = _data_->action_type;
		memset (&_data_->_tmp12_, 0, sizeof (UnityActivationReplyRaw));
		_data_->_state_ = 1;
		unity_scope_proxy_activate (_data_->_tmp8_, _data_->_tmp10_, _data_->_tmp11_, unity_lens_impl_activate_ready, _data_);
		return FALSE;
		_state_1:
		unity_scope_proxy_activate_finish (_data_->_tmp8_, _data_->_res_, &_data_->_tmp12_);
		unity_activation_reply_raw_destroy (&_data_->raw);
		_data_->raw = _data_->_tmp12_;
	}
	_data_->_tmp13_ = _data_->uri;
	_data_->_tmp14_ = g_strdup (_data_->_tmp13_);
	_g_free0 (_data_->raw.uri);
	_data_->raw.uri = _data_->_tmp14_;
	_data_->result = _data_->raw;
	_g_object_unref0 (_data_->scope);
	_data_->tokens = (_vala_array_free (_data_->tokens, _data_->tokens_length1, (GDestroyNotify) g_free), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	unity_activation_reply_raw_destroy (&_data_->raw);
	_g_object_unref0 (_data_->scope);
	_data_->tokens = (_vala_array_free (_data_->tokens, _data_->tokens_length1, (GDestroyNotify) g_free), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_lens_impl_real_search_data_free (gpointer _data) {
	UnityLensImplSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search_string);
	_g_hash_table_unref0 (_data_->hints);
	_g_hash_table_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityLensImplSearchData, _data_);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void unity_lens_impl_real_search (UnityLensService* base, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityLensImpl * self;
	UnityLensImplSearchData* _data_;
	UnityLensImpl* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	self = (UnityLensImpl*) base;
	_data_ = g_slice_new0 (UnityLensImplSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_lens_impl_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_lens_impl_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = search_string;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->search_string = _tmp2_;
	_tmp3_ = hints;
	_tmp4_ = _g_hash_table_ref0 (_tmp3_);
	_data_->hints = _tmp4_;
	unity_lens_impl_real_search_co (_data_);
}


static GHashTable* unity_lens_impl_real_search_finish (UnityLensService* base, GAsyncResult* _res_, GError** error) {
	GHashTable* result;
	UnityLensImplSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_hash_table_unref0 (_data2_->_result_);
		g_slice_free (Block2Data, _data2_);
	}
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		block3_data_unref (_data4_->_data3_);
		_data4_->_data3_ = NULL;
		g_slice_free (Block4Data, _data4_);
	}
}


static void _____lambda13_ (Block4Data* _data4_, DeeSharedModel* m, guint64 begin_seqnum, guint64 end_seqnum) {
	Block3Data* _data3_;
	Block2Data* _data2_;
	UnityLensImpl * self;
	guint64 _tmp0_;
	guint64 _tmp1_;
	DeeSharedModel* _tmp2_;
	gulong _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	_data3_ = _data4_->_data3_;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	g_return_if_fail (m != NULL);
	_tmp0_ = end_seqnum;
	_tmp1_ = _data3_->seqnum;
	if (_tmp0_ < _tmp1_) {
		return;
	}
	_tmp2_ = m;
	_tmp3_ = _data4_->update_sig_id;
	g_signal_handler_disconnect (_tmp2_, _tmp3_);
	_tmp4_ = _data2_->num_scopes;
	_data2_->num_scopes = _tmp4_ - 1;
	_tmp5_ = _data2_->num_scopes;
	if (_tmp5_ == 0) {
		unity_lens_impl_real_search_co (_data2_->_async_data_);
	}
}


static void ______lambda13__dee_shared_model_end_transaction (DeeSharedModel* _sender, guint64 begin_seqnum, guint64 end_seqnum, gpointer self) {
	_____lambda13_ (self, _sender, begin_seqnum, end_seqnum);
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static void __lambda12_ (Block2Data* _data2_, GObject* obj, GAsyncResult* res) {
	UnityLensImpl * self;
	GObject* _tmp0_;
	UnityScopeProxy* _tmp1_;
	UnityScopeProxy* scope;
	UnityScopeProxy* _tmp2_;
	GAsyncResult* _tmp3_;
	GHashTable* _tmp4_ = NULL;
	GHashTable* results;
	GHashTableIter iter = {0};
	GHashTable* _tmp5_;
	GHashTableIter _tmp6_ = {0};
	const gchar* key = NULL;
	GVariant* variant = NULL;
	gboolean models_updated;
	gboolean _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	self = _data2_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = obj;
	_tmp1_ = _g_object_ref0 (UNITY_IS_SCOPE_PROXY (_tmp0_) ? ((UnityScopeProxy*) _tmp0_) : NULL);
	scope = _tmp1_;
	_tmp2_ = scope;
	_tmp3_ = res;
	_tmp4_ = unity_scope_proxy_search_finish (_tmp2_, _tmp3_);
	results = _tmp4_;
	_tmp5_ = results;
	g_hash_table_iter_init (&_tmp6_, _tmp5_);
	iter = _tmp6_;
	models_updated = TRUE;
	while (TRUE) {
		gconstpointer _tmp7_ = NULL;
		gconstpointer _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_;
		_tmp9_ = g_hash_table_iter_next (&iter, &_tmp7_, &_tmp8_);
		key = _tmp7_;
		variant = _tmp8_;
		if (!_tmp9_) {
			break;
		}
		_tmp10_ = key;
		if (g_strcmp0 (_tmp10_, "model-seqnum") == 0) {
			Block3Data* _data3_;
			GVariant* _tmp11_;
			guint64 _tmp12_ = 0ULL;
			UnityScopeProxy* _tmp13_;
			DeeSerializableModel* _tmp14_;
			DeeSerializableModel* _tmp15_;
			DeeSerializableModel* model;
			DeeSerializableModel* _tmp16_;
			guint64 _tmp17_ = 0ULL;
			guint64 _tmp18_;
			_data3_ = g_slice_new0 (Block3Data);
			_data3_->_ref_count_ = 1;
			_data3_->_data2_ = block2_data_ref (_data2_);
			_tmp11_ = variant;
			_tmp12_ = g_variant_get_uint64 (_tmp11_);
			_data3_->seqnum = _tmp12_;
			_tmp13_ = scope;
			_tmp14_ = unity_scope_proxy_get_results_model (_tmp13_);
			_tmp15_ = _tmp14_;
			model = _tmp15_;
			_tmp16_ = model;
			_tmp17_ = dee_serializable_model_get_seqnum (_tmp16_);
			_tmp18_ = _data3_->seqnum;
			if (_tmp17_ < _tmp18_) {
				Block4Data* _data4_;
				DeeSerializableModel* _tmp19_;
				gulong _tmp20_ = 0UL;
				gulong _tmp21_;
				_data4_ = g_slice_new0 (Block4Data);
				_data4_->_ref_count_ = 1;
				_data4_->_data3_ = block3_data_ref (_data3_);
				_data4_->update_sig_id = (gulong) 0;
				_tmp19_ = model;
				_tmp20_ = g_signal_connect_data (DEE_IS_SHARED_MODEL (_tmp19_) ? ((DeeSharedModel*) _tmp19_) : NULL, "end-transaction", (GCallback) ______lambda13__dee_shared_model_end_transaction, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
				_data4_->update_sig_id = _tmp20_;
				_tmp21_ = _data4_->update_sig_id;
				models_updated = _tmp21_ == ((gulong) 0);
				block4_data_unref (_data4_);
				_data4_ = NULL;
			}
			block3_data_unref (_data3_);
			_data3_ = NULL;
		} else {
			GHashTable* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			GVariant* _tmp25_;
			GVariant* _tmp26_;
			_tmp22_ = _data2_->_result_;
			_tmp23_ = key;
			_tmp24_ = g_strdup (_tmp23_);
			_tmp25_ = variant;
			_tmp26_ = _g_variant_ref0 (_tmp25_);
			g_hash_table_insert (_tmp22_, _tmp24_, _tmp26_);
		}
	}
	_tmp27_ = models_updated;
	if (!_tmp27_) {
		_g_hash_table_unref0 (results);
		_g_object_unref0 (scope);
		return;
	}
	_tmp28_ = _data2_->num_scopes;
	_data2_->num_scopes = _tmp28_ - 1;
	_tmp29_ = _data2_->num_scopes;
	if (_tmp29_ == 0) {
		unity_lens_impl_real_search_co (_data2_->_async_data_);
	}
	_g_hash_table_unref0 (results);
	_g_object_unref0 (scope);
}


static void ___lambda12__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda12_ (self, source_object, res);
}


static gboolean unity_lens_impl_real_search_co (UnityLensImplSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = g_object_ref (_data_->self);
	_data_->_data2_->_async_data_ = _data_;
	_data_->_tmp0_ = g_str_hash;
	_data_->_tmp1_ = g_str_equal;
	_data_->_tmp2_ = g_hash_table_new_full (_data_->_tmp0_, _data_->_tmp1_, _g_free0_, _g_variant_unref0_);
	_data_->_data2_->_result_ = _data_->_tmp2_;
	_data_->_data2_->num_scopes = 0;
	_data_->cb = ___lambda12__gasync_ready_callback;
	_data_->cb_target = block2_data_ref (_data_->_data2_);
	_data_->cb_target_destroy_notify = block2_data_unref;
	{
		_data_->_tmp3_ = _data_->self->priv->_scope_factory;
		_data_->_tmp4_ = _data_->_tmp3_->scopes;
		_data_->_tmp5_ = _g_object_ref0 (_data_->_tmp4_);
		_data_->_scope_list = _data_->_tmp5_;
		_data_->_tmp6_ = _data_->_scope_list;
		_data_->_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp6_);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_scope_size = _data_->_tmp8_;
		_data_->_scope_index = -1;
		while (TRUE) {
			_data_->_tmp9_ = _data_->_scope_index;
			_data_->_scope_index = _data_->_tmp9_ + 1;
			_data_->_tmp10_ = _data_->_scope_index;
			_data_->_tmp11_ = _data_->_scope_size;
			if (!(_data_->_tmp10_ < _data_->_tmp11_)) {
				break;
			}
			_data_->_tmp12_ = _data_->_scope_list;
			_data_->_tmp13_ = _data_->_scope_index;
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp12_, _data_->_tmp13_);
			_data_->scope = (UnityScopeProxy*) _data_->_tmp14_;
			_data_->_tmp15_ = _data_->_data2_->num_scopes;
			_data_->_data2_->num_scopes = _data_->_tmp15_ + 1;
			_data_->_tmp16_ = _data_->scope;
			_data_->_tmp17_ = _data_->search_string;
			_data_->_tmp18_ = _data_->hints;
			_data_->_tmp19_ = _data_->cb;
			_data_->_tmp19__target = _data_->cb_target;
			unity_scope_proxy_search (_data_->_tmp16_, _data_->_tmp17_, _data_->_tmp18_, _data_->_tmp19_, _data_->_tmp19__target);
			_g_object_unref0 (_data_->scope);
		}
		_g_object_unref0 (_data_->_scope_list);
	}
	_data_->_tmp20_ = _data_->_data2_->num_scopes;
	if (_data_->_tmp20_ > 0) {
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
	}
	_data_->_tmp21_ = _data_->_data2_->_result_;
	_data_->_tmp22_ = g_strdup ("model-seqnum");
	_data_->_tmp23_ = _data_->self->priv->_results_model;
	_data_->_tmp24_ = 0ULL;
	_data_->_tmp24_ = dee_serializable_model_get_seqnum ((DeeSerializableModel*) _data_->_tmp23_);
	_data_->_tmp25_ = g_variant_new_uint64 (_data_->_tmp24_);
	_data_->_tmp26_ = g_variant_ref_sink (_data_->_tmp25_);
	g_hash_table_insert (_data_->_tmp21_, _data_->_tmp22_, _data_->_tmp26_);
	_data_->_tmp27_ = _data_->_data2_->_result_;
	_data_->_tmp28_ = _g_hash_table_ref0 (_data_->_tmp27_);
	_data_->result = _data_->_tmp28_;
	(_data_->cb_target_destroy_notify == NULL) ? NULL : (_data_->cb_target_destroy_notify (_data_->cb_target), NULL);
	_data_->cb = NULL;
	_data_->cb_target = NULL;
	_data_->cb_target_destroy_notify = NULL;
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	(_data_->cb_target_destroy_notify == NULL) ? NULL : (_data_->cb_target_destroy_notify (_data_->cb_target), NULL);
	_data_->cb = NULL;
	_data_->cb_target = NULL;
	_data_->cb_target_destroy_notify = NULL;
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_lens_impl_real_global_search_data_free (gpointer _data) {
	UnityLensImplGlobalSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search_string);
	_g_hash_table_unref0 (_data_->hints);
	_g_hash_table_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityLensImplGlobalSearchData, _data_);
}


static void unity_lens_impl_real_global_search (UnityLensService* base, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityLensImpl * self;
	UnityLensImplGlobalSearchData* _data_;
	UnityLensImpl* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	self = (UnityLensImpl*) base;
	_data_ = g_slice_new0 (UnityLensImplGlobalSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_lens_impl_real_global_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_lens_impl_real_global_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = search_string;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->search_string = _tmp2_;
	_tmp3_ = hints;
	_tmp4_ = _g_hash_table_ref0 (_tmp3_);
	_data_->hints = _tmp4_;
	unity_lens_impl_real_global_search_co (_data_);
}


static GHashTable* unity_lens_impl_real_global_search_finish (UnityLensService* base, GAsyncResult* _res_, GError** error) {
	GHashTable* result;
	UnityLensImplGlobalSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_object_unref0 (_data5_->self);
		g_slice_free (Block5Data, _data5_);
	}
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		block5_data_unref (_data6_->_data5_);
		_data6_->_data5_ = NULL;
		g_slice_free (Block6Data, _data6_);
	}
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (Block7Data* _data7_) {
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		block6_data_unref (_data7_->_data6_);
		_data7_->_data6_ = NULL;
		g_slice_free (Block7Data, _data7_);
	}
}


static void ____lambda15_ (Block7Data* _data7_, DeeSharedModel* m, guint64 begin_seqnum, guint64 end_seqnum) {
	Block6Data* _data6_;
	Block5Data* _data5_;
	UnityLensImpl * self;
	guint64 _tmp0_;
	guint64 _tmp1_;
	DeeSharedModel* _tmp2_;
	gulong _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	_data6_ = _data7_->_data6_;
	_data5_ = _data6_->_data5_;
	self = _data5_->self;
	g_return_if_fail (m != NULL);
	_tmp0_ = end_seqnum;
	_tmp1_ = _data6_->seqnum;
	if (_tmp0_ < _tmp1_) {
		return;
	}
	_tmp2_ = m;
	_tmp3_ = _data7_->update_sig_id;
	g_signal_handler_disconnect (_tmp2_, _tmp3_);
	_tmp4_ = _data5_->num_scopes;
	_data5_->num_scopes = _tmp4_ - 1;
	_tmp5_ = _data5_->num_scopes;
	if (_tmp5_ == 0) {
		unity_lens_impl_real_global_search_co (_data5_->_async_data_);
	}
}


static void _____lambda15__dee_shared_model_end_transaction (DeeSharedModel* _sender, guint64 begin_seqnum, guint64 end_seqnum, gpointer self) {
	____lambda15_ (self, _sender, begin_seqnum, end_seqnum);
}


static void __lambda14_ (Block5Data* _data5_, GObject* obj, GAsyncResult* _result_) {
	UnityLensImpl * self;
	GObject* _tmp0_;
	UnityScopeProxy* _tmp1_;
	UnityScopeProxy* scope;
	UnityScopeProxy* _tmp2_;
	GAsyncResult* _tmp3_;
	GHashTable* _tmp4_ = NULL;
	GHashTable* results;
	gboolean models_updated;
	GHashTable* _tmp5_;
	gconstpointer _tmp6_ = NULL;
	GVariant* seqnum_v;
	GVariant* _tmp7_;
	gboolean _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	self = _data5_->self;
	g_return_if_fail (_result_ != NULL);
	_tmp0_ = obj;
	_tmp1_ = _g_object_ref0 (UNITY_IS_SCOPE_PROXY (_tmp0_) ? ((UnityScopeProxy*) _tmp0_) : NULL);
	scope = _tmp1_;
	_tmp2_ = scope;
	_tmp3_ = _result_;
	_tmp4_ = unity_scope_proxy_global_search_finish (_tmp2_, _tmp3_);
	results = _tmp4_;
	models_updated = TRUE;
	_tmp5_ = results;
	_tmp6_ = g_hash_table_lookup (_tmp5_, "model-seqnum");
	seqnum_v = (GVariant*) _tmp6_;
	_tmp7_ = seqnum_v;
	if (_tmp7_ != NULL) {
		Block6Data* _data6_;
		GVariant* _tmp8_;
		guint64 _tmp9_ = 0ULL;
		UnityScopeProxy* _tmp10_;
		DeeSerializableModel* _tmp11_;
		DeeSerializableModel* _tmp12_;
		DeeSerializableModel* model;
		DeeSerializableModel* _tmp13_;
		guint64 _tmp14_ = 0ULL;
		guint64 _tmp15_;
		_data6_ = g_slice_new0 (Block6Data);
		_data6_->_ref_count_ = 1;
		_data6_->_data5_ = block5_data_ref (_data5_);
		_tmp8_ = seqnum_v;
		_tmp9_ = g_variant_get_uint64 (_tmp8_);
		_data6_->seqnum = _tmp9_;
		_tmp10_ = scope;
		_tmp11_ = unity_scope_proxy_get_global_results_model (_tmp10_);
		_tmp12_ = _tmp11_;
		model = _tmp12_;
		_tmp13_ = model;
		_tmp14_ = dee_serializable_model_get_seqnum (_tmp13_);
		_tmp15_ = _data6_->seqnum;
		if (_tmp14_ < _tmp15_) {
			Block7Data* _data7_;
			DeeSerializableModel* _tmp16_;
			gulong _tmp17_ = 0UL;
			gulong _tmp18_;
			_data7_ = g_slice_new0 (Block7Data);
			_data7_->_ref_count_ = 1;
			_data7_->_data6_ = block6_data_ref (_data6_);
			_data7_->update_sig_id = (gulong) 0;
			_tmp16_ = model;
			_tmp17_ = g_signal_connect_data (DEE_IS_SHARED_MODEL (_tmp16_) ? ((DeeSharedModel*) _tmp16_) : NULL, "end-transaction", (GCallback) _____lambda15__dee_shared_model_end_transaction, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
			_data7_->update_sig_id = _tmp17_;
			_tmp18_ = _data7_->update_sig_id;
			models_updated = _tmp18_ == ((gulong) 0);
			block7_data_unref (_data7_);
			_data7_ = NULL;
		}
		block6_data_unref (_data6_);
		_data6_ = NULL;
	}
	_tmp19_ = models_updated;
	if (!_tmp19_) {
		_g_hash_table_unref0 (results);
		_g_object_unref0 (scope);
		return;
	}
	_tmp20_ = _data5_->num_scopes;
	_data5_->num_scopes = _tmp20_ - 1;
	_tmp21_ = _data5_->num_scopes;
	if (_tmp21_ == 0) {
		unity_lens_impl_real_global_search_co (_data5_->_async_data_);
	}
	_g_hash_table_unref0 (results);
	_g_object_unref0 (scope);
}


static void ___lambda14__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda14_ (self, source_object, res);
}


static gboolean unity_lens_impl_real_global_search_co (UnityLensImplGlobalSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data5_ = g_slice_new0 (Block5Data);
	_data_->_data5_->_ref_count_ = 1;
	_data_->_data5_->self = g_object_ref (_data_->self);
	_data_->_data5_->_async_data_ = _data_;
	_data_->_data5_->num_scopes = 0;
	_data_->cb = ___lambda14__gasync_ready_callback;
	_data_->cb_target = block5_data_ref (_data_->_data5_);
	_data_->cb_target_destroy_notify = block5_data_unref;
	{
		_data_->_tmp0_ = _data_->self->priv->_scope_factory;
		_data_->_tmp1_ = _data_->_tmp0_->scopes;
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
		_data_->_scope_list = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->_scope_list;
		_data_->_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_scope_size = _data_->_tmp5_;
		_data_->_scope_index = -1;
		while (TRUE) {
			_data_->_tmp6_ = _data_->_scope_index;
			_data_->_scope_index = _data_->_tmp6_ + 1;
			_data_->_tmp7_ = _data_->_scope_index;
			_data_->_tmp8_ = _data_->_scope_size;
			if (!(_data_->_tmp7_ < _data_->_tmp8_)) {
				break;
			}
			_data_->_tmp9_ = _data_->_scope_list;
			_data_->_tmp10_ = _data_->_scope_index;
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp9_, _data_->_tmp10_);
			_data_->scope = (UnityScopeProxy*) _data_->_tmp11_;
			_data_->_tmp12_ = _data_->scope;
			_data_->_tmp13_ = unity_scope_proxy_get_search_in_global (_data_->_tmp12_);
			_data_->_tmp14_ = _data_->_tmp13_;
			if (_data_->_tmp14_) {
				_data_->_tmp15_ = _data_->_data5_->num_scopes;
				_data_->_data5_->num_scopes = _data_->_tmp15_ + 1;
				_data_->_tmp16_ = _data_->scope;
				_data_->_tmp17_ = _data_->search_string;
				_data_->_tmp18_ = _data_->hints;
				_data_->_tmp19_ = _data_->cb;
				_data_->_tmp19__target = _data_->cb_target;
				unity_scope_proxy_global_search (_data_->_tmp16_, _data_->_tmp17_, _data_->_tmp18_, _data_->_tmp19_, _data_->_tmp19__target);
			}
			_g_object_unref0 (_data_->scope);
		}
		_g_object_unref0 (_data_->_scope_list);
	}
	_data_->_tmp20_ = _data_->_data5_->num_scopes;
	if (_data_->_tmp20_ > 0) {
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
	}
	_data_->_tmp21_ = g_str_hash;
	_data_->_tmp22_ = g_str_equal;
	_data_->_tmp23_ = g_hash_table_new_full (_data_->_tmp21_, _data_->_tmp22_, _g_free0_, _g_variant_unref0_);
	_data_->_result_ = _data_->_tmp23_;
	_data_->_tmp24_ = g_strdup ("model-seqnum");
	_data_->_tmp25_ = _data_->self->priv->_global_results_model;
	_data_->_tmp26_ = 0ULL;
	_data_->_tmp26_ = dee_serializable_model_get_seqnum ((DeeSerializableModel*) _data_->_tmp25_);
	_data_->_tmp27_ = g_variant_new_uint64 (_data_->_tmp26_);
	_data_->_tmp28_ = g_variant_ref_sink (_data_->_tmp27_);
	g_hash_table_insert (_data_->_result_, _data_->_tmp24_, _data_->_tmp28_);
	_data_->result = _data_->_result_;
	(_data_->cb_target_destroy_notify == NULL) ? NULL : (_data_->cb_target_destroy_notify (_data_->cb_target), NULL);
	_data_->cb = NULL;
	_data_->cb_target = NULL;
	_data_->cb_target_destroy_notify = NULL;
	block5_data_unref (_data_->_data5_);
	_data_->_data5_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_hash_table_unref0 (_data_->_result_);
	(_data_->cb_target_destroy_notify == NULL) ? NULL : (_data_->cb_target_destroy_notify (_data_->cb_target), NULL);
	_data_->cb = NULL;
	_data_->cb_target = NULL;
	_data_->cb_target_destroy_notify = NULL;
	block5_data_unref (_data_->_data5_);
	_data_->_data5_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_lens_impl_real_preview_data_free (gpointer _data) {
	UnityLensImplPreviewData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	unity_preview_reply_raw_destroy (&_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityLensImplPreviewData, _data_);
}


static void unity_lens_impl_real_preview (UnityLensService* base, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityLensImpl * self;
	UnityLensImplPreviewData* _data_;
	UnityLensImpl* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	self = (UnityLensImpl*) base;
	_data_ = g_slice_new0 (UnityLensImplPreviewData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_lens_impl_real_preview);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_lens_impl_real_preview_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = uri;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->uri = _tmp2_;
	unity_lens_impl_real_preview_co (_data_);
}


static void unity_lens_impl_real_preview_finish (UnityLensService* base, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error) {
	UnityLensImplPreviewData* _data_;
	UnityPreviewReplyRaw _tmp0_ = {0};
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	unity_preview_reply_raw_copy (&_data_->result, &_tmp0_);
	*result = _tmp0_;
}


static void unity_lens_impl_preview_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityLensImplPreviewData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_lens_impl_real_preview_co (_data_);
}


static gboolean unity_lens_impl_real_preview_co (UnityLensImplPreviewData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->uri;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_ = g_strsplit (_data_->_tmp0_, ":", 2);
	_data_->tokens = _data_->_tmp2_;
	_data_->tokens_length1 = _vala_array_length (_data_->_tmp1_);
	_data_->_tokens_size_ = _data_->tokens_length1;
	_data_->_tmp3_ = _data_->tokens;
	_data_->_tmp3__length1 = _data_->tokens_length1;
	_data_->_tmp4_ = _data_->_tmp3_[0];
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = unity_lens_impl_get_scope_for_uid (_data_->self, _data_->_tmp4_);
	_data_->scope = _data_->_tmp5_;
	memset (&_data_->raw, 0, sizeof (UnityPreviewReplyRaw));
	_data_->_tmp6_ = g_strdup ("preview-none");
	_g_free0 (_data_->raw.renderer_name);
	_data_->raw.renderer_name = _data_->_tmp6_;
	_data_->_tmp7_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
	_g_hash_table_unref0 (_data_->raw.properties);
	_data_->raw.properties = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->scope;
	if (UNITY_IS_SCOPE_PROXY (_data_->_tmp8_)) {
		_data_->_tmp9_ = _data_->scope;
		_data_->_tmp10_ = _data_->tokens;
		_data_->_tmp10__length1 = _data_->tokens_length1;
		_data_->_tmp11_ = _data_->_tmp10_[1];
		memset (&_data_->_tmp12_, 0, sizeof (UnityPreviewReplyRaw));
		_data_->_state_ = 1;
		unity_scope_proxy_preview (_data_->_tmp9_, _data_->_tmp11_, unity_lens_impl_preview_ready, _data_);
		return FALSE;
		_state_1:
		unity_scope_proxy_preview_finish (_data_->_tmp9_, _data_->_res_, &_data_->_tmp12_);
		unity_preview_reply_raw_destroy (&_data_->raw);
		_data_->raw = _data_->_tmp12_;
	}
	_data_->_tmp13_ = _data_->uri;
	_data_->_tmp14_ = g_strdup (_data_->_tmp13_);
	_g_free0 (_data_->raw.uri);
	_data_->raw.uri = _data_->_tmp14_;
	_data_->result = _data_->raw;
	_g_object_unref0 (_data_->scope);
	_data_->tokens = (_vala_array_free (_data_->tokens, _data_->tokens_length1, (GDestroyNotify) g_free), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	unity_preview_reply_raw_destroy (&_data_->raw);
	_g_object_unref0 (_data_->scope);
	_data_->tokens = (_vala_array_free (_data_->tokens, _data_->tokens_length1, (GDestroyNotify) g_free), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_lens_impl_real_update_filter_data_free (gpointer _data) {
	UnityLensImplUpdateFilterData* _data_;
	_data_ = _data;
	_g_free0 (_data_->filter_name);
	_g_hash_table_unref0 (_data_->properties);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityLensImplUpdateFilterData, _data_);
}


static void unity_lens_impl_real_update_filter (UnityLensService* base, const gchar* filter_name, GHashTable* properties, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityLensImpl * self;
	UnityLensImplUpdateFilterData* _data_;
	UnityLensImpl* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	self = (UnityLensImpl*) base;
	_data_ = g_slice_new0 (UnityLensImplUpdateFilterData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_lens_impl_real_update_filter);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_lens_impl_real_update_filter_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = filter_name;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->filter_name = _tmp2_;
	_tmp3_ = properties;
	_tmp4_ = _g_hash_table_ref0 (_tmp3_);
	_data_->properties = _tmp4_;
	unity_lens_impl_real_update_filter_co (_data_);
}


static void unity_lens_impl_real_update_filter_finish (UnityLensService* base, GAsyncResult* _res_, GError** error) {
	UnityLensImplUpdateFilterData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean unity_lens_impl_real_update_filter_co (UnityLensImplUpdateFilterData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->filter_name;
	unity_trace_log_object ((GObject*) _data_->self, "Update file '%s'", _data_->_tmp0_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_lens_impl_update_active_sources_data_free (gpointer _data) {
	UnityLensImplUpdateActiveSourcesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->updated_scope_uids);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityLensImplUpdateActiveSourcesData, _data_);
}


void unity_lens_impl_update_active_sources (UnityLensImpl* self, GeeSet* updated_scope_uids, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityLensImplUpdateActiveSourcesData* _data_;
	UnityLensImpl* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	_data_ = g_slice_new0 (UnityLensImplUpdateActiveSourcesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_lens_impl_update_active_sources);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_lens_impl_update_active_sources_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = updated_scope_uids;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->updated_scope_uids = _tmp2_;
	unity_lens_impl_update_active_sources_co (_data_);
}


void unity_lens_impl_update_active_sources_finish (UnityLensImpl* self, GAsyncResult* _res_) {
	UnityLensImplUpdateActiveSourcesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean unity_lens_impl_update_active_sources_co (UnityLensImplUpdateActiveSourcesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->updated_scope_uids;
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp0_);
		_data_->_scope_uid_it = _data_->_tmp1_;
		while (TRUE) {
			_data_->_tmp2_ = _data_->_scope_uid_it;
			_data_->_tmp3_ = FALSE;
			_data_->_tmp3_ = gee_iterator_next (_data_->_tmp2_);
			if (!_data_->_tmp3_) {
				break;
			}
			_data_->_tmp4_ = _data_->_scope_uid_it;
			_data_->_tmp5_ = NULL;
			_data_->_tmp5_ = gee_iterator_get (_data_->_tmp4_);
			_data_->scope_uid = (gchar*) _data_->_tmp5_;
			_data_->_tmp6_ = _data_->scope_uid;
			_data_->_tmp7_ = NULL;
			_data_->_tmp7_ = unity_lens_impl_get_scope_for_uid (_data_->self, _data_->_tmp6_);
			_data_->scope = _data_->_tmp7_;
			_data_->_tmp8_ = _data_->scope;
			if (_data_->_tmp8_ == NULL) {
				_g_object_unref0 (_data_->scope);
				_g_free0 (_data_->scope_uid);
				continue;
			}
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = g_new0 (gchar*, 0 + 1);
			_data_->active_sources = _data_->_tmp9_;
			_data_->active_sources_length1 = 0;
			_data_->_active_sources_size_ = _data_->active_sources_length1;
			_data_->_tmp10_ = _data_->self->priv->_sources;
			_data_->_tmp11_ = _data_->_tmp10_->options;
			{
				_data_->filter_option_collection = _data_->_tmp11_;
				_data_->filter_option_it = NULL;
				for (_data_->filter_option_it = _data_->filter_option_collection; _data_->filter_option_it != NULL; _data_->filter_option_it = _data_->filter_option_it->next) {
					_data_->_tmp12_ = _g_object_ref0 ((UnityFilterOption*) _data_->filter_option_it->data);
					_data_->filter_option = _data_->_tmp12_;
					{
						_data_->_tmp14_ = _data_->filter_option;
						_data_->_tmp15_ = unity_filter_option_get_id (_data_->_tmp14_);
						_data_->_tmp16_ = _data_->_tmp15_;
						_data_->_tmp17_ = _data_->scope_uid;
						_data_->_tmp18_ = FALSE;
						_data_->_tmp18_ = g_str_has_prefix (_data_->_tmp16_, _data_->_tmp17_);
						if (_data_->_tmp18_) {
							_data_->_tmp19_ = _data_->filter_option;
							_data_->_tmp20_ = unity_filter_option_get_active (_data_->_tmp19_);
							_data_->_tmp21_ = _data_->_tmp20_;
							_data_->_tmp13_ = _data_->_tmp21_;
						} else {
							_data_->_tmp13_ = FALSE;
						}
						_data_->_tmp22_ = _data_->_tmp13_;
						if (_data_->_tmp22_) {
							_data_->_tmp23_ = _data_->active_sources;
							_data_->_tmp23__length1 = _data_->active_sources_length1;
							_data_->_tmp24_ = _data_->filter_option;
							_data_->_tmp25_ = unity_filter_option_get_id (_data_->_tmp24_);
							_data_->_tmp26_ = _data_->_tmp25_;
							_data_->_tmp27_ = _data_->scope_uid;
							_data_->_tmp28_ = strlen (_data_->_tmp27_);
							_data_->_tmp29_ = _data_->_tmp28_;
							_data_->_tmp30_ = NULL;
							_data_->_tmp30_ = string_substring (_data_->_tmp26_, (glong) (_data_->_tmp29_ + 1), (glong) (-1));
							_vala_array_add3 (&_data_->active_sources, &_data_->active_sources_length1, &_data_->_active_sources_size_, _data_->_tmp30_);
						}
						_g_object_unref0 (_data_->filter_option);
					}
				}
			}
			_data_->_tmp31_ = _data_->scope;
			_data_->_tmp32_ = _data_->active_sources;
			_data_->_tmp32__length1 = _data_->active_sources_length1;
			unity_scope_proxy_set_active_sources (_data_->_tmp31_, _data_->_tmp32_, _data_->_tmp32__length1, NULL, NULL);
			_data_->active_sources = (_vala_array_free (_data_->active_sources, _data_->active_sources_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->scope);
			_g_free0 (_data_->scope_uid);
		}
		_g_object_unref0 (_data_->_scope_uid_it);
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_lens_impl_real_set_view_type_data_free (gpointer _data) {
	UnityLensImplSetViewTypeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityLensImplSetViewTypeData, _data_);
}


static void unity_lens_impl_real_set_view_type (UnityLensService* base, guint view_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityLensImpl * self;
	UnityLensImplSetViewTypeData* _data_;
	UnityLensImpl* _tmp0_;
	guint _tmp1_;
	self = (UnityLensImpl*) base;
	_data_ = g_slice_new0 (UnityLensImplSetViewTypeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_lens_impl_real_set_view_type);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_lens_impl_real_set_view_type_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = view_type;
	_data_->view_type = _tmp1_;
	unity_lens_impl_real_set_view_type_co (_data_);
}


static void unity_lens_impl_real_set_view_type_finish (UnityLensService* base, GAsyncResult* _res_, GError** error) {
	UnityLensImplSetViewTypeData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean unity_lens_impl_real_set_view_type_co (UnityLensImplSetViewTypeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_scope_factory;
		_data_->_tmp1_ = _data_->_tmp0_->scopes;
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
		_data_->_scope_list = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->_scope_list;
		_data_->_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_scope_size = _data_->_tmp5_;
		_data_->_scope_index = -1;
		while (TRUE) {
			_data_->_tmp6_ = _data_->_scope_index;
			_data_->_scope_index = _data_->_tmp6_ + 1;
			_data_->_tmp7_ = _data_->_scope_index;
			_data_->_tmp8_ = _data_->_scope_size;
			if (!(_data_->_tmp7_ < _data_->_tmp8_)) {
				break;
			}
			_data_->_tmp9_ = _data_->_scope_list;
			_data_->_tmp10_ = _data_->_scope_index;
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp9_, _data_->_tmp10_);
			_data_->scope = (UnityScopeProxy*) _data_->_tmp11_;
			_data_->_tmp12_ = _data_->scope;
			_data_->_tmp13_ = _data_->view_type;
			unity_scope_proxy_set_view_type (_data_->_tmp12_, (UnityViewType) _data_->_tmp13_);
			_g_object_unref0 (_data_->scope);
		}
		_g_object_unref0 (_data_->_scope_list);
	}
	_data_->_tmp14_ = _data_->self->priv->_owner;
	_data_->_tmp15_ = _data_->view_type;
	unity_lens_set_active_internal (_data_->_tmp14_, _data_->_tmp15_ != ((guint) UNITY_VIEW_TYPE_HIDDEN));
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static UnityScopeProxy* unity_lens_impl_get_scope_for_uid (UnityLensImpl* self, const gchar* uid) {
	UnityScopeProxy* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	{
		UnityScopeFactory* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _scope_list;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _scope_size;
		gint _scope_index;
		_tmp0_ = self->priv->_scope_factory;
		_tmp1_ = _tmp0_->scopes;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_scope_list = _tmp2_;
		_tmp3_ = _scope_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_scope_size = _tmp5_;
		_scope_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			UnityScopeProxy* scope;
			const gchar* _tmp12_;
			UnityScopeProxy* _tmp13_;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			gboolean _tmp16_;
			_tmp6_ = _scope_index;
			_scope_index = _tmp6_ + 1;
			_tmp7_ = _scope_index;
			_tmp8_ = _scope_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _scope_list;
			_tmp10_ = _scope_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			scope = (UnityScopeProxy*) _tmp11_;
			_tmp12_ = uid;
			_tmp13_ = scope;
			_tmp14_ = unity_lens_impl_uid_for_scope (self, _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strcmp0 (_tmp12_, _tmp15_) == 0;
			_g_free0 (_tmp15_);
			if (_tmp16_) {
				result = scope;
				_g_object_unref0 (_scope_list);
				return result;
			}
			_g_object_unref0 (scope);
		}
		_g_object_unref0 (_scope_list);
	}
	result = NULL;
	return result;
}


static gchar* unity_lens_impl_uid_for_scope (UnityLensImpl* self, UnityScopeProxy* scope) {
	gchar* result = NULL;
	UnityScopeProxy* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (scope != NULL, NULL);
	_tmp0_ = scope;
	_tmp1_ = g_strdup_printf ("%p", _tmp0_);
	result = _tmp1_;
	return result;
}


UnityResultsSynchronizer* unity_lens_impl_get_results_sync (UnityLensImpl* self) {
	UnityResultsSynchronizer* result;
	UnityResultsSynchronizer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_results_sync;
	result = _tmp0_;
	return result;
}


UnityResultsSynchronizer* unity_lens_impl_get_global_results_sync (UnityLensImpl* self) {
	UnityResultsSynchronizer* result;
	UnityResultsSynchronizer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_global_results_sync;
	result = _tmp0_;
	return result;
}


static void unity_lens_impl_class_init (UnityLensImplClass * klass) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	unity_lens_impl_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityLensImplPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_lens_impl_get_property;
	G_OBJECT_CLASS (klass)->finalize = unity_lens_impl_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LENS_IMPL_RESULTS_SYNC, g_param_spec_object ("results-sync", "results-sync", "results-sync", UNITY_TYPE_RESULTS_SYNCHRONIZER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LENS_IMPL_GLOBAL_RESULTS_SYNC, g_param_spec_object ("global-results-sync", "global-results-sync", "global-results-sync", UNITY_TYPE_RESULTS_SYNCHRONIZER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	_tmp0_ = g_getenv ("LIBUNITY_LENS_DIRECTORY");
	unity_lens_impl_LENS_DIRECTORY = _tmp0_;
	_tmp1_ = unity_lens_impl_LENS_DIRECTORY;
	if (_tmp1_ == NULL) {
		unity_lens_impl_LENS_DIRECTORY = "";
	}
}


static void unity_lens_impl_unity_lens_service_interface_init (UnityLensServiceIface * iface) {
	unity_lens_impl_unity_lens_service_parent_iface = g_type_interface_peek_parent (iface);
	iface->info_request = (void (*)(UnityLensService*, GError**)) unity_lens_impl_real_info_request;
	iface->info_request_finish = unity_lens_impl_real_info_request_finish;
	iface->activate = (void (*)(UnityLensService*, const gchar*, guint, UnityActivationReplyRaw*, GError**)) unity_lens_impl_real_activate;
	iface->activate_finish = unity_lens_impl_real_activate_finish;
	iface->search = (GHashTable* (*)(UnityLensService*, const gchar*, GHashTable*, GError**)) unity_lens_impl_real_search;
	iface->search_finish = unity_lens_impl_real_search_finish;
	iface->global_search = (GHashTable* (*)(UnityLensService*, const gchar*, GHashTable*, GError**)) unity_lens_impl_real_global_search;
	iface->global_search_finish = unity_lens_impl_real_global_search_finish;
	iface->preview = (void (*)(UnityLensService*, const gchar*, UnityPreviewReplyRaw*, GError**)) unity_lens_impl_real_preview;
	iface->preview_finish = unity_lens_impl_real_preview_finish;
	iface->update_filter = (void (*)(UnityLensService*, const gchar*, GHashTable*, GError**)) unity_lens_impl_real_update_filter;
	iface->update_filter_finish = unity_lens_impl_real_update_filter_finish;
	iface->set_view_type = (void (*)(UnityLensService*, guint, GError**)) unity_lens_impl_real_set_view_type;
	iface->set_view_type_finish = unity_lens_impl_real_set_view_type_finish;
}


static void unity_lens_impl_instance_init (UnityLensImpl * self) {
	self->priv = UNITY_LENS_IMPL_GET_PRIVATE (self);
}


static void unity_lens_impl_finalize (GObject* obj) {
	UnityLensImpl * self;
	self = UNITY_LENS_IMPL (obj);
	_g_object_unref0 (self->priv->_results_model);
	_g_object_unref0 (self->priv->_global_results_model);
	_g_object_unref0 (self->priv->_categories_model);
	_g_object_unref0 (self->priv->_filters_model);
	_g_object_unref0 (self->priv->_sources);
	_g_object_unref0 (self->priv->_scope_factory);
	_g_object_unref0 (self->priv->_filters_sync);
	_g_object_unref0 (self->priv->_results_sync);
	_g_object_unref0 (self->priv->_global_results_sync);
	G_OBJECT_CLASS (unity_lens_impl_parent_class)->finalize (obj);
}


GType unity_lens_impl_get_type (void) {
	static volatile gsize unity_lens_impl_type_id__volatile = 0;
	if (g_once_init_enter (&unity_lens_impl_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityLensImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_lens_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityLensImpl), 0, (GInstanceInitFunc) unity_lens_impl_instance_init, NULL };
		static const GInterfaceInfo unity_lens_service_info = { (GInterfaceInitFunc) unity_lens_impl_unity_lens_service_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType unity_lens_impl_type_id;
		unity_lens_impl_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityLensImpl", &g_define_type_info, 0);
		g_type_add_interface_static (unity_lens_impl_type_id, UNITY_TYPE_LENS_SERVICE, &unity_lens_service_info);
		g_once_init_leave (&unity_lens_impl_type_id__volatile, unity_lens_impl_type_id);
	}
	return unity_lens_impl_type_id__volatile;
}


static void _vala_unity_lens_impl_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityLensImpl * self;
	self = UNITY_LENS_IMPL (object);
	switch (property_id) {
		case UNITY_LENS_IMPL_RESULTS_SYNC:
		g_value_set_object (value, unity_lens_impl_get_results_sync (self));
		break;
		case UNITY_LENS_IMPL_GLOBAL_RESULTS_SYNC:
		g_value_set_object (value, unity_lens_impl_get_global_results_sync (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



