/*
 * Copyright(C) 2010 Neil Jagdish Patel
 * Copyright(C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 */

[DBus (name = "com.Gwibber.Connection")]
private interface ConnectionInterface : Object {
	public signal void ConnectionOffline ();
	public signal void ConnectionOnline ();
	public abstract bool isConnected () throws GLib.IOError;
}

namespace Gwibber
{
    public class Connection : Object
    {
        private const string conn_name  = "com.Gwibber.Connection";
        private const string conn_path  = "/com/gwibber/Connection";

        private ConnectionInterface conn_service;
	private Gwibber.Utils utils;

	/** 
            Connection::is_available:
            @arg0: The current state

            Emitted when com.Gwibber.Connection availability state changes
	*/
	public signal void is_available(bool is_up);


        /** 
            Connection::connection_changed:
            @arg0: The current state

            Emitted when network connection state changes
        */
        public signal void connection_changed(bool is_online);

	public Connection ()
	{
	}

        construct
        {
            try
            {
                conn_service = Bus.get_proxy_sync(BusType.SESSION,
                                                       conn_name,
                                                       conn_path);
                utils = new Gwibber.Utils();
                utils.setup(conn_name);
                utils.available.connect(conn_available);

                conn_service.ConnectionOffline.connect(connection_offline);
                conn_service.ConnectionOnline.connect(connection_online);
            }
            catch(GLib.IOError e)
            {
                warning ("Unable to get Gwibber connection service: "+e.message);
            }
        }

        public bool is_connected()
        {
            try {
                return conn_service.isConnected();
            } catch (GLib.IOError e) {
                warning (e.message);
                return false;
            }
        }

        private void connection_offline()
        {
            connection_changed(false);
        }

        private void connection_online()
        {
            connection_changed(true);
        }

	public void conn_available(bool is_up)
	{
		is_available(is_up);
	}

    }
}
