#import "AllTests.h"

#import "AssertTest.h"
#import "ExpectationCounterTest.h"
#import "ExpectationGroupTest.h"
#import "ExpectationListTest.h"
#import "ExpectationSetTest.h"
#import "ExpectationValueTest.h"
#import "NSObjectObjcUnitAdditionsTest.h"
#import "TestCaseTest.h"
#import "TestListenerTest.h"
#import "TestSuiteTest.h"
#import "MockObjects/MockCoderTest.h"

@implementation AllTests

+ (TestSuite *)suite {
    TestSuite *suite = [TestSuite  suiteWithName:@"All ObjcUnit Tests"];

    [suite addTest:[TestSuite suiteWithClass:[TestCaseTest class]]];
    [suite addTest:[TestSuiteTest suite]];
    [suite addTest:[TestSuite suiteWithClass:[AssertTest class]]];
    [suite addTest:[TestSuite suiteWithClass:[TestListenerTest class]]];
    [suite addTest:[TestSuite suiteWithClass:[NSObjectObjcUnitAdditionsTest class]]];

    [suite addTest:[TestSuite suiteWithClass:[ExpectationCounterTest class]]];
    [suite addTest:[TestSuite suiteWithClass:[ExpectationGroupTest class]]];
    [suite addTest:[TestSuite suiteWithClass:[ExpectationListTest class]]];
    [suite addTest:[TestSuite suiteWithClass:[ExpectationSetTest class]]];
    [suite addTest:[TestSuite suiteWithClass:[ExpectationValueTest class]]];

    [suite addTest:[TestSuite suiteWithClass:[MockCoderTest class]]];
    
    return suite;
}

@end
