/*
 
 *****************************************************************************
 * Author:                                                                   *
 * ------                                                                    *
 *  Anton Kokalj                                  Email: Tone.Kokalj@ijs.si  *
 *  Department of Physical and Organic Chemistry  Phone: x 386 1 477 3523    *
 *  Jozef Stefan Institute                          Fax: x 386 1 477 3811    *
 *  Jamova 39, SI-1000 Ljubljana                                             *
 *  SLOVENIA                                                                 *
 *                                                                           *
 * Source: $XCRYSDEN_TOPDIR/C/ppmPrintTogl.c
 * ------                                                                    *
 * Copyright (c) 1996-2003 by Anton Kokalj                                   *
 *****************************************************************************

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "togl.h"
#include "struct.h"
#include "xcfunc.h"

/* --- xcDisplayFunc.c --- */
extern void (*xcDisplay)(struct Togl *togl);

extern int Togl_DumpToPpmFile( const struct Togl *togl, const char *filename,
			       int inColor, int interpDegree, int antialias,
			       void (*user_redraw)( const struct Togl *));
/*
 * this function takes care of PPM
 * 
 * Usage: toglName xc_dump2ppm filename ?colorEPS? ?interpDegre?
 */
int
CRY_Dump2PpmCb(struct Togl *togl, int argc, char *argv[])
{
  Tcl_Interp *interp = Togl_Interp(togl);
  int colorPPM = 1, interpDegree = 1, antialias = 0;

  if ( argc < 3 || argc > 6 ) {
    interp->result = "Usage: toglName xc_dump2ppm filename ?colorPPM? ?interpDegre? ?antialias?";
    return TCL_ERROR;
  }
  
  if ( argc >= 4 )
    if ( Tcl_GetInt(interp, argv[3], &colorPPM) == TCL_ERROR ) {
      sprintf(interp->result,"wanted integer, but got \"%s\" while executing %s %s %s %s", argv[3], argv[0], argv[1], argv[2], argv[3]);
      return TCL_ERROR;
    }
  if ( argc >= 5 )
    if ( Tcl_GetInt(interp, argv[4], &interpDegree) == TCL_ERROR ) {
      sprintf(interp->result,"wanted integer, but got \"%s\" while executing %s %s %s %s %s", argv[4], argv[0], argv[1], argv[2], argv[3], argv[4]);
      return TCL_ERROR;
    }
  if ( argc == 6 )
    if ( Tcl_GetInt(interp, argv[4], &antialias) == TCL_ERROR ) {
      sprintf(interp->result,"wanted integer, but got \"%s\" while executing %s %s %s %s %s %s", argv[5], argv[0], argv[1], argv[2], argv[3], argv[4], argv[5]);
      return TCL_ERROR;
    }
  
  if ( interpDegree < 1 ) interpDegree = 1;

  /* check if togl is .mesa or something else ... */
  if ( togl == Togl_FindTogl(".mesa") ) {
    Togl_DumpToPpmFile( togl, argv[2], colorPPM, interpDegree, antialias,
			(void (*)(const struct Togl *)) xcDisplay );
  } else {
    NEW_WIN_CONTEXT *wc;
    wc = FindWinContextByTogl( togl );
    Togl_DumpToPpmFile( togl, argv[2], colorPPM, interpDegree, antialias,
			(void (*)(const struct Togl *)) wc->xcDisplay );
  }
  
  return TCL_OK;
}
