theory Why3_Set
imports Why3_Setup "~~/src/HOL/Library/FSet"
begin

section {* Potentially infinite sets *}

definition choose :: "'a set \<Rightarrow> 'a" where
  "choose S = (\<some>x. x \<in> S)"

why3_open "set/Set.xml"
  constants
    mem = Set.member
    empty = bot
    add = insert
    remove = Set.remove
    union = sup
    inter = inf
    diff = minus
    choose = choose
    all = top
  types
    set = set

why3_vc all_def by simp

why3_vc add_def1 by simp

why3_vc diff_def1 by simp

why3_vc mem_empty by simp

why3_vc add_remove
  using assms
  by (auto simp add: remove_def)

why3_vc remove_add by (simp add: remove_def)

why3_vc choose_def
  using assms
  by (auto simp add: is_empty_def choose_def intro: someI_ex)

why3_vc empty_def1 by (simp add: is_empty_def)

why3_vc inter_def1 by simp

why3_vc union_def1 by simp

why3_vc remove_def1 by (auto simp add: remove_def)

why3_vc subset_diff by auto

why3_vc subset_def by auto

why3_vc subset_refl by simp

why3_vc subset_trans
  using assms
  by simp

why3_vc subset_remove by (auto simp add: remove_def)

why3_vc extensionality
  using assms
  by simp

why3_vc infix_eqeq_def by auto

why3_end


section {* Finite sets *}

definition fremove :: "'a \<Rightarrow> 'a fset \<Rightarrow> 'a fset" where
  "fremove x A = A - {|x|}"

definition fchoose :: "'a fset \<Rightarrow> 'a" where
  "fchoose S = (\<some>x. x |\<in>| S)"

why3_open "set/Fset.xml"
  constants
    mem = fmember
    empty = bot
    add = finsert
    remove = fremove
    union = sup
    inter = inf
    diff = minus
    choose = fchoose
    all = top
  types
    set = fset

why3_vc add_def1 by simp

why3_vc diff_def1 by simp

why3_vc mem_empty by simp

why3_vc add_remove
  using assms
  by (auto simp add: fremove_def)

why3_vc remove_add by (simp add: fremove_def)

why3_vc choose_def
  using assms
  by (auto simp add: is_empty_def fchoose_def intro: someI_ex)

why3_vc empty_def1 by (simp add: is_empty_def)

why3_vc inter_def1 by simp

why3_vc union_def1 by simp

why3_vc remove_def1 by (auto simp add: fremove_def)

why3_vc subset_diff by auto

why3_vc subset_def by auto

why3_vc subset_refl by simp

why3_vc subset_trans
  using assms
  by simp

why3_vc subset_remove by (auto simp add: fremove_def)

why3_vc extensionality
  using assms
  by simp

why3_vc infix_eqeq_def by auto

why3_vc cardinal1
proof (cases s rule: fset_strong_cases)
  case 1
  with assms
  show ?thesis by (simp add: fcard_fempty)
next
  case (2 s' x)
  show ?thesis
  proof (cases s' rule: fset_strong_cases)
    case 1
    with `s = finsert x s'` assms
    show ?thesis by (simp add: fchoose_def)
  next
    case (2 s'' y)
    with `s = finsert x s'` assms
    show ?thesis by (auto simp add: fcard_finsert_if fchoose_def
      split add: split_if_asm)
  qed
qed

why3_vc cardinal_add
  using assms
  by (simp add: fcard_finsert_disjoint)

why3_vc cardinal_empty by (simp add: is_empty_def)

why3_vc cardinal_nonneg by simp

why3_vc cardinal_remove
proof -
  from assms
  have "1 \<le> fcard s"
    by (cases s rule: fset_strong_cases)
      (auto simp add: fcard_finsert_disjoint)
  with assms show ?thesis
    by (simp add: fremove_def)
qed

why3_vc cardinal_subset
  using assms
  by (simp add: fcard_mono)

why3_vc subset_eq
by (metis H1 H2 fcard_seteq nat_int order_refl)

why3_end

end
