/*
vrerror.c - Error reporing functions
Copyright (C) 2001  Jeff Carneal

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "config.h"
#include <stdio.h>
#include <sys/time.h>
#include <unistd.h>
#include "progress.h"

PM pmeter;

void pm_showmeter(int mode) {
	char buf[128];
	long lastupdate = 0;
	float kdone = 0;
	float percent = 0;
	int elapsed_time = 0;
	int done_diff = 0;
	int kleft = 0;
	float kbps = 100;
	float secsleft = 0;
	int mins = 0;
	int secs = 0;

	memset(buf,0,128);

	lastupdate = pmeter.current.tv_sec;
	gettimeofday(&pmeter.current, NULL);
	elapsed_time = pmeter.current.tv_sec - lastupdate;

	done_diff = pmeter.bytesdone - pmeter.lastbytesdone;
	if(elapsed_time)
		kbps = (float)(done_diff / (float)elapsed_time / 1024);
	kdone = pmeter.bytesdone/1024;
	percent = (kdone/pmeter.totalkbytes)*100;

	kleft = pmeter.totalkbytes - (int)kdone;
	if(kbps)
		secsleft = (int)(kleft / kbps);

	mins = (int)(secsleft / 60);
	secs = (int)secsleft % 60;

	switch(mode) {
		case PM_START:
			snprintf(buf, 128, "\n");

		case PM_UPDATE:
			snprintf(buf, 128, "\r -- [%dk/%dk] | %5.2f KB/s | %3d%% | %02d:%02ds ETA --", (int)kdone, pmeter.totalkbytes, kbps, (int)percent, mins, secs);
			fprintf(stderr, "%s", buf);
			break;

		case PM_END:
			snprintf(buf, 128, "\r -- [%dk/%dk] | %5.2f KB/s | 100%% | DONE --          ", pmeter.totalkbytes, pmeter.totalkbytes, kbps);
			fprintf(stderr, "%s", buf);
			secsleft = pmeter.current.tv_sec - pmeter.start.tv_sec;
			mins = (int)(secsleft / 60);
			secs = (int)secsleft % 60;
			fprintf(stderr, "\nElapsed time:  %02d:%02d\n\n", mins, secs);
	}
	pmeter.lastbytesdone = pmeter.bytesdone;

}

void pm_updatemeter(void) {
	alarm(1);
	pm_showmeter(PM_UPDATE);
}

