//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#include "IdMetric.h"

using namespace tlp;

DOUBLEPLUGINOFGROUP(IdMetric,"Id","David Auber","06/04/2000","Alpha","1.0","Misc");

//==================================================================
IdMetric::IdMetric(const PropertyContext &context):DoubleAlgorithm(context) {
}
//==================================================================
bool IdMetric::run() {
  node n;
  forEach(n, graph->getNodes())
    doubleResult->setNodeValue(n, n.id);
  edge e;
  forEach(e, graph->getEdges())
    doubleResult->setEdgeValue(e, e.id);
  return true;
}
//=================================================================
