//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef COPYPROPERTYDIALOG_H
#define COPYPROPERTYDIALOG_H

#include <tulip/tulipconf.h>

#include <string>
#include <vector>

#ifdef  _WIN32
// compilation pb workaround
#include <windows.h>
#endif

#include "CopyPropertyDialogData.h"
#include "tulip/Iterator.h"

class TLP_QT_SCOPE CopyPropertyDialog : public QDialog, public Ui::CopyPropertyDialogData
{ 
  Q_OBJECT;

public:
  CopyPropertyDialog(QWidget *parent = 0);
  void setProperties(std::string& srcProp,
		     std::vector<std::string>& localProps,
		     std::vector<std::string>& inheritedProps);
  enum destType {NEW, LOCAL, INHERITED};
  std::string getDestinationProperty(destType&);
  
public slots:  
  void setNew( bool );
  void setLocal( bool );
  void setInherited( bool );
};

#endif // COPYPROPERTYDIALOG_H
