/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import java.applet.Applet;
import java.awt.Graphics;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XSLTProcessorApplet
extends Applet {
    TransformerFactory m_tfactory = null;
    private String m_styleURL;
    private String m_documentURL;
    private final String PARAM_styleURL = "styleURL";
    private final String PARAM_documentURL = "documentURL";
    private String m_styleURLOfCached = null;
    private String m_documentURLOfCached = null;
    private URL m_codeBase = null;
    private String m_treeURL = null;
    private URL m_documentBase = null;
    private transient Thread m_callThread = null;
    private transient TrustedAgent m_trustedAgent = null;
    private transient Thread m_trustedWorker = null;
    private transient String m_htmlText = null;
    private transient String m_sourceText = null;
    private transient String m_nameOfIDAttrOfElemToModify = null;
    private transient String m_elemIdToModify = null;
    private transient String m_attrNameToSet = null;
    private transient String m_attrValueToSet = null;
    transient String m_key;
    transient String m_expression;

    public String getAppletInfo() {
        return "Name: XSLTProcessorApplet\r\nAuthor: Scott Boag";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"styleURL", "String", "URL to an XSL stylesheet"}, {"documentURL", "String", "URL to an XML document"}};
        return stringArray;
    }

    public void init() {
        String string = this.getParameter("styleURL");
        if (string != null) {
            this.setStyleURL(string);
        }
        if ((string = this.getParameter("documentURL")) != null) {
            this.setDocumentURL(string);
        }
        this.m_codeBase = this.getCodeBase();
        this.m_documentBase = this.getDocumentBase();
        this.resize(320, 240);
    }

    public void start() {
        this.m_trustedAgent = new TrustedAgent();
        Thread thread = Thread.currentThread();
        this.m_trustedWorker = new Thread(thread.getThreadGroup(), this.m_trustedAgent);
        this.m_trustedWorker.start();
        try {
            this.m_tfactory = TransformerFactory.newInstance();
            this.showStatus("Causing Transformer and Parser to Load and JIT...");
            StringReader stringReader = new StringReader("<?xml version='1.0'?><foo/>");
            StringReader stringReader2 = new StringReader("<?xml version='1.0'?><xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version='1.0'><xsl:template match='foo'><out/></xsl:template></xsl:stylesheet>");
            PrintWriter printWriter = new PrintWriter(new StringWriter());
            TransformerFactory transformerFactory = this.m_tfactory;
            synchronized (transformerFactory) {
                Templates templates = this.m_tfactory.newTemplates(new StreamSource(stringReader2));
                Transformer transformer = templates.newTransformer();
                transformer.transform(new StreamSource(stringReader), new StreamResult(printWriter));
            }
            System.out.println("Primed the pump!");
            this.showStatus("Ready to go!");
        }
        catch (Exception exception) {
            this.showStatus("Could not prime the pump!");
            System.out.println("Could not prime the pump!");
            exception.printStackTrace();
        }
    }

    public void paint(Graphics graphics) {
    }

    public void stop() {
        if (null != this.m_trustedWorker) {
            this.m_trustedWorker.stop();
            this.m_trustedWorker = null;
        }
        this.m_styleURLOfCached = null;
        this.m_documentURLOfCached = null;
    }

    public void destroy() {
        if (null != this.m_trustedWorker) {
            this.m_trustedWorker.stop();
            this.m_trustedWorker = null;
        }
        this.m_styleURLOfCached = null;
        this.m_documentURLOfCached = null;
    }

    public void setStyleURL(String string) {
        this.m_styleURL = string;
    }

    public void setDocumentURL(String string) {
        this.m_documentURL = string;
    }

    public void freeCache() {
        this.m_styleURLOfCached = null;
        this.m_documentURLOfCached = null;
    }

    public void setStyleSheetAttribute(String string, String string2, String string3, String string4) {
        this.m_nameOfIDAttrOfElemToModify = string;
        this.m_elemIdToModify = string2;
        this.m_attrNameToSet = string3;
        this.m_attrValueToSet = string4;
    }

    public void setStylesheetParam(String string, String string2) {
        this.m_key = string;
        this.m_expression = string2;
    }

    public String escapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if ('<' == c) {
                stringBuffer.append("&lt;");
            } else if ('>' == c) {
                stringBuffer.append("&gt;");
            } else if ('&' == c) {
                stringBuffer.append("&amp;");
            } else if ('\ud800' <= c && c < '\udc00') {
                int n3;
                n3 = n2 + 1 >= n ? 63 : (56320 > (n3 = (int)string.charAt(++n2)) || n3 >= 57344 ? 63 : (c - 55296 << 10) + n3 - 56320 + 65536);
                stringBuffer.append("&#x");
                stringBuffer.append(Integer.toHexString(n3));
                stringBuffer.append(";");
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String getHtmlText() {
        this.m_trustedAgent.m_getData = true;
        this.m_callThread = Thread.currentThread();
        try {
            Thread thread = this.m_callThread;
            synchronized (thread) {
                this.m_callThread.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            System.out.println(interruptedException.getMessage());
        }
        return this.m_htmlText;
    }

    public String getTreeAsText(String string) throws IOException {
        this.m_treeURL = string;
        this.m_trustedAgent.m_getData = true;
        this.m_trustedAgent.m_getSource = true;
        this.m_callThread = Thread.currentThread();
        try {
            Thread thread = this.m_callThread;
            synchronized (thread) {
                this.m_callThread.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            System.out.println(interruptedException.getMessage());
        }
        return this.m_sourceText;
    }

    private String getSource() throws TransformerException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, false);
        String string = "";
        try {
            URL uRL = new URL(this.m_documentBase, this.m_treeURL);
            TransformerFactory transformerFactory = this.m_tfactory;
            synchronized (transformerFactory) {
                Transformer transformer = this.m_tfactory.newTransformer();
                StreamSource streamSource = new StreamSource(uRL.toString());
                StreamResult streamResult = new StreamResult(printWriter);
                transformer.transform(streamSource, streamResult);
                string = stringWriter.toString();
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            System.exit(-1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public String getSourceTreeAsText() throws Exception {
        return this.getTreeAsText(this.m_documentURL);
    }

    public String getStyleTreeAsText() throws Exception {
        return this.getTreeAsText(this.m_styleURL);
    }

    public String getResultTreeAsText() throws Exception {
        return this.escapeString(this.getHtmlText());
    }

    public String transformToHtml(String string, String string2) {
        if (null != string) {
            this.m_documentURL = string;
        }
        if (null != string2) {
            this.m_styleURL = string2;
        }
        return this.getHtmlText();
    }

    public String transformToHtml(String string) {
        if (null != string) {
            this.m_documentURL = string;
        }
        this.m_styleURL = null;
        return this.getHtmlText();
    }

    private String processTransformation() throws TransformerException {
        String string = null;
        this.showStatus("Waiting for Transformer and Parser to finish loading and JITing...");
        TransformerFactory transformerFactory = this.m_tfactory;
        synchronized (transformerFactory) {
            URL uRL = null;
            URL uRL2 = null;
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter((Writer)stringWriter, false);
            StreamResult streamResult = new StreamResult(printWriter);
            this.showStatus("Begin Transformation...");
            try {
                uRL = new URL(this.m_codeBase, this.m_documentURL);
                StreamSource streamSource = new StreamSource(uRL.toString());
                uRL2 = new URL(this.m_codeBase, this.m_styleURL);
                StreamSource streamSource2 = new StreamSource(uRL2.toString());
                Transformer transformer = this.m_tfactory.newTransformer(streamSource2);
                if (null != this.m_key) {
                    transformer.setParameter(this.m_key, this.m_expression);
                }
                transformer.transform(streamSource, streamResult);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                transformerConfigurationException.printStackTrace();
                System.exit(-1);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                System.exit(-1);
            }
            this.showStatus("Transformation Done!");
            string = stringWriter.toString();
        }
        return string;
    }

    class TrustedAgent
    implements Runnable {
        public boolean m_getData = false;
        public boolean m_getSource = false;

        TrustedAgent() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                XSLTProcessorApplet.this.m_trustedWorker;
                Thread.yield();
                if (this.m_getData) {
                    Thread thread;
                    Object var3_4;
                    try {
                        try {
                            this.m_getData = false;
                            XSLTProcessorApplet.this.m_htmlText = null;
                            XSLTProcessorApplet.this.m_sourceText = null;
                            if (this.m_getSource) {
                                this.m_getSource = false;
                                XSLTProcessorApplet.this.m_sourceText = XSLTProcessorApplet.this.getSource();
                            } else {
                                XSLTProcessorApplet.this.m_htmlText = XSLTProcessorApplet.this.processTransformation();
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            var3_4 = null;
                            thread = XSLTProcessorApplet.this.m_callThread;
                            synchronized (thread) {
                                XSLTProcessorApplet.this.m_callThread.notify();
                                continue;
                            }
                        }
                        var3_4 = null;
                    }
                    catch (Throwable throwable) {
                        var3_4 = null;
                        thread = XSLTProcessorApplet.this.m_callThread;
                        synchronized (thread) {
                            XSLTProcessorApplet.this.m_callThread.notify();
                            throw throwable;
                        }
                    }
                    thread = XSLTProcessorApplet.this.m_callThread;
                    synchronized (thread) {
                        XSLTProcessorApplet.this.m_callThread.notify();
                        continue;
                    }
                }
                try {
                    XSLTProcessorApplet.this.m_trustedWorker;
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

