#ifndef INDII_TINT_GUI_POSTPROCESSPANE_HPP
#define INDII_TINT_GUI_POSTPROCESSPANE_HPP

#include "TintPane.hpp"
#include "../ClusterModel.hpp"
#include "../ClusterModelObserver.hpp"

#include "wx/slider.h"

namespace indii {
  namespace tint {
    namespace gui {
/**
 * Preprocess settings pane.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * @version $Rev: 74 $
 * @date $Date: 2009-03-02 14:59:56 +0900 (Mon, 02 Mar 2009) $
 */
class PostProcessPane : public TintPane, public ClusterModelObserver {
public:
  /**
   * Constructor.
   *
   * @param parent Parent.
   * @param model Cluster model.
   */
  PostProcessPane(wxWindow* parent, ClusterModel* model);

  /*
   * Handle model changes.
   */
  virtual void notifySaturationDecayChange();
  virtual void notifyCentroidDecayChange();
  virtual void notifySaturationSoftnessChange();
  virtual void notifyCentroidSoftnessChange();

  /*
   * Slider control events.
   */
  void OnSlideSatDecay(wxScrollEvent& evt);
  void OnSlideCenDecay(wxScrollEvent& evt);
  void OnSlideSatSoft(wxScrollEvent& evt);
  void OnSlideCenSoft(wxScrollEvent& evt);
  
private:
  /**
   * Cluster model.
   */
  ClusterModel* model;

  /*
   * Slider controls.
   */ 
  wxSlider *slideSatDecay, *slideCenDecay, *slideSatSoft, *slideCenSoft;

  /*
   * Slider control ids.
   */
  enum ID {
    ID_SLIDE_SAT_DECAY,
    ID_SLIDE_CEN_DECAY,
    ID_SLIDE_SAT_SOFT,
    ID_SLIDE_CEN_SOFT
  };

  DECLARE_EVENT_TABLE()

};

    }
  }
}

#endif

