from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


_encoding_declaration_re = _Mock()

_reader = _Mock()

_writer = _Mock()

new_code_cell = _Mock()

new_notebook = _Mock()

new_text_cell = _Mock()

new_worksheet = _Mock()

re = _Mock()

read = _Mock()

reads = _Mock()

to_notebook = _Mock()

write = _Mock()

writes = _Mock()



class NotebookReader(_Mock):
  pass


class NotebookWriter(_Mock):
  pass


class PyReader(_Mock):
  pass


class PyReaderError(_Mock):
  pass


class PyWriter(_Mock):
  pass


class unicode_type(_Mock):
  pass


