C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=ROMBER,SSI=0
C
                        SUBROUTINE ROMBER
C                       *****************
     * (RES,T12,T22,T1,T2,T1T2,T0)
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------   Integration numerique par methode de Romberg            *
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS                    !
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !__________________________________________________________________!
C   ! FONCTIONS IMPLICITES                                             !
C   !__________________________________________________________________!
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : 
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON 
C**********************************************************************
C
#include "nlofes.h"
C
C**********************************************************************
C
      INTEGER MMAX,NMAX
      PARAMETER (MMAX=6,NMAX=6)
C
C.. Variables externes
      DOUBLE PRECISION RES,T12,T22,T1,T2,T1T2,T0
C
C.. Variables locales
      DOUBLE PRECISION T(MMAX,NMAX)
      DOUBLE PRECISION XH,BA2,COE,G,XX,F1,F0,X0,X1,EPS
      INTEGER N,M,I,MM1
C
      DOUBLE PRECISION F,A,B,C,D
      F(A,B,C,D) = (D/A) *(ATAN((2.*A+B)/D)-ATAN(B/D))
CC      F(A,B,C,D) = D/A *ATAN(D/(B+2*C))
C**********************************************************************
C
C     0- INITIALISATIONS
C     ==================
      X0= 0.
      X1 = 1.
      EPS= 1.E-8
C
      XH = X1-X0
      D = SQRT(ABS(-T1*T1+4*T12*T0))
      IF (D .LE. EPS) THEN
        F0 = 0.
      ELSE
        F0 = F(T12,T1,T0,D)
      ENDIF
      D = SQRT(ABS(-(T1T2+T1)*(T1T2+T1)+4.*T12*(T22+T2+T0)))
      IF (D .LE. EPS) THEN
        F1 = 0.
      ELSE
        F1 = F(T12,T1T2+T1,T22+T2+T0,D)
      ENDIF
      T(1,1) = (F0+F1) * XH/2.
C
C
C     1- ITERATIONS
C     =============
C
      DO 100 M=2,MMAX
C
        T(M,1) = 0.
        G = 0.
        MM1 = INT(2**(M-1))
        BA2 = XH / MM1
C
        DO 110 I=1,MM1-1,2
          XX = X0+I*BA2
          B = T1T2*XX + T1
          C =  T22*XX*XX + T2*XX +T0
          D = SQRT(ABS(-B*B+4.*T12*C))
          IF (D .GT.EPS)  THEN
            G = G + F(T12,B,C,D)
          ENDIF
  110   CONTINUE
C
        T(M,1) = T(M-1,1)/2. + BA2*G
C
  100 CONTINUE
C   
C     
      DO 120 N=2,NMAX
        COE = 4**(N-1)
        DO 121 M=N,MMAX
          T(M,N) = (COE*T(M,N-1) - T(M-1,N-1))/(COE-1)
  121   CONTINUE
  120 CONTINUE
C
      RES = T(MMAX,NMAX)
C
C      2- IMPRESSIONS DU RESULTAT
C      ==========================
CC       DO 200 M=1,MMAX
CC         WRITE (NFECRA,2000) (T(M,N),N=1,M)
CC  200  CONTINUE
C
C--------
C FORMATS
C--------
 2000 FORMAT(10E12.5)
C----
C FIN
C----
C
      END
