/*
 * Copyright 2014 Canonical Ltd.
 *
 * This file is part of sync-monitor.
 *
 * sync-monitor is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * contact-service-app is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SYNC_ACCOUNT_MOCK__
#define __SYNC_ACCOUNT_MOCK__


#include <gmock/gmock.h>
#include <QtCore/QStringList>

#include "src/sync-account.h"

class SyncAccountMock : public SyncAccount
{
    Q_OBJECT
public:
    SyncAccountMock(int id) : SyncAccount(0, 0), m_id(id) {}
    int id() const { return m_id; }
private:
    int m_id;

    MOCK_CONST_METHOD0(availableServices, QStringList());
};

#endif
