/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "ActionStorage.h"

// qt
#include <QtGui/QAction>
#include <QtGui/QWidget>

// sys
#include <map>
typedef std::map<long, QAction*> Actions;


class ActionStorage::Member
{
public:
  Actions actions;
};

ActionStorage::ActionStorage()
{
  _m = new ActionStorage::Member();
}

ActionStorage::~ActionStorage()
{
  delete _m;
}

QAction* ActionStorage::getAction( long key )
{
  return _m->actions[key];
}

void ActionStorage::addAction( long key, QAction* action )
{
  _m->actions[key] = action;
}

void ActionStorage::enableAction( long key, bool b )
{
  getAction( key )->setEnabled(b);
}

void ActionStorage::enableActions( long keys[] )
{
  int i = 0;
  while( keys[i] != ActionNull )
  {
    enableAction( keys[i], true );
    i++;
  }
}

void ActionStorage::disableActions( long keys[] )
{
  int i = 0;
  while( keys[i] != ActionNull )
  {
    enableAction( keys[i], false );
    i++;
  }
}

void ActionStorage::enableActions()
{
  for( Actions::iterator it = _m->actions.begin(); it != _m->actions.end(); it++ )
  {
    ((*it).second)->setEnabled(true);
  }
}

void ActionStorage::disableActions()
{
  for( Actions::iterator it = _m->actions.begin(); it != _m->actions.end(); it++ )
  {
    ((*it).second)->setEnabled(false);
  }
}
