/* ====================================================================
 * Copyright (c) 2007-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "RpViewState.h"
#include "Bookmark.h"

// sys
#include <cassert>


RpViewState::RpViewState( Bookmark* bm )
: _pathPos(0)
{
  addPath( bm->getSource() );
}

void RpViewState::setExpanded( const sc::String& name, bool expanded )
{
  RpViewExpandedItems::iterator it = _itemExpanded.find(name);

  if( it != _itemExpanded.end() )
  {
    (*it).second = expanded;
  }
  else
  {
    _itemExpanded.insert( RpViewExpandedItems::value_type(name,expanded) );
  }
}

bool RpViewState::isExpanded( const sc::String& name )
{
  RpViewExpandedItems::iterator it = _itemExpanded.find(name);
  if( it != _itemExpanded.end() )
  {
    return (*it).second;
  }
  else
  {
    return false;
  }
}

void RpViewState::clearSelected()
{
  _itemSelected.clear();
}

void RpViewState::setSelected( const sc::String& name, bool selected )
{
  RpViewSelectedItems::iterator it = _itemSelected.find(name);

  if( it != _itemSelected.end() )
  {
    (*it).second = selected;
  }
  else
  {
    _itemSelected.insert( RpViewSelectedItems::value_type(name,selected) );
  }
}

bool RpViewState::isSelected( const sc::String& name )
{
  RpViewExpandedItems::iterator it = _itemSelected.find(name);
  if( it != _itemSelected.end() )
  {
    return (*it).second;
  }
  else
  {
    return false;
  }
}

void RpViewState::getPrevPathHistory( PathHistory& history )
{
  for( int i = _pathPos-1; i >= 0; i-- )
  {
    history.push_back( _pathHistory[i] );
  }
}

void RpViewState::getNextPathHistory( PathHistory& history )
{
  for( size_t i = _pathPos+1; i < _pathHistory.size(); i++ )
  {
    history.push_back( _pathHistory[i] );
  }
}

void RpViewState::prevPath()
{
  prevPath(1);
}

void RpViewState::nextPath()
{
  nextPath(1);
}

void RpViewState::prevPath( int cnt )
{
  if( _pathPos-cnt >= 0 )
    _pathPos -= cnt;

  if( _pathPos < _pathHistory.size() )
  {
    emit currentChanged( _pathHistory[_pathPos] );
    emit historyChanged();
  }
}

void RpViewState::nextPath( int cnt )
{
  if( _pathPos+cnt < _pathHistory.size() )
    _pathPos += cnt;

  if( _pathPos < _pathHistory.size() )
  {
    emit currentChanged( _pathHistory[_pathPos] );
    emit historyChanged();
  }
}

const sc::String& RpViewState::getPath()
{
  return _pathHistory[_pathPos];
}

void RpViewState::addPath( const sc::String& path )
{
  if( _pathPos+1 < _pathHistory.size() )
  {
    _pathHistory.resize(_pathPos+1);
  }

  _pathHistory.push_back(path);
  _pathPos = (unsigned int)_pathHistory.size() - 1;

  emit historyChanged();
}
