#!perl

#
# Copyright 2014 Chris West (Faux)
#
# This file is part of strip-nondeterminism.
#
# strip-nondeterminism is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# strip-nondeterminism is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with strip-nondeterminism.  If not, see <http://www.gnu.org/licenses/>.
#

use File::Temp 'tempdir';
use Test::More tests => 2;
use File::StripNondeterminism;

$dir = tempdir( CLEANUP => 1 );
$path = "$dir/pom.properties";
open(my $fh, '>', $path) or die("error opening $path");

# note that the line has a load of random trailing whitespace (?!)
print $fh <<'ORIGINAL';
#Generated by Maven
#Mon Oct 27 09:12:51 UTC 2014                                                 
version=2.4
ORIGINAL

close $fh;

$normalizer = File::StripNondeterminism::get_normalizer_for_file($path);
isnt(undef, $normalizer);
$normalizer->($path);

open FILE,$path or die("error opening $path");
binmode FILE;
local $/ = undef;
is(<FILE>, <<'EXPECTED');
#Generated by Maven
version=2.4
EXPECTED

