#===================================
#          stackapplet
#  Copyright 2010 - Nathan Osman
#
#     Contains the main class
#      used by StackApplet
#
#   StackApplet is released under
#        the MIT license
#===================================

# For translation support
from stackapplet import _

import os

try:
	import json
except ImportError:
	import simplejson as json

import config_store
import stack_api

# For the message box...
import pygtk
pygtk.require('2.0')
import gtk

# This module does nothing more than read
# the old config file, and import it into
# StackApplet 1.4

LEGACY_FILE_NAME = os.path.join(os.getenv("HOME"),".stackapplet")

def Convert():
	
	global LEGACY_FILE_NAME
	
	# Begin the conversion by getting the info from the
	# old config file
	f = open(LEGACY_FILE_NAME,'r')
	
	old_data = json.loads(f.readline())
	
	# Now attempt the conversion
	old_refresh = old_data["RefreshRate"]
	old_sites   = old_data["DesiredSites"]
	
	# We can delete the old file now
	os.remove(LEGACY_FILE_NAME)
	
	# Now create the new config file
	newf = config_store.config_store()
	
	newf.set_val("refresh_rate",old_refresh)
	
	# Split the old sites up
	site_list = old_sites.split(' ')
	
	# We'll need this in a minutes
	api = stack_api.stack_api()
	
	accounts = []
	
	# Loop through each one
	for site in site_list:
		
		# Split the site into URL and ID
		site_parts = site.split('/')
		
		the_site = site_parts[0]
		the_id   = site_parts[1]
		
		# Now try to find the site
		stats = api.fetch_stats(the_site)["statistics"][0]["site"]
		
		site_name = stats["name"]
		
		new_entry = { "user_id"   : the_id,
		              "site_name" : site_name,
		              "site"      : the_site }
		
		accounts.append(new_entry)
		
	# Now store this in the new file
	newf.set_val("accounts",accounts)
	
	# Now save the file
	newf.save_settings()
	
	# Tell the user
	dialog = gtk.MessageDialog(None, gtk.DIALOG_MODAL,gtk.MESSAGE_INFO,gtk.BUTTONS_OK,
	                           _("StackApplet has been upgraded from 1.3 to 1.4.\n\nYour previous settings and accounts have been imported into StackApplet 1.4\n\nNote: StackApplet is no longer a panel applet - it uses the AppIndicator module and is now located in the status area of your panel."))
	dialog.set_title(_("StackApplet has been upgraded:"))
	dialog.connect("response",lambda x,y: dialog.destroy())
	dialog.run()
