/* sqlheavy-value.c generated by valac 0.12.1, the Vala compiler
 * generated from sqlheavy-value.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include "SQLHeavy.h"
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))

struct _SQLHeavyValueArrayPrivate {
	SQLHeavyValueArray* _source;
	gint* to_source_map;
	gint to_source_map_length1;
	gint _to_source_map_size_;
	GValue** values;
	gint values_length1;
	gint _values_size_;
};


static gpointer sql_heavy_value_array_parent_class = NULL;

GType sql_heavy_sqlite_type_to_g_type (gint stype, GError** error);
GType sql_heavy_sqlite_type_string_to_g_type (const gchar* stype, GError** error);
gboolean sql_heavy_value_equal (GValue* a, GValue* b);
void sql_heavy_sqlite_value_to_g_value (sqlite3_value* value, GValue* result);
GValueArray* sql_heavy_sqlite_value_array_to_g_value_array (sqlite3_value** values, int values_length1);
gboolean sql_heavy_check_type (GType gtype);
#define SQL_HEAVY_VALUE_ARRAY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SQL_HEAVY_TYPE_VALUE_ARRAY, SQLHeavyValueArrayPrivate))
enum  {
	SQL_HEAVY_VALUE_ARRAY_DUMMY_PROPERTY,
	SQL_HEAVY_VALUE_ARRAY_SOURCE,
	SQL_HEAVY_VALUE_ARRAY_LENGTH
};
static void _vala_GValue_free (GValue* self);
static void sql_heavy_value_array_prepare_set (SQLHeavyValueArray* self, gint index);
static void sql_heavy_value_array_set_values_length (SQLHeavyValueArray* self, gint length);
static void sql_heavy_value_array_finish_set (SQLHeavyValueArray* self, gint index);
static GValue* _g_value_dup (GValue* self);
static void sql_heavy_value_array_on_parent_position_changed (SQLHeavyValueArray* self, SQLHeavyValueArray* src, gint old_index, gint new_index);
static void sql_heavy_value_array_on_parent_value_changed (SQLHeavyValueArray* self, SQLHeavyValueArray* src, gint index);
static SQLHeavyValueArray* sql_heavy_value_array_new_with_source (SQLHeavyValueArray* source);
static SQLHeavyValueArray* sql_heavy_value_array_construct_with_source (GType object_type, SQLHeavyValueArray* source);
static void _sql_heavy_value_array_on_parent_position_changed_sql_heavy_value_array_position_changed (SQLHeavyValueArray* _sender, gint old_index, gint new_index, gpointer self);
static void _sql_heavy_value_array_on_parent_value_changed_sql_heavy_value_array_value_changed (SQLHeavyValueArray* _sender, gint index, gpointer self);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void sql_heavy_value_array_finalize (GObject* obj);
static void _vala_sql_heavy_value_array_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sql_heavy_value_array_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
   * Covert an SQLite type (integer) to a GLib.Type.
   *
   * @param stype the SQLite type
   * @return the GLib.Type
   * @see sqlite_type_string_to_g_type
   */
GType sql_heavy_sqlite_type_to_g_type (gint stype, GError** error) {
	GType result = 0UL;
	GError * _inner_error_ = NULL;
	switch (stype) {
		case SQLITE_INTEGER:
		{
			result = G_TYPE_INT64;
			return result;
		}
		case SQLITE3_TEXT:
		{
			result = G_TYPE_STRING;
			return result;
		}
		case SQLITE_FLOAT:
		{
			result = G_TYPE_DOUBLE;
			return result;
		}
		case SQLITE_NULL:
		{
			result = G_TYPE_POINTER;
			return result;
		}
		case SQLITE_BLOB:
		{
			result = G_TYPE_BYTE_ARRAY;
			return result;
		}
		default:
		{
			GError* _tmp0_ = NULL;
			_tmp0_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_DATA_TYPE, "Data type unsupported.");
			_inner_error_ = _tmp0_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0UL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0UL;
			}
		}
	}
}


/**
   * Covert an SQLite type (string) to a GLib.Type.
   *
   * @param stype the SQLite type
   * @return the GLib.Type
   * @see sqlite_type_to_g_type
   */
GType sql_heavy_sqlite_type_string_to_g_type (const gchar* stype, GError** error) {
	GType result = 0UL;
	const gchar* _tmp0_;
	GQuark _tmp1_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	static GQuark _tmp1__label2 = 0;
	static GQuark _tmp1__label3 = 0;
	static GQuark _tmp1__label4 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (stype != NULL, 0UL);
	_tmp0_ = stype;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("INTEGER")))) {
		switch (0) {
			default:
			{
				result = G_TYPE_INT64;
				return result;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("TEXT")))) {
		switch (0) {
			default:
			{
				result = G_TYPE_STRING;
				return result;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label2) ? _tmp1__label2 : (_tmp1__label2 = g_quark_from_static_string ("FLOAT")))) {
		switch (0) {
			default:
			{
				result = G_TYPE_DOUBLE;
				return result;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label3) ? _tmp1__label3 : (_tmp1__label3 = g_quark_from_static_string ("NULL")))) {
		switch (0) {
			default:
			{
				result = G_TYPE_POINTER;
				return result;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label4) ? _tmp1__label4 : (_tmp1__label4 = g_quark_from_static_string ("BLOB")))) {
		switch (0) {
			default:
			{
				result = G_TYPE_BYTE_ARRAY;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GError* _tmp2_ = NULL;
				_tmp2_ = g_error_new (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_DATA_TYPE, "Unknown datatype (\"%s\")", stype);
				_inner_error_ = _tmp2_;
				if (_inner_error_->domain == SQL_HEAVY_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0UL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0UL;
				}
			}
		}
	}
}


/**
   * Test whether two GLib.Values are equal
   */
gboolean sql_heavy_value_equal (GValue* a, GValue* b) {
	gboolean result = FALSE;
	GType _tmp0_;
	GType gtype;
	gboolean _tmp1_;
	_tmp0_ = G_VALUE_TYPE (a);
	gtype = _tmp0_;
	_tmp1_ = G_VALUE_HOLDS (b, gtype);
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	if (gtype == G_TYPE_INT64) {
		gint64 _tmp2_;
		gint64 _tmp3_;
		_tmp2_ = g_value_get_int64 (a);
		_tmp3_ = g_value_get_int64 (a);
		result = _tmp2_ == _tmp3_;
		return result;
	} else {
		if (gtype == G_TYPE_STRING) {
			const gchar* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			gboolean _tmp6_;
			_tmp4_ = g_value_get_string (a);
			_tmp5_ = g_value_get_string (b);
			_tmp6_ = g_str_equal (_tmp4_, _tmp5_);
			result = _tmp6_;
			return result;
		} else {
			if (gtype == G_TYPE_DOUBLE) {
				gdouble _tmp7_;
				gdouble _tmp8_;
				_tmp7_ = g_value_get_double (a);
				_tmp8_ = g_value_get_double (b);
				result = _tmp7_ == _tmp8_;
				return result;
			} else {
				if (gtype == G_TYPE_BYTE_ARRAY) {
					void* _tmp9_ = NULL;
					GByteArray* a1;
					void* _tmp10_ = NULL;
					GByteArray* b1;
					gboolean _tmp11_ = FALSE;
					_tmp9_ = g_value_get_boxed (a);
					a1 = (GByteArray*) _tmp9_;
					_tmp10_ = g_value_get_boxed (b);
					b1 = (GByteArray*) _tmp10_;
					if (a1->len == b1->len) {
						gint _tmp12_;
						_tmp12_ = memcmp (a1->data, b1->data, (gsize) a1->len);
						_tmp11_ = _tmp12_ == 0;
					} else {
						_tmp11_ = FALSE;
					}
					result = _tmp11_;
					return result;
				} else {
					if (gtype == G_TYPE_POINTER) {
						void* _tmp13_ = NULL;
						void* _tmp14_ = NULL;
						_tmp13_ = g_value_get_pointer (a);
						_tmp14_ = g_value_get_pointer (b);
						result = _tmp13_ == _tmp14_;
						return result;
					} else {
						const gchar* _tmp15_ = NULL;
						_tmp15_ = g_type_name (gtype);
						g_critical ("sqlheavy-value.vala:71: sql_heavy_value_equal not implemented for %s t" \
"ype.", _tmp15_);
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
}


/**
   * Convert an SQLite value to a GLib.Value
   *
   * @param value the SQLite value
   * @return the GLib.Value
   */
void sql_heavy_sqlite_value_to_g_value (sqlite3_value* value, GValue* result) {
	GType gtype = 0UL;
	gint _tmp0_;
	GType _tmp1_;
	GType _tmp2_;
	GValue _tmp3_ = {0};
	GValue _tmp4_ = {0};
	GValue gval;
	GError * _inner_error_ = NULL;
	g_return_if_fail (value != NULL);
	_tmp0_ = sqlite3_value_type (value);
	_tmp1_ = sql_heavy_sqlite_type_to_g_type (_tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			goto __catch48_sql_heavy_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	gtype = _tmp2_;
	goto __finally48;
	__catch48_sql_heavy_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally48:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_value_init (&_tmp3_, gtype);
	_tmp4_ = _tmp3_;
	gval = _tmp4_;
	if (gtype == G_TYPE_INT64) {
		gint64 _tmp5_;
		GValue _tmp6_ = {0};
		_tmp5_ = sqlite3_value_int64 (value);
		g_value_init (&_tmp6_, G_TYPE_INT64);
		g_value_set_int64 (&_tmp6_, _tmp5_);
		G_IS_VALUE (&gval) ? (g_value_unset (&gval), NULL) : NULL;
		gval = _tmp6_;
	} else {
		if (gtype == G_TYPE_DOUBLE) {
			gdouble _tmp7_;
			GValue _tmp8_ = {0};
			_tmp7_ = sqlite3_value_double (value);
			g_value_init (&_tmp8_, G_TYPE_DOUBLE);
			g_value_set_double (&_tmp8_, _tmp7_);
			G_IS_VALUE (&gval) ? (g_value_unset (&gval), NULL) : NULL;
			gval = _tmp8_;
		} else {
			if (gtype == G_TYPE_STRING) {
				const gchar* _tmp9_ = NULL;
				GValue _tmp10_ = {0};
				_tmp9_ = sqlite3_value_text (value);
				g_value_init (&_tmp10_, G_TYPE_STRING);
				g_value_set_string (&_tmp10_, _tmp9_);
				G_IS_VALUE (&gval) ? (g_value_unset (&gval), NULL) : NULL;
				gval = _tmp10_;
			} else {
				if (gtype == G_TYPE_BYTE_ARRAY) {
					void* _tmp11_ = NULL;
					guint8* blob;
					gint blob_length1;
					gint _blob_size_;
					gint _tmp12_;
					GByteArray* _tmp13_ = NULL;
					GByteArray* ba;
					GValue _tmp14_ = {0};
					_tmp11_ = sqlite3_value_blob (value);
					blob = (guint8*) _tmp11_;
					blob_length1 = -1;
					_blob_size_ = -1;
					_tmp12_ = sqlite3_value_bytes (value);
					blob_length1 = _tmp12_;
					_tmp13_ = g_byte_array_sized_new ((guint) blob_length1);
					ba = _tmp13_;
					g_byte_array_append (ba, blob, blob_length1);
					g_value_init (&_tmp14_, G_TYPE_BYTE_ARRAY);
					g_value_set_boxed (&_tmp14_, ba);
					G_IS_VALUE (&gval) ? (g_value_unset (&gval), NULL) : NULL;
					gval = _tmp14_;
					_g_byte_array_unref0 (ba);
				} else {
					if (gtype == G_TYPE_POINTER) {
						g_value_set_pointer (&gval, NULL);
					}
				}
			}
		}
	}
	*result = gval;
	return;
}


/**
   * Convert an array of SQLite values to a GLib.ValueArray
   *
   * @param values the SQLite values
   * @return the GLib.ValueArray
   */
GValueArray* sql_heavy_sqlite_value_array_to_g_value_array (sqlite3_value** values, int values_length1) {
	GValueArray* result = NULL;
	GValueArray* _tmp0_ = NULL;
	GValueArray* va;
	_tmp0_ = g_value_array_new ((guint) values_length1);
	va = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				GValue _tmp2_ = {0};
				GValue _tmp3_ = {0};
				GValue _tmp4_;
				if (!_tmp1_) {
					i++;
				}
				_tmp1_ = FALSE;
				if (!(i < values_length1)) {
					break;
				}
				sql_heavy_sqlite_value_to_g_value (values[i], &_tmp2_);
				_tmp3_ = _tmp2_;
				_tmp4_ = _tmp3_;
				g_value_array_append (va, &_tmp4_);
				G_IS_VALUE (&_tmp4_) ? (g_value_unset (&_tmp4_), NULL) : NULL;
			}
		}
	}
	result = va;
	return result;
}


/**
   * Escape a string for use in an SQL query.
   *
   * This function should be used sparingly, as it is generally
   * preferable to use prepared statements.
   *
   * @param str the string to escape
   * @return the escaped string
   * @see Query.bind_string
   */
static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	regex = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch49_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch49_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally49;
	__catch49_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally49:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* sql_heavy_escape_string (const gchar* str) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = string_replace (str, "'", "''");
	result = _tmp0_;
	return result;
}


/**
   * Check to see whether the specified GType is handled by SQLHeavy
   *
   * @param gtype the type to check
   * @return whether or not the type is handled by SQLHeavy
   */
gboolean sql_heavy_check_type (GType gtype) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	if (gtype == G_TYPE_INT) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = gtype == G_TYPE_STRING;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = gtype == G_TYPE_INT64;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = gtype == G_TYPE_FLOAT;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = gtype == G_TYPE_DOUBLE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = gtype == G_TYPE_POINTER;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = gtype == G_TYPE_BYTE_ARRAY;
	}
	result = _tmp0_;
	return result;
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


/**
     * Retrieve a value
     *
     * @param index the index of the value to retrieve
     * @return the value
     */
GValue* sql_heavy_value_array_get (SQLHeavyValueArray* self, gint index) {
	GValue* result = NULL;
	gint _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sql_heavy_value_array_get_length (self);
	g_return_val_if_fail (index < _tmp0_, NULL);
	if (self->priv->values != NULL) {
		gboolean _tmp2_ = FALSE;
		if (self->priv->to_source_map == NULL) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = self->priv->to_source_map[index] == (-1);
		}
		_tmp1_ = _tmp2_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = self->priv->values[index];
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		if (self->priv->_source != NULL) {
			_tmp3_ = self->priv->to_source_map[index] != (-1);
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			GValue* _tmp4_ = NULL;
			_tmp4_ = sql_heavy_value_array_get (self->priv->_source, self->priv->to_source_map[index]);
			result = _tmp4_;
			return result;
		} else {
			result = NULL;
			return result;
		}
	}
}


/**
     * Prepare to set a value
     *
     * @param index the index of the value to prepare
     */
static void sql_heavy_value_array_prepare_set (SQLHeavyValueArray* self, gint index) {
	gint _tmp0_;
	gint len;
	g_return_if_fail (self != NULL);
	_tmp0_ = sql_heavy_value_array_get_length (self);
	len = _tmp0_;
	if (index >= len) {
		gint _tmp1_;
		gint i;
		gint _tmp2_;
		_tmp1_ = MAX (index, len - 1);
		i = _tmp1_;
		_tmp2_ = MAX (1, index - i);
		sql_heavy_value_array_insert_padding (self, index, _tmp2_);
	} else {
		if (self->priv->values == NULL) {
			sql_heavy_value_array_set_values_length (self, len);
		}
	}
	g_signal_emit_by_name (self, "value-changed::before", index);
}


/**
     * Finish setting a value
     *
     * @param index the index of the value to finish setting
     */
static void sql_heavy_value_array_finish_set (SQLHeavyValueArray* self, gint index) {
	g_return_if_fail (self != NULL);
	if (self->priv->to_source_map != NULL) {
		self->priv->to_source_map[index] = -1;
	}
	g_signal_emit_by_name (self, "value-changed", index);
}


/**
     * Set a value
     *
     * This function will replace the value at the specified index if
     * it exists. If the array is not long enough to accomodate a
     * value at the specified index it is expanded.
     *
     * @param index the index to write to
     * @param value the value to write
     */
static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


void sql_heavy_value_array_set (SQLHeavyValueArray* self, gint index, GValue* value) {
	GValue* _tmp0_;
	GValue* _tmp1_;
	g_return_if_fail (self != NULL);
	sql_heavy_value_array_prepare_set (self, index);
	_tmp0_ = __g_value_dup0 (value);
	_tmp1_ = _tmp0_;
	__vala_GValue_free0 (self->priv->values[index]);
	self->priv->values[index] = _tmp1_;
	sql_heavy_value_array_finish_set (self, index);
}


/**
     * Set a string value
     *
     * @param index the index to write to
     * @param value the value to write
     */
void sql_heavy_value_array_set_string (SQLHeavyValueArray* self, gint index, const gchar* value) {
	GValue* _tmp0_ = NULL;
	GValue* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	sql_heavy_value_array_prepare_set (self, index);
	_tmp0_ = g_new0 (GValue, 1);
	g_value_init (_tmp0_, G_TYPE_STRING);
	g_value_set_string (_tmp0_, value);
	_tmp1_ = _tmp0_;
	__vala_GValue_free0 (self->priv->values[index]);
	self->priv->values[index] = _tmp1_;
	sql_heavy_value_array_finish_set (self, index);
}


/**
     * Set a int value
     *
     * @param index the index to write to
     * @param value the value to write
     */
void sql_heavy_value_array_set_int (SQLHeavyValueArray* self, gint index, gint value) {
	GValue* _tmp0_ = NULL;
	GValue* _tmp1_;
	g_return_if_fail (self != NULL);
	sql_heavy_value_array_prepare_set (self, index);
	_tmp0_ = g_new0 (GValue, 1);
	g_value_init (_tmp0_, G_TYPE_INT);
	g_value_set_int (_tmp0_, value);
	_tmp1_ = _tmp0_;
	__vala_GValue_free0 (self->priv->values[index]);
	self->priv->values[index] = _tmp1_;
	sql_heavy_value_array_finish_set (self, index);
}


/**
     * Set a 64-bit integer value
     *
     * @param index the index to write to
     * @param value the value to write
     */
void sql_heavy_value_array_set_int64 (SQLHeavyValueArray* self, gint index, gint64 value) {
	GValue* _tmp0_ = NULL;
	GValue* _tmp1_;
	g_return_if_fail (self != NULL);
	sql_heavy_value_array_prepare_set (self, index);
	_tmp0_ = g_new0 (GValue, 1);
	g_value_init (_tmp0_, G_TYPE_INT64);
	g_value_set_int64 (_tmp0_, value);
	_tmp1_ = _tmp0_;
	__vala_GValue_free0 (self->priv->values[index]);
	self->priv->values[index] = _tmp1_;
	sql_heavy_value_array_finish_set (self, index);
}


/**
     * Set a double value
     *
     * @param index the index to write to
     * @param value the value to write
     */
void sql_heavy_value_array_set_double (SQLHeavyValueArray* self, gint index, gdouble value) {
	GValue* _tmp0_ = NULL;
	GValue* _tmp1_;
	g_return_if_fail (self != NULL);
	sql_heavy_value_array_prepare_set (self, index);
	_tmp0_ = g_new0 (GValue, 1);
	g_value_init (_tmp0_, G_TYPE_DOUBLE);
	g_value_set_double (_tmp0_, value);
	_tmp1_ = _tmp0_;
	__vala_GValue_free0 (self->priv->values[index]);
	self->priv->values[index] = _tmp1_;
	sql_heavy_value_array_finish_set (self, index);
}


/**
     * Set a binary data value
     *
     * @param index the index to write to
     * @param value the value to write
     */
void sql_heavy_value_array_set_byte_array (SQLHeavyValueArray* self, gint index, GByteArray* value) {
	GValue* _tmp0_ = NULL;
	GValue* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	sql_heavy_value_array_prepare_set (self, index);
	_tmp0_ = g_new0 (GValue, 1);
	g_value_init (_tmp0_, G_TYPE_BYTE_ARRAY);
	g_value_set_boxed (_tmp0_, value);
	_tmp1_ = _tmp0_;
	__vala_GValue_free0 (self->priv->values[index]);
	self->priv->values[index] = _tmp1_;
	sql_heavy_value_array_finish_set (self, index);
}


void sql_heavy_value_array_set_null (SQLHeavyValueArray* self, gint index) {
	GValue _tmp0_ = {0};
	GValue _tmp1_ = {0};
	GValue v;
	GValue* _tmp2_;
	GValue* _tmp3_;
	g_return_if_fail (self != NULL);
	sql_heavy_value_array_prepare_set (self, index);
	g_value_init (&_tmp0_, G_TYPE_POINTER);
	_tmp1_ = _tmp0_;
	v = _tmp1_;
	g_value_set_pointer (&v, NULL);
	_tmp2_ = __g_value_dup0 (&v);
	_tmp3_ = _tmp2_;
	__vala_GValue_free0 (self->priv->values[index]);
	self->priv->values[index] = _tmp3_;
	sql_heavy_value_array_finish_set (self, index);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
}


/**
     * Insert a value into the array
     *
     * Rather than replacing the value at the specified index, this
     * function will move all subsequent data in order to make room
     * for the new value.
     *
     * @param index the index to write to
     * @param value the value to write
     */
void sql_heavy_value_array_insert (SQLHeavyValueArray* self, gint index, GValue* value) {
	g_return_if_fail (self != NULL);
	sql_heavy_value_array_insert_padding (self, index, 1);
	sql_heavy_value_array_set (self, index, value);
}


/**
     * Append a value
     *
     * @param value the value to write
     */
void sql_heavy_value_array_append (SQLHeavyValueArray* self, GValue* value) {
	gint _tmp0_;
	gint len;
	g_return_if_fail (self != NULL);
	_tmp0_ = sql_heavy_value_array_get_length (self);
	len = _tmp0_;
	sql_heavy_value_array_insert_padding (self, len, 1);
	sql_heavy_value_array_set (self, len, value);
}


/**
     * Prepend a value
     *
     * Note that prepend is much slower than append, since all other
     * values in the array must be moved.
     *
     * @param value the value to write
     */
void sql_heavy_value_array_prepend (SQLHeavyValueArray* self, GValue* value) {
	g_return_if_fail (self != NULL);
	sql_heavy_value_array_insert_padding (self, 0, 1);
	sql_heavy_value_array_set (self, 0, value);
}


/**
     * Remove a value
     *
     * All values after the removed value will be moved one slot in
     * order to fill in the gap.
     *
     * @param index the index of the value to remove
     */
void sql_heavy_value_array_remove (SQLHeavyValueArray* self, gint index) {
	g_return_if_fail (self != NULL);
	sql_heavy_value_array_insert_padding (self, index, -1);
}


/**
     * Set the length of the {@link values} array
     */
static void sql_heavy_value_array_set_values_length (SQLHeavyValueArray* self, gint length) {
	g_return_if_fail (self != NULL);
	if (self->priv->values != NULL) {
		if (self->priv->values_length1 != length) {
			gint _tmp0_;
			_tmp0_ = length;
			self->priv->values = g_renew (GValue*, self->priv->values, length);
			(_tmp0_ > self->priv->values_length1) ? memset (self->priv->values + self->priv->values_length1, 0, sizeof (GValue*) * (_tmp0_ - self->priv->values_length1)) : NULL;
			self->priv->values_length1 = _tmp0_;
			self->priv->_values_size_ = _tmp0_;
		}
	} else {
		void* _tmp1_ = NULL;
		void* m;
		_tmp1_ = g_malloc0 ((gsize) (sizeof (GValue*) * (length + 1)));
		m = _tmp1_;
		memcpy (&self->priv->values, &m, (gsize) sizeof (GValue**));
		self->priv->values_length1 = length;
	}
	if (self->priv->to_source_map != NULL) {
		gint _tmp2_;
		_tmp2_ = length;
		self->priv->to_source_map = g_renew (gint, self->priv->to_source_map, length);
		(_tmp2_ > self->priv->to_source_map_length1) ? memset (self->priv->to_source_map + self->priv->to_source_map_length1, 0, sizeof (gint) * (_tmp2_ - self->priv->to_source_map_length1)) : NULL;
		self->priv->to_source_map_length1 = _tmp2_;
		self->priv->_to_source_map_size_ = _tmp2_;
	}
}


/**
     * Handle an item in the {@link source} array moving
     *
     * This is currently not implemented.
     */
static void sql_heavy_value_array_on_parent_position_changed (SQLHeavyValueArray* self, SQLHeavyValueArray* src, gint old_index, gint new_index) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (src != NULL);
}


/**
     * Handle data in the {@link source} array being changed
     */
static void sql_heavy_value_array_on_parent_value_changed (SQLHeavyValueArray* self, SQLHeavyValueArray* src, gint index) {
	GValue* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (src != NULL);
	_tmp0_ = sql_heavy_value_array_get (src, index);
	sql_heavy_value_array_set (self, index, _tmp0_);
}


/**
     * Insert or remove padding from the array
     *
     * If members is positive, padding will be added. If elements is
     * negative, elements/padding will be removed.
     *
     * @param index to add/remove from
     * @param members number of members to add/remove
     */
void sql_heavy_value_array_insert_padding (SQLHeavyValueArray* self, gint index, gint members) {
	gint _tmp0_;
	gint old_length;
	gint new_length;
	g_return_if_fail (self != NULL);
	if (members == 0) {
		return;
	}
	_tmp0_ = sql_heavy_value_array_get_length (self);
	old_length = _tmp0_;
	new_length = old_length + members;
	if (members > 0) {
		{
			gint _tmp1_;
			gint i;
			_tmp1_ = MIN (old_length, index + members);
			i = _tmp1_;
			{
				gboolean _tmp2_;
				_tmp2_ = TRUE;
				while (TRUE) {
					if (!_tmp2_) {
						i--;
					}
					_tmp2_ = FALSE;
					if (!(i >= index)) {
						break;
					}
					g_signal_emit_by_name (self, "position-changed::before", i, i + members);
				}
			}
		}
		if (self->priv->values != NULL) {
			sql_heavy_value_array_set_values_length (self, new_length);
			if (index < old_length) {
				g_memmove ((void*) (((gulong) self->priv->values) + ((index + members) * sizeof (GValue*))), (void*) (((gulong) self->priv->values) + (index * sizeof (GValue*))), (gsize) (members * sizeof (GValue*)));
				memset ((void*) (((gulong) self->priv->values) + (index * sizeof (GValue*))), 0, (gsize) (members * sizeof (GValue*)));
				if (self->priv->to_source_map != NULL) {
					g_memmove ((void*) (((gulong) self->priv->to_source_map) + ((index + members) * sizeof (gint))), (void*) (((gulong) self->priv->to_source_map) + (index * sizeof (gint))), (gsize) (members * sizeof (gint)));
				}
			}
		} else {
			sql_heavy_value_array_set_values_length (self, new_length);
		}
		{
			gint _tmp3_;
			gint i;
			_tmp3_ = MIN (old_length, index + members);
			i = _tmp3_;
			{
				gboolean _tmp4_;
				_tmp4_ = TRUE;
				while (TRUE) {
					if (!_tmp4_) {
						i--;
					}
					_tmp4_ = FALSE;
					if (!(i >= index)) {
						break;
					}
					g_signal_emit_by_name (self, "position-changed", i, i + members);
				}
			}
		}
	} else {
		{
			gint i;
			i = index;
			{
				gboolean _tmp5_;
				_tmp5_ = TRUE;
				while (TRUE) {
					if (!_tmp5_) {
						i++;
					}
					_tmp5_ = FALSE;
					if (!(i < (index - members))) {
						break;
					}
					g_signal_emit_by_name (self, "position-changed::before", i, -1);
					sql_heavy_value_array_set (self, i, NULL);
				}
			}
		}
		{
			gint i;
			i = index - members;
			{
				gboolean _tmp6_;
				_tmp6_ = TRUE;
				while (TRUE) {
					if (!_tmp6_) {
						i++;
					}
					_tmp6_ = FALSE;
					if (!(i < old_length)) {
						break;
					}
					g_signal_emit_by_name (self, "position-changed::before", i, i + members);
				}
			}
		}
		if ((index - members) < old_length) {
			g_memmove ((void*) (((gulong) self->priv->values) + (index * sizeof (GValue*))), (void*) (((gulong) self->priv->values) + ((index - members) * sizeof (GValue*))), (gsize) (((old_length - index) + members) * sizeof (GValue*)));
			memset ((void*) (((gulong) self->priv->values) + ((old_length + members) * sizeof (GValue*))), 0, (gsize) ((-members) * sizeof (GValue*)));
			if (self->priv->to_source_map != NULL) {
				g_memmove ((void*) (((gulong) self->priv->to_source_map) + (index * sizeof (gint))), (void*) (((gulong) self->priv->to_source_map) + ((index - members) * sizeof (gint))), (gsize) (((old_length - index) + members) * sizeof (gint)));
				memset ((void*) (((gulong) self->priv->to_source_map) + ((old_length + members) * sizeof (gint))), 0, (gsize) ((-members) * sizeof (gint)));
			}
		}
		sql_heavy_value_array_set_values_length (self, new_length);
		{
			gint i;
			i = index;
			{
				gboolean _tmp7_;
				_tmp7_ = TRUE;
				while (TRUE) {
					if (!_tmp7_) {
						i++;
					}
					_tmp7_ = FALSE;
					if (!(i < (index - members))) {
						break;
					}
					g_signal_emit_by_name (self, "position-changed", i, -1);
				}
			}
		}
		{
			gint i;
			i = index - members;
			{
				gboolean _tmp8_;
				_tmp8_ = TRUE;
				while (TRUE) {
					if (!_tmp8_) {
						i++;
					}
					_tmp8_ = FALSE;
					if (!(i < old_length)) {
						break;
					}
					g_signal_emit_by_name (self, "position-changed", i, i + members);
				}
			}
		}
	}
}


/**
     * Clear all values from the array
     */
void sql_heavy_value_array_clear (SQLHeavyValueArray* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->values != NULL) {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp0_;
				_tmp0_ = TRUE;
				while (TRUE) {
					GValue* _tmp1_;
					if (!_tmp0_) {
						i++;
					}
					_tmp0_ = FALSE;
					if (!(i < self->priv->values_length1)) {
						break;
					}
					_tmp1_ = NULL;
					__vala_GValue_free0 (self->priv->values[i]);
					self->priv->values[i] = _tmp1_;
				}
			}
		}
	}
	if (self->priv->to_source_map != NULL) {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp2_;
				_tmp2_ = TRUE;
				while (TRUE) {
					if (!_tmp2_) {
						i++;
					}
					_tmp2_ = FALSE;
					if (!(i < self->priv->to_source_map_length1)) {
						break;
					}
					self->priv->to_source_map[i] = -1;
				}
			}
		}
	}
}


/**
     * Create a copy of the array
     *
     * No data will be copied unless the {@link source} array is
     * altered.
     *
     * @return a new array
     */
SQLHeavyValueArray* sql_heavy_value_array_copy (SQLHeavyValueArray* self) {
	SQLHeavyValueArray* result = NULL;
	SQLHeavyValueArray* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sql_heavy_value_array_new_with_source (self);
	result = _tmp0_;
	return result;
}


/**
     * Create a new array with the specified number of elements
     * pre-allocated
     */
SQLHeavyValueArray* sql_heavy_value_array_construct (GType object_type, gint length) {
	SQLHeavyValueArray * self = NULL;
	self = (SQLHeavyValueArray*) g_object_new (object_type, NULL);
	if (length > 0) {
		sql_heavy_value_array_insert_padding (self, 0, length);
	}
	return self;
}


SQLHeavyValueArray* sql_heavy_value_array_new (gint length) {
	return sql_heavy_value_array_construct (SQL_HEAVY_TYPE_VALUE_ARRAY, length);
}


static SQLHeavyValueArray* sql_heavy_value_array_construct_with_source (GType object_type, SQLHeavyValueArray* source) {
	SQLHeavyValueArray * self = NULL;
	g_return_val_if_fail (source != NULL, NULL);
	self = (SQLHeavyValueArray*) g_object_new (object_type, "source", source, NULL);
	return self;
}


static SQLHeavyValueArray* sql_heavy_value_array_new_with_source (SQLHeavyValueArray* source) {
	return sql_heavy_value_array_construct_with_source (SQL_HEAVY_TYPE_VALUE_ARRAY, source);
}


SQLHeavyValueArray* sql_heavy_value_array_get_source (SQLHeavyValueArray* self) {
	SQLHeavyValueArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_source;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _sql_heavy_value_array_on_parent_position_changed_sql_heavy_value_array_position_changed (SQLHeavyValueArray* _sender, gint old_index, gint new_index, gpointer self) {
	sql_heavy_value_array_on_parent_position_changed (self, _sender, old_index, new_index);
}


static void _sql_heavy_value_array_on_parent_value_changed_sql_heavy_value_array_value_changed (SQLHeavyValueArray* _sender, gint index, gpointer self) {
	sql_heavy_value_array_on_parent_value_changed (self, _sender, index);
}


void sql_heavy_value_array_set_source (SQLHeavyValueArray* self, SQLHeavyValueArray* value) {
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		gint _tmp0_;
		gint len;
		SQLHeavyValueArray* _tmp1_;
		gint* _tmp2_ = NULL;
		_tmp0_ = sql_heavy_value_array_get_length (value);
		len = _tmp0_;
		g_return_if_fail (len > 0);
		_tmp1_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_source);
		self->priv->_source = _tmp1_;
		_tmp2_ = g_new0 (gint, len);
		self->priv->to_source_map = (g_free (self->priv->to_source_map), NULL);
		self->priv->to_source_map = _tmp2_;
		self->priv->to_source_map_length1 = len;
		self->priv->_to_source_map_size_ = len;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp3_;
				_tmp3_ = TRUE;
				while (TRUE) {
					if (!_tmp3_) {
						i++;
					}
					_tmp3_ = FALSE;
					if (!(i < len)) {
						break;
					}
					self->priv->to_source_map[i] = i;
				}
			}
		}
		g_signal_connect_object (value, "position-changed::before", (GCallback) _sql_heavy_value_array_on_parent_position_changed_sql_heavy_value_array_position_changed, self, 0);
		g_signal_connect_object (value, "value-changed::before", (GCallback) _sql_heavy_value_array_on_parent_value_changed_sql_heavy_value_array_value_changed, self, 0);
	}
	g_object_notify ((GObject *) self, "source");
}


gint sql_heavy_value_array_get_length (SQLHeavyValueArray* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (self->priv->values != NULL) {
		result = self->priv->values_length1;
		return result;
	} else {
		SQLHeavyValueArray* _tmp0_ = NULL;
		_tmp0_ = sql_heavy_value_array_get_source (self);
		if (_tmp0_ != NULL) {
			SQLHeavyValueArray* _tmp1_ = NULL;
			gint _tmp2_;
			_tmp1_ = sql_heavy_value_array_get_source (self);
			_tmp2_ = sql_heavy_value_array_get_length (_tmp1_);
			result = _tmp2_;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}


static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static void sql_heavy_value_array_class_init (SQLHeavyValueArrayClass * klass) {
	sql_heavy_value_array_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SQLHeavyValueArrayPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_sql_heavy_value_array_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sql_heavy_value_array_set_property;
	G_OBJECT_CLASS (klass)->finalize = sql_heavy_value_array_finalize;
	/**
	     * The source array, or null if none
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_VALUE_ARRAY_SOURCE, g_param_spec_object ("source", "source", "source", SQL_HEAVY_TYPE_VALUE_ARRAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	     * The length of the array
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_VALUE_ARRAY_LENGTH, g_param_spec_int ("length", "length", "length", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The position of one of the elements in the array changed
	     */
	g_signal_new ("position_changed", SQL_HEAVY_TYPE_VALUE_ARRAY, G_SIGNAL_RUN_LAST | G_SIGNAL_DETAILED, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
	/**
	     * The value of one of the elements in the array changed
	     */
	g_signal_new ("value_changed", SQL_HEAVY_TYPE_VALUE_ARRAY, G_SIGNAL_RUN_LAST | G_SIGNAL_DETAILED, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}


static void sql_heavy_value_array_instance_init (SQLHeavyValueArray * self) {
	self->priv = SQL_HEAVY_VALUE_ARRAY_GET_PRIVATE (self);
	self->priv->_source = NULL;
	self->priv->to_source_map = NULL;
	self->priv->values = NULL;
}


static void sql_heavy_value_array_finalize (GObject* obj) {
	SQLHeavyValueArray * self;
	self = SQL_HEAVY_VALUE_ARRAY (obj);
	_g_object_unref0 (self->priv->_source);
	self->priv->to_source_map = (g_free (self->priv->to_source_map), NULL);
	self->priv->values = (_vala_array_free (self->priv->values, self->priv->values_length1, (GDestroyNotify) _vala_GValue_free), NULL);
	G_OBJECT_CLASS (sql_heavy_value_array_parent_class)->finalize (obj);
}


/**
   * A copy-on-write array of GValues
   */
GType sql_heavy_value_array_get_type (void) {
	static volatile gsize sql_heavy_value_array_type_id__volatile = 0;
	if (g_once_init_enter (&sql_heavy_value_array_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SQLHeavyValueArrayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sql_heavy_value_array_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SQLHeavyValueArray), 0, (GInstanceInitFunc) sql_heavy_value_array_instance_init, NULL };
		GType sql_heavy_value_array_type_id;
		sql_heavy_value_array_type_id = g_type_register_static (G_TYPE_OBJECT, "SQLHeavyValueArray", &g_define_type_info, 0);
		g_once_init_leave (&sql_heavy_value_array_type_id__volatile, sql_heavy_value_array_type_id);
	}
	return sql_heavy_value_array_type_id__volatile;
}


static void _vala_sql_heavy_value_array_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SQLHeavyValueArray * self;
	self = SQL_HEAVY_VALUE_ARRAY (object);
	switch (property_id) {
		case SQL_HEAVY_VALUE_ARRAY_SOURCE:
		g_value_set_object (value, sql_heavy_value_array_get_source (self));
		break;
		case SQL_HEAVY_VALUE_ARRAY_LENGTH:
		g_value_set_int (value, sql_heavy_value_array_get_length (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sql_heavy_value_array_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SQLHeavyValueArray * self;
	self = SQL_HEAVY_VALUE_ARRAY (object);
	switch (property_id) {
		case SQL_HEAVY_VALUE_ARRAY_SOURCE:
		sql_heavy_value_array_set_source (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



