/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg" on Wed Aug  1 15:15:05 2012

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_18 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 3890, "epsg", 3890,
        "IGRS / UTM zone 37N");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGRS / UTM zone 37N\",GEOGCS[\"IGRS\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "raqi_Geospatial_Reference_System\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1029\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"3889\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",39],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"3890\"]]");
    p = add_epsg_def (filter, first, last, 3891, "epsg", 3891,
        "IGRS / UTM zone 38N");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGRS / UTM zone 38N\",GEOGCS[\"IGRS\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "raqi_Geospatial_Reference_System\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1029\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"3889\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",45],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"3891\"]]");
    p = add_epsg_def (filter, first, last, 3892, "epsg", 3892,
        "IGRS / UTM zone 39N");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGRS / UTM zone 39N\",GEOGCS[\"IGRS\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "raqi_Geospatial_Reference_System\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1029\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"3889\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",51],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"3892\"]]");
    p = add_epsg_def (filter, first, last, 3893, "epsg", 3893,
        "ED50 / Iraq National Grid");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=29.02626833333333 +lon_0=46.5 +k=0.99");
    add_proj4text (p, 1,
        "94 +x_0=800000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,");
    add_proj4text (p, 2,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / Iraq National Grid\",GEOGCS[\"ED50\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"European_Datum_1950\",SPHEROID[\"International 1924");
    add_srs_wkt (p, 2,
        "\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87");
    add_srs_wkt (p, 3,
        ",-98,-121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",29.02626833333");
    add_srs_wkt (p, 8,
        "333],PARAMETER[\"central_meridian\",46.5],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",0.9994],PARAMETER[\"false_easting\",800000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"3893\"]]");
    p = add_epsg_def (filter, first, last, 3906, "epsg", 3906,
        "MGI 1901");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=682,-203,480,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"MGI 1901\",DATUM[\"MGI_1901\",SPHEROID[\"Bessel");
    add_srs_wkt (p, 1,
        " 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 2,
        "4\"]],TOWGS84[682,-203,480,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "1031\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"3906\"]]");
    p = add_epsg_def (filter, first, last, 3907, "epsg", 3907,
        "MGI 1901 / Balkans zone 5");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=5500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI 1901 / Balkans zone 5\",GEOGCS[\"MGI 1901\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"MGI_1901\",SPHEROID[\"Bessel 1841\",6377397.155");
    add_srs_wkt (p, 2,
        ",299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[682,-");
    add_srs_wkt (p, 3,
        "203,480,0,0,0,0],AUTHORITY[\"EPSG\",\"1031\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"3906\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",15],PARAMETER[\"scale_factor\",0.9999]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",5500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"3907\"]]");
    p = add_epsg_def (filter, first, last, 3908, "epsg", 3908,
        "MGI 1901 / Balkans zone 6");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=0.9999 +x_0=6500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI 1901 / Balkans zone 6\",GEOGCS[\"MGI 1901\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"MGI_1901\",SPHEROID[\"Bessel 1841\",6377397.155");
    add_srs_wkt (p, 2,
        ",299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[682,-");
    add_srs_wkt (p, 3,
        "203,480,0,0,0,0],AUTHORITY[\"EPSG\",\"1031\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"3906\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",18],PARAMETER[\"scale_factor\",0.9999]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",6500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"3908\"]]");
    p = add_epsg_def (filter, first, last, 3909, "epsg", 3909,
        "MGI 1901 / Balkans zone 7");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=0.9999 +x_0=7500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI 1901 / Balkans zone 7\",GEOGCS[\"MGI 1901\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"MGI_1901\",SPHEROID[\"Bessel 1841\",6377397.155");
    add_srs_wkt (p, 2,
        ",299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[682,-");
    add_srs_wkt (p, 3,
        "203,480,0,0,0,0],AUTHORITY[\"EPSG\",\"1031\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"3906\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",21],PARAMETER[\"scale_factor\",0.9999]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",7500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"3909\"]]");
    p = add_epsg_def (filter, first, last, 3910, "epsg", 3910,
        "MGI 1901 / Balkans zone 8");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9999 +x_0=8500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI 1901 / Balkans zone 8\",GEOGCS[\"MGI 1901\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"MGI_1901\",SPHEROID[\"Bessel 1841\",6377397.155");
    add_srs_wkt (p, 2,
        ",299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[682,-");
    add_srs_wkt (p, 3,
        "203,480,0,0,0,0],AUTHORITY[\"EPSG\",\"1031\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"3906\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",24],PARAMETER[\"scale_factor\",0.9999]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",8500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"3910\"]]");
    p = add_epsg_def (filter, first, last, 3911, "epsg", 3911,
        "MGI 1901 / Slovenia Grid");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI 1901 / Slovenia Grid\",GEOGCS[\"MGI 1901\",");
    add_srs_wkt (p, 1,
        "DATUM[\"MGI_1901\",SPHEROID[\"Bessel 1841\",6377397.155,");
    add_srs_wkt (p, 2,
        "299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[682,-2");
    add_srs_wkt (p, 3,
        "03,480,0,0,0,0],AUTHORITY[\"EPSG\",\"1031\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"3906\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",15],PARAMETER[\"scale_factor\",0.9999],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"3911\"]]");
    p = add_epsg_def (filter, first, last, 3912, "epsg", 3912,
        "MGI 1901 / Slovene National Grid");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=-5000000 +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI 1901 / Slovene National Grid\",GEOGCS[\"MGI");
    add_srs_wkt (p, 1,
        " 1901\",DATUM[\"MGI_1901\",SPHEROID[\"Bessel 1841\",6377");
    add_srs_wkt (p, 2,
        "397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[682,-203,480,0,0,0,0],AUTHORITY[\"EPSG\",\"1031\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"3906\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",15],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9999],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",-5000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Y\",EAST],AXIS[\"X\",NORTH],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"3912\"]]");
    p = add_epsg_def (filter, first, last, 3920, "epsg", 3920,
        "Puerto Rico / UTM zone 20N");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=clrk66 +towgs84=11,72,-101,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Puerto Rico / UTM zone 20N\",GEOGCS[\"Puerto Ri");
    add_srs_wkt (p, 1,
        "co\",DATUM[\"Puerto_Rico\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[11,72,-101,0,0,0,0],AUTHORITY[\"EPSG\",\"6139\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4139\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",-63],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"3920\"]]");
    p = add_epsg_def (filter, first, last, 3942, "epsg", 3942,
        "RGF93 / CC42");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.25 +lat_2=42.75 +lat_0=42 +lon_0=3 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=1200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 / CC42\",GEOGCS[\"RGF93\",DATUM[\"Reseau_");
    add_srs_wkt (p, 1,
        "Geodesique_Francais_1993\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6171\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4171\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"standard_parallel_1\",41.25],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"standard_parallel_2\",42.75],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",42],PARAMETER[\"central_meridian\",3],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",1700000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",1200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"3942\"]]");
    p = add_epsg_def (filter, first, last, 3943, "epsg", 3943,
        "RGF93 / CC43");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.25 +lat_2=43.75 +lat_0=43 +lon_0=3 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=2200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 / CC43\",GEOGCS[\"RGF93\",DATUM[\"Reseau_");
    add_srs_wkt (p, 1,
        "Geodesique_Francais_1993\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6171\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4171\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"standard_parallel_1\",42.25],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"standard_parallel_2\",43.75],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",43],PARAMETER[\"central_meridian\",3],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",1700000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",2200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"3943\"]]");
    p = add_epsg_def (filter, first, last, 3944, "epsg", 3944,
        "RGF93 / CC44");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.25 +lat_2=44.75 +lat_0=44 +lon_0=3 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=3200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 / CC44\",GEOGCS[\"RGF93\",DATUM[\"Reseau_");
    add_srs_wkt (p, 1,
        "Geodesique_Francais_1993\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6171\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4171\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"standard_parallel_1\",43.25],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"standard_parallel_2\",44.75],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",44],PARAMETER[\"central_meridian\",3],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",1700000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",3200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"3944\"]]");
    p = add_epsg_def (filter, first, last, 3945, "epsg", 3945,
        "RGF93 / CC45");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.25 +lat_2=45.75 +lat_0=45 +lon_0=3 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=4200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 / CC45\",GEOGCS[\"RGF93\",DATUM[\"Reseau_");
    add_srs_wkt (p, 1,
        "Geodesique_Francais_1993\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6171\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4171\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"standard_parallel_1\",44.25],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"standard_parallel_2\",45.75],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",45],PARAMETER[\"central_meridian\",3],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",1700000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",4200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"3945\"]]");
    p = add_epsg_def (filter, first, last, 3946, "epsg", 3946,
        "RGF93 / CC46");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.25 +lat_2=46.75 +lat_0=46 +lon_0=3 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=5200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 / CC46\",GEOGCS[\"RGF93\",DATUM[\"Reseau_");
    add_srs_wkt (p, 1,
        "Geodesique_Francais_1993\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6171\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4171\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"standard_parallel_1\",45.25],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"standard_parallel_2\",46.75],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",46],PARAMETER[\"central_meridian\",3],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",1700000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",5200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"3946\"]]");
    p = add_epsg_def (filter, first, last, 3947, "epsg", 3947,
        "RGF93 / CC47");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.25 +lat_2=47.75 +lat_0=47 +lon_0=3 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=6200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 / CC47\",GEOGCS[\"RGF93\",DATUM[\"Reseau_");
    add_srs_wkt (p, 1,
        "Geodesique_Francais_1993\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6171\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4171\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"standard_parallel_1\",46.25],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"standard_parallel_2\",47.75],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",47],PARAMETER[\"central_meridian\",3],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",1700000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",6200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"3947\"]]");
    p = add_epsg_def (filter, first, last, 3948, "epsg", 3948,
        "RGF93 / CC48");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.25 +lat_2=48.75 +lat_0=48 +lon_0=3 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=7200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 / CC48\",GEOGCS[\"RGF93\",DATUM[\"Reseau_");
    add_srs_wkt (p, 1,
        "Geodesique_Francais_1993\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6171\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4171\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"standard_parallel_1\",47.25],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"standard_parallel_2\",48.75],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",48],PARAMETER[\"central_meridian\",3],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",1700000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",7200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"3948\"]]");
    p = add_epsg_def (filter, first, last, 3949, "epsg", 3949,
        "RGF93 / CC49");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.25 +lat_2=49.75 +lat_0=49 +lon_0=3 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=8200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 / CC49\",GEOGCS[\"RGF93\",DATUM[\"Reseau_");
    add_srs_wkt (p, 1,
        "Geodesique_Francais_1993\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6171\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4171\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"standard_parallel_1\",48.25],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"standard_parallel_2\",49.75],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",49],PARAMETER[\"central_meridian\",3],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",1700000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",8200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"3949\"]]");
    p = add_epsg_def (filter, first, last, 3950, "epsg", 3950,
        "RGF93 / CC50");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.25 +lat_2=50.75 +lat_0=50 +lon_0=3 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=9200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 / CC50\",GEOGCS[\"RGF93\",DATUM[\"Reseau_");
    add_srs_wkt (p, 1,
        "Geodesique_Francais_1993\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6171\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4171\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"standard_parallel_1\",49.25],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"standard_parallel_2\",50.75],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",50],PARAMETER[\"central_meridian\",3],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",1700000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",9200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"3950\"]]");
    p = add_epsg_def (filter, first, last, 3968, "epsg", 3968,
        "NAD83 / Virginia Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37 +lat_2=39.5 +lat_0=36 +lon_0=-79.5 +");
    add_proj4text (p, 1,
        "x_0=0 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Virginia Lambert\",GEOGCS[\"NAD83\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",37],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",39.5],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",36],PARAMETER[\"central_meridian\",-79.5],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",0],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"39");
    add_srs_wkt (p, 13,
        "68\"]]");
    p = add_epsg_def (filter, first, last, 3969, "epsg", 3969,
        "NAD83(HARN) / Virginia Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37 +lat_2=39.5 +lat_0=36 +lon_0=-79.5 +");
    add_proj4text (p, 1,
        "x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Virginia Lambert\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"stand");
    add_srs_wkt (p, 8,
        "ard_parallel_1\",37],PARAMETER[\"standard_parallel_2\",3");
    add_srs_wkt (p, 9,
        "9.5],PARAMETER[\"latitude_of_origin\",36],PARAMETER[\"ce");
    add_srs_wkt (p, 10,
        "ntral_meridian\",-79.5],PARAMETER[\"false_easting\",0],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"3969\"]]");
    p = add_epsg_def (filter, first, last, 3970, "epsg", 3970,
        "NAD83(NSRS2007) / Virginia Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37 +lat_2=39.5 +lat_0=36 +lon_0=-79.5 +");
    add_proj4text (p, 1,
        "x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Virginia Lambert\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"standard_parallel_1\",37],PARAMETER[\"standar");
    add_srs_wkt (p, 9,
        "d_parallel_2\",39.5],PARAMETER[\"latitude_of_origin\",36");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"central_meridian\",-79.5],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 12,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3970\"]]");
    p = add_epsg_def (filter, first, last, 3973, "epsg", 3973,
        "WGS 84 / NSIDC EASE-Grid North");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +datum=WGS84");
    add_proj4text (p, 1,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / NSIDC EASE-Grid North\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Azimuthal_Equal_Area\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_center\",90],PARAMETER[\"longitude_of_center\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"false_easting\",0],PARAMETER[\"false_northing");
    add_srs_wkt (p, 9,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 10,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"397");
    add_srs_wkt (p, 11,
        "3\"]]");
    p = add_epsg_def (filter, first, last, 3974, "epsg", 3974,
        "WGS 84 / NSIDC EASE-Grid South");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=-90 +lon_0=0 +x_0=0 +y_0=0 +datum=WGS8");
    add_proj4text (p, 1,
        "4 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / NSIDC EASE-Grid South\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Azimuthal_Equal_Area\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_center\",-90],PARAMETER[\"longitude_of_center\",0],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"false_easting\",0],PARAMETER[\"false_northin");
    add_srs_wkt (p, 9,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 10,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"39");
    add_srs_wkt (p, 11,
        "74\"]]");
    p = add_epsg_def (filter, first, last, 3975, "epsg", 3975,
        "WGS 84 / NSIDC EASE-Grid Global");
    add_proj4text (p, 0,
        "+proj=cea +lon_0=0 +lat_ts=30 +x_0=0 +y_0=0 +datum=WGS84");
    add_proj4text (p, 1,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / NSIDC EASE-Grid Global\",GEOGCS[\"WGS ");
    add_srs_wkt (p, 1,
        "84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.");
    add_srs_wkt (p, 2,
        "257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJEC");
    add_srs_wkt (p, 6,
        "TION[\"Cylindrical_Equal_Area\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 7,
        "rallel_1\",30],PARAMETER[\"central_meridian\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 9,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 10,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3975\"]]");
    p = add_epsg_def (filter, first, last, 3976, "epsg", 3976,
        "WGS 84 / NSIDC Sea Ice Polar Stereographic South");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-70 +lon_0=0 +k=1 +x_0=0 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / NSIDC Sea Ice Polar Stereographic Sout");
    add_srs_wkt (p, 1,
        "h\",GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS ");
    add_srs_wkt (p, 2,
        "84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4326\"]],PROJECTION[\"Polar_Stereographic\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",-70],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 8,
        "n\",0],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3976\"]]");
    p = add_epsg_def (filter, first, last, 3978, "epsg", 3978,
        "NAD83 / Canada Atlas Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49 +lat_2=77 +lat_0=49 +lon_0=-95 +x_0=");
    add_proj4text (p, 1,
        "0 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Canada Atlas Lambert\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",49");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_2\",77],PARAMETER[\"lati");
    add_srs_wkt (p, 9,
        "tude_of_origin\",49],PARAMETER[\"central_meridian\",-95]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",0],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"3978\"]]");
    p = add_epsg_def (filter, first, last, 3979, "epsg", 3979,
        "NAD83(CSRS) / Canada Atlas Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49 +lat_2=77 +lat_0=49 +lon_0=-95 +x_0=");
    add_proj4text (p, 1,
        "0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / Canada Atlas Lambert\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "standard_parallel_1\",49],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 9,
        "2\",77],PARAMETER[\"latitude_of_origin\",49],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "central_meridian\",-95],PARAMETER[\"false_easting\",0],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 13,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"3979\"]]");
    p = add_epsg_def (filter, first, last, 3985, "epsg", 3985,
        "Katanga 1955 / Katanga Lambert (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-6.5 +lat_2=-11.5 +lat_0=9 +lon_0=26 +x");
    add_proj4text (p, 1,
        "_0=500000 +y_0=500000 +ellps=clrk66 +towgs84=-103.746,-9");
    add_proj4text (p, 2,
        ".614,-255.95,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Katanga 1955 / Katanga Lambert (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Katanga 1955\",DATUM[\"Katanga_1955\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7008\"]],TOWGS84[-103.746,-9.614,-255.95,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6695\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4695\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"standard_parallel_1\",-6.5],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_2\",-11.5],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",9],PARAMETER[\"central_meridian\",26],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_easting\",500000],PARAMETER[\"false_northing\",500000],");
    add_srs_wkt (p, 12,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3985\"]]");
    p = add_epsg_def (filter, first, last, 3986, "epsg", 3986,
        "Katanga 1955 / Katanga Gauss zone A");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-9 +lon_0=30 +k=1 +x_0=200000 +y_0=50");
    add_proj4text (p, 1,
        "0000 +ellps=clrk66 +towgs84=-103.746,-9.614,-255.95,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Katanga 1955 / Katanga Gauss zone A\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Katanga 1955\",DATUM[\"Katanga_1955\",SPHEROID[\"Clarke ");
    add_srs_wkt (p, 2,
        "1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7008\"]],TOWGS84[-103.746,-9.614,-255.95,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6695\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4695\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",-9],PARAMETER[\"central_meridian\",30],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",200000],PARAMETER[\"false_northing\",500000],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3986\"]]");
    p = add_epsg_def (filter, first, last, 3987, "epsg", 3987,
        "Katanga 1955 / Katanga Gauss zone B");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-9 +lon_0=28 +k=1 +x_0=200000 +y_0=50");
    add_proj4text (p, 1,
        "0000 +ellps=clrk66 +towgs84=-103.746,-9.614,-255.95,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Katanga 1955 / Katanga Gauss zone B\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Katanga 1955\",DATUM[\"Katanga_1955\",SPHEROID[\"Clarke ");
    add_srs_wkt (p, 2,
        "1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7008\"]],TOWGS84[-103.746,-9.614,-255.95,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6695\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4695\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",-9],PARAMETER[\"central_meridian\",28],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",200000],PARAMETER[\"false_northing\",500000],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3987\"]]");
    p = add_epsg_def (filter, first, last, 3988, "epsg", 3988,
        "Katanga 1955 / Katanga Gauss zone C");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-9 +lon_0=26 +k=1 +x_0=200000 +y_0=50");
    add_proj4text (p, 1,
        "0000 +ellps=clrk66 +towgs84=-103.746,-9.614,-255.95,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Katanga 1955 / Katanga Gauss zone C\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Katanga 1955\",DATUM[\"Katanga_1955\",SPHEROID[\"Clarke ");
    add_srs_wkt (p, 2,
        "1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7008\"]],TOWGS84[-103.746,-9.614,-255.95,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6695\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4695\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",-9],PARAMETER[\"central_meridian\",26],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",200000],PARAMETER[\"false_northing\",500000],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3988\"]]");
    p = add_epsg_def (filter, first, last, 3989, "epsg", 3989,
        "Katanga 1955 / Katanga Gauss zone D");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-9 +lon_0=24 +k=1 +x_0=200000 +y_0=50");
    add_proj4text (p, 1,
        "0000 +ellps=clrk66 +towgs84=-103.746,-9.614,-255.95,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Katanga 1955 / Katanga Gauss zone D\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Katanga 1955\",DATUM[\"Katanga_1955\",SPHEROID[\"Clarke ");
    add_srs_wkt (p, 2,
        "1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7008\"]],TOWGS84[-103.746,-9.614,-255.95,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6695\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4695\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",-9],PARAMETER[\"central_meridian\",24],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",200000],PARAMETER[\"false_northing\",500000],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3989\"]]");
    p = add_epsg_def (filter, first, last, 3991, "epsg", 3991,
        "Puerto Rico State Plane CS of 1927");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=18.43333333333333 +lat_2=18.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=17.83333333333333 +lon_0=-66.43333333333334 +");
    add_proj4text (p, 2,
        "x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +towgs84=11,7");
    add_proj4text (p, 3,
        "2,-101,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Puerto Rico State Plane CS of 1927\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "uerto Rico\",DATUM[\"Puerto_Rico\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],TOWGS84[11,72,-101,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "139\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4139\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 8,
        "llel_1\",18.43333333333333],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 9,
        "l_2\",18.03333333333333],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",17.83333333333333],PARAMETER[\"central_meridian\",-66.4");
    add_srs_wkt (p, 11,
        "3333333333334],PARAMETER[\"false_easting\",500000],PARAM");
    add_srs_wkt (p, 12,
        "ETER[\"false_northing\",0],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 13,
        "8006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 14,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3991\"]]");
    p = add_epsg_def (filter, first, last, 3992, "epsg", 3992,
        "Puerto Rico / St. Croix");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=18.43333333333333 +lat_2=18.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=17.83333333333333 +lon_0=-66.43333333333334 +");
    add_proj4text (p, 2,
        "x_0=152400.3048006096 +y_0=30480.06096012192 +ellps=clrk");
    add_proj4text (p, 3,
        "66 +towgs84=11,72,-101,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Puerto Rico / St. Croix\",GEOGCS[\"Puerto Rico\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Puerto_Rico\",SPHEROID[\"Clarke 1866\",6378206.");
    add_srs_wkt (p, 2,
        "4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[11,72,-101,0,0,0,0],AUTHORITY[\"EPSG\",\"6139\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4139\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",18");
    add_srs_wkt (p, 8,
        ".43333333333333],PARAMETER[\"standard_parallel_2\",18.03");
    add_srs_wkt (p, 9,
        "333333333333],PARAMETER[\"latitude_of_origin\",17.833333");
    add_srs_wkt (p, 10,
        "33333333],PARAMETER[\"central_meridian\",-66.43333333333");
    add_srs_wkt (p, 11,
        "334],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 12,
        "se_northing\",100000],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 13,
        "96012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],");
    add_srs_wkt (p, 14,
        "AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3992\"]]");
    p = add_epsg_def (filter, first, last, 3994, "epsg", 3994,
        "WGS 84 / Mercator 41");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=100 +lat_ts=-41 +x_0=0 +y_0=0 +datum=W");
    add_proj4text (p, 1,
        "GS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Mercator 41\",GEOGCS[\"WGS 84\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Merc");
    add_srs_wkt (p, 6,
        "ator_2SP\"],PARAMETER[\"standard_parallel_1\",-41],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"central_meridian\",100],PARAMETER[\"false_easting");
    add_srs_wkt (p, 8,
        "\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 9,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 10,
        ",NORTH],AUTHORITY[\"EPSG\",\"3994\"]]");
    p = add_epsg_def (filter, first, last, 3995, "epsg", 3995,
        "WGS 84 / Arctic Polar Stereographic");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=71 +lon_0=0 +k=1 +x_0=0 +y");
    add_proj4text (p, 1,
        "_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Arctic Polar Stereographic\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,");
    add_srs_wkt (p, 2,
        "298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PR");
    add_srs_wkt (p, 6,
        "OJECTION[\"Polar_Stereographic\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",71],PARAMETER[\"central_meridian\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"3995\"]]");
    p = add_epsg_def (filter, first, last, 3996, "epsg", 3996,
        "WGS 84 / IBCAO Polar Stereographic");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=75 +lon_0=0 +k=1 +x_0=0 +y");
    add_proj4text (p, 1,
        "_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / IBCAO Polar Stereographic\",GEOGCS[\"W");
    add_srs_wkt (p, 1,
        "GS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Polar_Stereographic\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",75],PARAMETER[\"central_meridian\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 10,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"3996\"]]");
    p = add_epsg_def (filter, first, last, 3997, "epsg", 3997,
        "WGS 84 / Dubai Local TM");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=55.33333333333334 +k=1 +x_0=");
    add_proj4text (p, 1,
        "500000 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Dubai Local TM\",GEOGCS[\"WGS 84\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.25722356");
    add_srs_wkt (p, 2,
        "3,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"632");
    add_srs_wkt (p, 3,
        "6\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"T");
    add_srs_wkt (p, 6,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"central_meridian\",55.33333333333334],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3997\"]]");
    p = add_epsg_def (filter, first, last, 4001, "epsg", 4001,
        "Unknown datum based upon the Airy 1830 ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=airy +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Airy 1830 ellipsoi");
    add_srs_wkt (p, 1,
        "d\",DATUM[\"Not_specified_based_on_Airy_1830_ellipsoid\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Airy 1830\",6377563.396,299.3249646,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7001\"]],AUTHORITY[\"EPSG\",\"6001\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4001\"]]");
    p = add_epsg_def (filter, first, last, 4002, "epsg", 4002,
        "Unknown datum based upon the Airy Modified 1849 ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=mod_airy +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Airy Modified 1849");
    add_srs_wkt (p, 1,
        " ellipsoid\",DATUM[\"Not_specified_based_on_Airy_Modifie");
    add_srs_wkt (p, 2,
        "d_1849_ellipsoid\",SPHEROID[\"Airy Modified 1849\",63773");
    add_srs_wkt (p, 3,
        "40.189,299.3249646,AUTHORITY[\"EPSG\",\"7002\"]],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6002\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4002\"");
    add_srs_wkt (p, 7,
        "]]");
    p = add_epsg_def (filter, first, last, 4003, "epsg", 4003,
        "Unknown datum based upon the Australian National Spheroid");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=aust_SA +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Australian Nationa");
    add_srs_wkt (p, 1,
        "l Spheroid\",DATUM[\"Not_specified_based_on_Australian_N");
    add_srs_wkt (p, 2,
        "ational_Spheroid\",SPHEROID[\"Australian National Sphero");
    add_srs_wkt (p, 3,
        "id\",6378160,298.25,AUTHORITY[\"EPSG\",\"7003\"]],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6003\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4003\"");
    add_srs_wkt (p, 7,
        "]]");
    p = add_epsg_def (filter, first, last, 4004, "epsg", 4004,
        "Unknown datum based upon the Bessel 1841 ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Bessel 1841 ellips");
    add_srs_wkt (p, 1,
        "oid\",DATUM[\"Not_specified_based_on_Bessel_1841_ellipso");
    add_srs_wkt (p, 2,
        "id\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6004\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4004\"]]");
    p = add_epsg_def (filter, first, last, 4005, "epsg", 4005,
        "Unknown datum based upon the Bessel Modified ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377492.018 +b=6356173.508712696 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Bessel Modified el");
    add_srs_wkt (p, 1,
        "lipsoid\",DATUM[\"Not_specified_based_on_Bessel_Modified");
    add_srs_wkt (p, 2,
        "_ellipsoid\",SPHEROID[\"Bessel Modified\",6377492.018,29");
    add_srs_wkt (p, 3,
        "9.1528128,AUTHORITY[\"EPSG\",\"7005\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6005\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4005\"]]");
    p = add_epsg_def (filter, first, last, 4006, "epsg", 4006,
        "Unknown datum based upon the Bessel Namibia ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bess_nam +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Bessel Namibia ell");
    add_srs_wkt (p, 1,
        "ipsoid\",DATUM[\"Not_specified_based_on_Bessel_Namibia_e");
    add_srs_wkt (p, 2,
        "llipsoid\",SPHEROID[\"Bessel Namibia (GLM)\",6377483.865");
    add_srs_wkt (p, 3,
        "280419,299.1528128,AUTHORITY[\"EPSG\",\"7046\"]],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6006\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4006\"");
    add_srs_wkt (p, 7,
        "]]");
    p = add_epsg_def (filter, first, last, 4007, "epsg", 4007,
        "Unknown datum based upon the Clarke 1858 ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378293.645208759 +b=6356617.987679838 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Clarke 1858 ellips");
    add_srs_wkt (p, 1,
        "oid\",DATUM[\"Not_specified_based_on_Clarke_1858_ellipso");
    add_srs_wkt (p, 2,
        "id\",SPHEROID[\"Clarke 1858\",6378293.645208759,294.2606");
    add_srs_wkt (p, 3,
        "763692654,AUTHORITY[\"EPSG\",\"7007\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6007\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4007\"]]");
    p = add_epsg_def (filter, first, last, 4008, "epsg", 4008,
        "Unknown datum based upon the Clarke 1866 ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Clarke 1866 ellips");
    add_srs_wkt (p, 1,
        "oid\",DATUM[\"Not_specified_based_on_Clarke_1866_ellipso");
    add_srs_wkt (p, 2,
        "id\",SPHEROID[\"Clarke 1866\",6378206.4,294.978698213898");
    add_srs_wkt (p, 3,
        "2,AUTHORITY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"600");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4008\"]]");
    p = add_epsg_def (filter, first, last, 4009, "epsg", 4009,
        "Unknown datum based upon the Clarke 1866 Michigan ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378450.047548896 +b=6356826.621488444 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Clarke 1866 Michig");
    add_srs_wkt (p, 1,
        "an ellipsoid\",DATUM[\"Not_specified_based_on_Clarke_186");
    add_srs_wkt (p, 2,
        "6_Michigan_ellipsoid\",SPHEROID[\"Clarke 1866 Michigan\"");
    add_srs_wkt (p, 3,
        ",6378450.047548896,294.9786971646747,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"7009\"]],AUTHORITY[\"EPSG\",\"6009\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 5,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 6,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4009\"]]");
    p = add_epsg_def (filter, first, last, 4010, "epsg", 4010,
        "Unknown datum based upon the Clarke 1880 (Benoit) ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378300.789 +b=6356566.435 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Clarke 1880 (Benoi");
    add_srs_wkt (p, 1,
        "t) ellipsoid\",DATUM[\"Not_specified_based_on_Clarke_188");
    add_srs_wkt (p, 2,
        "0_Benoit_ellipsoid\",SPHEROID[\"Clarke 1880 (Benoit)\",6");
    add_srs_wkt (p, 3,
        "378300.789,293.4663155389811,AUTHORITY[\"EPSG\",\"7010\"");
    add_srs_wkt (p, 4,
        "]],AUTHORITY[\"EPSG\",\"6010\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4010\"]]");
    p = add_epsg_def (filter, first, last, 4011, "epsg", 4011,
        "Unknown datum based upon the Clarke 1880 (IGN) ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Clarke 1880 (IGN) ");
    add_srs_wkt (p, 1,
        "ellipsoid\",DATUM[\"Not_specified_based_on_Clarke_1880_I");
    add_srs_wkt (p, 2,
        "GN_ellipsoid\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,");
    add_srs_wkt (p, 3,
        "293.4660212936269,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"6011\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4011\"]]");
    p = add_epsg_def (filter, first, last, 4012, "epsg", 4012,
        "Unknown datum based upon the Clarke 1880 (RGS) ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Clarke 1880 (RGS) ");
    add_srs_wkt (p, 1,
        "ellipsoid\",DATUM[\"Not_specified_based_on_Clarke_1880_R");
    add_srs_wkt (p, 2,
        "GS_ellipsoid\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 3,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6012\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4012\"]]");
    p = add_epsg_def (filter, first, last, 4013, "epsg", 4013,
        "Unknown datum based upon the Clarke 1880 (Arc) ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.145 +b=6356514.966398753 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Clarke 1880 (Arc) ");
    add_srs_wkt (p, 1,
        "ellipsoid\",DATUM[\"Not_specified_based_on_Clarke_1880_A");
    add_srs_wkt (p, 2,
        "rc_ellipsoid\",SPHEROID[\"Clarke 1880 (Arc)\",6378249.14");
    add_srs_wkt (p, 3,
        "5,293.4663077,AUTHORITY[\"EPSG\",\"7013\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6013\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4013\"]]");
    p = add_epsg_def (filter, first, last, 4014, "epsg", 4014,
        "Unknown datum based upon the Clarke 1880 (SGA 1922) ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356514.996941779 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Clarke 1880 (SGA 1");
    add_srs_wkt (p, 1,
        "922) ellipsoid\",DATUM[\"Not_specified_based_on_Clarke_1");
    add_srs_wkt (p, 2,
        "880_SGA_1922_ellipsoid\",SPHEROID[\"Clarke 1880 (SGA 192");
    add_srs_wkt (p, 3,
        "2)\",6378249.2,293.46598,AUTHORITY[\"EPSG\",\"7014\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6014\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4014\"]]");
    p = add_epsg_def (filter, first, last, 4015, "epsg", 4015,
        "Unknown datum based upon the Everest 1830 (1937 Adjustment) ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377276.345 +b=6356075.413140239 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Everest 1830 (1937");
    add_srs_wkt (p, 1,
        " Adjustment) ellipsoid\",DATUM[\"Not_specified_based_on_");
    add_srs_wkt (p, 2,
        "Everest_1830_1937_Adjustment_ellipsoid\",SPHEROID[\"Ever");
    add_srs_wkt (p, 3,
        "est 1830 (1937 Adjustment)\",6377276.345,300.8017,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"7015\"]],AUTHORITY[\"EPSG\",\"6015\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AUTHORITY[\"EPSG\",\"4015\"]]");
    p = add_epsg_def (filter, first, last, 4016, "epsg", 4016,
        "Unknown datum based upon the Everest 1830 (1967 Definition) ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=evrstSS +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Everest 1830 (1967");
    add_srs_wkt (p, 1,
        " Definition) ellipsoid\",DATUM[\"Not_specified_based_on_");
    add_srs_wkt (p, 2,
        "Everest_1830_1967_Definition_ellipsoid\",SPHEROID[\"Ever");
    add_srs_wkt (p, 3,
        "est 1830 (1967 Definition)\",6377298.556,300.8017,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"7016\"]],AUTHORITY[\"EPSG\",\"6016\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AUTHORITY[\"EPSG\",\"4016\"]]");
    p = add_epsg_def (filter, first, last, 4018, "epsg", 4018,
        "Unknown datum based upon the Everest 1830 Modified ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377304.063 +b=6356103.038993155 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Everest 1830 Modif");
    add_srs_wkt (p, 1,
        "ied ellipsoid\",DATUM[\"Not_specified_based_on_Everest_1");
    add_srs_wkt (p, 2,
        "830_Modified_ellipsoid\",SPHEROID[\"Everest 1830 Modifie");
    add_srs_wkt (p, 3,
        "d\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"7018\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6018\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4018\"]]");
    p = add_epsg_def (filter, first, last, 4019, "epsg", 4019,
        "Unknown datum based upon the GRS 1980 ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the GRS 1980 ellipsoid");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Not_specified_based_on_GRS_1980_ellipsoid\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6019\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4019\"]]");
    p = add_epsg_def (filter, first, last, 4020, "epsg", 4020,
        "Unknown datum based upon the Helmert 1906 ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=helmert +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Helmert 1906 ellip");
    add_srs_wkt (p, 1,
        "soid\",DATUM[\"Not_specified_based_on_Helmert_1906_ellip");
    add_srs_wkt (p, 2,
        "soid\",SPHEROID[\"Helmert 1906\",6378200,298.3,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7020\"]],AUTHORITY[\"EPSG\",\"6020\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4020\"]]");
    p = add_epsg_def (filter, first, last, 4021, "epsg", 4021,
        "Unknown datum based upon the Indonesian National Spheroid");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378160 +b=6356774.50408554 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Indonesian Nationa");
    add_srs_wkt (p, 1,
        "l Spheroid\",DATUM[\"Not_specified_based_on_Indonesian_N");
    add_srs_wkt (p, 2,
        "ational_Spheroid\",SPHEROID[\"Indonesian National Sphero");
    add_srs_wkt (p, 3,
        "id\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6021\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4021");
    add_srs_wkt (p, 7,
        "\"]]");
    p = add_epsg_def (filter, first, last, 4022, "epsg", 4022,
        "Unknown datum based upon the International 1924 ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the International 1924");
    add_srs_wkt (p, 1,
        " ellipsoid\",DATUM[\"Not_specified_based_on_Internationa");
    add_srs_wkt (p, 2,
        "l_1924_ellipsoid\",SPHEROID[\"International 1924\",63783");
    add_srs_wkt (p, 3,
        "88,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6022\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4022\"]]");
    p = add_epsg_def (filter, first, last, 4023, "epsg", 4023,
        "MOLDREF99");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"MOLDREF99\",DATUM[\"MOLDREF99\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 1,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 2,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1032\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AUTHORITY[\"EPSG\",\"4023\"]]");
    p = add_epsg_def (filter, first, last, 4024, "epsg", 4024,
        "Unknown datum based upon the Krassowsky 1940 ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Krassowsky 1940 el");
    add_srs_wkt (p, 1,
        "lipsoid\",DATUM[\"Not_specified_based_on_Krassowsky_1940");
    add_srs_wkt (p, 2,
        "_ellipsoid\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"EPSG\",\"6024\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4024\"]]");
    p = add_epsg_def (filter, first, last, 4025, "epsg", 4025,
        "Unknown datum based upon the NWL 9D ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS66 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the NWL 9D ellipsoid\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Not_specified_based_on_NWL_9D_ellipsoid\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"NWL 9D\",6378145,298.25,AUTHORITY[\"EPSG\",\"7025\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6025\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4025\"]]");
    p = add_epsg_def (filter, first, last, 4026, "epsg", 4026,
        "MOLDREF99 / Moldova TM");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=28.4 +k=0.9999400000000001 +");
    add_proj4text (p, 1,
        "x_0=200000 +y_0=-5000000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MOLDREF99 / Moldova TM\",GEOGCS[\"MOLDREF99\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"MOLDREF99\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 3,
        ",0],AUTHORITY[\"EPSG\",\"1032\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 5,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"4023\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 7,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 8,
        "an\",28.4],PARAMETER[\"scale_factor\",0.99994],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",200000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "-5000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "4026\"]]");
    p = add_epsg_def (filter, first, last, 4027, "epsg", 4027,
        "Unknown datum based upon the Plessis 1817 ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +a=6376523 +b=6355862.933255573 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Plessis 1817 ellip");
    add_srs_wkt (p, 1,
        "soid\",DATUM[\"Not_specified_based_on_Plessis_1817_ellip");
    add_srs_wkt (p, 2,
        "soid\",SPHEROID[\"Plessis 1817\",6376523,308.64,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7027\"]],AUTHORITY[\"EPSG\",\"6027\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4027\"]]");
    p = add_epsg_def (filter, first, last, 4028, "epsg", 4028,
        "Unknown datum based upon the Struve 1860 ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378298.3 +b=6356657.142669562 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Struve 1860 ellips");
    add_srs_wkt (p, 1,
        "oid\",DATUM[\"Not_specified_based_on_Struve_1860_ellipso");
    add_srs_wkt (p, 2,
        "id\",SPHEROID[\"Struve 1860\",6378298.3,294.73,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7028\"]],AUTHORITY[\"EPSG\",\"6028\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4028\"]]");
    p = add_epsg_def (filter, first, last, 4029, "epsg", 4029,
        "Unknown datum based upon the War Office ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378300 +b=6356751.689189189 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the War Office ellipso");
    add_srs_wkt (p, 1,
        "id\",DATUM[\"Not_specified_based_on_War_Office_ellipsoid");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"War Office\",6378300,296,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7029\"]],AUTHORITY[\"EPSG\",\"6029\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4029\"]]");
    p = add_epsg_def (filter, first, last, 4030, "epsg", 4030,
        "Unknown datum based upon the WGS 84 ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the WGS 84 ellipsoid\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Not_specified_based_on_WGS_84_ellipsoid\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7030\"]],AUTHORITY[\"EPSG\",\"6030\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4030\"]]");
    p = add_epsg_def (filter, first, last, 4031, "epsg", 4031,
        "Unknown datum based upon the GEM 10C ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the GEM 10C ellipsoid\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Not_specified_based_on_GEM_10C_ellipsoid\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GEM 10C\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7031\"]],AUTHORITY[\"EPSG\",\"6031\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4031\"]]");
    p = add_epsg_def (filter, first, last, 4032, "epsg", 4032,
        "Unknown datum based upon the OSU86F ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378136.2 +b=6356751.516927429 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the OSU86F ellipsoid\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Not_specified_based_on_OSU86F_ellipsoid\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"OSU86F\",6378136.2,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7032\"]],AUTHORITY[\"EPSG\",\"6032\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4032\"]]");
    p = add_epsg_def (filter, first, last, 4033, "epsg", 4033,
        "Unknown datum based upon the OSU91A ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378136.3 +b=6356751.616592146 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the OSU91A ellipsoid\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Not_specified_based_on_OSU91A_ellipsoid\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"OSU91A\",6378136.3,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7033\"]],AUTHORITY[\"EPSG\",\"6033\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4033\"]]");
    p = add_epsg_def (filter, first, last, 4034, "epsg", 4034,
        "Unknown datum based upon the Clarke 1880 ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.144808011 +b=6356514.966204134 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Clarke 1880 ellips");
    add_srs_wkt (p, 1,
        "oid\",DATUM[\"Not_specified_based_on_Clarke_1880_ellipso");
    add_srs_wkt (p, 2,
        "id\",SPHEROID[\"Clarke 1880\",6378249.144808011,293.4663");
    add_srs_wkt (p, 3,
        "076556303,AUTHORITY[\"EPSG\",\"7034\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6034\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4034\"]]");
    p = add_epsg_def (filter, first, last, 4035, "epsg", 4035,
        "Unknown datum based upon the Authalic Sphere");
    add_proj4text (p, 0,
        "+proj=longlat +a=6371000 +b=6371000 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Authalic Sphere\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Not_specified_based_on_Authalic_Sphere\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"Sphere\",6371000,0,AUTHORITY[\"EPSG\",\"7035\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6035\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\",\"40");
    add_srs_wkt (p, 6,
        "35\"]]");
    p = add_epsg_def (filter, first, last, 4036, "epsg", 4036,
        "Unknown datum based upon the GRS 1967 ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS67 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the GRS 1967 ellipsoid");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Not_specified_based_on_GRS_1967_ellipsoid\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1967\",6378160,298.247167427,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7036\"]],AUTHORITY[\"EPSG\",\"6036\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4036\"]]");
    p = add_epsg_def (filter, first, last, 4037, "epsg", 4037,
        "WGS 84 / TMzn35N");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / TMzn35N\",GEOGCS[\"WGS 84\",DATUM[\"WG");
    add_srs_wkt (p, 1,
        "S_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 6,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"central_meridian\",27],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 8,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 10,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AUTHORITY[\"EPSG\",\"4037\"]]");
    p = add_epsg_def (filter, first, last, 4038, "epsg", 4038,
        "WGS 84 / TMzn36N");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / TMzn36N\",GEOGCS[\"WGS 84\",DATUM[\"WG");
    add_srs_wkt (p, 1,
        "S_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 6,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"central_meridian\",33],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 8,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 10,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AUTHORITY[\"EPSG\",\"4038\"]]");
    p = add_epsg_def (filter, first, last, 4041, "epsg", 4041,
        "Unknown datum based upon the Average Terrestrial System 1977 ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378135 +b=6356750.304921594 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Average Terrestria");
    add_srs_wkt (p, 1,
        "l System 1977 ellipsoid\",DATUM[\"Not_specified_based_on");
    add_srs_wkt (p, 2,
        "_Average_Terrestrial_System_1977_ellipsoid\",SPHEROID[\"");
    add_srs_wkt (p, 3,
        "Average Terrestrial System 1977\",6378135,298.257,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"7041\"]],AUTHORITY[\"EPSG\",\"6041\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AUTHORITY[\"EPSG\",\"4041\"]]");
    p = add_epsg_def (filter, first, last, 4042, "epsg", 4042,
        "Unknown datum based upon the Everest (1830 Definition) ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377299.36559538 +b=6356098.359005156 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Everest (1830 Defi");
    add_srs_wkt (p, 1,
        "nition) ellipsoid\",DATUM[\"Not_specified_based_on_Evere");
    add_srs_wkt (p, 2,
        "st_1830_Definition_ellipsoid\",SPHEROID[\"Everest (1830 ");
    add_srs_wkt (p, 3,
        "Definition)\",6377299.36559538,300.8017255433612,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"7042\"]],AUTHORITY[\"EPSG\",\"6042\"]],PRI");
    add_srs_wkt (p, 5,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4042\"]]");
    p = add_epsg_def (filter, first, last, 4043, "epsg", 4043,
        "Unknown datum based upon the WGS 72 ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS72 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the WGS 72 ellipsoid\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Not_specified_based_on_WGS_72_ellipsoid\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"WGS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6043\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4043\"]]");
    p = add_epsg_def (filter, first, last, 4044, "epsg", 4044,
        "Unknown datum based upon the Everest 1830 (1962 Definition) ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377301.243 +b=6356100.230165385 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Everest 1830 (1962");
    add_srs_wkt (p, 1,
        " Definition) ellipsoid\",DATUM[\"Not_specified_based_on_");
    add_srs_wkt (p, 2,
        "Everest_1830_1962_Definition_ellipsoid\",SPHEROID[\"Ever");
    add_srs_wkt (p, 3,
        "est 1830 (1962 Definition)\",6377301.243,300.8017255,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"7044\"]],AUTHORITY[\"EPSG\",\"6044\"]]");
    add_srs_wkt (p, 5,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 6,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 7,
        "22\"]],AUTHORITY[\"EPSG\",\"4044\"]]");
    p = add_epsg_def (filter, first, last, 4045, "epsg", 4045,
        "Unknown datum based upon the Everest 1830 (1975 Definition) ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377299.151 +b=6356098.145120132 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Everest 1830 (1975");
    add_srs_wkt (p, 1,
        " Definition) ellipsoid\",DATUM[\"Not_specified_based_on_");
    add_srs_wkt (p, 2,
        "Everest_1830_1975_Definition_ellipsoid\",SPHEROID[\"Ever");
    add_srs_wkt (p, 3,
        "est 1830 (1975 Definition)\",6377299.151,300.8017255,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"7045\"]],AUTHORITY[\"EPSG\",\"6045\"]]");
    add_srs_wkt (p, 5,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 6,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 7,
        "22\"]],AUTHORITY[\"EPSG\",\"4045\"]]");
    p = add_epsg_def (filter, first, last, 4046, "epsg", 4046,
        "RGRDC 2005");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGRDC 2005\",DATUM[\"Reseau_Geodesique_de_la_RD");
    add_srs_wkt (p, 1,
        "C_2005\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1033\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4046\"");
    add_srs_wkt (p, 6,
        "]]");
    p = add_epsg_def (filter, first, last, 4047, "epsg", 4047,
        "Unspecified datum based upon the GRS 1980 Authalic Sphere");
    add_proj4text (p, 0,
        "+proj=longlat +a=6371007 +b=6371007 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unspecified datum based upon the GRS 1980 Autha");
    add_srs_wkt (p, 1,
        "lic Sphere\",DATUM[\"Not_specified_based_on_GRS_1980_Aut");
    add_srs_wkt (p, 2,
        "halic_Sphere\",SPHEROID[\"GRS 1980 Authalic Sphere\",637");
    add_srs_wkt (p, 3,
        "1007,0,AUTHORITY[\"EPSG\",\"7048\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6047\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4047\"]]");
    p = add_epsg_def (filter, first, last, 4048, "epsg", 4048,
        "RGRDC 2005 / Congo TM zone 12");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGRDC 2005 / Congo TM zone 12\",GEOGCS[\"RGRDC ");
    add_srs_wkt (p, 1,
        "2005\",DATUM[\"Reseau_Geodesique_de_la_RDC_2005\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1033\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4046\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",12],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9999],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"4048\"]]");
    p = add_epsg_def (filter, first, last, 4049, "epsg", 4049,
        "RGRDC 2005 / Congo TM zone 14");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=14 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGRDC 2005 / Congo TM zone 14\",GEOGCS[\"RGRDC ");
    add_srs_wkt (p, 1,
        "2005\",DATUM[\"Reseau_Geodesique_de_la_RDC_2005\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1033\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4046\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",14],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9999],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"4049\"]]");
    p = add_epsg_def (filter, first, last, 4050, "epsg", 4050,
        "RGRDC 2005 / Congo TM zone 16");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=16 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGRDC 2005 / Congo TM zone 16\",GEOGCS[\"RGRDC ");
    add_srs_wkt (p, 1,
        "2005\",DATUM[\"Reseau_Geodesique_de_la_RDC_2005\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1033\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4046\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",16],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9999],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"4050\"]]");
    p = add_epsg_def (filter, first, last, 4051, "epsg", 4051,
        "RGRDC 2005 / Congo TM zone 18");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGRDC 2005 / Congo TM zone 18\",GEOGCS[\"RGRDC ");
    add_srs_wkt (p, 1,
        "2005\",DATUM[\"Reseau_Geodesique_de_la_RDC_2005\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1033\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4046\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",18],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9999],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"4051\"]]");
    p = add_epsg_def (filter, first, last, 4052, "epsg", 4052,
        "Unspecified datum based upon the Clarke 1866 Authalic Sphere");
    add_proj4text (p, 0,
        "+proj=longlat +a=6370997 +b=6370997 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unspecified datum based upon the Clarke 1866 Au");
    add_srs_wkt (p, 1,
        "thalic Sphere\",DATUM[\"Not_specified_based_on_Clarke_18");
    add_srs_wkt (p, 2,
        "66_Authalic_Sphere\",SPHEROID[\"Clarke 1866 Authalic Sph");
    add_srs_wkt (p, 3,
        "ere\",6370997,0,AUTHORITY[\"EPSG\",\"7052\"]],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6052\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4052\"]]");
    p = add_epsg_def (filter, first, last, 4053, "epsg", 4053,
        "Unspecified datum based upon the International 1924 Authalic Sphere");
    add_proj4text (p, 0,
        "+proj=longlat +a=6371228 +b=6371228 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unspecified datum based upon the International ");
    add_srs_wkt (p, 1,
        "1924 Authalic Sphere\",DATUM[\"Not_specified_based_on_In");
    add_srs_wkt (p, 2,
        "ternational_1924_Authalic_Sphere\",SPHEROID[\"Internatio");
    add_srs_wkt (p, 3,
        "nal 1924 Authalic Sphere\",6371228,0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"7057\"]],AUTHORITY[\"EPSG\",\"6053\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 5,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 6,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4053\"]]");
    p = add_epsg_def (filter, first, last, 4054, "epsg", 4054,
        "Unspecified datum based upon the Hughes 1980 ellipsoid");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378273 +b=6356889.449 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unspecified datum based upon the Hughes 1980 el");
    add_srs_wkt (p, 1,
        "lipsoid\",DATUM[\"Not_specified_based_on_Hughes_1980_ell");
    add_srs_wkt (p, 2,
        "ipsoid\",SPHEROID[\"Hughes 1980\",6378273,298.2794111230");
    add_srs_wkt (p, 3,
        "64,AUTHORITY[\"EPSG\",\"7058\"]],AUTHORITY[\"EPSG\",\"60");
    add_srs_wkt (p, 4,
        "54\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4054\"]]");
    p = add_epsg_def (filter, first, last, 4055, "epsg", 4055,
        "Popular Visualisation CRS");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378137 +b=6378137 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 1,
        ",0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Popular Visualisation CRS\",DATUM[\"Popular_Vis");
    add_srs_wkt (p, 1,
        "ualisation_Datum\",SPHEROID[\"Popular Visualisation Sphe");
    add_srs_wkt (p, 2,
        "re\",6378137,0,AUTHORITY[\"EPSG\",\"7059\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6055\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4055\"]]");
    p = add_epsg_def (filter, first, last, 4056, "epsg", 4056,
        "RGRDC 2005 / Congo TM zone 20");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=20 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGRDC 2005 / Congo TM zone 20\",GEOGCS[\"RGRDC ");
    add_srs_wkt (p, 1,
        "2005\",DATUM[\"Reseau_Geodesique_de_la_RDC_2005\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1033\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4046\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",20],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9999],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"4056\"]]");
    p = add_epsg_def (filter, first, last, 4057, "epsg", 4057,
        "RGRDC 2005 / Congo TM zone 22");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=22 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGRDC 2005 / Congo TM zone 22\",GEOGCS[\"RGRDC ");
    add_srs_wkt (p, 1,
        "2005\",DATUM[\"Reseau_Geodesique_de_la_RDC_2005\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1033\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4046\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",22],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9999],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"4057\"]]");
    p = add_epsg_def (filter, first, last, 4058, "epsg", 4058,
        "RGRDC 2005 / Congo TM zone 24");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGRDC 2005 / Congo TM zone 24\",GEOGCS[\"RGRDC ");
    add_srs_wkt (p, 1,
        "2005\",DATUM[\"Reseau_Geodesique_de_la_RDC_2005\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1033\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4046\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",24],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9999],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"4058\"]]");
    p = add_epsg_def (filter, first, last, 4059, "epsg", 4059,
        "RGRDC 2005 / Congo TM zone 26");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=26 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGRDC 2005 / Congo TM zone 26\",GEOGCS[\"RGRDC ");
    add_srs_wkt (p, 1,
        "2005\",DATUM[\"Reseau_Geodesique_de_la_RDC_2005\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1033\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4046\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",26],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9999],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"4059\"]]");
    p = add_epsg_def (filter, first, last, 4060, "epsg", 4060,
        "RGRDC 2005 / Congo TM zone 28");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=28 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGRDC 2005 / Congo TM zone 28\",GEOGCS[\"RGRDC ");
    add_srs_wkt (p, 1,
        "2005\",DATUM[\"Reseau_Geodesique_de_la_RDC_2005\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1033\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4046\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",28],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9999],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"4060\"]]");
    p = add_epsg_def (filter, first, last, 4061, "epsg", 4061,
        "RGRDC 2005 / UTM zone 33S");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGRDC 2005 / UTM zone 33S\",GEOGCS[\"RGRDC 2005");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Reseau_Geodesique_de_la_RDC_2005\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1033\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4046\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",15],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 12,
        "],AUTHORITY[\"EPSG\",\"4061\"]]");
    p = add_epsg_def (filter, first, last, 4062, "epsg", 4062,
        "RGRDC 2005 / UTM zone 34S");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGRDC 2005 / UTM zone 34S\",GEOGCS[\"RGRDC 2005");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Reseau_Geodesique_de_la_RDC_2005\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1033\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4046\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",21],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 12,
        "],AUTHORITY[\"EPSG\",\"4062\"]]");
    p = add_epsg_def (filter, first, last, 4063, "epsg", 4063,
        "RGRDC 2005 / UTM zone 35S");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGRDC 2005 / UTM zone 35S\",GEOGCS[\"RGRDC 2005");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Reseau_Geodesique_de_la_RDC_2005\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1033\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4046\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",27],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 12,
        "],AUTHORITY[\"EPSG\",\"4063\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

