-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

--------------------------------------------------------------------------------
--Synopsis:                                                                   --
--                                                                            --
--To provide global state representing the command line options and a         --
--procedure to parse the system command line.                                 --
--                                                                            --
--------------------------------------------------------------------------------

with OSFiling;

package body CommandLine is

   function Usage_String return  E_Strings.T is
   begin
      return E_Strings.Copy_String (Str => "pogs [-d=input_directory] [-i] [-o=output_file] [-p] [-s | -x] [-v]");
   end Usage_String;

   procedure Read is
      Report_Filename : E_Strings.T;
      Temp_String     : E_Strings.T;
   begin
      -- Process the command line arguments and store the result in Data
      OSCommandLine.Read (Data);

      -- What should the report filename be?
      -- -d specified?  -o specified?  Output filename
      -- =============  =============  ===============
      --    No               No        CWD.sum
      --    No               Yes       As specified (relative to CWD or absolute)
      --    Yes              No        Located in, and named after, specified output dir
      --    Yes              Yes       Located in specified output dir unless absolute path given

      if E_Strings.Is_Empty (E_Str => Data.ReportFile) then

         Report_Filename := OSFiling.Base_Dir_Name (Path => Data.StartDirectory);
         E_Strings.Append_Examiner_String (E_Str1 => Report_Filename,
                                           E_Str2 => OSFiling.Default_Report_Extn);
         Data.ReportFile := OSFiling.Full_Filename (Path     => Data.StartDirectory,
                                                    Filename => Report_Filename);
      else
         OSCommandLine.Normalize_Pathname
           (InputFile  => Data.ReportFile,
            InputDir   => Data.StartDirectory,
            ResultPath => Temp_String);
         Data.ReportFile := Temp_String;

      end if;
   end Read;

end CommandLine;
