-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Dictionary)
procedure WriteLocation (File : in SPARK_IO.File_Type;
                         Loc  : in Location) is

   procedure Write_Token_Position (File : in SPARK_IO.File_Type;
                                   Pos  : in LexTokenManager.Token_Position)
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                File,
   --#                                Pos;
   is

      procedure Write_Line_Number (File  : in SPARK_IO.File_Type;
                                   Value : in LexTokenManager.Line_Numbers)
      --# global in out SPARK_IO.File_Sys;
      --# derives SPARK_IO.File_Sys from *,
      --#                                File,
      --#                                Value;
      is
      begin
         WriteInteger (File, Integer (Value));
      end Write_Line_Number;

   begin
      WriteString (File, "line ");
      Write_Line_Number (File  => File,
                         Value => Pos.Start_Line_No);
      WriteString (File, " column ");
      WriteInteger (File, Pos.Start_Pos);
   end Write_Token_Position;

begin
   E_Strings.Put_String (File  => File,
                         E_Str => Dict.File_Name);
   WriteSpace (File);
   Write_Token_Position (File => File,
                         Pos  => Loc.Start_Position);
   WriteString (File, " to ");
   Write_Token_Position (File => File,
                         Pos  => Loc.End_Position);
end WriteLocation;
