from .colorconv import (convert_colorspace,
                        guess_spatial_dimensions,
                        rgb2hsv,
                        hsv2rgb,
                        rgb2xyz,
                        xyz2rgb,
                        rgb2rgbcie,
                        rgbcie2rgb,
                        rgb2grey,
                        rgb2gray,
                        gray2rgb,
                        xyz2lab,
                        lab2xyz,
                        lab2rgb,
                        rgb2lab,
                        rgb2hed,
                        hed2rgb,
                        lab2lch,
                        lch2lab,
                        separate_stains,
                        combine_stains,
                        rgb_from_hed,
                        hed_from_rgb,
                        rgb_from_hdx,
                        hdx_from_rgb,
                        rgb_from_fgx,
                        fgx_from_rgb,
                        rgb_from_bex,
                        bex_from_rgb,
                        rgb_from_rbd,
                        rbd_from_rgb,
                        rgb_from_gdx,
                        gdx_from_rgb,
                        rgb_from_hax,
                        hax_from_rgb,
                        rgb_from_bro,
                        bro_from_rgb,
                        rgb_from_bpx,
                        bpx_from_rgb,
                        rgb_from_ahx,
                        ahx_from_rgb,
                        rgb_from_hpx,
                        hpx_from_rgb,
                        is_rgb,
                        is_gray)

from .colorlabel import color_dict, label2rgb

from .delta_e import (deltaE_cie76,
                      deltaE_ciede94,
                      deltaE_ciede2000,
                      deltaE_cmc,
                      )


__all__ = ['convert_colorspace',
           'guess_spatial_dimensions',
           'rgb2hsv',
           'hsv2rgb',
           'rgb2xyz',
           'xyz2rgb',
           'rgb2rgbcie',
           'rgbcie2rgb',
           'rgb2grey',
           'rgb2gray',
           'gray2rgb',
           'xyz2lab',
           'lab2xyz',
           'lab2rgb',
           'rgb2lab',
           'rgb2hed',
           'hed2rgb',
           'lab2lch',
           'lch2lab',
           'separate_stains',
           'combine_stains',
           'rgb_from_hed',
           'hed_from_rgb',
           'rgb_from_hdx',
           'hdx_from_rgb',
           'rgb_from_fgx',
           'fgx_from_rgb',
           'rgb_from_bex',
           'bex_from_rgb',
           'rgb_from_rbd',
           'rbd_from_rgb',
           'rgb_from_gdx',
           'gdx_from_rgb',
           'rgb_from_hax',
           'hax_from_rgb',
           'rgb_from_bro',
           'bro_from_rgb',
           'rgb_from_bpx',
           'bpx_from_rgb',
           'rgb_from_ahx',
           'ahx_from_rgb',
           'rgb_from_hpx',
           'hpx_from_rgb',
           'is_rgb',
           'is_gray',
           'color_dict',
           'label2rgb',
           'deltaE_cie76',
           'deltaE_ciede94',
           'deltaE_ciede2000',
           'deltaE_cmc',
           ]
