#include <boost/bind.hpp>
#include "protocoltimerasio.h"


ProtocolIOAsio::ProtocolIOAsio(asio::io_service & ioservice) : ioservice(ioservice)
{
}


boost::posix_time::ptime ProtocolIOAsio::currentTimeUTC()
{
  return boost::posix_time::microsec_clock::universal_time();
}


TheTimerObjectBase * ProtocolIOAsio::getTimer()
{
  return new TheTimerObjectAsio(ioservice);
}


void TheTimerObjectAsio::timerExpiredEvent(const asio::error_code& err)
{
  if (asio::error::operation_aborted==err)
  {
  }
  else
  {
    if (myHandlerBase)
    {
      (*myHandlerBase)();
    }
  }
}


TheTimerObjectAsio::TheTimerObjectAsio(asio::io_service & ioservice) : ioservice(ioservice), timer(ioservice)
{
  myHandlerBase=0;
}


TheTimerObjectAsio::~TheTimerObjectAsio()
{
}


void TheTimerObjectAsio::startAlarmAt(const boost::posix_time::ptime & time, TimerEventHandlerBase * handler)
{
  myHandlerBase=handler;
  timer.expires_at(time);
  timer.async_wait(boost::bind(&TheTimerObjectAsio::timerExpiredEvent, this, asio::placeholders::error));
}


void TheTimerObjectAsio::startAlarmAfter(const boost::posix_time::time_duration & expiry_time, TimerEventHandlerBase * handler)
{
  myHandlerBase=handler;
  timer.expires_from_now(expiry_time);
  timer.async_wait(boost::bind(&TheTimerObjectAsio::timerExpiredEvent, this, asio::placeholders::error));
}


void TheTimerObjectAsio::stop()
{
  timer.cancel();
}

