/*******************************************************************************
 *
 *                                 Silverjuke
 *     Copyright (C) 2015 Björn Petersen Software Design and Development
 *                   Contact: r10s@b44t.com, http://b44t.com
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program.  If not, see http://www.gnu.org/licenses/ .
 *
 *******************************************************************************
 *
 * File:    settingssj.h
 * Authors: Björn Petersen
 * Purpose: The settings module
 *
 ******************************************************************************/


#ifndef __SJ_SETTINGS_H__
#define __SJ_SETTINGS_H__


class SjSettingsModule : public SjCommonModule
{
public:
	SjSettingsModule    (SjInterfaceBase*);
	static void     OpenSettings        (const wxString& module, int moduleIndex, int pageIndex);
	static bool     IsDialogOpen        ();
	static void     RaiseIfOpen         ();

	// this should only be used by modules who want to switch to a different page,
	// the change is delayed as the current page gets unloaded before
	static void     OpenSettingsAsync   (const wxString& module, int moduleIndex, int pageIndex);

protected:
	bool            FirstLoad           ();
	void            LastUnload          ();
	void            ReceiveMsg          (int msg);

private:
	SjDialogPos     m_dlgPos;
	friend class    SjSettingsDlg;
};



#endif // __SJ_SETTINGS_H__
