#!/usr/bin/php
<?php
// This script is used to generate the SQL schema files as needed
// by dbconfig-common. Serendipity generates these on the fly,
// this script calls the serendipity functions to create the static
// files we need (or uses adapted serendipity functions).

// I only run this by hand, it's not part of the build process.

error_reporting(E_ALL);

require('gen_sql_libs.inc.php');

$queries = serendipity_parse_sql_tables('../../sql/db.sql');
$queries = str_replace('{PREFIX}', 's9y_', $queries);

$dbs = array('mysql', 'pgsql', 'sqlite', 'sqlite3');
foreach ( $dbs as $db ) {
    $data = fopen("dbc/install/$db", 'w');
    foreach ( $queries as $query ) {
        fwrite($data, call_user_func("convert_db_schema_$db", $query) . "\n");
    }
    fclose($data);
    file_put_contents("dbc/install/$db", file_get_contents('data.sql'), FILE_APPEND);
}
