/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <atcommand.h>
#include <helper.h>

char* at_get_vendor (void) {
  static char* vendor = NULL;

  if (vendor == NULL) {
    at_command_send(AT_GEN_VENDOR,NULL);
    vendor = at_get_value(AT_GEN_VENDOR);
  }
  return str_dup(vendor);
}

char* at_get_model (void) {
  static char* model = NULL;

  if (model == NULL) {
    at_command_send(AT_GEN_MODEL,NULL);
    model = at_get_value(AT_GEN_MODEL);
  }
  return str_dup(model);
}
