/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2010 - DIGITEO - Yann Collette
 * 
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at    
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */
#include <sci_mysql.h>

int sci_mysql_real_connect(char * fname)
{
  int * sql_pointer_in = NULL;
  int * host = NULL;
  int * user = NULL;
  int * passwd = NULL;
  int * db = NULL;
  int * port = NULL;
  int * socket = NULL;
  int * flag = NULL;
  char * chost = NULL, * cuser = NULL, * cdb = NULL, * csocket = NULL, * cpasswd = NULL;
  double dport = 0, dflag = 0;
  MYSQL * mysql_ptr_in = NULL;
  MYSQL * mysql_ptr_out = NULL;
  int Index_Args = 0;
  void * ptr_in = NULL;
  SciErr _SciErr;
  double result;

  CheckRhs(1,8);
  CheckLhs(0,1);

  if (GetType(1)==sci_strings)
    {
      // We need to call mysq_init to create an initial pointer
      mysql_ptr_in = mysql_init(NULL);
      Index_Args = 0;
    }
  else
    {
      _SciErr = getVarAddressFromPosition(pvApiCtx, 1, &sql_pointer_in);
      getPointer(pvApiCtx, sql_pointer_in, &ptr_in);
      mysql_ptr_in = (MYSQL *)ptr_in;

      Index_Args = 1;
    }

  if (mysql_ptr_in==NULL)
    {
      Scierror(999,"%s: problem with the mysql pointer\n", fname);
      return 0;
    }

  if (Rhs>=1+Index_Args) 
    {
      _SciErr = getVarAddressFromPosition(pvApiCtx, 1+Index_Args, &host);
      if (!isEmptyMatrix(pvApiCtx, host)) getAllocatedSingleString(pvApiCtx, host, &chost);
      else                                chost = NULL;
    }
  else
    {
      chost = NULL;
    }
  if (Rhs>=2+Index_Args) 
    {
      _SciErr = getVarAddressFromPosition(pvApiCtx, 2+Index_Args, &user);
      if (!isEmptyMatrix(pvApiCtx, user)) getAllocatedSingleString(pvApiCtx, user, &cuser);
      else                                cuser = NULL;
    }
  else
    {
      cuser = NULL;
    }
  if (Rhs>=3+Index_Args)
    {
      _SciErr = getVarAddressFromPosition(pvApiCtx, 3+Index_Args, &passwd);
      if (!isEmptyMatrix(pvApiCtx, passwd)) getAllocatedSingleString(pvApiCtx, passwd, &cpasswd);
      else                                  cpasswd = NULL;
    }
  else
    {
      cpasswd = NULL;
    }
  if (Rhs>=4+Index_Args)
    {
      _SciErr = getVarAddressFromPosition(pvApiCtx, 4+Index_Args, &db);
      if (!isEmptyMatrix(pvApiCtx, db)) getAllocatedSingleString(pvApiCtx, db, &cdb);
      else                              cdb = NULL;
    }
  else
    {
      cdb = NULL;
    }
  if (Rhs>=5+Index_Args)
    {
      _SciErr = getVarAddressFromPosition(pvApiCtx, 5+Index_Args, &port);
      if (!isEmptyMatrix(pvApiCtx, port)) getScalarDouble(pvApiCtx, port, &dport);
      else                                dport = 0;
    }
  else
    {
      dport = 0;
    }
  if (Rhs>=6+Index_Args)
    {
      _SciErr = getVarAddressFromPosition(pvApiCtx, 6+Index_Args, &socket);
      if (!isEmptyMatrix(pvApiCtx, socket)) getAllocatedSingleString(pvApiCtx, socket, &csocket);
      else                                  csocket = NULL;
    }
  else
    {
      csocket = NULL;
    }
  if (Rhs>=7+Index_Args)
    {
      _SciErr = getVarAddressFromPosition(pvApiCtx, 7+Index_Args, &flag);
      if (!isEmptyMatrix(pvApiCtx, flag)) getScalarDouble(pvApiCtx, flag, &dflag);
      else                                dflag = 0;
    }
  else
    {
      dflag = 0;
    }

  mysql_ptr_out = mysql_real_connect(mysql_ptr_in, chost, cuser, cpasswd, cdb, (unsigned int)dport, csocket, (unsigned int)dflag);

  if (!isEmptyMatrix(pvApiCtx, sql_pointer_in))
    {
      if (mysql_ptr_out)
	{
	  _SciErr = createPointer(pvApiCtx, Rhs+1, (void *)mysql_ptr_out);
	}
      else
	{
	  createEmptyMatrix(pvApiCtx, Rhs+1);
	}
    }
  else
    {
      if (mysql_ptr_out==NULL) result = -1;
      else                     result = 0;

      createScalarDouble(pvApiCtx, Rhs+1, result);
    }

  LhsVar(1) = Rhs+1;

  if (chost)   freeAllocatedSingleString(chost);
  if (cuser)   freeAllocatedSingleString(cuser);
  if (cdb)     freeAllocatedSingleString(cdb);
  if (csocket) freeAllocatedSingleString(csocket);
  if (cpasswd) freeAllocatedSingleString(cpasswd);

  return 0;
}
