/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2010 - DIGITEO - Yann Collette
 * 
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at    
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */
#include <sci_mysql.h>

int sci_mysql_fetch_row(char * fname)
{
  int * sql_res_pointer_in = NULL;
  int m_sql_row_pointer_out, n_sql_row_pointer_out;
  MYSQL_RES * mysql_res_ptr = NULL;
  MYSQL_ROW mysql_row_ptr; // It's a char **
  char ** res_copy = NULL;
  unsigned long * lengths = NULL;
  int i;
  void * ptr_in = NULL;
  SciErr _SciErr;

  CheckRhs(1,1);
  CheckLhs(0,1);

  _SciErr = getVarAddressFromPosition(pvApiCtx, 1, &sql_res_pointer_in);
  getPointer(pvApiCtx, sql_res_pointer_in, &ptr_in);
  mysql_res_ptr = (MYSQL_RES *)ptr_in;

  if (mysql_res_ptr==NULL)
    {
      Scierror(999,"%s: problem with the mysql_res pointer\n", fname);
      return 0;
    }

  mysql_row_ptr = mysql_fetch_row(mysql_res_ptr);
  lengths = mysql_fetch_lengths(mysql_res_ptr);

#ifdef DEBUG
  sciprint("DEBUG: mysql_row_ptr = %ld, lengths = %ld\n", mysql_row_ptr, lengths);
#endif

  if (mysql_row_ptr)
    {
      //YC: à vérifier !!
      n_sql_row_pointer_out = 1;
      m_sql_row_pointer_out = mysql_num_fields(mysql_res_ptr);
      
      res_copy = (char **)MALLOC(m_sql_row_pointer_out*sizeof(char *));

#ifdef DEBUG
      sciprint("m_sql_row_pointer_out = %d\n", m_sql_row_pointer_out);
#endif

      for(i=0; i<m_sql_row_pointer_out;i++)
	{
#ifdef DEBUG
	  sciprint("DEBUG: orig = !%s!, length = %d\n", mysql_row_ptr[i],lengths[i]);
#endif

#ifdef _MSC_VER
	  res_copy[i] = strdup(mysql_row_ptr[i]);
#else
	  res_copy[i] = strndup(mysql_row_ptr[i],lengths[i]);
#endif
	}
      
      _SciErr = createMatrixOfString(pvApiCtx, Rhs+1, m_sql_row_pointer_out, n_sql_row_pointer_out, res_copy);

      freeArrayOfString(res_copy, m_sql_row_pointer_out);
    }
  else
    {
      createEmptyMatrix(pvApiCtx, Rhs+1);
    }

  LhsVar(1) = Rhs+1;


  return 0;
}
