module Schleuder
  class ResendPlugin < Plugin
  
    def match(mail)
      mail.keywords.keys.include?('X-RESEND') || mail.keywords.keys.include?('X-RESEND-ENCRYPTED-ONLY')
    end
  
    def process(mail)
      if r = fetch(mail, 'X-RESEND-ENCRYPTED-ONLY')
        r.each { |m| m.encrypted_only = true }
        mail.resend_to.concat r
      end
      if r = fetch(mail, 'X-RESEND')
        mail.resend_to.concat r
      end
    end

    def fetch mail, word
      if mail.keywords[word]
        r = []
        mail.keywords[word].split(/[ ,;]+/).each do |recip|
          r << Member.new({'email' => recip.strip})
        end 
      end
      r or false 
    end

  end
end
