# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Web
  module Models
    #
    # Configuration of Azure web site
    #
    class SiteConfig < MsRestAzure::Resource

      include MsRestAzure

      # @return [Integer] Number of workers
      attr_accessor :number_of_workers

      # @return [Array<String>] Default documents
      attr_accessor :default_documents

      # @return [String] Net Framework Version
      attr_accessor :net_framework_version

      # @return [String] Version of PHP
      attr_accessor :php_version

      # @return [String] Version of Python
      attr_accessor :python_version

      # @return [Boolean] Enable request tracing
      attr_accessor :request_tracing_enabled

      # @return [DateTime] Request tracing expiration time
      attr_accessor :request_tracing_expiration_time

      # @return [Boolean] Remote Debugging Enabled
      attr_accessor :remote_debugging_enabled

      # @return [String] Remote Debugging Version
      attr_accessor :remote_debugging_version

      # @return [Boolean] HTTP logging Enabled
      attr_accessor :http_logging_enabled

      # @return [Integer] HTTP Logs Directory size limit
      attr_accessor :logs_directory_size_limit

      # @return [Boolean] Detailed error logging enabled
      attr_accessor :detailed_error_logging_enabled

      # @return [String] Publishing user name
      attr_accessor :publishing_username

      # @return [String] Publishing password
      attr_accessor :publishing_password

      # @return [Array<NameValuePair>] Application Settings
      attr_accessor :app_settings

      # @return [Array<NameValuePair>] Site Metadata
      attr_accessor :metadata

      # @return [Array<ConnStringInfo>] Connection strings
      attr_accessor :connection_strings

      # @return [Array<HandlerMapping>] Handler mappings
      attr_accessor :handler_mappings

      # @return [String] Document root
      attr_accessor :document_root

      # @return [String] SCM type
      attr_accessor :scm_type

      # @return [Boolean] Use 32 bit worker process
      attr_accessor :use32bit_worker_process

      # @return [Boolean] Web socket enabled.
      attr_accessor :web_sockets_enabled

      # @return [Boolean] Always On
      attr_accessor :always_on

      # @return [String] Java version
      attr_accessor :java_version

      # @return [String] Java container
      attr_accessor :java_container

      # @return [String] Java container version
      attr_accessor :java_container_version

      # @return [String] App Command Line to launch
      attr_accessor :app_command_line

      # @return [ManagedPipelineMode] Managed pipeline mode. Possible values
      # include: 'Integrated', 'Classic'
      attr_accessor :managed_pipeline_mode

      # @return [Array<VirtualApplication>] Virtual applications
      attr_accessor :virtual_applications

      # @return [SiteLoadBalancing] Site load balancing. Possible values
      # include: 'WeightedRoundRobin', 'LeastRequests', 'LeastResponseTime',
      # 'WeightedTotalTraffic', 'RequestHash'
      attr_accessor :load_balancing

      # @return [Experiments] This is work around for polymophic types
      attr_accessor :experiments

      # @return [SiteLimits] Site limits
      attr_accessor :limits

      # @return [Boolean] Auto heal enabled
      attr_accessor :auto_heal_enabled

      # @return [AutoHealRules] Auto heal rules
      attr_accessor :auto_heal_rules

      # @return [String] Tracing options
      attr_accessor :tracing_options

      # @return [String] Vnet name
      attr_accessor :vnet_name

      # @return [CorsSettings] Cross-Origin Resource Sharing (CORS) settings.
      attr_accessor :cors

      # @return [ApiDefinitionInfo] Information about the formal API
      # definition for the web app.
      attr_accessor :api_definition

      # @return [String] Auto swap slot name
      attr_accessor :auto_swap_slot_name

      # @return [Boolean] Local mysql enabled
      attr_accessor :local_my_sql_enabled

      # @return [Array<IpSecurityRestriction>] Ip Security restrictions
      attr_accessor :ip_security_restrictions


      #
      # Mapper for SiteConfig class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'SiteConfig',
          type: {
            name: 'Composite',
            class_name: 'SiteConfig',
            model_properties: {
              id: {
                required: false,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                required: false,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              kind: {
                required: false,
                serialized_name: 'kind',
                type: {
                  name: 'String'
                }
              },
              location: {
                required: true,
                serialized_name: 'location',
                type: {
                  name: 'String'
                }
              },
              type: {
                required: false,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              tags: {
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Dictionary',
                  value: {
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              number_of_workers: {
                required: false,
                serialized_name: 'properties.numberOfWorkers',
                type: {
                  name: 'Number'
                }
              },
              default_documents: {
                required: false,
                serialized_name: 'properties.defaultDocuments',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              net_framework_version: {
                required: false,
                serialized_name: 'properties.netFrameworkVersion',
                type: {
                  name: 'String'
                }
              },
              php_version: {
                required: false,
                serialized_name: 'properties.phpVersion',
                type: {
                  name: 'String'
                }
              },
              python_version: {
                required: false,
                serialized_name: 'properties.pythonVersion',
                type: {
                  name: 'String'
                }
              },
              request_tracing_enabled: {
                required: false,
                serialized_name: 'properties.requestTracingEnabled',
                type: {
                  name: 'Boolean'
                }
              },
              request_tracing_expiration_time: {
                required: false,
                serialized_name: 'properties.requestTracingExpirationTime',
                type: {
                  name: 'DateTime'
                }
              },
              remote_debugging_enabled: {
                required: false,
                serialized_name: 'properties.remoteDebuggingEnabled',
                type: {
                  name: 'Boolean'
                }
              },
              remote_debugging_version: {
                required: false,
                serialized_name: 'properties.remoteDebuggingVersion',
                type: {
                  name: 'String'
                }
              },
              http_logging_enabled: {
                required: false,
                serialized_name: 'properties.httpLoggingEnabled',
                type: {
                  name: 'Boolean'
                }
              },
              logs_directory_size_limit: {
                required: false,
                serialized_name: 'properties.logsDirectorySizeLimit',
                type: {
                  name: 'Number'
                }
              },
              detailed_error_logging_enabled: {
                required: false,
                serialized_name: 'properties.detailedErrorLoggingEnabled',
                type: {
                  name: 'Boolean'
                }
              },
              publishing_username: {
                required: false,
                serialized_name: 'properties.publishingUsername',
                type: {
                  name: 'String'
                }
              },
              publishing_password: {
                required: false,
                serialized_name: 'properties.publishingPassword',
                type: {
                  name: 'String'
                }
              },
              app_settings: {
                required: false,
                serialized_name: 'properties.appSettings',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'NameValuePairElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'NameValuePair'
                      }
                  }
                }
              },
              metadata: {
                required: false,
                serialized_name: 'properties.metadata',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'NameValuePairElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'NameValuePair'
                      }
                  }
                }
              },
              connection_strings: {
                required: false,
                serialized_name: 'properties.connectionStrings',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'ConnStringInfoElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'ConnStringInfo'
                      }
                  }
                }
              },
              handler_mappings: {
                required: false,
                serialized_name: 'properties.handlerMappings',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'HandlerMappingElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'HandlerMapping'
                      }
                  }
                }
              },
              document_root: {
                required: false,
                serialized_name: 'properties.documentRoot',
                type: {
                  name: 'String'
                }
              },
              scm_type: {
                required: false,
                serialized_name: 'properties.scmType',
                type: {
                  name: 'String'
                }
              },
              use32bit_worker_process: {
                required: false,
                serialized_name: 'properties.use32BitWorkerProcess',
                type: {
                  name: 'Boolean'
                }
              },
              web_sockets_enabled: {
                required: false,
                serialized_name: 'properties.webSocketsEnabled',
                type: {
                  name: 'Boolean'
                }
              },
              always_on: {
                required: false,
                serialized_name: 'properties.alwaysOn',
                type: {
                  name: 'Boolean'
                }
              },
              java_version: {
                required: false,
                serialized_name: 'properties.javaVersion',
                type: {
                  name: 'String'
                }
              },
              java_container: {
                required: false,
                serialized_name: 'properties.javaContainer',
                type: {
                  name: 'String'
                }
              },
              java_container_version: {
                required: false,
                serialized_name: 'properties.javaContainerVersion',
                type: {
                  name: 'String'
                }
              },
              app_command_line: {
                required: false,
                serialized_name: 'properties.appCommandLine',
                type: {
                  name: 'String'
                }
              },
              managed_pipeline_mode: {
                required: false,
                serialized_name: 'properties.managedPipelineMode',
                type: {
                  name: 'Enum',
                  module: 'ManagedPipelineMode'
                }
              },
              virtual_applications: {
                required: false,
                serialized_name: 'properties.virtualApplications',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'VirtualApplicationElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'VirtualApplication'
                      }
                  }
                }
              },
              load_balancing: {
                required: false,
                serialized_name: 'properties.loadBalancing',
                type: {
                  name: 'Enum',
                  module: 'SiteLoadBalancing'
                }
              },
              experiments: {
                required: false,
                serialized_name: 'properties.experiments',
                type: {
                  name: 'Composite',
                  class_name: 'Experiments'
                }
              },
              limits: {
                required: false,
                serialized_name: 'properties.limits',
                type: {
                  name: 'Composite',
                  class_name: 'SiteLimits'
                }
              },
              auto_heal_enabled: {
                required: false,
                serialized_name: 'properties.autoHealEnabled',
                type: {
                  name: 'Boolean'
                }
              },
              auto_heal_rules: {
                required: false,
                serialized_name: 'properties.autoHealRules',
                type: {
                  name: 'Composite',
                  class_name: 'AutoHealRules'
                }
              },
              tracing_options: {
                required: false,
                serialized_name: 'properties.tracingOptions',
                type: {
                  name: 'String'
                }
              },
              vnet_name: {
                required: false,
                serialized_name: 'properties.vnetName',
                type: {
                  name: 'String'
                }
              },
              cors: {
                required: false,
                serialized_name: 'properties.cors',
                type: {
                  name: 'Composite',
                  class_name: 'CorsSettings'
                }
              },
              api_definition: {
                required: false,
                serialized_name: 'properties.apiDefinition',
                type: {
                  name: 'Composite',
                  class_name: 'ApiDefinitionInfo'
                }
              },
              auto_swap_slot_name: {
                required: false,
                serialized_name: 'properties.autoSwapSlotName',
                type: {
                  name: 'String'
                }
              },
              local_my_sql_enabled: {
                required: false,
                serialized_name: 'properties.localMySqlEnabled',
                type: {
                  name: 'Boolean'
                }
              },
              ip_security_restrictions: {
                required: false,
                serialized_name: 'properties.ipSecurityRestrictions',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'IpSecurityRestrictionElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'IpSecurityRestriction'
                      }
                  }
                }
              }
            }
          }
        }
      end
    end
  end
end
