# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Web
  #
  # Use these APIs to manage Azure Websites resources through the Azure
  # Resource Manager. All task operations conform to the HTTP/1.1 protocol
  # specification and each operation returns an x-ms-request-id header that
  # can be used to obtain information about the request. You must make sure
  # that requests made to these resources are secure. For more information,
  # see <a
  # href="https://msdn.microsoft.com/en-us/library/azure/dn790557.aspx">Authenticating
  # Azure Resource Manager requests.</a>
  #
  class ManagedHostingEnvironments
    include Azure::ARM::Web::Models
    include MsRestAzure

    #
    # Creates and initializes a new instance of the ManagedHostingEnvironments class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [WebSiteManagementClient] reference to the WebSiteManagementClient
    attr_reader :client

    #
    # Get properties of a managed hosting environment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ManagedHostingEnvironment] operation results.
    #
    def get_managed_hosting_environment(resource_group_name, name, custom_headers = nil)
      response = get_managed_hosting_environment_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get properties of a managed hosting environment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_managed_hosting_environment_with_http_info(resource_group_name, name, custom_headers = nil)
      get_managed_hosting_environment_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get properties of a managed hosting environment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_managed_hosting_environment_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/managedHostingEnvironments/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ManagedHostingEnvironment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create or update a managed hosting environment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param managed_hosting_environment_envelope [HostingEnvironment] Properties
    # of managed hosting environment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostingEnvironment] operation results.
    #
    def create_or_update_managed_hosting_environment(resource_group_name, name, managed_hosting_environment_envelope, custom_headers = nil)
      response = create_or_update_managed_hosting_environment_async(resource_group_name, name, managed_hosting_environment_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param managed_hosting_environment_envelope [HostingEnvironment] Properties
    # of managed hosting environment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_managed_hosting_environment_async(resource_group_name, name, managed_hosting_environment_envelope, custom_headers = nil)
      # Send request
      promise = begin_create_or_update_managed_hosting_environment_async(resource_group_name, name, managed_hosting_environment_envelope, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = HostingEnvironment.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Create or update a managed hosting environment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param managed_hosting_environment_envelope [HostingEnvironment] Properties
    # of managed hosting environment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostingEnvironment] operation results.
    #
    def begin_create_or_update_managed_hosting_environment(resource_group_name, name, managed_hosting_environment_envelope, custom_headers = nil)
      response = begin_create_or_update_managed_hosting_environment_async(resource_group_name, name, managed_hosting_environment_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create or update a managed hosting environment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param managed_hosting_environment_envelope [HostingEnvironment] Properties
    # of managed hosting environment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_managed_hosting_environment_with_http_info(resource_group_name, name, managed_hosting_environment_envelope, custom_headers = nil)
      begin_create_or_update_managed_hosting_environment_async(resource_group_name, name, managed_hosting_environment_envelope, custom_headers).value!
    end

    #
    # Create or update a managed hosting environment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param managed_hosting_environment_envelope [HostingEnvironment] Properties
    # of managed hosting environment
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_managed_hosting_environment_async(resource_group_name, name, managed_hosting_environment_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'managed_hosting_environment_envelope is nil' if managed_hosting_environment_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = HostingEnvironment.mapper()
      request_content = @client.serialize(request_mapper,  managed_hosting_environment_envelope, 'managed_hosting_environment_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/managedHostingEnvironments/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202 || status_code == 400 || status_code == 404 || status_code == 409
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HostingEnvironment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete a managed hosting environment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param force_delete [Boolean] Delete even if the managed hosting environment
    # contains resources
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_managed_hosting_environment(resource_group_name, name, force_delete = nil, custom_headers = nil)
      response = delete_managed_hosting_environment_async(resource_group_name, name, force_delete, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param force_delete [Boolean] Delete even if the managed hosting environment
    # contains resources
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_managed_hosting_environment_async(resource_group_name, name, force_delete = nil, custom_headers = nil)
      # Send request
      promise = begin_delete_managed_hosting_environment_async(resource_group_name, name, force_delete, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = {
            required: false,
            serialized_name: 'parsed_response',
            type: {
              name: 'Object'
            }
          }
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Delete a managed hosting environment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param force_delete [Boolean] Delete even if the managed hosting environment
    # contains resources
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def begin_delete_managed_hosting_environment(resource_group_name, name, force_delete = nil, custom_headers = nil)
      response = begin_delete_managed_hosting_environment_async(resource_group_name, name, force_delete, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Delete a managed hosting environment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param force_delete [Boolean] Delete even if the managed hosting environment
    # contains resources
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_managed_hosting_environment_with_http_info(resource_group_name, name, force_delete = nil, custom_headers = nil)
      begin_delete_managed_hosting_environment_async(resource_group_name, name, force_delete, custom_headers).value!
    end

    #
    # Delete a managed hosting environment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param force_delete [Boolean] Delete even if the managed hosting environment
    # contains resources
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_managed_hosting_environment_async(resource_group_name, name, force_delete = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/managedHostingEnvironments/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'forceDelete' => force_delete,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202 || status_code == 400 || status_code == 404 || status_code == 409
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Get all managed hosting environments in a resource group.
    #
    # @param resource_group_name [String] Name of resource group
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostingEnvironmentCollection] which provide lazy access to pages of
    # the response.
    #
    def get_managed_hosting_environments_as_lazy(resource_group_name, custom_headers = nil)
      response = get_managed_hosting_environments_async(resource_group_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_managed_hosting_environments_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get all managed hosting environments in a resource group.
    #
    # @param resource_group_name [String] Name of resource group
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<HostingEnvironment>] operation results.
    #
    def get_managed_hosting_environments(resource_group_name, custom_headers = nil)
      first_page = get_managed_hosting_environments_as_lazy(resource_group_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get all managed hosting environments in a resource group.
    #
    # @param resource_group_name [String] Name of resource group
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_managed_hosting_environments_with_http_info(resource_group_name, custom_headers = nil)
      get_managed_hosting_environments_async(resource_group_name, custom_headers).value!
    end

    #
    # Get all managed hosting environments in a resource group.
    #
    # @param resource_group_name [String] Name of resource group
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_managed_hosting_environments_async(resource_group_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/managedHostingEnvironments'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HostingEnvironmentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get list of ip addresses assigned to a managed hosting environment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AddressResponse] operation results.
    #
    def get_managed_hosting_environment_vips(resource_group_name, name, custom_headers = nil)
      response = get_managed_hosting_environment_vips_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get list of ip addresses assigned to a managed hosting environment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_managed_hosting_environment_vips_with_http_info(resource_group_name, name, custom_headers = nil)
      get_managed_hosting_environment_vips_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get list of ip addresses assigned to a managed hosting environment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_managed_hosting_environment_vips_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/managedHostingEnvironments/{name}/capacities/virtualip'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = AddressResponse.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get status of an operation on a managed hosting environment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param operation_id [String] operation identifier GUID
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def get_managed_hosting_environment_operation(resource_group_name, name, operation_id, custom_headers = nil)
      response = get_managed_hosting_environment_operation_async(resource_group_name, name, operation_id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get status of an operation on a managed hosting environment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param operation_id [String] operation identifier GUID
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_managed_hosting_environment_operation_with_http_info(resource_group_name, name, operation_id, custom_headers = nil)
      get_managed_hosting_environment_operation_async(resource_group_name, name, operation_id, custom_headers).value!
    end

    #
    # Get status of an operation on a managed hosting environment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param operation_id [String] operation identifier GUID
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_managed_hosting_environment_operation_async(resource_group_name, name, operation_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'operation_id is nil' if operation_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/managedHostingEnvironments/{name}/operations/{operationId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'operationId' => operation_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202 || status_code == 404 || status_code == 500
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Get all sites on the managed hosting environment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param properties_to_include [String] Comma separated list of site
    # properties to include
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteCollection] which provide lazy access to pages of the response.
    #
    def get_managed_hosting_environment_sites_as_lazy(resource_group_name, name, properties_to_include = nil, custom_headers = nil)
      response = get_managed_hosting_environment_sites_async(resource_group_name, name, properties_to_include, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_managed_hosting_environment_sites_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get all sites on the managed hosting environment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param properties_to_include [String] Comma separated list of site
    # properties to include
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Site>] operation results.
    #
    def get_managed_hosting_environment_sites(resource_group_name, name, properties_to_include = nil, custom_headers = nil)
      first_page = get_managed_hosting_environment_sites_as_lazy(resource_group_name, name, properties_to_include, custom_headers)
      first_page.get_all_items
    end

    #
    # Get all sites on the managed hosting environment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param properties_to_include [String] Comma separated list of site
    # properties to include
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_managed_hosting_environment_sites_with_http_info(resource_group_name, name, properties_to_include = nil, custom_headers = nil)
      get_managed_hosting_environment_sites_async(resource_group_name, name, properties_to_include, custom_headers).value!
    end

    #
    # Get all sites on the managed hosting environment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param properties_to_include [String] Comma separated list of site
    # properties to include
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_managed_hosting_environment_sites_async(resource_group_name, name, properties_to_include = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/managedHostingEnvironments/{name}/sites'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'propertiesToInclude' => properties_to_include,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all serverfarms (App Service Plans) on the managed hosting environment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ServerFarmCollection] which provide lazy access to pages of the
    # response.
    #
    def get_managed_hosting_environment_web_hosting_plans_as_lazy(resource_group_name, name, custom_headers = nil)
      response = get_managed_hosting_environment_web_hosting_plans_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_managed_hosting_environment_web_hosting_plans_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get all serverfarms (App Service Plans) on the managed hosting environment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ServerFarmWithRichSku>] operation results.
    #
    def get_managed_hosting_environment_web_hosting_plans(resource_group_name, name, custom_headers = nil)
      first_page = get_managed_hosting_environment_web_hosting_plans_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get all serverfarms (App Service Plans) on the managed hosting environment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_managed_hosting_environment_web_hosting_plans_with_http_info(resource_group_name, name, custom_headers = nil)
      get_managed_hosting_environment_web_hosting_plans_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get all serverfarms (App Service Plans) on the managed hosting environment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_managed_hosting_environment_web_hosting_plans_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/managedHostingEnvironments/{name}/webhostingplans'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ServerFarmCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all serverfarms (App Service Plans) on the managed hosting environment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ServerFarmCollection] which provide lazy access to pages of the
    # response.
    #
    def get_managed_hosting_environment_server_farms_as_lazy(resource_group_name, name, custom_headers = nil)
      response = get_managed_hosting_environment_server_farms_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_managed_hosting_environment_server_farms_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get all serverfarms (App Service Plans) on the managed hosting environment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ServerFarmWithRichSku>] operation results.
    #
    def get_managed_hosting_environment_server_farms(resource_group_name, name, custom_headers = nil)
      first_page = get_managed_hosting_environment_server_farms_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get all serverfarms (App Service Plans) on the managed hosting environment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_managed_hosting_environment_server_farms_with_http_info(resource_group_name, name, custom_headers = nil)
      get_managed_hosting_environment_server_farms_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get all serverfarms (App Service Plans) on the managed hosting environment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of managed hosting environment
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_managed_hosting_environment_server_farms_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/managedHostingEnvironments/{name}/serverfarms'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ServerFarmCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all managed hosting environments in a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostingEnvironmentCollection] operation results.
    #
    def get_managed_hosting_environments_next(next_page_link, custom_headers = nil)
      response = get_managed_hosting_environments_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all managed hosting environments in a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_managed_hosting_environments_next_with_http_info(next_page_link, custom_headers = nil)
      get_managed_hosting_environments_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get all managed hosting environments in a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_managed_hosting_environments_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HostingEnvironmentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all sites on the managed hosting environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteCollection] operation results.
    #
    def get_managed_hosting_environment_sites_next(next_page_link, custom_headers = nil)
      response = get_managed_hosting_environment_sites_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all sites on the managed hosting environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_managed_hosting_environment_sites_next_with_http_info(next_page_link, custom_headers = nil)
      get_managed_hosting_environment_sites_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get all sites on the managed hosting environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_managed_hosting_environment_sites_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all serverfarms (App Service Plans) on the managed hosting environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ServerFarmCollection] operation results.
    #
    def get_managed_hosting_environment_web_hosting_plans_next(next_page_link, custom_headers = nil)
      response = get_managed_hosting_environment_web_hosting_plans_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all serverfarms (App Service Plans) on the managed hosting environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_managed_hosting_environment_web_hosting_plans_next_with_http_info(next_page_link, custom_headers = nil)
      get_managed_hosting_environment_web_hosting_plans_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get all serverfarms (App Service Plans) on the managed hosting environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_managed_hosting_environment_web_hosting_plans_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ServerFarmCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all serverfarms (App Service Plans) on the managed hosting environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ServerFarmCollection] operation results.
    #
    def get_managed_hosting_environment_server_farms_next(next_page_link, custom_headers = nil)
      response = get_managed_hosting_environment_server_farms_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all serverfarms (App Service Plans) on the managed hosting environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_managed_hosting_environment_server_farms_next_with_http_info(next_page_link, custom_headers = nil)
      get_managed_hosting_environment_server_farms_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get all serverfarms (App Service Plans) on the managed hosting environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_managed_hosting_environment_server_farms_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ServerFarmCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
